/*
 * Decompiled with CFR 0.152.
 */
package dev6.script;

import dev6.script.PwScript;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jvx.project.PjWorkshop_IP;

public class PwScript_IP
extends PjWorkshop_IP
implements ItemListener {
    private static final String HELP = "Use the importer if you want to simplify allocations new\nJavaView objects, at the cost of execution speed.\nWith the box enabled you can write\n    importClass(Packages.jv.vecmath.PdVector);\n    new PdVector(1,2,3) \ninstead of\n    importClass(Packages.jv.vecmath.PdVector);\n    new Packages.jv.vecmath.PdVector(1,2,3)";
    protected PwScript m_pwScript = null;
    private Button m_startButton;
    private TextArea m_scriptArea;
    private Label m_outputLabel;
    private TextArea m_outputArea;
    private Checkbox[] m_example = new Checkbox[3];
    private int m_currentExample = 0;
    private Checkbox m_useImporter;
    private Button m_helpButton;

    public PwScript_IP() {
        this.setName("Script_IP");
        if (this.getClass() == PwScript_IP.class) {
            this.init();
        }
    }

    public String getNotice() {
        String string = "Create your own script in JavaScipt language.\nYou can access the following variables directly:\n\ngeom:    active geometry (" + this.m_pwScript.getGeometry().getName() + ").\n" + "disp:       current display.\n";
        return string;
    }

    public void setParent(PsUpdateIf parent) {
        if (!(parent instanceof PwScript)) {
            PsDebug.warning((String)"Parent has to be of type PwScript");
            return;
        }
        this.setTitle("Script");
        super.setParent(parent);
        this.m_pwScript = (PwScript)parent;
        this.makeLayout();
    }

    protected int getDialogButtons() {
        return 13;
    }

    public Dimension getDialogSize() {
        return new Dimension(600, 600);
    }

    public void makeLayout() {
        this.removeAll();
        Insets insets = new Insets(1, 1, 1, 1);
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        CheckboxGroup group = new CheckboxGroup();
        this.m_example[0] = new Checkbox("own script", true, group);
        this.m_example[1] = new Checkbox("example 1", false, group);
        this.m_example[2] = new Checkbox("example 2", false, group);
        Panel p = new Panel(new GridLayout(1, 3));
        int i = 0;
        while (i < 3) {
            this.m_example[i].addItemListener(this);
            p.add(this.m_example[i]);
            ++i;
        }
        this.add(p, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, insets, 0, 0));
        this.m_scriptArea = new TextArea(PwScript.m_example[0], 14, 60);
        this.m_scriptArea.setFont(new Font("Monospaced", 0, 12));
        this.add(this.m_scriptArea, new GridBagConstraints(0, 1, 1, 1, 2.0, 2.0, 11, 1, insets, 0, 0));
        p = new Panel(new BorderLayout());
        this.m_outputLabel = new Label("Output:");
        p.add((Component)this.m_outputLabel, "West");
        Panel p2 = new Panel(new BorderLayout());
        this.m_helpButton = new Button("?");
        this.m_helpButton.addActionListener((ActionListener)((Object)this));
        p2.add((Component)this.m_helpButton, "East");
        this.m_useImporter = new Checkbox("Use JavaImporter", this.m_pwScript.m_useImporter);
        this.m_useImporter.addItemListener(this);
        p2.add((Component)this.m_useImporter, "West");
        p.add((Component)p2, "East");
        this.add(p, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 2, insets, 0, 0));
        this.m_outputArea = new TextArea(8, 60);
        this.m_outputArea.setEditable(false);
        this.m_outputArea.setFont(new Font("Monospaced", 0, 12));
        this.add(this.m_outputArea, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 11, 1, insets, 0, 0));
        p = new Panel();
        this.m_startButton = new Button("Start");
        p.add(this.m_startButton);
        this.m_startButton.addActionListener((ActionListener)((Object)this));
        this.add(p, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 11, 0, insets, 0, 0));
        this.validate();
    }

    public boolean update(Object event) {
        if (this.m_pwScript == null) {
            PsDebug.notify((String)"missing parent");
            return true;
        }
        if (event == this.m_pwScript) {
            return true;
        }
        return super.update(event);
    }

    public void actionPerformed(ActionEvent event) {
        int id = event.getID();
        if (id == 4) {
            PwScript.m_example[this.m_currentExample] = this.m_scriptArea.getText();
        }
        if (event.getSource() == this.m_helpButton) {
            this.m_outputArea.setText(HELP);
        }
        if (event.getSource() == this.m_startButton) {
            this.m_pwScript.setScript(this.m_scriptArea.getText());
            String output = this.m_pwScript.start();
            this.m_outputArea.setText(output);
            return;
        }
        super.actionPerformed(event);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (source == this.m_example[0] || source == this.m_example[1] || source == this.m_example[2]) {
            PwScript.m_example[this.m_currentExample] = this.m_scriptArea.getText();
            int i = 0;
            while (i < 3) {
                if (this.m_example[i].getState()) {
                    this.m_currentExample = i;
                    this.m_scriptArea.setText(PwScript.m_example[i]);
                }
                ++i;
            }
        }
        if (source == this.m_useImporter) {
            this.m_pwScript.m_useImporter = this.m_useImporter.getState();
        }
    }
}

