/*
 * Decompiled with CFR 0.152.
 */
package dev6.script;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jv.geom.PgElementSet;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jvx.project.PjWorkshop;

public class PwScript
extends PjWorkshop {
    private String m_script;
    protected boolean m_useImporter = false;
    public static final String example0 = "";
    public static final String example1 = "importClass(Packages.jv.object.PsObject);\n\n// Select all elements whose normals point to the camera\nfor (var i=0; i<geom.getNumElements(); i++) {\n\tif (disp.getCamera().getViewDir().dot(geom.getElementNormal(i)) < 0) {\n\t\tgeom.setTagElement(i, PsObject.IS_SELECTED);\n\t}\n}\n";
    public static final String example2 = "importPackage(Packages.java.awt);\n\n// add 0.05 to the hue of each element's color\nfor (var i=0; i < geom.getNumElements(); i++) {\n\tvar c = geom.getElementColor(i);\n\tvar red = c.getRed();\n\tvar green = c.getGreen();\n\tvar blue = c.getBlue();\n\tvar hsb = Color.RGBtoHSB(red, green, blue, null);\n\tvar newRGB = Color.HSBtoRGB((hsb[0]+0.05), hsb[1], hsb[2]);\n\tgeom.setElementColor(i, new Color(newRGB));\n}";
    public static String[] m_example = new String[]{"", "importClass(Packages.jv.object.PsObject);\n\n// Select all elements whose normals point to the camera\nfor (var i=0; i<geom.getNumElements(); i++) {\n\tif (disp.getCamera().getViewDir().dot(geom.getElementNormal(i)) < 0) {\n\t\tgeom.setTagElement(i, PsObject.IS_SELECTED);\n\t}\n}\n", "importPackage(Packages.java.awt);\n\n// add 0.05 to the hue of each element's color\nfor (var i=0; i < geom.getNumElements(); i++) {\n\tvar c = geom.getElementColor(i);\n\tvar red = c.getRed();\n\tvar green = c.getGreen();\n\tvar blue = c.getBlue();\n\tvar hsb = Color.RGBtoHSB(red, green, blue, null);\n\tvar newRGB = Color.HSBtoRGB((hsb[0]+0.05), hsb[1], hsb[2]);\n\tgeom.setElementColor(i, new Color(newRGB));\n}"};

    public PwScript(String name) {
        super(name);
        if (((Object)((Object)this)).getClass() == PwScript.class) {
            this.init();
        }
    }

    public PwScript(String name, PgElementSet geom) {
        this(name);
        this.setGeometry((PgGeometry)geom);
    }

    public String getName() {
        return "Script workshop";
    }

    public String start() {
        ScriptEngine jsEngine = new ScriptEngineManager().getEngineByName("JavaScript");
        jsEngine.put("geom", this.m_geom);
        jsEngine.put("disp", this.m_display);
        jsEngine.put("PdVector", new PdVector(0));
        try {
            String scriptWithImporter = "var imp = new JavaImporter(); with (imp) {" + this.m_script + "}";
            Object returnValue = jsEngine.eval(this.m_useImporter ? scriptWithImporter : this.m_script);
            this.m_geom.update((Object)this.m_geom);
            if (returnValue != null) {
                return returnValue.toString();
            }
            return null;
        }
        catch (ScriptException ex) {
            String message = ex.getMessage();
            int index = message.indexOf(":");
            return message.substring(index + 2);
        }
    }

    public void setScript(String text) {
        this.m_script = text;
    }

    public void reset() {
        if (this.m_geom != null && this.m_geomSave != null) {
            this.m_geom.copy((PsObject)this.m_geomSave);
            this.m_geom.update((Object)this.m_geom);
        }
    }
}

