/*
 * Decompiled with CFR 0.152.
 */
package dev6.numeric;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnSparseMatrix;
import no.uib.cipr.matrix.AbstractVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.sparse.ArpackSym;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;

public class PuJMT {
    public static final int LA = 0;
    public static final int SA = 1;
    public static final int LM = 2;
    public static final int SM = 3;
    public static final int BE = 4;

    public static Matrix toJMTSparseMatrix(PnSparseMatrix sM) {
        if (sM == null) {
            PsDebug.warning((String)"Matrix is null.");
            return null;
        }
        System.out.println("Converting to sparse JMT matrix");
        int numRows = sM.getNumRows();
        int numCols = sM.getNumCols();
        FlexCompRowMatrix M = new FlexCompRowMatrix(numRows, numCols);
        PdVector[] entries = sM.getEntries();
        PiVector[] colIndices = sM.getColIndices();
        int i = 0;
        while (i < numRows) {
            PdVector rowEntries = entries[i];
            PiVector rowColIndices = colIndices[i];
            int j = 0;
            while (j < rowEntries.getSize()) {
                M.set(i, rowColIndices.getEntry(j), rowEntries.getEntry(j));
                ++j;
            }
            ++i;
        }
        System.out.println("done.");
        return M;
    }

    public static PdVector toPdVector(AbstractVector v) {
        if (v == null) {
            PsDebug.warning((String)"Vector is null.");
            return null;
        }
        int size = v.size();
        PdVector pdVector = new PdVector(size);
        int i = 0;
        while (i < size) {
            pdVector.setEntry(i, v.get(i));
            ++i;
        }
        return pdVector;
    }

    public static List<Eigenpair> computeEigenspectrumARPACK(PnSparseMatrix sM, int numOfEvals, int whichEvals) {
        Matrix M = PuJMT.toJMTSparseMatrix(sM);
        ArpackSym solver = new ArpackSym(M);
        ArpackSym.Ritz whichRitz = null;
        switch (whichEvals) {
            case 0: {
                whichRitz = ArpackSym.Ritz.LA;
                break;
            }
            case 1: {
                whichRitz = ArpackSym.Ritz.SA;
                break;
            }
            case 2: {
                whichRitz = ArpackSym.Ritz.LM;
                break;
            }
            case 3: {
                whichRitz = ArpackSym.Ritz.SM;
                break;
            }
            case 4: {
                whichRitz = ArpackSym.Ritz.BE;
                break;
            }
            default: {
                PsDebug.warning((String)"Not a valid eigenvalue mode.");
                return null;
            }
        }
        System.out.println("Calling ARPACK.solve...");
        PsDebug.notify((String)"Calling ARPACK.solve...");
        Map results = solver.solve(numOfEvals, whichRitz);
        System.out.println("...done.");
        PsDebug.notify((String)"...done.");
        int numOfResults = results.size();
        ArrayList<Eigenpair> eigenpairs = new ArrayList<Eigenpair>(numOfResults);
        for (Map.Entry e : results.entrySet()) {
            double eval = (Double)e.getKey();
            PdVector evec = PuJMT.toPdVector((AbstractVector)e.getValue());
            Eigenpair ep = new Eigenpair(eval, evec);
            eigenpairs.add(ep);
        }
        return eigenpairs;
    }

    public static class Eigenpair {
        public double eval;
        public PdVector evec;

        public Eigenpair(double eval, PdVector evec) {
            this.eval = eval;
            this.evec = evec;
        }

        public String toString() {
            return "\nEigenvalue: " + this.eval + "\nEigenvector: " + this.evec;
        }
    }
}

