/*
 * Decompiled with CFR 0.152.
 */
package dev6.numeric;

import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnSparseMatrix;

public class PnMumpsSolver {
    public static long NULL = 0L;
    private static boolean m_available = true;

    static {
        try {
            if (System.getProperty("os.name").startsWith("Win") && System.getProperty("os.arch").endsWith("64")) {
                System.loadLibrary("w64gcc_s_sjlj-1");
                System.loadLibrary("libstdc++-6");
                System.loadLibrary("libgfortran-3");
            }
            System.loadLibrary("MumpsJNI");
        }
        catch (UnsatisfiedLinkError e) {
            m_available = false;
            PsDebug.warning((String)("Cannot load MUMPS library: " + e.getMessage()));
        }
    }

    public static boolean isAvailable() {
        return m_available;
    }

    private static native void solve(PiVector[] var0, PiVector var1, PdVector[] var2, PdVector var3, PdVector var4, int var5) throws Exception;

    public static void solve(PnSparseMatrix matrix, PdVector x, PdVector b, Type sym) throws Exception {
        PnMumpsSolver.solve(matrix.getColIndices(), matrix.getNumEntries(), matrix.getEntries(), x, b, sym.mumps_id);
    }

    public static long analyze(PiVector[] sindx, PiVector snoe, Type sym) throws Exception {
        return PnMumpsSolver.analyze(sindx, snoe, sym.mumps_id);
    }

    private static native long analyze(PiVector[] var0, PiVector var1, int var2) throws Exception;

    public static native long factor(long var0, PdVector[] var2) throws Exception;

    public static long factor(PnSparseMatrix matrix, Type sym) throws Exception {
        long factorization = PnMumpsSolver.analyze(matrix.getColIndices(), matrix.getNumEntries(), sym.mumps_id);
        return PnMumpsSolver.factor(factorization, matrix.getEntries());
    }

    public static native void solve(long var0, PdVector var2, PdVector var3) throws Exception;

    public static native void free(long var0) throws Exception;

    public static enum Type {
        UNSYMMETRIC(0),
        GENERAL_SYMMETRIC(2),
        SYMMETRIC_POSITIVE_DEFINITE(1);

        protected int mumps_id;

        private Type(int id) {
            this.mumps_id = id;
        }
    }
}

