/*
 * Decompiled with CFR 0.152.
 */
package dev6.numeric;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnSparseMatrix;

public class PnConjugateGradientMatrixMT {
    protected int m_iter;
    protected double m_err;
    protected int m_itol = 1;
    protected int m_itmax = 10000;
    protected double m_tol = 1.0E-10;
    private double[] m_invdiag;
    private double m_rho;
    private double m_rho_1;
    private double m_dot;
    private PnSparseMatrix m_smat;
    private double[] m_x;
    private double[] m_p;
    private double[] m_q;
    private double[] m_r;
    private ExecutorService m_threadPool;

    public boolean converged() {
        return this.m_err < this.m_tol;
    }

    public double getActualEstimatedError() {
        return this.m_err;
    }

    public int getActualNumOfTakenIterations() {
        return this.m_iter;
    }

    public void setMaxNumIterations(int itmax) {
        this.m_itmax = itmax;
    }

    public int getMaxNumIterations() {
        return this.m_itmax;
    }

    public void setTolerance(double tol) {
        this.m_tol = tol;
    }

    public double getTolerance() {
        return this.m_tol;
    }

    public void setConvergenceTest(int aTest) {
        if (aTest > 4 || aTest < 1) {
            PsDebug.warning((String)"Cannot set convergence test method, desired method is unknown.");
            return;
        }
        this.m_itol = aTest;
    }

    public double getConvergenceTest() {
        return this.m_itol;
    }

    public double solve(PnSparseMatrix smat, PdVector x, PdVector b) {
        if (smat == null || x == null || b == null) {
            PsDebug.warning((String)"One of the arguments is null");
            return -1.0;
        }
        if (!smat.isSquare()) {
            PsDebug.warning((String)"Matrix is not square.");
            return -1.0;
        }
        this.m_smat = smat;
        int m_size = smat.getNumRows();
        if (b.getSize() != m_size) {
            PsDebug.warning((String)"Dimension of b and smat does not match");
            return -1.0;
        }
        if (x.getSize() != m_size) {
            x.setSize(m_size);
        }
        this.m_x = x.m_data;
        this.m_rho_1 = 0.0;
        this.m_p = new double[m_size];
        this.m_q = new double[m_size];
        this.m_r = new double[m_size];
        this.m_invdiag = new double[m_size];
        int i = 0;
        while (i < m_size) {
            double val = smat.getEntry(i, i);
            this.m_invdiag[i] = val == 0.0 ? 1.0 : 1.0 / val;
            ++i;
        }
        int numThreads = Runtime.getRuntime().availableProcessors();
        ExecutorService threadPool = this.m_threadPool == null ? Executors.newFixedThreadPool(numThreads) : this.m_threadPool;
        int i2 = 0;
        while (i2 < m_size) {
            double sum = 0.0;
            int noe = smat.getNumEntries(i2);
            int j = 0;
            while (j < noe) {
                sum += smat.getEntrySparse(i2, j) * x.m_data[smat.getColIndex(i2, j)];
                ++j;
            }
            this.m_r[i2] = b.m_data[i2] - sum;
            ++i2;
        }
        this.m_err = 0.0;
        i2 = 0;
        while (i2 < m_size) {
            this.m_err += this.m_r[i2] * this.m_r[i2];
            ++i2;
        }
        this.m_err = Math.sqrt(this.m_err);
        this.m_iter = 0;
        while (this.m_err > this.m_tol && this.m_iter < this.m_itmax) {
            this.m_err = this.conjugentGradientStep(threadPool, numThreads);
            ++this.m_iter;
        }
        if (threadPool != this.m_threadPool) {
            threadPool.shutdown();
        }
        return this.m_err;
    }

    private double conjugentGradientStep(ExecutorService threadPool, int numThreads) {
        this.m_rho = this.submitThreads(threadPool, numThreads, 0);
        this.submitThreads(threadPool, numThreads, 1);
        this.m_rho_1 = this.m_rho;
        this.m_dot = this.submitThreads(threadPool, numThreads, 2);
        double err = this.submitThreads(threadPool, numThreads, 3);
        return Math.sqrt(err);
    }

    private double submitThreads(ExecutorService threadPool, int numThreads, final int task) {
        Future[] future = new Future[numThreads];
        int size = this.m_smat.getNumCols();
        int j = 0;
        while (j < numThreads) {
            final int from = j * (size / numThreads);
            final int to = j == numThreads - 1 ? size : (j + 1) * (size / numThreads);
            future[j] = threadPool.submit(new Callable<Double>(){

                @Override
                public Double call() {
                    switch (task) {
                        case 0: {
                            return new Double(PnConjugateGradientMatrixMT.this.taks0(from, to));
                        }
                        case 1: {
                            return new Double(PnConjugateGradientMatrixMT.this.task1(from, to));
                        }
                        case 2: {
                            return new Double(PnConjugateGradientMatrixMT.this.task2(from, to));
                        }
                        case 3: {
                            return new Double(PnConjugateGradientMatrixMT.this.task3(from, to));
                        }
                    }
                    return new Double(0.0);
                }
            });
            ++j;
        }
        double res = 0.0;
        try {
            int j2 = 0;
            while (j2 < future.length) {
                res += ((Double)future[j2].get()).doubleValue();
                ++j2;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return res;
    }

    protected final double taks0(int from, int to) {
        double rho = 0.0;
        int i = from;
        while (i < to) {
            this.m_q[i] = this.m_r[i] * this.m_invdiag[i];
            rho += this.m_r[i] * this.m_q[i];
            ++i;
        }
        return rho;
    }

    protected final double task1(int from, int to) {
        if (this.m_iter == 0) {
            int i = from;
            while (i < to) {
                this.m_p[i] = this.m_q[i];
                ++i;
            }
        } else {
            double beta = this.m_rho / this.m_rho_1;
            int i = from;
            while (i < to) {
                this.m_p[i] = beta * this.m_p[i] + this.m_q[i];
                ++i;
            }
        }
        return 0.0;
    }

    protected final double task2(int from, int to) {
        double dot = 0.0;
        PdVector[] stiff = this.m_smat.getEntries();
        PiVector[] index = this.m_smat.getColIndices();
        int[] noe = this.m_smat.getNumEntries().m_data;
        int i = from;
        while (i < to) {
            double sum = 0.0;
            int noe_i = noe[i];
            double[] stiff_i = stiff[i].m_data;
            int[] index_i = index[i].m_data;
            int j = 0;
            while (j < noe_i) {
                sum += stiff_i[j] * this.m_p[index_i[j]];
                ++j;
            }
            this.m_q[i] = sum;
            dot += this.m_p[i] * sum;
            ++i;
        }
        return dot;
    }

    protected final double task3(int from, int to) {
        double err = 0.0;
        double alpha = this.m_rho_1 / this.m_dot;
        int i = from;
        while (i < to) {
            int n = i;
            this.m_x[n] = this.m_x[n] + alpha * this.m_p[i];
            int n2 = i;
            this.m_r[n2] = this.m_r[n2] - alpha * this.m_q[i];
            err += this.m_r[i] * this.m_r[i];
            ++i;
        }
        return err;
    }

    public ExecutorService getThreadPool() {
        return this.m_threadPool;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.m_threadPool = threadPool;
    }
}

