/*
 * Decompiled with CFR 0.152.
 */
package dev6.numeric;

import dev6.thirdParty.csparsej.Dcs;
import dev6.thirdParty.csparsej.Dcs_chol;
import dev6.thirdParty.csparsej.Dcs_common;
import dev6.thirdParty.csparsej.Dcss;
import jv.vecmath.PdVector;
import jvx.numeric.PnSparseMatrix;

public class PnCSparseCholesky {
    public static PnCSparseCholeskyFactor solve(PnSparseMatrix A, PdVector x, PdVector b) {
        if (A == null) {
            return null;
        }
        Dcs dcs = new Dcs(A).toCSC();
        Dcss S = Dcs_chol.cs_schol(1, dcs);
        Dcs_common.Dcsn N = Dcs_chol.cs_chol(dcs, S);
        if (S == null || N == null) {
            return null;
        }
        PnCSparseCholeskyFactor fact = new PnCSparseCholeskyFactor();
        fact.S = S;
        int[] p = fact.S.pinv;
        if (p == null) {
            p = new int[N.L.n];
            int i = 0;
            while (i < N.L.n) {
                p[i] = i;
                ++i;
            }
        }
        fact.N = N;
        if (x == null || b == null) {
            return fact;
        }
        x.copyArray(b);
        float[] invX = PnCSparseCholesky.ipvec(x.m_data, p);
        PnCSparseCholesky.solve(fact, invX);
        PnCSparseCholesky.pvec(x.m_data, p, invX);
        return fact;
    }

    private static void pvec(double[] x, int[] pinv, float[] invX) {
        int size = x.length;
        int k = 0;
        while (k < size) {
            x[k] = invX[pinv[k]];
            ++k;
        }
    }

    public static void solveUseFactorization(PnCSparseCholeskyFactor fact, PdVector x, PdVector b) {
        x.copyArray(b);
        float[] invX = PnCSparseCholesky.ipvec(x.m_data, fact.S.pinv);
        PnCSparseCholesky.solve(fact, invX);
        PnCSparseCholesky.pvec(x.m_data, fact.S.pinv, invX);
    }

    private static final void solve(PnCSparseCholeskyFactor fact, float[] invX) {
        int i;
        int to;
        int from;
        Dcs L = fact.N.L;
        int n = L.n;
        int[] p = L.p;
        int[] ind = L.ind;
        double[] Lx = L.values;
        int j = 0;
        while (j < n) {
            int n2 = j;
            invX[n2] = (float)((double)invX[n2] / Lx[p[j]]);
            from = p[j] + 1;
            to = p[j + 1];
            i = from;
            while (i < to) {
                int n3 = ind[i];
                invX[n3] = (float)((double)invX[n3] - Lx[i] * (double)invX[j]);
                ++i;
            }
            ++j;
        }
        j = n - 1;
        while (j >= 0) {
            from = p[j] + 1;
            to = p[j + 1];
            i = from;
            while (i < to) {
                int n4 = j;
                invX[n4] = (float)((double)invX[n4] - Lx[i] * (double)invX[ind[i]]);
                ++i;
            }
            int n5 = j;
            invX[n5] = (float)((double)invX[n5] / Lx[p[j]]);
            --j;
        }
    }

    private static float[] ipvec(double[] x, int[] p) {
        int size = x.length;
        float[] invX = new float[size];
        int k = 0;
        while (k < size) {
            invX[p[k]] = (float)x[k];
            ++k;
        }
        return invX;
    }

    public static class PnCSparseCholeskyFactor {
        public Dcs_common.Dcsn N;
        public Dcss S;
    }
}

