/*
 * Decompiled with CFR 0.152.
 */
package dev6.numeric;

import dev6.numeric.PnMumpsSolver;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnBandEigenSolver;
import jvx.numeric.PnLanczos;
import jvx.numeric.PnSparseMatrix;

public class PnBandEigenSolverMumps
extends PnBandEigenSolver
implements PnLanczos.PnMatrixVectorProductIf {
    protected PnSparseMatrix m_matrix;
    protected long m_factorization = PnMumpsSolver.NULL;

    public PnBandEigenSolverMumps() {
        this.setName("band-by-band MUMPS");
        if (((Object)((Object)this)).getClass() == PnBandEigenSolverMumps.class) {
            this.init();
        }
    }

    protected PnLanczos getLanczos() {
        return new PnLanczos((PnLanczos.PnMatrixVectorProductIf)this);
    }

    protected void shiftSpectrum(double shift) {
        PdVector[] entries = this.m_matrix.getEntries();
        int i = 0;
        while (i < this.m_matrix.getNumRows()) {
            PiVector indices = this.m_matrix.getColIndices(i);
            int j = 0;
            while (j < indices.getSize()) {
                if (indices.m_data[j] == i) {
                    int n = j;
                    entries[i].m_data[n] = entries[i].m_data[n] - shift;
                }
                ++j;
            }
            ++i;
        }
        this.destroy();
    }

    public void init() {
        super.init();
    }

    protected void destroy() {
        if (this.m_factorization != PnMumpsSolver.NULL) {
            try {
                PnMumpsSolver.free(this.m_factorization);
            }
            catch (Exception e) {
                PsDebug.error((String)("Error freeing memory in MUMPS: " + e.getMessage()));
            }
            this.m_factorization = PnMumpsSolver.NULL;
        }
    }

    public int getDimension() {
        return this.m_matrix.getNumRows();
    }

    public PdVector run(PdVector v) {
        if (this.m_factorization == PnMumpsSolver.NULL) {
            try {
                this.m_factorization = PnMumpsSolver.factor(this.m_matrix, PnMumpsSolver.Type.GENERAL_SYMMETRIC);
            }
            catch (Exception e) {
                PsDebug.error((String)"Unable to factorize matrix with Mumps.", (Object)e);
            }
        }
        PdVector w = new PdVector(v.getSize());
        try {
            PnMumpsSolver.solve(this.m_factorization, w, v);
        }
        catch (Exception e) {
            PsDebug.error((String)"Unable to solve linear system using Mumps.", (Object)e);
        }
        return w;
    }

    public Object getMatrix() {
        return this.m_matrix;
    }

    public void setMatrix(Object matrix) {
        this.m_matrix = (PnSparseMatrix)matrix;
    }

    public boolean isAvailable() {
        return PnMumpsSolver.isAvailable();
    }

    public int getInputType() {
        return 1;
    }
}

