/*
 * Decompiled with CFR 0.152.
 */
package jvx.volume;

import java.util.Vector;
import jv.geom.PgEdgeStar;
import jv.geom.PgPolygonSet;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwCleanMesh;
import jvx.project.PjWorkshop;
import jvx.volume.PgCubeSet;
import jvx.volume.PwCubeSet;

public class PwStc
extends PjWorkshop {
    public PgCubeSet m_cubeSet;
    public int m_numSurfaces;
    public PiVector[] m_stc;
    int m_numStcElements;
    public PiVector[] m_stcElement;
    public PiVector m_cubeToSurface;
    public PgPolygonSet m_stcReebGraph;
    protected PuInteger m_surfaceIndex = new PuInteger("Surface Index", (PsUpdateIf)this);
    static /* synthetic */ Class class$jvx$volume$PwStc;

    public PwStc() {
        super("STC");
        if (((Object)((Object)this)).getClass() == (class$jvx$volume$PwStc == null ? (class$jvx$volume$PwStc = PwStc.class$("jvx.volume.PwStc")) : class$jvx$volume$PwStc)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_surfaceIndex.setDefBounds(0, 10, 1, 1);
        this.m_surfaceIndex.setDefValue(0);
        this.m_surfaceIndex.init();
    }

    public void setGeometry(PgGeometry pgGeometry) {
        super.setGeometry(pgGeometry);
        this.m_cubeSet = (PgCubeSet)pgGeometry;
        this.computeStcElements();
        this.computeStcConnectivity();
    }

    public void computeStcNeighbourhood() {
        int n;
        PdVector pdVector;
        int n2;
        if (this.m_cubeSet == null) {
            return;
        }
        if (this.m_cubeToSurface == null) {
            return;
        }
        this.m_stcReebGraph = new PgPolygonSet(this.m_cubeSet.getDimOfVertices());
        int n3 = this.m_stc.length;
        int n4 = this.m_cubeSet.getNumCubes();
        this.m_stcReebGraph.setNumVertices(n3);
        for (int i = 0; i < n3; ++i) {
            n2 = this.m_stc[i].getSize();
            pdVector = new PdVector(this.m_cubeSet.getDimOfVertices());
            for (n = 0; n < n2; ++n) {
                pdVector.add(this.m_cubeSet.getCenterOfCube(this.m_stc[i].m_data[n] % n4));
            }
            pdVector.multScalar(1.0 / (double)n2);
            this.m_stcReebGraph.setVertex(i, pdVector);
        }
        Vector<PiVector> vector = new Vector<PiVector>();
        for (n2 = 0; n2 < n4; ++n2) {
            pdVector = this.m_cubeSet.getNeighbour(n2);
            for (n = 0; n < 6; ++n) {
                int n5;
                int n6;
                int n7;
                if (pdVector.m_data[n] < 0 || pdVector.m_data[n] < n2) continue;
                int[][] nArray = new int[2][3];
                for (n7 = 0; n7 < 3; ++n7) {
                    nArray[0][n7] = this.m_cubeToSurface.m_data[n7 * n4 + n2];
                    nArray[1][n7] = this.m_cubeToSurface.m_data[n7 * n4 + pdVector.m_data[n]];
                }
                n7 = 0;
                block5: for (n6 = 0; n6 < 3; ++n6) {
                    for (n5 = 0; n5 < 3; ++n5) {
                        if (nArray[0][n6] != nArray[1][n5]) continue;
                        nArray[0][n6] = -1;
                        nArray[1][n5] = -1;
                        ++n7;
                        continue block5;
                    }
                }
                if (n7 < 2) {
                    PsDebug.warning((String)"Something went wrong in computing the surface neighbourhoods!");
                }
                block7: for (n6 = 0; n6 < 3; ++n6) {
                    if (nArray[0][n6] == -1) continue;
                    for (n5 = 0; n5 < 3; ++n5) {
                        if (nArray[1][n5] == -1) continue;
                        vector.addElement(new PiVector(nArray[0][n6], nArray[1][n5]));
                        continue block7;
                    }
                }
            }
        }
        n2 = vector.size();
        this.m_stcReebGraph.setNumPolygons(n2);
        for (int i = 0; i < n2; ++i) {
            this.m_stcReebGraph.setPolygon(i, (PiVector)vector.elementAt(i));
        }
        PwCleanMesh.joinPolygons(this.m_stcReebGraph);
    }

    public void showReebGraph() {
        if (this.m_stc == null) {
            return;
        }
        if (this.m_stcReebGraph == null || this.m_stcReebGraph.getNumVertices() != this.m_stc.length) {
            this.computeStcNeighbourhood();
        }
        if (this.m_display != null) {
            this.m_display.addGeometry((PgGeometryIf)this.m_stcReebGraph);
            this.m_display.update((Object)this.m_stcReebGraph);
        }
    }

    public void computeStcConnectivity() {
        int n;
        int n2;
        if (this.m_stcElement == null || this.m_stcElement.length == 0) {
            PsDebug.warning((String)"Missing STC Faces");
            return;
        }
        int n3 = this.m_cubeSet.getNumCubes();
        int n4 = 0;
        int[] nArray = new int[3 * n3];
        for (n2 = 0; n2 < 3 * n3; ++n2) {
            nArray[n2] = n2;
        }
        for (n2 = 0; n2 < this.m_numStcElements; ++n2) {
            int n5;
            PiVector piVector = this.m_stcElement[n2];
            n = piVector.getSize();
            if (n < 2) continue;
            int n6 = piVector.m_data[0];
            for (n5 = 0; n5 < n; ++n5) {
                if (n6 <= piVector.m_data[n5]) continue;
                n6 = piVector.m_data[n5];
            }
            for (n5 = 0; n5 < n; ++n5) {
                if (piVector.m_data[n5] == n6) continue;
                int n7 = piVector.m_data[n5];
                while (nArray[n7] != nArray[n6]) {
                    if (nArray[n7] < nArray[n6]) {
                        if (n6 == nArray[n6]) {
                            nArray[n6] = nArray[n7];
                            continue;
                        }
                        n6 = nArray[n6];
                        continue;
                    }
                    if (n7 == nArray[n7]) {
                        nArray[n7] = nArray[n6];
                        continue;
                    }
                    n7 = nArray[n7];
                }
            }
        }
        for (n2 = 0; n2 < 3 * n3; ++n2) {
            while (nArray[nArray[n2]] != nArray[n2]) {
                nArray[n2] = nArray[nArray[n2]];
            }
        }
        int[] nArray2 = new int[3 * n3];
        for (int i = 0; i < 3 * n3; ++i) {
            if (nArray[i] != i) continue;
            nArray2[i] = n4++;
        }
        int[] nArray3 = new int[n4];
        for (n = 0; n < n4; ++n) {
            nArray3[n] = 0;
        }
        for (n = 0; n < 3 * n3; ++n) {
            if (nArray[n] == n) {
                int n8 = nArray2[n];
                nArray3[n8] = nArray3[n8] + 1;
                continue;
            }
            int n9 = nArray2[nArray[n]];
            nArray3[n9] = nArray3[n9] + 1;
        }
        this.m_stc = new PiVector[n4];
        for (n = 0; n < n4; ++n) {
            this.m_stc[n] = new PiVector(nArray3[n]);
        }
        this.m_cubeToSurface = new PiVector(3 * n3);
        for (n = 0; n < n4; ++n) {
            nArray3[n] = 0;
        }
        for (n = 0; n < 3 * n3; ++n) {
            this.m_stc[nArray2[nArray[n]]].m_data[nArray3[nArray2[nArray[n]]]] = n;
            int n10 = nArray2[nArray[n]];
            nArray3[n10] = nArray3[n10] + 1;
            this.m_cubeToSurface.m_data[n] = nArray2[nArray[n]];
        }
        this.m_surfaceIndex.setBounds(0, n4 - 1, 1, 10);
    }

    public void computeStcElements() {
        int n = this.m_cubeSet.getNumCubes();
        int n2 = this.m_cubeSet.getNumEdges();
        PiVector[] piVectorArray = new PiVector[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 12; ++j) {
                PgEdgeStar pgEdgeStar = PwCubeSet.computeEdgeStar(this.m_cubeSet, i, j, null);
                int n4 = pgEdgeStar.getValence();
                boolean bl = true;
                for (int k = 0; k < n4; ++k) {
                    if (pgEdgeStar.getElementInd(k) >= i) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                int[] nArray = new int[]{this.m_cubeSet.getCube((int)i).m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[j][0]], this.m_cubeSet.getCube((int)i).m_data[PgCubeSet.LOCAL_EDGE_TO_VERTEX[j][1]]};
                PiVector piVector = new PiVector(n4);
                for (int k = 0; k < n4; ++k) {
                    int n5;
                    int n6 = pgEdgeStar.getElementInd(k);
                    int[] nArray2 = new int[2];
                    for (n5 = 0; n5 < 2; ++n5) {
                        nArray2[n5] = this.m_cubeSet.getCube(n6).getIndexOf(nArray[n5]);
                    }
                    n5 = Math.abs(nArray2[1] - nArray2[0]);
                    n5 = (n5 % 4 + 2) % 3;
                    piVector.m_data[k] = n * n5 + n6;
                }
                piVectorArray[n3] = piVector;
                ++n3;
            }
        }
        this.m_stcElement = piVectorArray;
        this.m_numStcElements = n3;
    }

    public void selectSurface(int n) {
        int n2 = this.m_cubeSet.getNumCubes();
        for (int i = 0; i < n2; ++i) {
            this.m_cubeSet.clearTagCube(i, 1);
        }
        PiVector piVector = this.m_stc[n];
        int n3 = piVector.getSize();
        for (int i = 0; i < n3; ++i) {
            this.m_cubeSet.setTagCube(piVector.m_data[i] % n2, 1);
        }
    }

    public boolean update(Object object) {
        if (object == this.m_surfaceIndex) {
            this.selectSurface(this.m_surfaceIndex.getValue());
            this.m_cubeSet.update((Object)this.m_cubeSet);
            return true;
        }
        return super.update(object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

