/*
 * Decompiled with CFR 0.152.
 */
package jvx.surface;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import jv.function.PuFunction;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jvx.surface.PgDomain;
import jvx.surface.PgDomainDescr;

public class PgGraph
extends PgElementSet {
    protected int m_dimOfDomain;
    protected int m_dimOfSurface;
    protected PgDomain m_domain;
    protected PgElementSet m_walls = new PgElementSet(3);
    protected PgElementSet m_surface;
    protected PuFunction m_function;
    protected boolean m_bShowDomain = true;
    protected boolean m_bShowWalls = true;
    protected boolean m_bSynchronize = false;
    protected PuDouble m_scalingFactor;
    protected PuDouble m_offset;
    protected boolean m_bIsUpdateSender = false;
    static /* synthetic */ Class class$jvx$surface$PgGraph;

    public PgGraph(int n) {
        this();
    }

    public PgGraph() {
        super(3);
        this.m_walls.setName("Wall of Graph");
        this.m_walls.setVisible(!this.m_bShowWalls);
        this.m_walls.setDimOfElements(4);
        this.m_walls.setGlobalElementColor(new Color(255, 255, 180));
        this.m_walls.showElements(false);
        this.setTag(10);
        this.m_scalingFactor = new PuDouble(PsConfig.getMessage((int)54225), (PsUpdateIf)this);
        this.m_offset = new PuDouble(PsConfig.getMessage((int)54009), (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$surface$PgGraph == null ? (class$jvx$surface$PgGraph = PgGraph.class$("jvx.surface.PgGraph")) : class$jvx$surface$PgGraph)) {
            this.init();
        }
        PgDomain pgDomain = new PgDomain(2);
        pgDomain.setVisible(!this.m_bShowDomain);
        pgDomain.setName("Domain of Graph");
        pgDomain.setDimOfElements(4);
        pgDomain.setGlobalElementColor(new Color(192, 140, 0));
        PgDomainDescr pgDomainDescr = pgDomain.getDescr();
        pgDomainDescr.setMaxSize(-10.0, -10.0, 10.0, 10.0);
        pgDomainDescr.setSize(-3.0, -3.0, 3.0, 3.0);
        pgDomainDescr.setDiscrBounds(2, 2, 50, 50);
        pgDomainDescr.setDiscr(15, 15);
        pgDomain.compute();
        this.m_domain = pgDomain;
        PgElementSet pgElementSet = new PgElementSet(1);
        pgElementSet.setName("Graph");
        pgElementSet.setNumVertices(this.m_domain.getNumVertices());
        pgElementSet.copyElementSet((PgElementSet)pgDomain);
        this.setSurfaces(this.m_domain, pgElementSet);
        this.m_function = new PuFunction(2, 1);
        this.m_function.setParent((PsUpdateIf)this);
        this.m_function.setName("Graph");
        this.m_function.setVariables(new String[]{"u", "v"});
        this.m_function.setExpression("2.+sin(u)*cos(v)");
        this.m_function.init();
        this.compute();
    }

    public void init() {
        super.init();
        this.m_scalingFactor.setDefBounds(0.0, 5.0, 0.1, 1.0);
        this.m_scalingFactor.setDefValue(1.0);
        this.m_scalingFactor.init();
        this.m_offset.setDefBounds(-5.0, 5.0, 0.1, 1.0);
        this.m_offset.setDefValue(0.0);
        this.m_offset.init();
        if (this.m_function != null) {
            this.m_function.init();
        }
        this.setSurfaces(this.m_domain, this.m_surface);
        this.compute();
    }

    public Object clone() {
        PgGraph pgGraph = (PgGraph)((Object)super.clone());
        if (pgGraph == null) {
            return null;
        }
        if (this.m_domain != null) {
            pgGraph.m_domain = (PgDomain)((Object)this.m_domain.clone());
            if (pgGraph.m_domain.hasUpdateListener((PsUpdateIf)this)) {
                pgGraph.m_domain.removeUpdateListener((PsUpdateIf)this);
            }
        }
        if (this.m_walls != null) {
            pgGraph.m_walls = (PgElementSet)this.m_walls.clone();
        }
        if (this.m_surface != null) {
            pgGraph.m_surface = (PgElementSet)this.m_surface.clone();
            if (pgGraph.m_surface.hasUpdateListener((PsUpdateIf)this)) {
                pgGraph.m_surface.addUpdateListener((PsUpdateIf)pgGraph);
            }
        }
        if (this.m_function != null) {
            pgGraph.m_function = (PuFunction)this.m_function.clone();
            pgGraph.m_function.setParent((PsUpdateIf)pgGraph);
        }
        pgGraph.m_offset = (PuDouble)this.m_offset.clone();
        pgGraph.m_offset.setParent((PsUpdateIf)pgGraph);
        pgGraph.m_scalingFactor = (PuDouble)this.m_scalingFactor.clone();
        pgGraph.m_scalingFactor.setParent((PsUpdateIf)pgGraph);
        return pgGraph;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (!(psObject instanceof PgGraph)) {
            return;
        }
        PgGraph pgGraph = (PgGraph)psObject;
        if (this.m_domain != null && pgGraph.m_domain != null) {
            this.m_domain.copy((PsObject)pgGraph.m_domain);
        }
        if (this.m_walls != null && pgGraph.m_walls != null) {
            this.m_walls.copy((PsObject)pgGraph.m_walls);
        }
        if (this.m_surface != null && pgGraph.m_surface != null) {
            this.m_surface.copy((PsObject)pgGraph.m_surface);
        }
        if (this.m_function != null && pgGraph.m_function != null) {
            this.m_function.copy((PsObject)pgGraph.m_function);
        }
        this.m_dimOfDomain = pgGraph.m_dimOfDomain;
        this.m_dimOfSurface = pgGraph.m_dimOfSurface;
        this.m_bShowDomain = pgGraph.m_bShowDomain;
        this.m_bShowWalls = pgGraph.m_bShowWalls;
        this.m_bSynchronize = pgGraph.m_bSynchronize;
        this.m_offset.copy(pgGraph.m_offset);
        this.m_scalingFactor.copy(pgGraph.m_scalingFactor);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgGraph *********\n");
        if (this.m_domain == null) {
            stringBuffer.append("\t m_domain    = null\n");
        } else {
            stringBuffer.append(this.m_domain.toString());
        }
        if (this.m_surface == null) {
            stringBuffer.append("\t m_surface    = null\n");
        } else {
            stringBuffer.append(this.m_surface.toString());
        }
        if (this.m_function == null) {
            stringBuffer.append("\t m_function    = null\n");
        } else {
            stringBuffer.append(this.m_function.toString());
        }
        return stringBuffer.toString();
    }

    public boolean update(Object object) {
        PsDebug.notify((String)"called");
        if (this.m_bIsUpdateSender) {
            return true;
        }
        if (object == null) {
            return super.update(null);
        }
        if (object == this) {
            PvDisplayIf pvDisplayIf;
            Enumeration enumeration;
            Vector vector;
            boolean bl = false;
            if (this.m_bSynchronize) {
                if (this.hasVertexColors()) {
                    this.m_domain.setVertexColors(this.getVertexColors());
                    this.m_domain.showVertexColors(this.isShowingVertexColors());
                    bl = true;
                }
                if (this.hasElementColors()) {
                    this.m_domain.setElementColors(this.getElementColors());
                    this.m_domain.showElementColors(this.isShowingElementColors());
                    bl = true;
                }
            }
            if (this.m_bShowWalls != this.m_walls.isVisible()) {
                this.m_walls.setVisible(this.m_bShowWalls);
                vector = this.getDisplayList();
                if (vector != null) {
                    enumeration = vector.elements();
                    while (enumeration != null && enumeration.hasMoreElements()) {
                        pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
                        if (this.m_bShowWalls) {
                            pvDisplayIf.addGeometry((PgGeometryIf)this.m_walls);
                            continue;
                        }
                        pvDisplayIf.removeGeometry((PgGeometryIf)this.m_walls);
                    }
                }
            }
            if (this.m_domain != null && this.m_bShowDomain != this.m_domain.isVisible()) {
                this.m_domain.setVisible(this.m_bShowDomain);
                vector = this.getDisplayList();
                if (vector != null) {
                    enumeration = vector.elements();
                    while (enumeration != null && enumeration.hasMoreElements()) {
                        pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
                        if (this.m_bShowDomain) {
                            pvDisplayIf.addGeometry((PgGeometryIf)this.m_domain);
                            continue;
                        }
                        pvDisplayIf.removeGeometry((PgGeometryIf)this.m_domain);
                    }
                }
                bl = true;
            }
            if (bl) {
                this.m_bIsUpdateSender = true;
                this.m_domain.update((Object)this.m_domain);
                this.m_bIsUpdateSender = false;
            }
            this.compute();
            if (this.m_bShowWalls) {
                this.m_bIsUpdateSender = true;
                this.m_walls.update((Object)this.m_walls);
                this.m_bIsUpdateSender = false;
            }
            return super.update(object);
        }
        if (object == this.m_domain) {
            if (this.m_surface != null) {
                if (this.m_surface.getNumVertices() != this.m_domain.getNumVertices()) {
                    this.m_surface.setNumVertices(this.m_domain.getNumVertices());
                }
                this.m_surface.copyElementSet((PgElementSet)this.m_domain);
            }
            if (this.getNumVertices() != this.m_domain.getNumVertices()) {
                this.setNumVertices(this.m_domain.getNumVertices());
            }
            this.copyConnectivity(this.m_domain);
            return this.update((Object)this);
        }
        if (object == this.m_surface) {
            this.makeVertices();
            return this.update((Object)this);
        }
        if (object == this.m_function) {
            return this.update((Object)this);
        }
        if (object == this.m_scalingFactor) {
            return this.update((Object)this);
        }
        if (object == this.m_offset) {
            return this.update((Object)this);
        }
        return super.update(object);
    }

    public void setNumVertices(int n) {
        super.setNumVertices(n);
        if (this.m_walls != null) {
            PgDomainDescr pgDomainDescr = this.m_domain.getDescr();
            int n2 = 2 * (pgDomainDescr.getNumULines() + pgDomainDescr.getNumVLines()) - 4;
            this.m_walls.setNumVertices(2 * n2);
            this.m_walls.setNumElements(n2);
            for (int i = 0; i < n2 - 1; ++i) {
                this.m_walls.setElement(i, i, i + n2, i + n2 + 1, i + 1);
            }
            this.m_walls.setElement(n2 - 1, n2 - 1, n2 - 1 + n2, n2, 0);
        }
    }

    public PgDomain getDomain() {
        PdVector[] pdVectorArray = this.m_domain.getVertices();
        for (int i = 0; i < ((PgPointSet)this).m_numVertices; ++i) {
            for (int j = 0; j < this.m_dimOfDomain; ++j) {
                pdVectorArray[i].m_data[j] = ((PgPointSet)this).m_vertex[i].m_data[j];
            }
        }
        return this.m_domain;
    }

    public PgElementSet getSurface() {
        PdVector[] pdVectorArray = this.m_surface.getVertices();
        for (int i = 0; i < ((PgPointSet)this).m_numVertices; ++i) {
            for (int j = 0; j < this.m_dimOfSurface; ++j) {
                pdVectorArray[i].m_data[j] = ((PgPointSet)this).m_vertex[i].m_data[this.m_dimOfDomain + j];
            }
        }
        return this.m_surface;
    }

    public void setSurfaces(PgDomain pgDomain, PgElementSet pgElementSet) {
        if (pgDomain == null && pgElementSet == null) {
            if (this.m_domain != null) {
                this.m_domain.removeUpdateListener((PsUpdateIf)this);
                this.m_domain = null;
            }
            if (this.m_surface != null) {
                this.m_surface.removeUpdateListener((PsUpdateIf)this);
                this.m_surface = null;
            }
            return;
        }
        if (pgDomain == null) {
            PsDebug.warning((String)"missing domain");
            return;
        }
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing image surface");
            return;
        }
        if (pgDomain.getDimOfVertices() + pgElementSet.getDimOfVertices() != ((PgGeometry)this).m_dim) {
            PsDebug.warning((String)"Sum of vertex dimension of domain and surface unequal to m_dim");
            return;
        }
        if (pgDomain.getNumVertices() != pgElementSet.getNumVertices()) {
            PsDebug.warning((String)("new domain and surface differ in number of vertices.\n\tdomain  = " + pgDomain.getName() + " numVertices = " + pgDomain.getNumVertices() + "\n\tsurface = " + pgElementSet.getName() + " numVertices = " + pgElementSet.getNumVertices()));
            return;
        }
        this.m_domain = pgDomain;
        this.m_domain.addUpdateListener((PsUpdateIf)this);
        this.m_dimOfDomain = this.m_domain.getDimOfVertices();
        this.m_surface = pgElementSet;
        this.m_surface.addUpdateListener((PsUpdateIf)this);
        this.m_dimOfSurface = this.m_surface.getDimOfVertices();
        this.setNumVertices(this.m_domain.getNumVertices());
        this.copyConnectivity(this.m_domain);
    }

    public PuFunction getFunction() {
        return this.m_function;
    }

    public boolean setFunction(PuFunction puFunction) {
        if (puFunction == null) {
            PsDebug.warning((String)"missing argument function.");
            return false;
        }
        if (puFunction.getNumFunctions() != this.m_dimOfSurface) {
            PsDebug.warning((String)("number of functions unequal to m_dim\n\tnumFunctions = " + puFunction.getNumFunctions() + " != " + this.m_dimOfSurface));
            return false;
        }
        if (this.m_function != null) {
            this.m_function.copy((PsObject)puFunction);
        } else {
            this.m_function = (PuFunction)puFunction.clone();
            this.m_function.setParent((PsUpdateIf)this);
        }
        return true;
    }

    public boolean isEnabledSynchronization() {
        return this.m_bSynchronize;
    }

    public void setEnabledSynchronization(boolean bl) {
        this.m_bSynchronize = bl;
    }

    public boolean isShowingDomain() {
        return this.m_bShowDomain;
    }

    public void setShowingDomain(boolean bl) {
        this.m_bShowDomain = bl;
    }

    public boolean isShowingWalls() {
        return this.m_bShowWalls;
    }

    public void setShowingWalls(boolean bl) {
        this.m_bShowWalls = bl;
    }

    public PuDouble getOffsetSlider() {
        return this.m_offset;
    }

    public double getOffset() {
        return this.m_offset.getValue();
    }

    public void setOffset(double d) {
        this.m_offset.setValue(d);
    }

    public double getScalingFactor() {
        return this.m_scalingFactor.getValue();
    }

    public void setScalingFactor(double d) {
        this.m_scalingFactor.setValue(d);
    }

    public void makeSurface() {
        if (this.m_domain == null || this.m_surface == null || this.m_function == null) {
            return;
        }
        if (this.m_domain.getNumVertices() != this.m_surface.getNumVertices()) {
            PsDebug.warning((String)("domain and surface differ in numVertices.\n\tdomain  = " + this.m_domain.getName() + " numVertices = " + this.m_domain.getNumVertices() + "\n\tsurface = " + this.m_surface.getName() + " numVertices = " + this.m_surface.getNumVertices()));
            return;
        }
        PdVector[] pdVectorArray = this.m_domain.getVertices();
        PdVector[] pdVectorArray2 = this.m_surface.getVertices();
        for (int i = 0; i < ((PgPointSet)this).m_numVertices; ++i) {
            this.m_function.eval(pdVectorArray2[i].m_data, pdVectorArray[i].m_data);
        }
    }

    public void makeVertices() {
        int n;
        int n2;
        if (this.m_domain == null || this.m_surface == null) {
            return;
        }
        if (this.m_domain.getNumVertices() != this.m_surface.getNumVertices()) {
            PsDebug.warning((String)("domain and surface differ in numVertices.\n\tdomain  = " + this.m_domain.getName() + " numVertices = " + this.m_domain.getNumVertices() + "\n\tsurface = " + this.m_surface.getName() + " numVertices = " + this.m_surface.getNumVertices()));
            return;
        }
        PdVector[] pdVectorArray = this.m_domain.getVertices();
        PdVector[] pdVectorArray2 = this.m_surface.getVertices();
        double d = this.m_scalingFactor.getValue();
        double d2 = this.m_offset.getValue();
        for (n2 = 0; n2 < ((PgPointSet)this).m_numVertices; ++n2) {
            for (n = 0; n < this.m_dimOfDomain; ++n) {
                ((PgPointSet)this).m_vertex[n2].m_data[n] = pdVectorArray[n2].m_data[n];
            }
            for (n = 0; n < this.m_dimOfSurface; ++n) {
                ((PgPointSet)this).m_vertex[n2].m_data[this.m_dimOfDomain + n] = d * pdVectorArray2[n2].m_data[n] + d2;
            }
        }
        this.makeVertexNormals();
        this.makeElementNormals();
        if (this.m_walls != null) {
            int n3;
            n2 = this.m_domain.getDescr().getNumULines();
            n = this.m_domain.getDescr().getNumVLines();
            int n4 = 0;
            int n5 = 0;
            for (n3 = 0; n3 < n2 - 1; ++n3) {
                this.setWallVertex(n4, n5);
                ++n4;
                n5 += n;
            }
            n5 = (n2 - 1) * n;
            for (n3 = 0; n3 < n - 1; ++n3) {
                this.setWallVertex(n4, n5);
                ++n4;
                ++n5;
            }
            n5 = n2 * n - 1;
            for (n3 = 0; n3 < n2 - 1; ++n3) {
                this.setWallVertex(n4, n5);
                ++n4;
                n5 -= n;
            }
            n5 = n - 1;
            for (n3 = 0; n3 < n - 1; ++n3) {
                this.setWallVertex(n4, n5);
                ++n4;
                --n5;
            }
        }
    }

    private void setWallVertex(int n, int n2) {
        int n3;
        PdVector[] pdVectorArray = this.m_domain.getVertices();
        PdVector[] pdVectorArray2 = this.m_walls.getVertices();
        for (n3 = 0; n3 < this.m_dimOfDomain; ++n3) {
            pdVectorArray2[n].m_data[n3] = pdVectorArray[n2].m_data[n3];
        }
        for (n3 = 0; n3 < this.m_dimOfSurface; ++n3) {
            pdVectorArray2[n].m_data[this.m_dimOfDomain + n3] = 0.0;
        }
        n3 = this.m_walls.getNumVertices() / 2;
        pdVectorArray2[n3 + n].copyArray(((PgPointSet)this).m_vertex[n2]);
    }

    public boolean setSurfaceVertex(int n, PdVector pdVector) {
        if (n < 0 || n > ((PgPointSet)this).m_numVertices - 1) {
            PsDebug.warning((String)("index=" + n + " out of range"));
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning((String)"missing argument");
            return false;
        }
        if (pdVector.getSize() != this.m_dimOfSurface) {
            PsDebug.warning((String)"vertex size does not match dimOfSurface.");
            return false;
        }
        PdVector[] pdVectorArray = this.m_surface.getVertices();
        for (int i = this.m_dimOfDomain; i < ((PgGeometry)this).m_dim; ++i) {
            pdVectorArray[n].m_data[i - this.m_dimOfDomain] = pdVector.m_data[i];
            ((PgPointSet)this).m_vertex[n].m_data[i] = pdVector.m_data[i];
        }
        return true;
    }

    public void compute() {
        this.makeSurface();
        this.makeVertices();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

