/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.object.PsDebug;
import jv.vecmath.PdMatrix;

public class PnMatrix {
    public static void main(String[] stringArray) {
        int n;
        int n2 = 2;
        PdMatrix pdMatrix = new PdMatrix(n2);
        pdMatrix.m_data[0][0] = 2.0;
        pdMatrix.m_data[0][1] = 1.0;
        pdMatrix.m_data[1][0] = 0.0;
        pdMatrix.m_data[1][1] = 1.0;
        PsDebug.message((String)pdMatrix.toString());
        PdMatrix pdMatrix2 = new PdMatrix(n2);
        pdMatrix2.copy(pdMatrix);
        PdMatrix pdMatrix3 = new PdMatrix(n2);
        PnMatrix.invert(pdMatrix3.m_data, pdMatrix.m_data, n2);
        PsDebug.message((String)pdMatrix3.toString());
        PdMatrix pdMatrix4 = new PdMatrix(n2);
        pdMatrix4.mult(pdMatrix2, pdMatrix3);
        PsDebug.message((String)pdMatrix4.toString());
        n2 = 12;
        pdMatrix = new PdMatrix(n2);
        for (n = 0; n < n2; ++n) {
            pdMatrix.m_data[n][n] = 2.0;
        }
        for (n = 1; n < n2; ++n) {
            pdMatrix.m_data[n - 1][n] = 1.0;
        }
        for (n = 1; n < n2; ++n) {
            pdMatrix.m_data[n][n - 1] = 1.0;
        }
        PsDebug.message((String)pdMatrix.toString());
        double d = PnMatrix.determinant(pdMatrix.m_data, n2);
        PsDebug.message((String)("determinant = " + d));
        pdMatrix2 = new PdMatrix(n2);
        pdMatrix2.copy(pdMatrix);
        pdMatrix3 = new PdMatrix(n2);
        PnMatrix.invert(pdMatrix3.m_data, pdMatrix.m_data, n2);
        PsDebug.message((String)pdMatrix3.toString());
        pdMatrix4 = new PdMatrix(n2);
        pdMatrix4.mult(pdMatrix2, pdMatrix3);
        PsDebug.message((String)pdMatrix4.toString());
    }

    public static boolean invert(double[][] dArray, double[][] dArray2, int n) {
        int n2;
        int n3;
        double[][] dArray3 = new double[n][n];
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 < n; ++n2) {
                dArray3[n3][n2] = dArray2[n3][n2];
            }
        }
        int[] nArray = new int[n];
        try {
            PnMatrix.ludcmp(dArray3, n, nArray);
        }
        catch (ArithmeticException arithmeticException) {
            return false;
        }
        double[] dArray4 = new double[n];
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 < n; ++n2) {
                dArray4[n2] = 0.0;
            }
            dArray4[n3] = 1.0;
            PnMatrix.lubksb(dArray3, n, nArray, dArray4);
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2][n3] = dArray4[n2];
            }
        }
        return true;
    }

    public static double determinant(double[][] dArray, int n) {
        int n2;
        double[][] dArray2 = new double[n][n];
        for (n2 = 0; n2 < n; ++n2) {
            for (int i = 0; i < n; ++i) {
                dArray2[n2][i] = dArray[n2][i];
            }
        }
        int[] nArray = new int[n];
        double d = 0.0;
        try {
            d = PnMatrix.ludcmp(dArray2, n, nArray);
        }
        catch (ArithmeticException arithmeticException) {
            PsDebug.warning((String)"matrix singular.");
            return 0.0;
        }
        for (n2 = 0; n2 < n; ++n2) {
            d *= dArray2[n2][n2];
        }
        return d;
    }

    public static double ludcmp(double[][] dArray, int n, int[] nArray) throws ArithmeticException {
        int n2;
        double d;
        int n3;
        double d2 = 1.0E-20;
        int n4 = 0;
        double[] dArray2 = new double[n];
        double d3 = 1.0;
        for (n3 = 0; n3 < n; ++n3) {
            d = 0.0;
            for (n2 = 0; n2 < n; ++n2) {
                double d4;
                double d5 = Math.abs(dArray[n3][n2]);
                if (!(d4 > d)) continue;
                d = d5;
            }
            if (d == 0.0) {
                throw new ArithmeticException("Singular matrix in routine LUDCMP");
            }
            dArray2[n3] = 1.0 / d;
        }
        for (n2 = 0; n2 < n; ++n2) {
            double d6;
            int n5;
            double d7;
            for (n3 = 0; n3 < n2; ++n3) {
                d7 = dArray[n3][n2];
                for (n5 = 0; n5 < n3; ++n5) {
                    d7 -= dArray[n3][n5] * dArray[n5][n2];
                }
                dArray[n3][n2] = d7;
            }
            d = 0.0;
            for (n3 = n2; n3 < n; ++n3) {
                double d8;
                d7 = dArray[n3][n2];
                for (n5 = 0; n5 < n2; ++n5) {
                    d7 -= dArray[n3][n5] * dArray[n5][n2];
                }
                dArray[n3][n2] = d7;
                d6 = dArray2[n3] * Math.abs(d7);
                if (!(d8 >= d)) continue;
                d = d6;
                n4 = n3;
            }
            if (n2 != n4) {
                for (n5 = 0; n5 < n; ++n5) {
                    d6 = dArray[n4][n5];
                    dArray[n4][n5] = dArray[n2][n5];
                    dArray[n2][n5] = d6;
                }
                d3 = -1.0 * d3;
                dArray2[n4] = dArray2[n2];
            }
            nArray[n2] = n4;
            if (dArray[n2][n2] == 0.0) {
                dArray[n2][n2] = d2;
            }
            if (n2 == n) continue;
            d6 = 1.0 / dArray[n2][n2];
            for (n3 = n2 + 1; n3 < n; ++n3) {
                double[] dArray3 = dArray[n3];
                int n6 = n2;
                dArray3[n6] = dArray3[n6] * d6;
            }
        }
        return d3;
    }

    public static void lubksb(double[][] dArray, int n, int[] nArray, double[] dArray2) {
        int n2;
        double d;
        int n3;
        int n4 = -1;
        for (n3 = 0; n3 < n; ++n3) {
            int n5 = nArray[n3];
            d = dArray2[n5];
            dArray2[n5] = dArray2[n3];
            if (n4 != -1) {
                for (n2 = n4; n2 <= n3 - 1; ++n2) {
                    d -= dArray[n3][n2] * dArray2[n2];
                }
            } else if (d != 0.0) {
                n4 = n3;
            }
            dArray2[n3] = d;
        }
        for (n3 = n - 1; n3 >= 0; --n3) {
            d = dArray2[n3];
            for (n2 = n3 + 1; n2 < n; ++n2) {
                d -= dArray[n3][n2] * dArray2[n2];
            }
            dArray2[n3] = d / dArray[n3][n3];
        }
    }

    public static final boolean pentas(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d) {
        int n2;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        for (n2 = 0; n2 < n; ++n2) {
            double d11 = dArray[n2] - d5 * d2 - d10 * d8;
            if (d11 < d && d11 > -d) {
                return false;
            }
            double d12 = dArray2[n2];
            d7 = d2;
            dArray2[n2] = d2 = (d12 - d5 * d3) / d11;
            double d13 = dArray3[n2];
            d8 = d3;
            dArray3[n2] = d3 = d13 / d11;
            dArray[n2] = (dArray4[n2] - d9 * d10 - d4 * d5) / d11;
            d9 = d4;
            d4 = dArray[n2];
            d5 = d12 - d6 * d7;
            d10 = d6;
            d6 = d13;
        }
        d3 = 0.0;
        dArray4[n - 1] = d2 = dArray[n - 1];
        for (n2 = n - 2; n2 >= 0; --n2) {
            dArray4[n2] = dArray[n2] - dArray2[n2] * d2 - dArray3[n2] * d3;
            d3 = d2;
            d2 = dArray4[n2];
        }
        return true;
    }

    public static final boolean penpes(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double d) {
        double d2;
        double d3;
        int n2;
        double d4;
        double d5 = 0.0;
        int n3 = n - 2;
        int n4 = n - 3;
        int n5 = n - 4;
        int n6 = n - 5;
        double d6 = dArray[0];
        if (d6 < d && d6 > -d) {
            return false;
        }
        dArray[0] = dArray4[0] / d6;
        dArray5[0] = dArray3[n3] / d6;
        dArray6[0] = dArray2[n - 1] / d6;
        dArray4[0] = dArray3[n3];
        dArray7[0] = dArray2[n - 1];
        double d7 = dArray2[0];
        double d8 = dArray3[0];
        dArray2[0] = d4 = dArray2[0] / d6;
        dArray3[0] = dArray3[0] / d6;
        d6 = dArray[1] - d7 * d4;
        if (d6 < d && d6 > -d) {
            return false;
        }
        dArray[1] = (dArray4[1] - d7 * dArray[0]) / d6;
        dArray5[1] = -(d7 * dArray5[0]) / d6;
        dArray6[1] = (dArray3[n - 1] - d7 * dArray6[0]) / d6;
        dArray4[1] = -dArray4[0] * d4;
        dArray7[1] = dArray3[n - 1] - dArray7[0] * d4;
        double d9 = d7;
        d7 = dArray2[1] - d8 * d4;
        dArray2[1] = d4 = (dArray2[1] - d9 * dArray3[0]) / d6;
        if (n > 5) {
            int n7 = n - 6;
            for (int i = 2; i <= n5; ++i) {
                n2 = i - 1;
                int n8 = i - 2;
                d5 = d8;
                d8 = dArray3[n2];
                dArray3[n2] = dArray3[n2] / d6;
                d3 = dArray3[n8];
                d6 = dArray[i] - d5 * d3 - d7 * d4;
                if (d6 < d && d6 > -d) {
                    return false;
                }
                dArray[i] = (dArray4[i] - d5 * dArray[n8] - d7 * dArray[n2]) / d6;
                dArray5[i] = -(d5 * dArray5[n8] + d7 * dArray5[n2]) / d6;
                dArray6[i] = -(d5 * dArray6[n8] + d7 * dArray6[n2]) / d6;
                dArray4[i] = -dArray4[n8] * d3 - dArray4[n2] * d4;
                dArray7[i] = -dArray7[n8] * d3 - dArray7[n2] * d4;
                d9 = d7;
                d7 = dArray2[i] - d8 * d4;
                dArray2[i] = d4 = (dArray2[i] - d9 * dArray3[n2]) / d6;
            }
            d2 = d5;
            d5 = d8;
            d8 = dArray3[n5] - dArray4[n7] * dArray3[n7] - dArray4[n6] * dArray2[n6];
            dArray3[n5] = (dArray3[n5] - d2 * dArray5[n7] - d9 * dArray5[n6]) / d6;
        } else {
            d5 = d8;
            d8 = dArray3[n5] - dArray4[n6] * dArray2[n6];
            dArray3[n5] = (dArray3[n5] - d9 * dArray5[n6]) / d6;
        }
        d3 = dArray3[n6];
        d6 = dArray[n4] - d5 * d3 - d7 * d4;
        if (d6 < d && d6 > -d) {
            return false;
        }
        dArray[n4] = (dArray4[n4] - d5 * dArray[n6] - d7 * dArray[n5]) / d6;
        d9 = d7;
        d7 = dArray2[n4] - dArray4[n6] * d3 - d8 * d4;
        dArray2[n4] = d4 = (dArray2[n4] - dArray5[n6] * d5 - d9 * dArray3[n5]) / d6;
        d2 = d5;
        d5 = d8;
        d8 = dArray3[n4] - dArray7[n6] * d3 - dArray7[n5] * dArray2[n5];
        dArray3[n4] = (dArray3[n4] - d2 * dArray6[n6] - d9 * dArray6[n5]) / d6;
        double d10 = 0.0;
        for (n2 = 0; n2 <= n6; ++n2) {
            d10 += dArray4[n2] * dArray5[n2];
        }
        d6 = dArray[n3] - d5 * dArray3[n5] - d7 * d4 - d10;
        if (d6 < d && d6 > -d) {
            return false;
        }
        d10 = 0.0;
        for (n2 = 0; n2 <= n6; ++n2) {
            d10 += dArray4[n2] * dArray[n2];
        }
        dArray[n3] = (dArray4[n3] - d10 - d5 * dArray[n5] - d7 * dArray[n4]) / d6;
        d10 = 0.0;
        for (n2 = 0; n2 <= n6; ++n2) {
            d10 += dArray4[n2] * dArray6[n2];
        }
        double d11 = dArray2[n3];
        dArray2[n3] = d4 = (d11 - d7 * dArray3[n4] - d10 - d5 * dArray6[n5]) / d6;
        d10 = 0.0;
        for (n2 = 0; n2 <= n6; ++n2) {
            d10 += dArray7[n2] * dArray5[n2];
        }
        d9 = d7;
        d7 = d11 - d8 * dArray2[n4] - d10 - dArray7[n5] * dArray3[n5];
        d10 = 0.0;
        for (n2 = 0; n2 <= n5; ++n2) {
            d10 += dArray7[n2] * dArray6[n2];
        }
        d6 = dArray[n - 1] - d8 * dArray3[n4] - d7 * d4 - d10;
        if (d6 < d && d6 > -d) {
            return false;
        }
        d10 = 0.0;
        for (n2 = 0; n2 <= n5; ++n2) {
            d10 += dArray7[n2] * dArray[n2];
        }
        dArray[n - 1] = (dArray4[n - 1] - d10 - d8 * dArray[n4] - d7 * dArray[n3]) / d6;
        dArray4[n - 1] = dArray[n - 1];
        dArray4[n3] = dArray[n3] - dArray2[n3] * dArray4[n - 1];
        dArray4[n4] = dArray[n4] - dArray2[n4] * dArray4[n3] - dArray3[n4] * dArray4[n - 1];
        dArray4[n5] = dArray[n5] - dArray2[n5] * dArray4[n4] - dArray3[n5] * dArray4[n3] - dArray6[n5] * dArray4[n - 1];
        for (n2 = n6; n2 >= 0; --n2) {
            dArray4[n2] = dArray[n2] - dArray2[n2] * dArray4[n2 + 1] - dArray3[n2] * dArray4[n2 + 2] - dArray5[n2] * dArray4[n3] - dArray6[n2] * dArray4[n - 1];
        }
        return true;
    }

    public static boolean tridag(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, int n, double d) {
        int n2;
        if (dArray6 == null) {
            dArray6 = new double[n];
        }
        if (dArray2[0] < d && dArray2[0] > -d) {
            return false;
        }
        double d2 = dArray2[0];
        dArray5[0] = dArray4[0] / d2;
        for (n2 = 1; n2 < n; ++n2) {
            dArray6[n2] = dArray3[n2 - 1] / d2;
            d2 = dArray2[n2] - dArray[n2] * dArray6[n2];
            if (d2 < d && d2 > -d) {
                return false;
            }
            dArray5[n2] = (dArray4[n2] - dArray[n2] * dArray5[n2 - 1]) / d2;
        }
        for (n2 = n - 2; n2 >= 0; --n2) {
            int n3 = n2;
            dArray5[n3] = dArray5[n3] - dArray6[n2 + 1] * dArray5[n2 + 1];
        }
        return true;
    }

    public static boolean cyclic(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8, double[] dArray9, int n, double d) {
        int n2;
        if (n <= 2) {
            return false;
        }
        double d2 = dArray3[n - 1];
        double d3 = dArray[0];
        if (dArray6 == null) {
            dArray6 = new double[n];
        }
        if (dArray7 == null) {
            dArray7 = new double[n];
        }
        if (dArray8 == null) {
            dArray8 = new double[n];
        }
        if (dArray9 == null) {
            dArray9 = new double[n];
        }
        double d4 = -dArray2[0];
        dArray6[0] = dArray2[0] - d4;
        dArray6[n - 1] = dArray2[n - 1] - d2 * d3 / d4;
        System.arraycopy(dArray2, 1, dArray6, 1, n - 2);
        if (!PnMatrix.tridag(dArray, dArray6, dArray3, dArray4, dArray5, dArray9, n, d)) {
            return false;
        }
        dArray7[0] = d4;
        dArray7[n - 1] = d2;
        for (n2 = 1; n2 < n - 1; ++n2) {
            dArray7[n2] = 0.0;
        }
        if (!PnMatrix.tridag(dArray, dArray6, dArray3, dArray7, dArray8, dArray9, n, d)) {
            return false;
        }
        double d5 = 1.0 + dArray8[0] + d3 * dArray8[n - 1] / d4;
        if (d5 < d) {
            return false;
        }
        d5 = (dArray5[0] + d3 * dArray5[n - 1] / d4) / d5;
        for (n2 = 0; n2 < n; ++n2) {
            int n3 = n2;
            dArray5[n3] = dArray5[n3] - d5 * dArray8[n2];
        }
        return true;
    }
}

