/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.numeric.PnEnergy;
import jvx.numeric.PnStiffDiriConforming;
import jvx.numeric.PnStiffDiriNonConforming;

public class PnAreaEnergy
extends PnEnergy {
    static /* synthetic */ Class class$jvx$numeric$PnAreaEnergy;

    public PnAreaEnergy() {
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnAreaEnergy == null ? (class$jvx$numeric$PnAreaEnergy = PnAreaEnergy.class$("jvx.numeric.PnAreaEnergy")) : class$jvx$numeric$PnAreaEnergy)) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void initSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (this.m_stiffMatrix == null) {
            PsDebug.warning((String)"missing m_stiffMatrix, call setSurface before.");
            return;
        }
        super.initSurface(pgElementSet, pgElementSet2);
        this.m_stiffMatrix.init(pgElementSet2);
    }

    private void initStiff(PdVector pdVector) {
        if (this.m_surface == null) {
            return;
        }
        PdVector[] pdVectorArray = this.m_surface.getVertices();
        int n = 0;
        for (int i = 0; i < this.m_nop; ++i) {
            for (int j = 0; j < this.m_dim; ++j) {
                pdVectorArray[i].m_data[j] = pdVector.m_data[n++];
            }
        }
        this.m_stiffMatrix.init(this.m_surface);
    }

    public boolean setSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (pgElementSet2 == null) {
            PsDebug.warning((String)"missing surface geometry.");
            return false;
        }
        if (!super.setSurface(pgElementSet, pgElementSet2)) {
            return false;
        }
        if (this.m_domain != null && this.m_domain.isConforming() != this.m_surface.isConforming()) {
            PsDebug.error((String)"domain and surface have different conformality", (Object)((Object)this));
            return false;
        }
        if (this.m_domain != null && this.m_domain.getDimOfElements() != 3) {
            PsDebug.warning((String)("domain=" + this.m_domain.getName() + " not triangulated"));
            PgElementSet.triangulate((PgElementSet)this.m_domain);
        }
        if (this.m_surface.getDimOfElements() != 3) {
            PsDebug.warning((String)("surface=" + this.m_surface.getName() + " not triangulated"));
            PgElementSet.triangulate((PgElementSet)this.m_surface);
        }
        this.m_stiffMatrix = this.m_surface.isConforming() ? new PnStiffDiriConforming(this.m_surface) : new PnStiffDiriNonConforming(this.m_surface);
        return true;
    }

    public double eval(PdVector pdVector) {
        this.initStiff(pdVector);
        return super.eval(pdVector);
    }

    public PdVector evalGradient(PdVector pdVector, PdVector pdVector2) {
        this.initStiff(pdVector);
        return super.evalGradient(pdVector, pdVector2);
    }

    public PdMatrix evalHessian(PdMatrix pdMatrix) {
        PsDebug.notify((String)"called");
        if (pdMatrix == null) {
            pdMatrix = new PdMatrix();
        }
        int n = this.m_index.length;
        pdMatrix.setSize(this.m_dim * n);
        pdMatrix.setConstant(0.0);
        PdVector[] pdVectorArray = this.m_surface.getVertices();
        PiVector[] piVectorArray = this.m_surface.getElements();
        this.m_surface.makeElementNormals();
        PdVector[] pdVectorArray2 = this.m_surface.getElementNormals();
        int n2 = this.m_surface.getNumElements();
        double[] dArray = new double[3];
        PdVector[] pdVectorArray3 = PdVector.realloc(null, (int)3, (int)this.m_dim);
        PdVector[] pdVectorArray4 = PdVector.realloc(null, (int)3, (int)this.m_dim);
        PdMatrix pdMatrix2 = new PdMatrix(this.m_dim);
        PdMatrix pdMatrix3 = new PdMatrix(this.m_dim);
        PdMatrix pdMatrix4 = new PdMatrix(this.m_dim);
        for (int i = 0; i < n2; ++i) {
            int n3;
            int[] nArray = piVectorArray[i].m_data;
            PuVectorGeom.ctg((double[])dArray, (PdVector)pdVectorArray[nArray[0]], (PdVector)pdVectorArray[nArray[1]], (PdVector)pdVectorArray[nArray[2]]);
            pdMatrix2.adjoint(pdVectorArray2[i]);
            for (n3 = 0; n3 < 3; ++n3) {
                pdVectorArray4[n3].sub(pdVectorArray[nArray[(n3 + 2) % 3]], pdVectorArray[nArray[(n3 + 1) % 3]]);
            }
            for (n3 = 0; n3 < 3; ++n3) {
                pdVectorArray3[n3].blend(dArray[(n3 + 1) % 3], pdVectorArray4[(n3 + 1) % 3], -dArray[(n3 + 2) % 3], pdVectorArray4[(n3 + 2) % 3]);
            }
            for (n3 = 0; n3 < 3; ++n3) {
                pdVectorArray4[n3].normalize();
                pdVectorArray3[n3].normalize();
            }
            for (n3 = 0; n3 < 3; ++n3) {
                int n4;
                int n5;
                int n6;
                if (this.m_bUseConstrainMatrix || !pdVectorArray[nArray[n3]].hasTag(14)) {
                    n6 = this.m_dim * this.m_invIndex[nArray[n3]];
                    if (n6 < 0 || n6 > 3 * n + 2) {
                        PsDebug.warning((String)("index out of range: i=" + n6));
                        return pdMatrix;
                    }
                    for (n5 = 0; n5 < this.m_dim; ++n5) {
                        for (n4 = 0; n4 < this.m_dim; ++n4) {
                            double[] dArray2 = pdMatrix.m_data[n6 + n5];
                            int n7 = n6 + n4;
                            dArray2[n7] = dArray2[n7] + (dArray[(n3 + 1) % 3] + dArray[(n3 + 2) % 3]) * pdMatrix2.m_data[n5][n4] / 2.0;
                        }
                    }
                }
                if (!this.m_bUseConstrainMatrix && (pdVectorArray[nArray[(n3 + 2) % 3]].hasTag(14) || pdVectorArray[nArray[(n3 + 1) % 3]].hasTag(14))) continue;
                pdMatrix3.adjoint(pdVectorArray4[n3], pdVectorArray3[n3]);
                pdMatrix4.adjoint(pdVectorArray3[n3], pdVectorArray4[n3]);
                n6 = this.m_dim * this.m_invIndex[nArray[(n3 + 2) % 3]];
                int n8 = this.m_dim * this.m_invIndex[nArray[(n3 + 1) % 3]];
                if (n6 < 0 || n6 > this.m_dim * n + this.m_dim - 1 || n8 < 0 || n8 > this.m_dim * n + this.m_dim - 1) {
                    PsDebug.notify((String)("index out of range: i=" + n6 + ", j=" + n8));
                    return pdMatrix;
                }
                for (n5 = 0; n5 < this.m_dim; ++n5) {
                    for (n4 = 0; n4 < this.m_dim; ++n4) {
                        double[] dArray3 = pdMatrix.m_data[n6 + n5];
                        int n9 = n8 + n4;
                        dArray3[n9] = dArray3[n9] + (-pdMatrix3.m_data[n5][n4] + pdMatrix4.m_data[n5][n4] - dArray[n3] * pdMatrix2.m_data[n5][n4]) / 2.0;
                        double[] dArray4 = pdMatrix.m_data[n8 + n5];
                        int n10 = n6 + n4;
                        dArray4[n10] = dArray4[n10] + (pdMatrix3.m_data[n5][n4] - pdMatrix4.m_data[n5][n4] - dArray[n3] * pdMatrix2.m_data[n5][n4]) / 2.0;
                    }
                }
            }
        }
        return pdMatrix;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

