/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.io.DataOutputStream;
import jvx.loader.PsU3dBlock;

class PsU3dGroupNodeBlock
extends PsU3dBlock {
    public String m_name;
    public int m_parentNodeCount;
    public String[] m_parentNodeName;
    public float[][][] m_parentNodeTransform;

    public PsU3dGroupNodeBlock() {
        this.m_blockType = -223;
    }

    public void setNumParents(int n) {
        this.m_parentNodeCount = n;
        this.m_parentNodeTransform = new float[n][4][4];
        this.m_parentNodeName = new String[n];
    }

    public void computeSize() {
        this.m_dataSize = this.m_name.length() + 2 + 4;
        for (int i = 0; i < this.m_parentNodeCount; ++i) {
            this.m_dataSize += this.m_parentNodeName[i].length() + 2 + 64;
        }
        this.m_metaDataSize = 0;
    }

    public void write(DataOutputStream dataOutputStream) {
        super.write(dataOutputStream);
        int n = this.writeString(dataOutputStream, this.m_name);
        this.writeUInt32(dataOutputStream, this.m_parentNodeCount);
        for (int i = 0; i < this.m_parentNodeCount; ++i) {
            n += this.writeString(dataOutputStream, this.m_parentNodeName[i]);
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    this.writeFloat32(dataOutputStream, this.m_parentNodeTransform[i][j][k]);
                }
            }
        }
        this.writePaddingBytes(dataOutputStream, n %= 4);
    }
}

