/*
 * Decompiled with CFR 0.152.
 */
package jvx.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PvDisplayOverlayIf;
import jvx.gui.PuColorBar;

public class PuColorBarCanvas
extends Canvas
implements PvDisplayOverlayIf,
ActionListener {
    public static final String[] COLOR_MAP_NAMES = new String[]{"JavaView Colortable", "white/green/red", "white/red"};
    private static final int MODE_LEFT_RESIZE = 1;
    private static final int MODE_RIGHT_RESIZE = 2;
    private static final int MODE_MOVE = 3;
    private final Cursor[] CURSOR = new Cursor[]{new Cursor(0), new Cursor(10), new Cursor(11), new Cursor(13)};
    protected PuColorBar m_puColorBar;
    protected int m_width;
    protected int m_height;
    protected int m_leftInset;
    protected int m_topInset;
    protected int m_clickButton;
    protected double m_startMark;
    private int m_mode;
    private double m_clickPos;
    private PopupMenu m_popupMenu;
    private MenuItem[] m_menuItems;
    protected Component m_dispPanel;
    public static final int MODE_PANEL = 0;
    public static final int MODE_OVERLAY = 1;
    public int m_panelMode;
    protected static final int PREF_WIDTH = 200;
    protected static final int PREF_HEIGHT = 20;

    public PuColorBarCanvas() {
        this.addMouseListener((MouseListener)((Object)this));
        this.addMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        if (!(psUpdateIf instanceof PuColorBar)) {
            PsDebug.warning((String)"Parent must be instance of PuColorBar");
            return;
        }
        this.m_puColorBar = (PuColorBar)psUpdateIf;
    }

    public void enableContextMenu(boolean bl) {
        if (bl && this.m_popupMenu == null) {
            this.m_popupMenu = new PopupMenu("ColorBar Popupmenu");
            Font font = PsConfig.getFont((int)2);
            font = new Font(font.getName(), 0, font.getSize() - 2 * PsConfig.getMonitorScale());
            this.m_popupMenu.setFont(font);
            int n = COLOR_MAP_NAMES.length;
            this.m_menuItems = new MenuItem[n];
            for (int i = 0; i < n; ++i) {
                this.m_menuItems[i] = new MenuItem(COLOR_MAP_NAMES[i]);
                this.m_menuItems[i].addActionListener(this);
                this.m_popupMenu.add(this.m_menuItems[i]);
            }
            if (this.m_dispPanel != null) {
                this.m_dispPanel.add(this.m_popupMenu);
            }
        } else if (!bl && this.m_popupMenu != null) {
            this.m_dispPanel.remove(this.m_popupMenu);
            this.m_popupMenu = null;
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        int n = this.getSize().width - 1;
        int n2 = this.getSize().height - 1;
        this.paintOverlay(graphics, 0, 0, n, n2);
    }

    private boolean isInside(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        PsDebug.message((String)("mouse event at = (" + n + ", " + n2 + "), mode = " + this.m_mode));
        boolean bl = this.m_leftInset < n && n < this.m_leftInset + this.m_width && this.m_topInset < n2 && n2 < this.m_topInset + this.m_height;
        return bl;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isInside(mouseEvent)) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = n - this.m_leftInset;
        int n4 = n2 - this.m_topInset;
        int n5 = mouseEvent.getModifiers();
        if ((n5 & 0x10) != 0) {
            this.m_clickButton = 1;
            double d = (double)n3 / ((double)this.m_width - 1.0);
            if (mouseEvent.isControlDown()) {
                if (this.m_puColorBar.m_allowMark) {
                    this.m_puColorBar.m_maxMark = this.m_startMark = d;
                    this.m_puColorBar.m_minMark = this.m_startMark;
                    this.m_puColorBar.update((Object)this.m_puColorBar);
                    this.repaint();
                }
            } else {
                this.m_clickPos = d;
                this.m_mode = this.getMode(this.m_clickPos);
            }
        } else if ((n5 & 4) != 0) {
            if (!this.m_puColorBar.m_allowContextMenu) {
                return;
            }
            this.m_popupMenu.show(this.m_dispPanel, n, n2);
        } else {
            return;
        }
        mouseEvent.consume();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isInside(mouseEvent)) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = n - this.m_leftInset;
        int n4 = n2 - this.m_topInset;
        switch (this.m_clickButton) {
            case 1: {
                double d = (double)n3 / ((double)this.m_width - 1.0);
                if (mouseEvent.isControlDown()) {
                    this.ctrlLeftDrag(d);
                    break;
                }
                this.leftDrag(d);
                break;
            }
            case 3: {
                break;
            }
            default: {
                return;
            }
        }
        mouseEvent.consume();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.isInside(mouseEvent)) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = n - this.m_leftInset;
        int n4 = n2 - this.m_topInset;
        double d = (double)n3 / ((double)this.m_width - 1.0);
        int n5 = this.getMode(d);
        if (n5 != this.m_mode) {
            this.m_mode = n5;
            this.m_dispPanel.setCursor(this.CURSOR[n5]);
        }
        mouseEvent.isConsumed();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.m_clickButton = 0;
        if (!this.isInside(mouseEvent)) {
            return;
        }
        mouseEvent.consume();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.isInside(mouseEvent)) {
            return;
        }
        mouseEvent.consume();
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void ctrlLeftDrag(double d) {
        if (!this.m_puColorBar.m_allowMark) {
            return;
        }
        if (d >= 1.0) {
            this.m_puColorBar.m_maxMark = Double.MAX_VALUE;
        } else if (d <= 0.0) {
            this.m_puColorBar.m_minMark = Double.MIN_VALUE;
        } else {
            this.m_puColorBar.m_minMark = Math.min(this.m_startMark, d);
            this.m_puColorBar.m_maxMark = Math.max(this.m_startMark, d);
        }
        this.m_puColorBar.update((Object)this.m_puColorBar);
        this.repaint();
    }

    private void leftDrag(double d) {
        switch (this.m_mode) {
            case 1: {
                double d2 = Math.max(0.0, d);
                if (d2 > this.m_puColorBar.m_transformMax) {
                    d2 = this.m_puColorBar.m_transformMax;
                }
                this.m_puColorBar.setTransformMin(d2);
                this.m_puColorBar.update((Object)this.m_puColorBar);
                this.repaint();
                break;
            }
            case 2: {
                double d3 = Math.min(1.0, d);
                if (d3 < this.m_puColorBar.m_transformMin) {
                    d3 = this.m_puColorBar.m_transformMin;
                }
                this.m_puColorBar.setTransformMax(d3);
                this.m_puColorBar.update((Object)this.m_puColorBar);
                this.repaint();
                break;
            }
            case 3: {
                double d4 = this.m_clickPos;
                this.m_clickPos = d;
                double d5 = this.m_puColorBar.m_transformMin + d - d4;
                double d6 = this.m_puColorBar.m_transformMax + d - d4;
                if (d5 < 0.0) {
                    d6 -= d5;
                    d5 = 0.0;
                }
                if (d6 > 1.0) {
                    d5 -= d6 - 1.0;
                    d6 = 1.0;
                }
                this.m_puColorBar.setTransformMin(d5);
                this.m_puColorBar.setTransformMax(d6);
                this.m_puColorBar.update((Object)this.m_puColorBar);
                this.repaint();
            }
        }
    }

    private int getMode(double d) {
        double d2 = 0.05 * (this.m_puColorBar.m_transformMax - this.m_puColorBar.m_transformMin);
        int n = 0;
        if (Math.abs(d - this.m_puColorBar.m_transformMin) <= d2) {
            n = 1;
        } else if (Math.abs(d - this.m_puColorBar.m_transformMax) <= d2) {
            n = 2;
        } else if (d > this.m_puColorBar.m_transformMin && d < this.m_puColorBar.m_transformMax && (this.m_puColorBar.m_transformMin > 0.0 || this.m_puColorBar.m_transformMax < 1.0)) {
            n = 3;
        }
        PsDebug.message((String)("getMode: pos = " + d + ", eps = " + d2));
        return n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        for (int i = 0; i < this.m_menuItems.length; ++i) {
            if (object != this.m_menuItems[i]) continue;
            this.m_puColorBar.setColorTable(i);
            this.repaint();
            this.m_puColorBar.update((Object)this.m_puColorBar);
            break;
        }
    }

    public int getPanelMode() {
        return this.m_panelMode;
    }

    public void setPanelMode(int n) {
        this.m_panelMode = n;
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 20);
    }

    public void setDisplayComponent(Component component) {
        this.m_dispPanel = component;
        this.enableContextMenu(this.m_puColorBar.m_allowContextMenu);
    }

    public void paintOverlay(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        this.m_leftInset = n;
        this.m_topInset = n2;
        this.m_width = n3;
        this.m_height = n4;
        for (n8 = 0; n8 < this.m_width; ++n8) {
            double d = 1.0 * (double)n8 / (double)this.m_width;
            if (d < this.m_puColorBar.m_minMark || d >= this.m_puColorBar.m_maxMark) {
                graphics.setColor(this.m_puColorBar.m_colorTable.getColor(this.m_puColorBar.transformUnitValueToColorIndex(d)));
            } else {
                graphics.setColor(this.m_puColorBar.m_markColor);
            }
            n7 = this.m_leftInset + n8;
            n6 = this.m_topInset + 0;
            n5 = this.m_topInset + this.m_height;
            graphics.drawLine(n7, n6, n7, n5);
        }
        if (this.m_puColorBar.m_transformMin > Double.NEGATIVE_INFINITY) {
            graphics.setColor(Color.black);
            Font font = new Font("Arial", 0, 12);
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n7 = this.m_leftInset + 3 * PsConfig.getMonitorScale();
            n6 = this.m_topInset + (this.m_height + fontMetrics.getHeight() >> 1) - 2 * PsConfig.getMonitorScale();
            graphics.drawString(PuString.toString((double)this.m_puColorBar.m_minValue, (int)1), n7, n6);
            String string = PuString.toString((double)this.m_puColorBar.m_maxValue, (int)1);
            n7 = this.m_leftInset + this.m_width - fontMetrics.stringWidth(string) - 3 * PsConfig.getMonitorScale();
            graphics.drawString(string, n7, n6);
            if (this.m_puColorBar.m_minValue <= 0.0 && this.m_puColorBar.m_maxValue > 0.0) {
                n8 = (int)((double)(-this.m_width) * this.m_puColorBar.m_minValue / (this.m_puColorBar.m_maxValue - this.m_puColorBar.m_minValue));
                n7 = this.m_leftInset + n8;
                n6 = this.m_topInset + 0;
                n5 = this.m_topInset + this.m_height;
                graphics.drawLine(n7, n6, n7, n5);
            }
            n8 = (int)((double)this.m_width * this.m_puColorBar.m_transformMin);
            int n9 = (int)((double)this.m_width * this.m_puColorBar.m_transformMax);
            n7 = this.m_leftInset + n8;
            int n10 = this.m_leftInset + n9;
            n6 = this.m_topInset + 0;
            n5 = this.m_topInset + this.m_height;
            graphics.drawLine(n7, n6, n7, n5);
            graphics.drawLine(n10, n6, n10, n5);
            graphics.drawLine(n7, n6, n10, n6);
            graphics.drawLine(n7, n5, n10, n5);
        }
    }
}

