/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import java.util.Vector;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PuCleanMesh;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuReflect;
import jv.vecmath.PuVectorGeom;
import jvx.geom.EquiPoint;
import jvx.geom.PwBoundary;
import jvx.geom.PwCleanMesh;
import jvx.geom.PwIdentify;
import jvx.geom.PwSymmetry_IP;
import jvx.geom.WordPoint;
import jvx.project.PjWorkshop;

public class PwSymmetry
extends PjWorkshop {
    public static final long serialVersionUID = 0L;
    protected boolean m_cIdGeom;
    protected boolean m_cShowBnd;
    protected boolean m_showElTexture;
    protected boolean m_showVerTexture;
    protected boolean m_showElBackColor;
    protected boolean m_checkGeomOverlap;
    protected boolean m_showElColor;
    protected boolean m_badBound;
    protected int m_maxlength;
    protected int m_splittingDef;
    protected double m_sel;
    protected double m_short;
    protected PuInteger m_maxdep;
    protected PuInteger m_angle;
    protected PuInteger m_elementNum;
    protected PuDouble m_epsilon;
    protected PgPointSet m_elSet_NoBdry;
    protected PgElementSet m_elSet;
    protected PgElementSet m_resetGeom;
    protected PgElementSet m_point_Orbit;
    protected PgElementSet m_overlayGeom;
    protected PgElementSet[] m_boundary;
    protected PgPointSet m_geomOverlap;
    protected Vector m_mirrGeom = new Vector();
    protected PgBndPolygon[] m_bound;
    protected Color m_elColor;
    protected EquiPoint[] m_eq;
    protected WordPoint[] m_list;
    protected PwSymmetry_IP m_symmIP = new PwSymmetry_IP();
    static /* synthetic */ Class class$jvx$geom$PwSymmetry;

    public PwSymmetry() {
        super("Symmetry generator");
        this.m_epsilon = new PuDouble("Tolerance", (PsUpdateIf)this);
        this.m_maxdep = new PuInteger("Maximal tree depth", (PsUpdateIf)this);
        this.m_angle = new PuInteger("Splitting angle", (PsUpdateIf)this);
        this.m_elementNum = new PuInteger("# Geometries", (PsUpdateIf)this);
        this.m_list = new WordPoint[0];
        this.m_eq = new EquiPoint[0];
        this.m_point_Orbit = new PgElementSet();
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwSymmetry == null ? (class$jvx$geom$PwSymmetry = PwSymmetry.class$("jvx.geom.PwSymmetry")) : class$jvx$geom$PwSymmetry)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_cShowBnd = true;
        this.m_epsilon.setDefBounds(0.001, 1.0, 0.001, 0.01);
        this.m_epsilon.setDefValue(0.001);
        this.m_epsilon.init();
        this.m_maxdep.setDefBounds(1, 10, 1, 2);
        this.m_maxdep.setDefValue(1);
        this.m_maxdep.init();
        this.m_angle.setDefBounds(10, 170, 1, 10);
        this.m_splittingDef = 120;
        this.m_angle.setDefValue(this.m_splittingDef);
        this.m_angle.init();
        this.m_elementNum.setDefBounds(1, 1, 1, 10);
        this.m_elementNum.setDefValue(1);
        this.m_elementNum.init();
    }

    public void setGeometry(PgGeometry pgGeometry) {
        super.setGeometry(pgGeometry);
        this.m_resetGeom = this.m_elSet = (PgElementSet)pgGeometry;
        this.m_elSet_NoBdry = new PgElementSet();
        this.m_geomOverlap = new PgPointSet();
        this.m_elSet.setName("Object with symmetries");
        this.m_elSet.setEnabledIndexLabels(false);
        this.m_elSet.setGlobalVertexSize(1.0);
        this.m_elSet.showVertices(false);
        this.m_short = this.getShortestPointDist(this.m_elSet) / 2.0;
        this.m_sel = 0.04;
        this.m_epsilon.setValue(this.m_sel);
        this.m_point_Orbit.setGlobalVertexSize(9.0);
        this.m_point_Orbit.setGlobalVertexColor(Color.pink);
        this.m_point_Orbit.showVertices(true);
        this.m_point_Orbit.setEnabledIndexLabels(true);
        this.m_point_Orbit.setName("point Orbit");
        this.saveColors();
        this.showBoundaries(this.m_cShowBnd);
    }

    public boolean update(Object object) {
        if (object == this.m_epsilon) {
            return true;
        }
        if (object == this.m_maxdep) {
            return true;
        }
        if (object == this.m_angle) {
            if (this.m_cShowBnd) {
                this.showBoundaries(true);
                for (int i = 0; i < this.m_bound.length; ++i) {
                    this.m_bound[i].update((Object)this.m_bound[i]);
                }
                this.m_display.update((Object)this.m_display);
            }
            return true;
        }
        if (object == this.m_elementNum) {
            this.showMirroredGeoms(this.m_elementNum.getValue(), this.m_elSet);
            this.m_display.update((Object)this.m_display);
            return true;
        }
        return super.update(object);
    }

    public void reset() {
        this.m_display.removeGeometries();
        this.m_mirrGeom.removeAllElements();
        this.m_elementNum.setBounds(1, 1);
        this.m_elementNum.setValue(1);
        this.m_maxdep.setValue(1);
        this.m_angle.setValue(this.m_splittingDef);
        this.m_epsilon.setValue(this.m_sel);
        this.m_elSet = this.m_resetGeom;
        this.m_display.addGeometry((PgGeometryIf)this.m_elSet);
        this.resetOptions();
        this.m_display.fit();
        this.m_display.update((Object)this.m_display);
    }

    public void resetOptions() {
        this.colorGeoms(false);
        this.showBoundaries(false);
        this.m_symmIP.m_cShowBound.setState(false);
    }

    public void setCheckGeometricOverlap(boolean bl) {
        this.m_checkGeomOverlap = bl;
    }

    public void showMirroredGeoms(int n, PgElementSet pgElementSet) {
        if (this.m_mirrGeom.size() > 0) {
            if (this.m_display.containsGeometry((PgGeometryIf)pgElementSet)) {
                this.m_display.removeGeometry((PgGeometryIf)pgElementSet);
            }
            for (int i = 0; i < this.m_mirrGeom.size(); ++i) {
                if (i < n) {
                    this.m_display.addGeometry((PgGeometryIf)((PgElementSet)this.m_mirrGeom.elementAt(i)));
                    continue;
                }
                if (!this.m_display.containsGeometry((PgGeometryIf)((PgElementSet)this.m_mirrGeom.elementAt(i)))) continue;
                this.m_display.removeGeometry((PgGeometryIf)((PgElementSet)this.m_mirrGeom.elementAt(i)));
            }
            this.m_display.selectGeometry((PgGeometryIf)((PgElementSet)this.m_mirrGeom.elementAt(0)));
        }
    }

    public void showAllGeoms() {
        if (this.m_mirrGeom != null) {
            this.m_elSet = this.mergeGeoms(this.m_epsilon.getValue());
            this.m_display.removeGeometries();
            this.m_elSet.showVertices(false);
            this.m_display.addGeometry((PgGeometryIf)this.m_elSet);
            this.m_display.addGeometry((PgGeometryIf)this.m_point_Orbit);
        } else {
            PsDebug.warning((String)"The geometry cannot be merged as there are no mirrored geometries. Reasons for this could be:\n1.) The geometry has not yet been mirrored\n2.) The geometry has no symmetries and therefore was not mirrored\n3.} The geometry has already been merged");
        }
    }

    public void partialMerge() {
        if (this.m_mirrGeom != null && this.m_mirrGeom.size() > 0) {
            this.m_overlayGeom = new PgElementSet();
            for (int i = 0; i < this.m_mirrGeom.size(); ++i) {
                if (this.m_display.containsGeometry((PgGeometryIf)((PgElementSet)this.m_mirrGeom.elementAt(i)))) {
                    this.m_overlayGeom.merge((PgGeometryIf)((PgElementSet)this.m_mirrGeom.elementAt(i)));
                    continue;
                }
                this.m_mirrGeom.removeElement(this.m_mirrGeom.elementAt(i));
                --i;
                this.m_elementNum.setBounds(1, this.m_elementNum.getMax() - 1);
                this.m_elementNum.setValue(this.m_elementNum.getValue() - 1);
            }
            this.m_overlayGeom.setGlobalVertexSize(3.0);
            this.m_overlayGeom.showEdges(false);
            this.m_overlayGeom.showVertices(false);
            this.m_overlayGeom.showElements(false);
            this.m_display.addGeometry((PgGeometryIf)this.m_overlayGeom);
            this.m_display.selectGeometry((PgGeometryIf)this.m_overlayGeom);
            this.m_display.update((Object)this.m_display);
        }
    }

    protected PgElementSet mergeGeoms(double d) {
        int n;
        PgElementSet pgElementSet = new PgElementSet();
        for (n = 0; n < this.m_mirrGeom.size(); ++n) {
            pgElementSet.merge((PgGeometryIf)((PgElementSet)this.m_mirrGeom.elementAt(n)));
        }
        for (n = 0; n < this.m_mirrGeom.size(); ++n) {
            if (!this.m_display.containsGeometry((PgGeometryIf)((PgElementSet)this.m_mirrGeom.elementAt(n)))) continue;
            this.m_display.removeGeometry((PgGeometryIf)((PgElementSet)this.m_mirrGeom.elementAt(n)));
        }
        this.m_mirrGeom.removeAllElements();
        this.m_elementNum.setBounds(1, 1);
        this.m_elementNum.setValue(1);
        PuCleanMesh.identifyVertices((PgPointSet)pgElementSet, (double)d);
        PwCleanMesh.identifyEqualElements(pgElementSet);
        return pgElementSet;
    }

    public void mergeVis() {
        this.resetOptions();
        if (!this.m_mirrGeom.isEmpty()) {
            int n;
            for (n = 0; n < this.m_mirrGeom.size(); ++n) {
                if (this.m_display.containsGeometry((PgGeometryIf)((PgElementSet)this.m_mirrGeom.elementAt(n)))) continue;
                this.m_mirrGeom.removeElement(this.m_mirrGeom.elementAt(n));
                --n;
            }
            this.m_elSet = this.mergeGeoms(this.m_epsilon.getValue());
            this.m_elSet.showVertices(false);
            this.m_display.addGeometry((PgGeometryIf)this.m_elSet);
            for (n = 0; n < this.m_mirrGeom.size(); ++n) {
                this.m_display.removeGeometry((PgGeometryIf)((PgElementSet)this.m_mirrGeom.elementAt(n)));
            }
            this.m_display.update((Object)this.m_display);
            this.m_mirrGeom = new Vector();
        } else {
            PsDebug.warning((String)"The geometry cannot be merged as there are no mirrored geometries. Reasons for this could be:\n1.) The geometry has not yet been mirrored\n2.) The geometry has no symmetries and therefore was not mirrored\n3.} The geometry has already been merged");
        }
    }

    public PdVector approxNormal(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        PdVector pdVector4 = PdVector.subNew((PdVector)pdVector, (PdVector)pdVector2);
        PdVector pdVector5 = PdVector.subNew((PdVector)pdVector, (PdVector)pdVector3);
        PdVector pdVector6 = PdVector.crossNew((PdVector)pdVector4, (PdVector)pdVector5);
        return pdVector6;
    }

    public void colorGeoms(boolean bl) {
        this.m_cIdGeom = bl;
        this.m_symmIP.m_cIdentGeom.setState(bl);
        if (bl) {
            float f = 0.16f;
            float f2 = 1.0f;
            float f3 = 1.0f;
            if (this.m_mirrGeom != null && this.m_mirrGeom.size() > 0) {
                for (int i = 0; i < this.m_mirrGeom.size(); ++i) {
                    Color color = new Color(Color.HSBtoRGB(f, f2, f3));
                    this.showProperties((PgElementSet)this.m_mirrGeom.elementAt(i), color);
                    f = (f + 0.3073f) % 1.0f;
                    f2 = (f2 - 0.1313f) % 0.5f + 0.5f;
                    f3 = (f3 - 0.13f) % 0.5f + 0.5f;
                }
            } else {
                Color color = new Color(Color.HSBtoRGB(f, f2, f3));
                this.showProperties(this.m_elSet, color);
                this.m_elSet.update((Object)this.m_elSet);
            }
        } else if (this.m_mirrGeom != null && this.m_mirrGeom.size() > 0) {
            for (int i = 0; i < this.m_mirrGeom.size(); ++i) {
                this.restoreColors((PgElementSet)this.m_mirrGeom.elementAt(i));
            }
        } else {
            this.restoreColors(this.m_elSet);
        }
    }

    public void saveColors() {
        this.m_showElTexture = this.m_elSet.isShowingElementTexture();
        this.m_showVerTexture = this.m_elSet.isShowingVertexTexture();
        this.m_showElBackColor = this.m_elSet.isShowingElementBackColor();
        this.m_showElColor = this.m_elSet.isShowingElementColors();
        this.m_elColor = this.m_elSet.getGlobalElementColor();
    }

    public void restoreColors(PgElementSet pgElementSet) {
        if (this.m_showElTexture) {
            pgElementSet.showElementTexture(true);
        } else if (this.m_showVerTexture) {
            pgElementSet.showVertexTexture(true);
        } else {
            if (this.m_showElColor) {
                pgElementSet.showElementColors(true);
            } else {
                pgElementSet.setGlobalElementColor(this.m_elColor);
            }
            if (this.m_showElBackColor) {
                pgElementSet.showElementBackColor(true);
            }
        }
        pgElementSet.update((Object)pgElementSet);
    }

    protected void showProperties(PgElementSet pgElementSet, Color color) {
        pgElementSet.showElementTexture(false);
        pgElementSet.showVertexTexture(false);
        pgElementSet.showElementBackColor(false);
        pgElementSet.showElementColors(false);
        pgElementSet.setGlobalElementColor(color);
        pgElementSet.update((Object)pgElementSet);
    }

    public int[] selectBoundaries(PgPolygon[] pgPolygonArray, PgPointSet pgPointSet) {
        PiVector piVector = new PiVector();
        if (pgPolygonArray != null && pgPolygonArray.length > 0) {
            int[] nArray = new int[pgPolygonArray.length];
            block0: for (int i = 0; i < pgPolygonArray.length; ++i) {
                for (int j = 0; j < pgPolygonArray[i].getNumVertices(); ++j) {
                    for (int k = 0; k < pgPointSet.getNumVertices(); ++k) {
                        if (!this.epsEqual(pgPolygonArray[i].getVertex(j), pgPointSet.getVertex(k), this.m_short)) continue;
                        int n = i;
                        nArray[n] = nArray[n] + 1;
                        if (nArray[i] <= 1) continue;
                        piVector.addEntry(i);
                        continue block0;
                    }
                }
            }
        } else {
            PsDebug.warning((String)"No boundary has been created, yet.");
        }
        return piVector.getEntries();
    }

    public PgBndPolygon[] makeBoundaries(int n, PgElementSet pgElementSet) {
        int n2;
        PwIdentify.removeMarks((PgGeometry)pgElementSet);
        PwCleanMesh.markCornerVertices(pgElementSet, n);
        PwBoundary.makeBoundary(pgElementSet);
        PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
        Vector<PgBndPolygon> vector = new Vector<PgBndPolygon>();
        for (int i = 0; i < pgBndPolygonArray.length; ++i) {
            if (this.getPolyDimension((PgPointSet)pgBndPolygonArray[i]) <= 0) continue;
            vector.addElement(pgBndPolygonArray[i]);
        }
        PgBndPolygon[] pgBndPolygonArray2 = new PgBndPolygon[vector.size()];
        for (n2 = 0; n2 < pgBndPolygonArray2.length; ++n2) {
            pgBndPolygonArray2[n2] = (PgBndPolygon)vector.elementAt(n2);
            pgBndPolygonArray2[n2].showVertices(false);
            int n3 = pgBndPolygonArray2[n2].getNumVertices();
            for (int i = 0; i < n3; ++i) {
                pgBndPolygonArray2[n2].getVertex(i).clearTag(1);
            }
        }
        PwIdentify.removeMarks((PgGeometry)pgElementSet);
        for (n2 = 0; n2 < pgBndPolygonArray2.length; ++n2) {
            PuCleanMesh.identifyVertices((PgPointSet)pgBndPolygonArray2[n2], (double)this.m_short);
        }
        return pgBndPolygonArray2;
    }

    public void showBoundaries(boolean bl) {
        if (bl) {
            this.clearOldBoundaries();
            int n = this.m_angle.getValue();
            this.m_bound = this.makeBoundaries(n, this.m_elSet);
            this.showBoundaries(this.m_bound);
        } else {
            this.clearOldBoundaries();
        }
        this.m_display.update((Object)this.m_display);
    }

    public void showBoundaries(PgBndPolygon[] pgBndPolygonArray) {
        int n = 102;
        int n2 = 215;
        int n3 = 170;
        for (int i = 0; i < pgBndPolygonArray.length; ++i) {
            Color color = new Color(n, n2, n3);
            pgBndPolygonArray[i].setGlobalVertexColor(color);
            pgBndPolygonArray[i].setGlobalEdgeColor(color);
            pgBndPolygonArray[i].setGlobalEdgeSize(4.0);
            pgBndPolygonArray[i].setGlobalVertexSize(1.0);
            pgBndPolygonArray[i].setName("boundary_" + i);
            this.m_display.addGeometry((PgGeometryIf)pgBndPolygonArray[i]);
            n = (n + 152) % 255;
            n2 = (n2 + 37) % 255;
            n3 = (n3 + 93) % 255;
        }
    }

    protected void clearOldBoundaries() {
        if (this.m_bound != null) {
            for (int i = 0; i < this.m_bound.length; ++i) {
                if (!this.m_display.containsGeometry((PgGeometryIf)this.m_bound[i])) continue;
                this.m_display.removeGeometry((PgGeometryIf)this.m_bound[i]);
            }
            this.m_bound = null;
        }
    }

    public PgPointSet selectPoints(PgElementSet pgElementSet) {
        PgPointSet pgPointSet = new PgPointSet();
        for (int i = 0; i < pgElementSet.getNumVertices(); ++i) {
            if (!pgElementSet.hasTagVertex(i, 1)) continue;
            pgPointSet.addVertex(pgElementSet.getVertex(i));
        }
        return pgPointSet;
    }

    public void mirrorAlongSelected() {
        if (this.m_elSet != null) {
            if (this.m_display.containsGeometry((PgGeometryIf)this.m_elSet)) {
                PdMatrix pdMatrix;
                int n;
                PgPointSet pgPointSet = this.selectPoints(this.m_elSet);
                if (this.m_bound == null) {
                    this.m_bound = this.makeBoundaries(this.m_angle.getValue(), this.m_elSet);
                }
                int[] nArray = this.selectBoundaries((PgPolygon[])this.m_bound, pgPointSet);
                Vector<PdMatrix> vector = new Vector<PdMatrix>();
                PdMatrix pdMatrix2 = new PdMatrix(4);
                pdMatrix2.setIdentity();
                vector.addElement(pdMatrix2);
                for (n = 0; n < nArray.length; ++n) {
                    pdMatrix = this.mirrorBoundary(nArray[n], this.m_bound, this.m_elSet);
                    if (this.m_badBound) continue;
                    vector.addElement(pdMatrix);
                }
                n = vector.size();
                pdMatrix = PdMatrix.realloc(null, (int)n, (int)4, (int)4);
                for (int i = 0; i < n; ++i) {
                    pdMatrix[i] = (PdMatrix)vector.elementAt(i);
                }
                PwIdentify.removeMarks((PgGeometry)this.m_elSet);
                if (((PdMatrix)pdMatrix).length > 1) {
                    this.createGeo((PdMatrix[])pdMatrix);
                } else {
                    PsDebug.warning((String)"No mirror-planes or edges found.");
                }
            } else if (this.m_overlayGeom != null) {
                PgPointSet pgPointSet = this.selectPoints(this.m_overlayGeom);
                int n = this.m_mirrGeom.size();
                for (int i = 0; i < n; ++i) {
                    PdMatrix[] pdMatrixArray;
                    int n2;
                    Vector<PdMatrix[]> vector = new Vector<PdMatrix[]>();
                    PgElementSet pgElementSet = (PgElementSet)this.m_mirrGeom.elementAt(i);
                    PgBndPolygon[] pgBndPolygonArray = this.makeBoundaries(this.m_angle.getValue(), pgElementSet);
                    int[] nArray = this.selectBoundaries((PgPolygon[])pgBndPolygonArray, pgPointSet);
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        pdMatrixArray = this.mirrorBoundary(nArray[n2], pgBndPolygonArray, pgElementSet);
                        if (this.m_badBound) continue;
                        vector.addElement(pdMatrixArray);
                    }
                    n2 = vector.size();
                    pdMatrixArray = PdMatrix.realloc(null, (int)n2, (int)4, (int)4);
                    for (int j = 0; j < n2; ++j) {
                        pdMatrixArray[j] = (PdMatrix)vector.elementAt(j);
                        PgGeometry pgGeometry = pgElementSet.reflect(pdMatrixArray[j], true, true);
                        this.m_mirrGeom.addElement(pgGeometry);
                    }
                    this.m_maxlength = this.m_mirrGeom.size() + pdMatrixArray.length;
                    this.showMirroredGeoms(this.m_maxlength, pgElementSet);
                }
                this.m_elementNum.setBounds(1, this.m_maxlength);
                this.m_elementNum.setValue(this.m_maxlength);
                this.showBoundaries(this.m_symmIP.m_cShowBound.getState());
                this.colorGeoms(this.m_symmIP.m_cIdentGeom.getState());
                if (this.m_overlayGeom != null && this.m_display.containsGeometry((PgGeometryIf)this.m_overlayGeom)) {
                    this.m_display.removeGeometry((PgGeometryIf)this.m_overlayGeom);
                }
                this.m_display.fit();
                this.m_display.update((Object)this.m_display);
            } else {
                PsDebug.warning((String)"The geometries must be merged or all must be selected before they can be mirrored.");
            }
        } else {
            PsDebug.warning((String)"There is no geometry to be considered, please load one.");
        }
    }

    public PdMatrix mirrorBoundary(int n, PgBndPolygon[] pgBndPolygonArray, PgElementSet pgElementSet) {
        pgBndPolygonArray = this.makeBoundaries(this.m_angle.getValue(), pgElementSet);
        if (this.m_bound == null) {
            this.m_bound = pgBndPolygonArray;
        }
        int n2 = this.getPolyDimension((PgPointSet)pgBndPolygonArray[n]);
        PdMatrix pdMatrix = new PdMatrix(4);
        this.m_badBound = true;
        switch (n2) {
            case -1: {
                PsDebug.warning((String)("The boundary #" + n + " is empty and is therefore ignored at mirroring."));
                break;
            }
            case 0: {
                PsDebug.warning((String)("The boundary #" + n + " consists of a single point only and is therefore ignored at mirroring."));
                break;
            }
            case 1: {
                PdVector pdVector = pgBndPolygonArray[n].getVertex(1);
                pdVector.sub(pgBndPolygonArray[n].getVertex(0));
                pdMatrix = PuReflect.rotateLine((PdVector)pgBndPolygonArray[n].getVertex(0), (PdVector)pdVector);
                this.m_badBound = false;
                break;
            }
            case 2: {
                int n3 = pgBndPolygonArray[n].getNumVertices() - 1;
                if (this.epsEqual(pgBndPolygonArray[n].getVertex(pgBndPolygonArray[n].getNumVertices() - 1), pgBndPolygonArray[n].getVertex(0), this.m_short)) {
                    --n3;
                }
                int n4 = (int)(Math.floor(n3) / 2.0);
                pdMatrix = PuReflect.planeReflect((PdVector)pgBndPolygonArray[n].getVertex(0), (PdVector)pgBndPolygonArray[n].getVertex(n4), (PdVector)pgBndPolygonArray[n].getVertex(n3));
                this.m_badBound = false;
                break;
            }
            case 3: {
                PsDebug.warning((String)("The boundary #" + n + " is three-dimensional, therefore no mirroring is possible.\nIf you want to mirror here, try to split the boundary by increasing the splitting angle."));
                break;
            }
            default: {
                PsDebug.warning((String)("An error occured: The dimension of boundary #" + n + " could not be determined."));
            }
        }
        return pdMatrix;
    }

    public int getPolyDimension(PgPointSet pgPointSet) {
        double d = this.m_epsilon.getValue();
        int n = -1;
        if (pgPointSet.getNumVertices() > 0) {
            n = 0;
            block0: for (int i = 1; i < pgPointSet.getNumVertices(); ++i) {
                PdVector pdVector;
                PdVector pdVector2 = pgPointSet.getVertex(0);
                if (this.epsEqual(pdVector2, pdVector = pgPointSet.getVertex(i), d)) continue;
                n = 1;
                for (int j = i + 1; j < pgPointSet.getNumVertices(); ++j) {
                    PdVector pdVector3 = pgPointSet.getVertex(j);
                    PdVector pdVector4 = new PdVector(3);
                    pdVector4 = this.approxNormal(pdVector2, pdVector, pdVector3);
                    if (!(pdVector4.length() > d)) continue;
                    n = 2;
                    pdVector4.normalize();
                    for (int k = j + 1; k < pgPointSet.getNumVertices(); ++k) {
                        PdVector pdVector5 = pgPointSet.getVertex(k);
                        if (!(Math.abs(PuVectorGeom.distOfPointToPlane((PdVector)pdVector5, (PdVector)pdVector2, (PdVector)pdVector4)) > d)) continue;
                        n = 3;
                        break block0;
                    }
                    break block0;
                }
                break;
            }
        }
        return n;
    }

    public void getSymmAndGeom() {
        int n = this.m_maxdep.getValue();
        int n2 = this.m_angle.getValue();
        PdMatrix[] pdMatrixArray = this.getSymmetries(n, n2, this.m_epsilon.getValue());
        PiVector[] piVectorArray = this.getWords(this.m_list);
        PdMatrix[] pdMatrixArray2 = this.getWordMatrices(piVectorArray, pdMatrixArray);
        this.createGeo(pdMatrixArray2);
        this.m_elSet.setVisible(true);
        this.m_elSet.update((Object)this.m_elSet);
    }

    public void createGeo(PdMatrix[] pdMatrixArray) {
        int n = 0;
        block0: for (int i = 0; i < pdMatrixArray.length; ++i) {
            PgGeometry pgGeometry;
            if (this.m_checkGeomOverlap) {
                pgGeometry = this.m_elSet_NoBdry.reflect(pdMatrixArray[i], true, true);
                for (int j = 0; j < this.m_elSet_NoBdry.getNumVertices(); ++j) {
                    for (int k = 0; k < this.m_geomOverlap.getNumVertices(); ++k) {
                        if (!this.epsEqual(pgGeometry.getVertex(j), this.m_geomOverlap.getVertex(k), this.m_short)) continue;
                        ++n;
                        continue block0;
                    }
                    this.m_geomOverlap.addVertex(pgGeometry.getVertex(j));
                }
            }
            pgGeometry = this.m_elSet.reflect(pdMatrixArray[i], true, true);
            this.m_mirrGeom.addElement(pgGeometry);
        }
        if (n > 0) {
            System.out.println(n + " geometric overlaps were blocked.");
        }
        this.m_maxlength = this.m_mirrGeom.size();
        this.m_elementNum.setBounds(1, this.m_maxlength);
        this.m_elementNum.setValue(this.m_maxlength);
        this.showMirroredGeoms(this.m_maxlength, this.m_elSet);
        this.showBoundaries(this.m_symmIP.m_cShowBound.getState());
        this.colorGeoms(this.m_symmIP.m_cIdentGeom.getState());
        this.m_display.fit();
        this.m_display.update((Object)this.m_display);
    }

    public PdMatrix[] getSymmetries(int n, int n2, double d) {
        PgBndPolygon[] pgBndPolygonArray = this.makeBoundaries(n2, this.m_elSet);
        PdMatrix[] pdMatrixArray = this.getSymmetryMatrices((PgPolygon[])pgBndPolygonArray);
        PdVector pdVector = this.getHomogCenter(this.m_elSet);
        this.getTreeAndEqui(pdVector, pdMatrixArray, pdMatrixArray.length, d, n);
        if (this.m_checkGeomOverlap) {
            this.m_elSet_NoBdry.copy((PsObject)this.m_elSet);
            for (int i = 0; i < this.m_elSet_NoBdry.getNumVertices(); ++i) {
                for (int j = 0; j < pgBndPolygonArray.length; ++j) {
                    for (int k = 0; k < pgBndPolygonArray[j].getNumVertices(); ++k) {
                        if (!this.epsEqual(pgBndPolygonArray[j].getVertex(k), this.m_elSet_NoBdry.getVertex(i), this.m_short)) continue;
                        this.m_elSet_NoBdry.setTagVertex(i, 2);
                    }
                }
            }
            this.m_elSet_NoBdry.removeMarkedVertices();
        }
        return pdMatrixArray;
    }

    public PdMatrix[] getSymmetryMatrices(PgPolygon[] pgPolygonArray) {
        PdMatrix[] pdMatrixArray;
        int n;
        Vector<PdMatrix> vector = new Vector<PdMatrix>();
        for (n = 0; n < pgPolygonArray.length; ++n) {
            PdMatrix pdMatrix = this.mirrorBoundary(n, this.m_bound, this.m_elSet);
            if (this.m_badBound) continue;
            vector.addElement(pdMatrix);
        }
        if (vector.size() > 0) {
            n = ((PdMatrix)vector.elementAt(0)).getISize();
            pdMatrixArray = PdMatrix.realloc(null, (int)vector.size(), (int)n, (int)n);
            for (int i = 0; i < vector.size(); ++i) {
                pdMatrixArray[i] = (PdMatrix)vector.elementAt(i);
            }
        } else {
            PsDebug.warning((String)"No symmetries found. Try changing parameters.");
            pdMatrixArray = PdMatrix.realloc(null, (int)1, (int)4, (int)4);
            pdMatrixArray[0].setIdentity();
        }
        return pdMatrixArray;
    }

    public void getTreeAndEqui(PdVector pdVector, PdMatrix[] pdMatrixArray, int n, double d, int n2) {
        int n3;
        int n4;
        Vector<EquiPoint> vector = new Vector<EquiPoint>();
        Vector<WordPoint> vector2 = new Vector<WordPoint>();
        EquiPoint equiPoint = new EquiPoint();
        WordPoint wordPoint = new WordPoint();
        wordPoint.p = pdVector;
        wordPoint.parent = -1;
        wordPoint.letter = -1;
        vector2.addElement(wordPoint);
        for (n4 = 0; n4 < vector2.size() && (((WordPoint)vector2.elementAt((int)n4)).level < n2 || n2 == 0); ++n4) {
            for (n3 = 0; n3 < n; ++n3) {
                PdVector pdVector2 = this.matmult(pdMatrixArray[n3], ((WordPoint)vector2.elementAt((int)n4)).p);
                int n5 = this.hasEquivPoint(vector2, pdVector2, d);
                if (n5 >= 0) {
                    equiPoint = this.getEquiWords(n3, n5, n4, vector2);
                    vector.addElement(equiPoint);
                    continue;
                }
                wordPoint = new WordPoint();
                wordPoint.p = pdVector2;
                wordPoint.parent = n4;
                wordPoint.letter = n3;
                wordPoint.level = ((WordPoint)vector2.elementAt((int)n4)).level + 1;
                vector2.addElement(wordPoint);
            }
        }
        n4 = vector.size();
        this.m_eq = new EquiPoint[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            this.m_eq[n3] = (EquiPoint)vector.elementAt(n3);
        }
        n3 = vector2.size();
        this.m_list = new WordPoint[n3];
        for (int i = 0; i < n3; ++i) {
            this.m_list[i] = (WordPoint)vector2.elementAt(i);
        }
    }

    public WordPoint[] makeTree(PdVector pdVector, PdMatrix[] pdMatrixArray, int n, double d) {
        int n2;
        Vector<WordPoint> vector = new Vector<WordPoint>();
        WordPoint wordPoint = new WordPoint();
        wordPoint.p = pdVector;
        wordPoint.parent = -1;
        wordPoint.letter = -1;
        vector.addElement(wordPoint);
        for (n2 = 0; n2 < vector.size(); ++n2) {
            for (int i = 0; i < n; ++i) {
                PdVector pdVector2 = this.matmult(pdMatrixArray[i], ((WordPoint)vector.elementAt((int)n2)).p);
                int n3 = this.hasEquivPoint(vector, pdVector2, d);
                if (n3 != -1) continue;
                wordPoint = new WordPoint();
                wordPoint.p = pdVector2;
                wordPoint.parent = n2;
                wordPoint.letter = i;
                vector.addElement(wordPoint);
            }
            ++n2;
        }
        n2 = vector.size();
        WordPoint[] wordPointArray = new WordPoint[n2];
        for (int i = 0; i < n2; ++i) {
            wordPointArray[i] = (WordPoint)vector.elementAt(i);
        }
        return wordPointArray;
    }

    public EquiPoint[] getEquivalents(PdVector pdVector, PdMatrix[] pdMatrixArray, int n, double d) {
        int n2;
        Vector<EquiPoint> vector = new Vector<EquiPoint>();
        Vector<WordPoint> vector2 = new Vector<WordPoint>();
        EquiPoint equiPoint = new EquiPoint();
        WordPoint wordPoint = new WordPoint();
        wordPoint.p = pdVector;
        wordPoint.parent = -1;
        wordPoint.letter = -1;
        vector2.addElement(wordPoint);
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            for (int i = 0; i < n; ++i) {
                PdVector pdVector2 = this.matmult(pdMatrixArray[i], ((WordPoint)vector2.elementAt((int)n2)).p);
                int n3 = this.hasEquivPoint(vector2, pdVector2, d);
                if (n3 >= 0) {
                    equiPoint = this.getEquiWords(i, n3, n2, vector2);
                    vector.addElement(equiPoint);
                    continue;
                }
                wordPoint = new WordPoint();
                wordPoint.p = pdVector2;
                wordPoint.parent = n2;
                wordPoint.letter = i;
                vector2.addElement(wordPoint);
            }
        }
        n2 = vector.size();
        EquiPoint[] equiPointArray = new EquiPoint[n2];
        for (int i = 0; i < n2; ++i) {
            equiPointArray[i] = (EquiPoint)vector.elementAt(i);
        }
        return equiPointArray;
    }

    public EquiPoint getEquiWords(int n, int n2, int n3, Vector vector) {
        EquiPoint equiPoint = new EquiPoint();
        equiPoint.word1 = this.getWord(n2, vector);
        equiPoint.word2 = this.getWord(n3, vector);
        equiPoint.word2.addEntry(n);
        return equiPoint;
    }

    public PdMatrix[] getWordMatrices(PiVector[] piVectorArray, PdMatrix[] pdMatrixArray) {
        PdMatrix[] pdMatrixArray2 = PdMatrix.realloc(null, (int)piVectorArray.length);
        PdMatrix pdMatrix = new PdMatrix(pdMatrixArray[0].getSize());
        for (int i = 0; i < piVectorArray.length; ++i) {
            if (piVectorArray[i].getEntry(0) >= 0) {
                pdMatrix = PdMatrix.copyNew((PdMatrix)pdMatrixArray[piVectorArray[i].getEntry(0)]);
                for (int j = 1; j < piVectorArray[i].getSize(); ++j) {
                    PdMatrix pdMatrix2 = PdMatrix.copyNew((PdMatrix)pdMatrixArray[piVectorArray[i].getEntry(j)]);
                    pdMatrix.rightMult(pdMatrix2);
                }
            } else {
                pdMatrix.setIdentity();
            }
            pdMatrixArray2[i] = PdMatrix.copyNew((PdMatrix)pdMatrix);
        }
        return pdMatrixArray2;
    }

    public PdMatrix[] getWordMatrices(WordPoint[] wordPointArray, PdMatrix[] pdMatrixArray) {
        PdMatrix[] pdMatrixArray2 = PdMatrix.realloc(null, (int)wordPointArray.length, (int)pdMatrixArray[0].getSize(), (int)pdMatrixArray[0].getSize());
        for (int i = 1; i < wordPointArray.length; ++i) {
            PdMatrix pdMatrix = new PdMatrix(pdMatrixArray[0].getSize());
            int n = i;
            int n2 = 0;
            while (wordPointArray[n].parent >= 0) {
                PdMatrix pdMatrix2 = PdMatrix.copyNew((PdMatrix)pdMatrixArray[wordPointArray[n].letter]);
                if (n2 == 0) {
                    pdMatrix = pdMatrix2;
                } else {
                    pdMatrix.rightMult(pdMatrix2);
                }
                n = wordPointArray[n].parent;
                ++n2;
            }
            pdMatrixArray2[i] = PdMatrix.copyNew((PdMatrix)pdMatrix);
        }
        pdMatrixArray2[0].setIdentity();
        return pdMatrixArray2;
    }

    public PiVector getWord(int n, Vector vector) {
        PiVector piVector = new PiVector(0);
        int n2 = n;
        if (((WordPoint)vector.elementAt((int)n2)).parent == -1) {
            piVector.addEntry(-1);
        } else {
            while (((WordPoint)vector.elementAt((int)n2)).parent >= 0) {
                piVector.addEntry(((WordPoint)vector.elementAt((int)n2)).letter);
                n2 = ((WordPoint)vector.elementAt((int)n2)).parent;
            }
        }
        return piVector;
    }

    public PiVector getWord(int n, WordPoint[] wordPointArray) {
        PiVector piVector = new PiVector(0);
        int n2 = n;
        if (wordPointArray[n2].parent == -1) {
            piVector.addEntry(-1);
        } else {
            while (wordPointArray[n2].parent >= 0) {
                piVector.addEntry(wordPointArray[n2].letter);
                n2 = wordPointArray[n2].parent;
            }
        }
        return piVector;
    }

    public PiVector[] getWords(WordPoint[] wordPointArray) {
        PiVector[] piVectorArray = PiVector.realloc(null, (int)wordPointArray.length);
        for (int i = 0; i < wordPointArray.length; ++i) {
            piVectorArray[i] = this.getWord(i, wordPointArray);
        }
        return piVectorArray;
    }

    public double getShortestPointDist(PgElementSet pgElementSet) {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < pgElementSet.getNumVertices(); ++i) {
            for (int j = i + 1; j < pgElementSet.getNumVertices(); ++j) {
                PdVector pdVector = PdVector.copyNew((PdVector)pgElementSet.getVertex(i));
                pdVector.sub(pgElementSet.getVertex(j));
                double d2 = pdVector.length();
                if (!(d2 < d) || !(d2 > 9.0E-4)) continue;
                d = d2;
            }
        }
        d = Math.floor(d * 1000.0) / 1000.0;
        return d;
    }

    public PdVector getHomogCenter(PgElementSet pgElementSet) {
        PdVector pdVector = pgElementSet.getCenterOfGravity();
        PdVector pdVector2 = new PdVector(pdVector.getEntry(0), pdVector.getEntry(1), pdVector.getEntry(2), 1.0);
        return pdVector2;
    }

    public int hasEquivPoint(Vector vector, PdVector pdVector, double d) {
        int n = -1;
        for (int i = 0; i < vector.size(); ++i) {
            if (!this.epsEqual(pdVector, ((WordPoint)vector.elementAt((int)i)).p, 2.0 * d)) continue;
            n = i;
            break;
        }
        return n;
    }

    public boolean epsEqual(PdVector pdVector, PdVector pdVector2, double d) {
        boolean bl = true;
        for (int i = 0; i < pdVector.getSize(); ++i) {
            if (!(Math.abs(pdVector.getEntry(i) - pdVector2.getEntry(i)) > d)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public PdVector matmult(PdMatrix pdMatrix, PdVector pdVector) {
        PdMatrix pdMatrix2 = new PdMatrix(pdVector.getSize(), 1);
        PdMatrix pdMatrix3 = new PdMatrix(pdVector.getSize(), 1);
        pdMatrix2.setColumn(0, pdVector);
        pdMatrix3.mult(pdMatrix, pdMatrix2);
        return pdMatrix3.getColumn(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

