/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgTetraSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgUtil {
    public static PdVector getEdgeLengths(PgElementSet pgElementSet, PdVector pdVector, boolean bl) {
        int n = pgElementSet.getNumEdges();
        if (pdVector == null) {
            pdVector = new PdVector();
        }
        pdVector.setSize(n);
        int n2 = pgElementSet.getNumElements();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = piVectorArray[i].getSize();
            for (int j = 0; j < n4; ++j) {
                if ((piVectorArray2 != null || !bl) && (piVectorArray2 == null || piVectorArray2[i].m_data[j] >= i)) continue;
                double d = pgElementSet.getEdgeLength(i, j);
                pdVector.setEntry(n3, d);
                ++n3;
            }
        }
        pdVector.setSize(n3);
        return pdVector;
    }

    public static PdVector getVertexAngles(PgElementSet pgElementSet, PdVector pdVector, boolean bl) {
        int n = pgElementSet.getNumElementIndices();
        if (pdVector == null) {
            pdVector = new PdVector();
        }
        pdVector.setSize(n);
        int n2 = pgElementSet.getNumElements();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        pgElementSet.markBoundary();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            PiVector piVector = piVectorArray[i];
            int n4 = piVector.getSize();
            for (int j = 0; j < n4; ++j) {
                int n5 = piVector.getEntry(j % n4);
                if (!bl && pdVectorArray[n5].hasTag(14)) continue;
                int n6 = piVector.getEntry((j - 1 + n4) % n4);
                int n7 = piVector.getEntry((j + 1) % n4);
                double d = PdVector.angle((PdVector)pdVectorArray[n5], (PdVector)pdVectorArray[n6], (PdVector)pdVectorArray[n7]);
                pdVector.setEntry(n3, d);
                ++n3;
            }
        }
        pdVector.setSize(n3);
        return pdVector;
    }

    public static double averageEdgeLength(PgElementSet pgElementSet) {
        return PgUtil.getEdgeLengths(pgElementSet, null, true).average();
    }

    public static PdVector calcLinearGradient(PgElementSet pgElementSet, int n, PdVector pdVector, PdVector pdVector2) {
        PiVector piVector = pgElementSet.getElement(n);
        if (piVector.getSize() != 3) {
            PsDebug.warning((String)"Element is not a triangle.");
            return null;
        }
        PdVector pdVector3 = pgElementSet.getVertex(piVector.m_data[0]);
        PdVector pdVector4 = pgElementSet.getVertex(piVector.m_data[1]);
        PdVector pdVector5 = pgElementSet.getVertex(piVector.m_data[2]);
        return PgUtil.calcLinearGradient(pdVector3, pdVector4, pdVector5, pdVector, pdVector2);
    }

    public static PdVector calcLinearGradientNonConforming(PgElementSet pgElementSet, int n, PdVector pdVector, PdVector pdVector2) {
        if (pgElementSet.getDimOfElement(n) != 3) {
            PsDebug.warning((String)"Element is not a triangle.");
            return null;
        }
        if ((pdVector2 = PgUtil.calcLinearGradient(pgElementSet, n, pdVector, pdVector2)) == null) {
            return null;
        }
        pdVector2.multScalar(-2.0);
        return pdVector2;
    }

    public static PdVector calcLinearGradient(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4, PdVector pdVector5) {
        if (pdVector5 == null) {
            pdVector5 = new PdVector(3);
        }
        double d = pdVector.sqrDist(pdVector2);
        double d2 = pdVector.sqrDist(pdVector3);
        double d3 = pdVector2.sqrDist(pdVector3);
        double d4 = d;
        double d5 = d2;
        double d6 = (d + d2 - d3) / 2.0;
        double d7 = d4 * d5 - d6 * d6;
        double d8 = d6 * (pdVector4.m_data[2] - pdVector4.m_data[0]) - d5 * (pdVector4.m_data[1] - pdVector4.m_data[0]);
        double d9 = d6 * (pdVector4.m_data[1] - pdVector4.m_data[0]) - d4 * (pdVector4.m_data[2] - pdVector4.m_data[0]);
        pdVector5.blend((d8 + d9) / d7, pdVector, -d8 / d7, pdVector2, -d9 / d7, pdVector3);
        return pdVector5;
    }

    public static PdVector calcLinearGradient(PgTetraSet pgTetraSet, int n, PdVector pdVector, PdVector pdVector2) {
        PiVector piVector = pgTetraSet.getTetra(n);
        if (piVector.getSize() != 4) {
            PsDebug.warning((String)"Invalid length of tetrahedra.");
            return null;
        }
        PdVector pdVector3 = pgTetraSet.getVertex(piVector.m_data[0]);
        PdVector pdVector4 = pgTetraSet.getVertex(piVector.m_data[1]);
        PdVector pdVector5 = pgTetraSet.getVertex(piVector.m_data[2]);
        PdVector pdVector6 = pgTetraSet.getVertex(piVector.m_data[3]);
        return PgUtil.calcLinearGradient(pdVector3, pdVector4, pdVector5, pdVector6, pdVector, pdVector2);
    }

    public static PdVector calcLinearGradient(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4, PdVector pdVector5, PdVector pdVector6) {
        if (pdVector6 == null) {
            pdVector6 = new PdVector(3);
        }
        PdVector pdVector7 = PdVector.subNew((PdVector)pdVector2, (PdVector)pdVector);
        PdVector pdVector8 = PdVector.subNew((PdVector)pdVector3, (PdVector)pdVector);
        PdVector pdVector9 = PdVector.subNew((PdVector)pdVector4, (PdVector)pdVector);
        PdVector pdVector10 = PdVector.crossNew((PdVector)pdVector7, (PdVector)pdVector8);
        PgUtil.calcLinearGradient(pdVector, pdVector2, pdVector3, pdVector5, pdVector6);
        double d = (pdVector5.m_data[3] - pdVector5.m_data[0] - pdVector6.dot(pdVector9)) / pdVector10.dot(pdVector9);
        for (int i = 0; i < 3; ++i) {
            int n = i;
            pdVector6.m_data[n] = pdVector6.m_data[n] + d * pdVector10.m_data[i];
        }
        return pdVector6;
    }

    public static PgVectorField[] deriveTexture(PgElementSet pgElementSet) {
        int n;
        boolean bl = pgElementSet.hasVertexTextures();
        if (!bl && !pgElementSet.hasElementTextures()) {
            PsDebug.warning((String)"No texture found");
            return null;
        }
        int n2 = pgElementSet.getDimOfTextures();
        PgVectorField[] pgVectorFieldArray = new PgVectorField[n2];
        for (n = 0; n < n2; ++n) {
            pgVectorFieldArray[n] = new PgVectorField(3, 1);
            pgVectorFieldArray[n].setGeometry((PgPointSet)pgElementSet);
            pgVectorFieldArray[n].setName("VF[" + n + "]");
        }
        n = pgElementSet.getNumElements();
        for (int i = 0; i < n; ++i) {
            int n3;
            PiVector piVector = pgElementSet.getElement(i);
            int n4 = piVector.getSize();
            PdVector[] pdVectorArray = PdVector.realloc(null, (int)n2, (int)n4);
            for (n3 = 0; n3 < n4; ++n3) {
                int n5;
                if (bl) {
                    n5 = piVector.m_data[n3];
                    for (int j = 0; j < n2; ++j) {
                        pdVectorArray[j].m_data[n3] = pgElementSet.getVertexTexture((int)n5).m_data[j];
                    }
                    continue;
                }
                for (n5 = 0; n5 < n2; ++n5) {
                    pdVectorArray[n5].m_data[n3] = pgElementSet.getElementTexture((int)i)[n3].m_data[n5];
                }
            }
            for (n3 = 0; n3 < n2; ++n3) {
                PgUtil.calcLinearGradient(pgElementSet, i, pdVectorArray[n3], pgVectorFieldArray[n3].getVector(i));
            }
        }
        return pgVectorFieldArray;
    }

    public static PdVector computeTextureAreas(PgElementSet pgElementSet) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return null;
        }
        if (!pgElementSet.hasElementTextures() && !pgElementSet.hasVertexTextures()) {
            PsDebug.warning((String)"Geometry has no textures");
            return null;
        }
        PdVector[] pdVectorArray = pgElementSet.hasVertexTextures() ? pgElementSet.getVertexTextures() : null;
        PdVector[][] pdVectorArray2 = pgElementSet.hasElementTextures() ? pgElementSet.getElementTextures() : (PdVector[][])null;
        boolean bl = pdVectorArray2 != null;
        int n = pgElementSet.getNumElements();
        int n2 = 3;
        PdVector[] pdVectorArray3 = bl ? null : PdVector.realloc(null, (int)n2, (int)2);
        PdVector pdVector = new PdVector(n);
        for (int i = 0; i < n; ++i) {
            int n3 = pgElementSet.getDimOfElement(i);
            if (bl) {
                pdVectorArray3 = pdVectorArray2[i];
            } else {
                PiVector piVector = pgElementSet.getElement(i);
                if (n3 > n2) {
                    n2 = n3;
                    pdVectorArray3 = PdVector.realloc(null, (int)n2, (int)2);
                }
                for (int j = 0; j < n3; ++j) {
                    pdVectorArray3[j].copy(pdVectorArray[piVector.m_data[j]]);
                }
            }
            double d = 0.0;
            for (int j = 0; j < n3 - 2; ++j) {
                d += (pdVectorArray3[j + 1].m_data[0] - pdVectorArray3[j].m_data[0]) * (pdVectorArray3[j + 2].m_data[1] - pdVectorArray3[j].m_data[1]) - (pdVectorArray3[j + 1].m_data[1] - pdVectorArray3[j].m_data[1]) * (pdVectorArray3[j + 2].m_data[0] - pdVectorArray3[j].m_data[0]);
            }
            pdVector.m_data[i] = d;
        }
        return pdVector;
    }
}

