/*
 * Decompiled with CFR 0.152.
 */
package jvx.curve;

import jv.function.PuFunction;
import jv.geom.PgPolygon;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;

public class PgFunction
extends PgPolygon {
    protected PuFunction m_function;
    protected PuDouble m_uMin;
    protected PuDouble m_uMax;
    protected PuInteger m_numPoints;
    static /* synthetic */ Class class$jvx$curve$PgFunction;

    public PgFunction() {
        super(2);
        this.setTag(10);
        this.setFunction(new PuFunction(1, 1));
        this.m_function.setName(PsConfig.getMessage((int)15044));
        this.m_uMin = new PuDouble("u-" + PsConfig.getMessage((int)54000), (PsUpdateIf)this);
        this.m_uMax = new PuDouble("u-" + PsConfig.getMessage((int)54001), (PsUpdateIf)this);
        this.m_numPoints = new PuInteger(PsConfig.getMessage((int)54002), (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$curve$PgFunction == null ? (class$jvx$curve$PgFunction = PgFunction.class$("jvx.curve.PgFunction")) : class$jvx$curve$PgFunction)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.showVertices(false);
        this.setGlobalEdgeSize(1.0);
        this.m_function.setExpression(0, "cos(u)*exp(-u*u/50)*10");
        this.m_uMin.setDefBounds(-100.0, 100.0, 0.1, 5.0);
        this.m_uMin.setDefValue(-20.0);
        this.m_uMin.init();
        this.m_uMax.setDefBounds(-100.0, 100.0, 0.1, 5.0);
        this.m_uMax.setDefValue(20.0);
        this.m_uMax.init();
        this.m_numPoints.setDefBounds(2, 1000, 1, 5);
        this.m_numPoints.setDefValue(300);
        this.m_numPoints.init();
        this.computeCurve();
    }

    public boolean update(Object object) {
        PsDebug.notify((String)"called");
        if (object == this.m_function) {
            this.computeCurve();
            return super.update((Object)this);
        }
        if (object == this.m_numPoints) {
            if (this.m_numPoints.getValue() <= 1) {
                this.m_numPoints.setValue(2);
            }
            this.computeCurve();
            return super.update((Object)this);
        }
        if (object == this.m_uMin) {
            if (this.m_uMin.getValue() > this.m_uMax.getValue()) {
                this.m_uMax.setValue(this.m_uMin.getValue());
            } else {
                this.computeCurve();
            }
            return super.update((Object)this);
        }
        if (object == this.m_uMax) {
            if (this.m_uMax.getValue() < this.m_uMin.getValue()) {
                this.m_uMin.setValue(this.m_uMax.getValue());
            } else {
                this.computeCurve();
            }
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public boolean computeCurve() {
        int n = this.m_numPoints.getValue();
        double d = this.m_uMin.getValue();
        double d2 = (this.m_uMax.getValue() - d) / (double)(n - 1);
        this.setNumVertices(n);
        double d3 = d;
        for (int i = 0; i < n; ++i) {
            double d4 = this.m_function.eval(d3);
            this.setVertex(i, d3, d4);
            d3 += d2;
        }
        return true;
    }

    public boolean setFunction(PuFunction puFunction) {
        if (puFunction == null) {
            PsDebug.warning((String)"missing function");
            return false;
        }
        if (puFunction.getNumFunctions() != 1) {
            PsDebug.warning((String)"number of functions must be one.");
            return false;
        }
        this.m_function = puFunction;
        this.m_function.setParent((PsUpdateIf)this);
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

