/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.expr;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import jv.thirdParty.expr.Expr;
import jv.thirdParty.expr.Literal;
import jv.thirdParty.expr.Syntax_error;
import jv.thirdParty.expr.Var_ref;
import jv.thirdParty.expr.Variable;

public class Parser {
    private static final String[] PROCS = new String[]{"cos", "sin", "tan", "cot", "acos", "asin", "atan", "acot", "arccos", "arcsin", "arctan", "arccot", "cosh", "sinh", "tanh", "coth", "acosh", "asinh", "atanh", "acoth", "arccosh", "arcsinh", "arctanh", "arccoth", "sqrt", "exp", "log", "ln", "abs", "sign", "ceil", "floor", "round", "arg", "conj", "inv", "re", "real", "im", "imag"};
    private static final int[] RATORS = new int[]{106, 112, 114, 115, 101, 102, 103, 104, 101, 102, 103, 104, 117, 116, 118, 119, 121, 120, 122, 123, 121, 120, 122, 123, 113, 107, 109, 109, 100, 124, 105, 108, 111, 125, 126, 127, 128, 128, 129, 129};
    private static final String[] PROCS2 = new String[]{"cmplx", "complex"};
    private static final int[] RATORS2 = new int[]{130, 130};
    private static StreamTokenizer m_tokens;

    public static synchronized Expr parse(String string) throws Syntax_error {
        m_tokens = new StreamTokenizer(new StringReader(string));
        m_tokens.ordinaryChar(47);
        m_tokens.ordinaryChar(45);
        Parser.next();
        Expr expr = Parser.parse_expr(0);
        if (Parser.m_tokens.ttype != -1) {
            throw new Syntax_error("Incomplete expression: " + string);
        }
        return expr;
    }

    private static void next() {
        try {
            m_tokens.nextToken();
        }
        catch (IOException iOException) {
            throw new RuntimeException("I/O error: " + iOException);
        }
    }

    private static void expect(int n) throws Syntax_error {
        if (Parser.m_tokens.ttype != n) {
            throw new Syntax_error("'" + (char)n + "' expected");
        }
        Parser.next();
    }

    private static Expr parse_expr(int n) throws Syntax_error {
        Expr expr = Parser.parse_factor();
        block7: while (true) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            switch (Parser.m_tokens.ttype) {
                case 43: {
                    n2 = 10;
                    n3 = 11;
                    n4 = 0;
                    break;
                }
                case 45: {
                    n2 = 10;
                    n3 = 11;
                    n4 = 1;
                    break;
                }
                case 42: {
                    n2 = 20;
                    n3 = 21;
                    n4 = 2;
                    break;
                }
                case 47: {
                    n2 = 20;
                    n3 = 21;
                    n4 = 3;
                    break;
                }
                case 94: {
                    n2 = 30;
                    n3 = 30;
                    n4 = 4;
                    break;
                }
                default: {
                    break block7;
                }
            }
            if (n2 < n) break;
            Parser.next();
            expr = Expr.make_app2(n4, expr, Parser.parse_expr(n3));
        }
        return expr;
    }

    private static Expr parse_factor() throws Syntax_error {
        switch (Parser.m_tokens.ttype) {
            case -2: {
                double d = Parser.m_tokens.nval;
                Literal literal = new Literal(d);
                m_tokens.ordinaryChar(101);
                m_tokens.ordinaryChar(69);
                Parser.next();
                m_tokens.wordChars(101, 101);
                m_tokens.wordChars(69, 69);
                if (Parser.m_tokens.ttype == 101 || Parser.m_tokens.ttype == 69) {
                    Parser.next();
                    double d2 = 0.0;
                    if (Parser.m_tokens.ttype == 43) {
                        Parser.next();
                        d2 = Parser.m_tokens.nval;
                    } else if (Parser.m_tokens.ttype == 45) {
                        Parser.next();
                        d2 = -Parser.m_tokens.nval;
                    } else {
                        d2 = Parser.m_tokens.nval;
                    }
                    if (Parser.m_tokens.ttype != -2) {
                        m_tokens.pushBack();
                        return literal;
                    }
                    d2 = d * Math.pow(10.0, d2);
                    literal = new Literal(d2);
                    Parser.next();
                }
                return literal;
            }
            case -3: {
                int n;
                for (n = 0; n < PROCS.length; ++n) {
                    if (!PROCS[n].equalsIgnoreCase(Parser.m_tokens.sval)) continue;
                    Parser.next();
                    Parser.expect(40);
                    Expr expr = Parser.parse_expr(0);
                    Parser.expect(41);
                    return Expr.make_app1(RATORS[n], expr);
                }
                for (n = 0; n < PROCS2.length; ++n) {
                    if (!PROCS2[n].equalsIgnoreCase(Parser.m_tokens.sval)) continue;
                    Parser.next();
                    Parser.expect(40);
                    Expr expr = Parser.parse_expr(0);
                    Parser.expect(44);
                    Expr expr2 = Parser.parse_expr(0);
                    Parser.expect(41);
                    return Expr.make_app2(RATORS2[n], expr, expr2);
                }
                Var_ref var_ref = new Var_ref(Variable.make(Parser.m_tokens.sval));
                Parser.next();
                return var_ref;
            }
            case 40: {
                Parser.next();
                Expr expr = Parser.parse_expr(0);
                Parser.expect(41);
                return expr;
            }
            case 45: {
                Parser.next();
                return Expr.make_app1(110, Parser.parse_expr(15));
            }
            case 43: {
                Parser.next();
                return Parser.parse_expr(15);
            }
        }
        throw new Syntax_error("Expected a factor");
    }
}

