/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.PuInteger;
import jv.number.PuInteger_CP;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsSlotLayout;
import jv.objectGui.PsToolbarItem;

public class PuInteger_IP
extends PsPanel
implements ActionListener,
AdjustmentListener,
ItemListener {
    protected PuInteger m_number;
    protected int m_oldValue = 0;
    protected int m_newValue = 0;
    protected TextField m_text;
    protected Scrollbar m_scrollbar;
    protected PsToolbarItem m_toolItem;
    protected Checkbox m_enabledBox;
    static /* synthetic */ Class class$jv$number$PuInteger_IP;

    public PuInteger_IP() {
        if (this.getClass() == (class$jv$number$PuInteger_IP == null ? (class$jv$number$PuInteger_IP = PuInteger_IP.class$("jv.number.PuInteger_IP")) : class$jv$number$PuInteger_IP)) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_number = (PuInteger)psUpdateIf;
        this.m_insetSizeVerExtra = 1;
        this.setLayout(new PsSlotLayout(6));
        if (this.m_number.m_showEnabled) {
            this.m_enabledBox = new Checkbox("", this.isEnabled());
            this.add("2", this.m_enabledBox);
            this.m_enabledBox.addItemListener(this);
        } else {
            this.add("2", this.getTitle(""));
        }
        this.m_text = new TextField(7);
        this.m_text.addActionListener(this);
        this.add("1", this.m_text);
        PsPanel psPanel = new PsPanel(new BorderLayout());
        this.add("3", psPanel);
        this.m_scrollbar = new Scrollbar(0);
        this.m_scrollbar.addAdjustmentListener(this);
        psPanel.add((Component)this.m_scrollbar, "Center");
        this.m_toolItem = new PsToolbarItem(43);
        this.m_toolItem.addActionListener(this);
        this.m_toolItem.setChoice("Open configuration panel");
        psPanel.add((Component)this.m_toolItem, "East");
    }

    public boolean update(Object object) {
        PsDebug.notify("called");
        if (this.m_number == null) {
            PsDebug.warning("missing integer");
            return true;
        }
        if (object == this.m_number) {
            String string = this.m_number.getName();
            String string2 = this.m_number.getSymbol();
            if (string2 != null) {
                string = string + " (" + string2 + ")";
            }
            this.setTitle(string);
            if (this.m_enabledBox != null) {
                this.m_enabledBox.setLabel(string);
                this.m_enabledBox.validate();
            }
            PsPanel.setText(this.m_text, String.valueOf(this.m_number.getValue()));
            if (this.m_scrollbar.getUnitIncrement() != this.m_number.m_lineIncr) {
                this.m_scrollbar.setUnitIncrement(this.m_number.m_lineIncr);
            }
            if (this.m_scrollbar.getBlockIncrement() != this.m_number.m_pageIncr) {
                this.m_scrollbar.setBlockIncrement(this.m_number.m_pageIncr);
            }
            this.m_scrollbar.setValues(this.m_number.m_value, this.m_number.m_pageIncr, this.m_number.m_minimum, this.m_number.m_maximum + this.m_number.m_pageIncr);
            this.m_oldValue = this.m_number.m_value;
            if (this.isEnabled() != this.m_number.m_bEnabled || this.m_toolItem.isEnabled() != this.m_number.m_bEnabledConfigButton) {
                this.setEnabled(this.m_number.m_bEnabled);
            }
            if (this.m_number.getBackground() != null) {
                this.setBackColor(this.m_number.getBackground());
            }
            return true;
        }
        return super.update(object);
    }

    public void setEnabled(boolean bl) {
        if (this.m_number != null) {
            PsPanel.setEnabled(this.m_toolItem, bl && this.m_number.m_bEnabledConfigButton);
        } else {
            PsPanel.setEnabled(this.m_toolItem, bl);
        }
        PsPanel.setEnabled(this.m_lTitle, bl);
        PsPanel.setEnabled(this.m_text, bl);
        PsPanel.setEnabled(this.m_scrollbar, bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_text) {
            PsDebug.notify("text chosen");
            String string = this.m_text.getText();
            if (PuString.isEmpty(string)) {
                return;
            }
            try {
                int n = Integer.parseInt(string);
                if ((actionEvent.getModifiers() & 1) != 0) {
                    this.m_number.enlargeBounds(n);
                }
                this.m_number.setValueFromPanel(n, this);
                if (this.m_number.getValue() != n) {
                    n = this.m_number.getValue();
                    PsPanel.setText(this.m_text, String.valueOf(n));
                }
                this.m_scrollbar.setValue(n);
                this.m_oldValue = n;
                PsDebug.notify("setValue=" + n);
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning("wrong format = " + string);
                PsPanel.setText(this.m_text, String.valueOf(this.m_number.getValue()));
                return;
            }
            this.m_number.update(this.m_number);
        } else if (object == this.m_toolItem) {
            PuInteger_CP puInteger_CP = new PuInteger_CP(this.m_number);
            puInteger_CP.init(this.m_number.m_minimum, this.m_number.m_maximum, this.m_number.m_lineIncr, this.m_number.m_pageIncr);
            puInteger_CP.setParent(this);
            ((Component)puInteger_CP).setVisible(true);
            if (puInteger_CP.getUserAction() == 4) {
                this.m_number.update(this.m_number);
            }
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (object == this.m_scrollbar) {
            this.m_newValue = this.m_scrollbar.getValue();
            if (this.m_oldValue == this.m_newValue) {
                return;
            }
            this.m_oldValue = this.m_newValue;
            this.m_number.setValueFromPanel(this.m_newValue, this);
            PsPanel.setText(this.m_text, String.valueOf(this.m_number.getValue()));
            PsDebug.notify("setValue=" + this.m_number.getValue());
            this.m_number.update(this);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.m_enabledBox) {
            this.m_number.setEnabled(this.m_enabledBox.getState());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

