/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PsXmlLoader {
    public static PsXmlSrc read(String string) {
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open file = " + string);
            return null;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read(bufferedReader);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (psXmlSrc == null) {
            PsDebug.warning("error when reading file = " + string);
            return null;
        }
        psXmlSrc.setRsrcFile(string);
        return psXmlSrc;
    }

    public static PsXmlSrc read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning("missing buffered reader");
            return null;
        }
        PsXmlSrc psXmlSrc = new PsXmlSrc();
        try {
            boolean bl = PsXmlLoader.parse(bufferedReader, psXmlSrc);
            if (!bl) {
                PsDebug.warning("failed reading stream = " + bufferedReader);
                return null;
            }
        }
        catch (IOException iOException) {
            PsDebug.warning("failed reading stream = " + bufferedReader);
            iOException.printStackTrace();
            return null;
        }
        return psXmlSrc;
    }

    /*
     * Loose catch block
     */
    protected static boolean parse(BufferedReader bufferedReader, PsXmlSrc psXmlSrc) throws IOException {
        int n;
        if (bufferedReader == null || psXmlSrc == null) {
            PsDebug.warning("missing reader or XML source");
            return false;
        }
        do {
            bufferedReader.mark(200);
        } while ((n = bufferedReader.read()) == 32 || n == 9 || n == 10 || n == 13);
        if (n == -1) {
            PsDebug.warning("empty file.");
            return false;
        }
        char[] cArray = new char[5];
        cArray[0] = (char)n;
        for (int i = 1; i < 5; ++i) {
            n = (char)bufferedReader.read();
            if (n == -1) {
                PsDebug.warning("invalid file, could not find xml-tag, eof reached.");
                return false;
            }
            cArray[i] = (char)n;
        }
        String string = String.valueOf(cArray);
        bufferedReader.reset();
        if (!string.startsWith("<?xml")) {
            int n2 = string.indexOf("<?xml");
            if (n2 == -1) {
                if (!"<javaview-models>".startsWith(string)) {
                    PsDebug.warning("invalid XML file, first line starts with = " + string);
                    return false;
                }
            } else if (n2 > 0) {
                string = string.substring(n2);
                bufferedReader.read(new char[n2], 0, n2);
            }
        }
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.ordinaryChars(48, 48);
        streamTokenizer.ordinaryChars(49, 57);
        streamTokenizer.ordinaryChar(124);
        streamTokenizer.ordinaryChar(60);
        streamTokenizer.ordinaryChar(62);
        streamTokenizer.ordinaryChar(47);
        streamTokenizer.ordinaryChar(33);
        streamTokenizer.ordinaryChar(63);
        streamTokenizer.ordinaryChar(91);
        streamTokenizer.ordinaryChar(93);
        streamTokenizer.ordinaryChar(123);
        streamTokenizer.ordinaryChar(125);
        streamTokenizer.ordinaryChar(45);
        streamTokenizer.ordinaryChar(43);
        streamTokenizer.ordinaryChar(46);
        streamTokenizer.ordinaryChar(39);
        streamTokenizer.ordinaryChar(92);
        streamTokenizer.ordinaryChar(96);
        streamTokenizer.ordinaryChar(180);
        streamTokenizer.ordinaryChar(176);
        streamTokenizer.wordChars(124, 124);
        streamTokenizer.wordChars(39, 39);
        streamTokenizer.wordChars(92, 92);
        streamTokenizer.wordChars(96, 96);
        streamTokenizer.wordChars(180, 180);
        streamTokenizer.wordChars(176, 176);
        streamTokenizer.wordChars(35, 35);
        streamTokenizer.wordChars(94, 94);
        streamTokenizer.wordChars(38, 38);
        streamTokenizer.wordChars(36, 36);
        streamTokenizer.wordChars(40, 40);
        streamTokenizer.wordChars(41, 41);
        streamTokenizer.wordChars(123, 123);
        streamTokenizer.wordChars(125, 125);
        streamTokenizer.wordChars(126, 126);
        streamTokenizer.wordChars(64, 64);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(43, 43);
        streamTokenizer.wordChars(42, 42);
        streamTokenizer.wordChars(48, 48);
        streamTokenizer.wordChars(49, 57);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.wordChars(44, 44);
        streamTokenizer.wordChars(59, 59);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(58, 58);
        streamTokenizer.whitespaceChars(61, 61);
        int n3 = 0;
        PsXmlNode psXmlNode = null;
        PsXmlNode psXmlNode2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = true;
        block30: while (true) {
            block31: while (true) {
                if (bl2) {
                    PsDebug.notify("num of lines  = " + streamTokenizer.lineno());
                    PsDebug.notify("... finished");
                    if (n3 > 0) {
                        PsDebug.warning("missing closing element");
                        if (psXmlNode != null) {
                            PsDebug.warning("current element = " + psXmlNode.getType());
                        }
                        return false;
                    }
                    if (n3 < 0) {
                        PsDebug.warning("too many closing element");
                        if (psXmlNode != null) {
                            PsDebug.warning("current element = " + psXmlNode.getType());
                        }
                        return false;
                    }
                    if (psXmlNode2 != psXmlNode) {
                        PsDebug.warning("mismatch between opening and closing elements.");
                    }
                    psXmlSrc.setRootNode(psXmlNode2);
                    return true;
                }
                switch (streamTokenizer.nextToken()) {
                    default: {
                        if (bl6) {
                            if (!psXmlNode.isMixedMode() && psXmlNode.getChild() != null) {
                                psXmlNode.setMixedMode(true);
                                psXmlNode.addMixedContent(psXmlNode.getChild());
                            }
                            psXmlNode.appendContent(String.valueOf((char)streamTokenizer.ttype));
                            continue block31;
                        }
                        PsDebug.warning("parsing broke abnormally\n\t in line=" + streamTokenizer.lineno() + " reading st.sval=" + streamTokenizer.sval + ", st.ttype=" + streamTokenizer.ttype);
                        return false;
                    }
                    case 10: {
                        if (!bl4 || psXmlNode == null || !psXmlNode.hasContent()) continue block31;
                        psXmlNode.appendContent("\n");
                        continue block31;
                    }
                    case -1: {
                        bl2 = true;
                        continue block31;
                    }
                    case 60: {
                        char c;
                        streamTokenizer.whitespaceChars(32, 32);
                        streamTokenizer.ordinaryChar(47);
                        streamTokenizer.ordinaryChar(34);
                        streamTokenizer.quoteChar(34);
                        if (bl4 && psXmlNode != null && psXmlNode.hasContent() && psXmlNode.contentEndsWith('\n')) {
                            String string2 = psXmlNode.getContent();
                            string2 = string2.substring(0, string2.length() - 1);
                            psXmlNode.setContent(string2);
                        }
                        bl4 = false;
                        int n4 = streamTokenizer.nextToken();
                        if (n4 == 33 || n4 == 63) {
                            streamTokenizer.nextToken();
                            if (streamTokenizer.sval.equals("xml")) {
                                while ((n4 = streamTokenizer.nextToken()) != 62 && n4 != -1) {
                                }
                                continue block31;
                            }
                            if (streamTokenizer.sval.equals("DOCTYPE")) {
                                streamTokenizer.nextToken();
                                if (streamTokenizer.sval != null) {
                                    psXmlSrc.setDocName(streamTokenizer.sval);
                                } else {
                                    PsDebug.warning("missing DTD doc name.");
                                }
                                int n5 = streamTokenizer.nextToken();
                                if (streamTokenizer.sval != null && streamTokenizer.sval.equals("SYSTEM")) {
                                    streamTokenizer.nextToken();
                                    if (streamTokenizer.sval != null) {
                                        psXmlSrc.setDocType(streamTokenizer.sval);
                                    } else {
                                        PsDebug.warning("missing DTD doc type.");
                                    }
                                } else if (streamTokenizer.sval != null && streamTokenizer.sval.equals("PUBLIC")) {
                                    streamTokenizer.nextToken();
                                    streamTokenizer.nextToken();
                                    if (streamTokenizer.sval != null) {
                                        psXmlSrc.setDocType(streamTokenizer.sval);
                                    } else {
                                        streamTokenizer.pushBack();
                                    }
                                } else if (n5 == 91) {
                                    bl5 = true;
                                } else {
                                    PsDebug.warning("error while parsing doctype.\n\t in line=" + streamTokenizer.lineno() + " reading st.sval=" + streamTokenizer.sval + ", st.ttype=" + streamTokenizer.ttype);
                                }
                                do {
                                    if ((n4 = streamTokenizer.nextToken()) == 62) continue block30;
                                } while (n4 != -1);
                                continue block31;
                            }
                            if (streamTokenizer.sval.equals("ENTITY")) {
                                while ((n4 = streamTokenizer.nextToken()) != 62 && n4 != -1) {
                                }
                                continue block31;
                            }
                            if (streamTokenizer.sval.equals("ELEMENT")) {
                                while ((n4 = streamTokenizer.nextToken()) != 62 && n4 != -1) {
                                }
                                continue block31;
                            }
                            if (streamTokenizer.sval.equals("ATTLIST")) {
                                while ((n4 = streamTokenizer.nextToken()) != 62 && n4 != -1) {
                                }
                                continue block31;
                            }
                            if (streamTokenizer.sval.equals("--")) {
                                while ((n4 = streamTokenizer.nextToken()) != 62 && n4 != -1) {
                                }
                                continue block31;
                            }
                            PsDebug.warning("unknown command.\n\t in line=" + streamTokenizer.lineno() + " reading st.sval=" + streamTokenizer.sval + ", st.ttype=" + streamTokenizer.ttype);
                            while ((n4 = streamTokenizer.nextToken()) != 62 && n4 != -1) {
                            }
                            continue block31;
                        }
                        if (streamTokenizer.sval != null && streamTokenizer.sval.equals("!--")) {
                            while ((n4 = streamTokenizer.nextToken()) != 62 && n4 != -1) {
                            }
                            continue block31;
                        }
                        if (streamTokenizer.sval != null && streamTokenizer.sval.equals("![CDATA[")) {
                            streamTokenizer.ordinaryChar(93);
                            streamTokenizer.wordChars(32, 32);
                            streamTokenizer.wordChars(61, 61);
                            streamTokenizer.ordinaryChar(34);
                            streamTokenizer.wordChars(34, 34);
                            streamTokenizer.wordChars(47, 47);
                            StringBuffer stringBuffer = new StringBuffer();
                            if (psXmlNode.hasContent()) {
                                psXmlNode.appendContent("\n");
                            }
                            psXmlNode.appendContent("<" + streamTokenizer.sval);
                            boolean bl8 = true;
                            block40: while (bl8) {
                                int n6 = streamTokenizer.nextToken();
                                switch (n6) {
                                    default: {
                                        if (streamTokenizer.sval != null) {
                                            stringBuffer.append(streamTokenizer.sval);
                                            continue block40;
                                        }
                                        c = (char)streamTokenizer.ttype;
                                        stringBuffer.append(c);
                                        continue block40;
                                    }
                                    case 93: {
                                        stringBuffer.append("]");
                                        if (streamTokenizer.nextToken() != 93) continue block40;
                                        stringBuffer.append("]");
                                        if (streamTokenizer.nextToken() != 62) continue block40;
                                        stringBuffer.append(">");
                                        if (!psXmlNode.hasContent()) {
                                            psXmlNode.setContent(stringBuffer.toString());
                                        } else {
                                            psXmlNode.appendContent(stringBuffer.toString());
                                        }
                                        bl8 = false;
                                        continue block40;
                                    }
                                    case 10: {
                                        stringBuffer.append("\n");
                                        continue block40;
                                    }
                                    case -1: 
                                }
                                PsDebug.warning("premature end of a CDATA block, missed ']]>' closing");
                                return false;
                            }
                            streamTokenizer.wordChars(93, 93);
                            streamTokenizer.whitespaceChars(32, 32);
                            streamTokenizer.whitespaceChars(61, 61);
                            streamTokenizer.ordinaryChar(34);
                            streamTokenizer.quoteChar(34);
                            streamTokenizer.ordinaryChar(47);
                            continue block31;
                        }
                        if (n4 == 47) {
                            --n3;
                            streamTokenizer.nextToken();
                            if (!(streamTokenizer.sval.equals(psXmlNode.getType()) && psXmlNode.isExpanded() || (psXmlNode = psXmlNode.getFather()).getType().equals(streamTokenizer.sval))) {
                                PsDebug.warning("closing element <" + streamTokenizer.sval + "> does not match open element <" + psXmlNode.getType() + "> in line=" + streamTokenizer.lineno());
                            }
                            if (psXmlNode.isMixedMode() && psXmlNode.hasContent()) {
                                psXmlNode.addMixedContent(psXmlNode.getContent());
                                psXmlNode.setContent(null);
                            }
                            psXmlNode.setExpanded(false);
                            if (psXmlNode != psXmlNode2) continue block31;
                            bl = true;
                            continue block31;
                        }
                        if (bl7) {
                            bl7 = false;
                            streamTokenizer.wordChars(33, 33);
                            streamTokenizer.wordChars(63, 63);
                            streamTokenizer.wordChars(91, 91);
                            streamTokenizer.wordChars(93, 93);
                        }
                        bl6 = false;
                        ++n3;
                        PsXmlNode psXmlNode3 = new PsXmlNode(streamTokenizer.sval);
                        if (psXmlNode == null) {
                            psXmlNode2 = psXmlNode3;
                        } else if (psXmlNode.isExpanded()) {
                            psXmlNode.addChild(psXmlNode3);
                            boolean bl9 = psXmlNode.isMixedMode();
                            if (!bl9 && psXmlNode.hasContent()) {
                                psXmlNode.setMixedMode(true);
                                bl9 = true;
                            }
                            if (bl9) {
                                if (psXmlNode.hasContent()) {
                                    psXmlNode.addMixedContent(psXmlNode.getContent());
                                    psXmlNode.setContent(null);
                                }
                                psXmlNode.addMixedContent(psXmlNode3);
                            }
                        } else {
                            psXmlNode.setSibling(psXmlNode3);
                        }
                        psXmlNode = psXmlNode3;
                        psXmlNode.setExpanded(true);
                        bl3 = true;
                        streamTokenizer.whitespaceChars(61, 61);
                        continue block31;
                    }
                    case 62: {
                        bl3 = false;
                        streamTokenizer.ordinaryChar(61);
                        streamTokenizer.wordChars(61, 61);
                        bl6 = true;
                        streamTokenizer.ordinaryChar(34);
                        streamTokenizer.wordChars(34, 34);
                        streamTokenizer.wordChars(47, 47);
                        if (bl) {
                            bl2 = true;
                            continue block31;
                        }
                        if (psXmlNode == null || psXmlNode.isExpanded() || psXmlNode.getFather() == null || !psXmlNode.getFather().isMixedMode()) continue block31;
                        psXmlNode = psXmlNode.getFather();
                        continue block31;
                    }
                    case 93: {
                        if (bl5) {
                            bl5 = false;
                            continue block31;
                        }
                        if (!bl6) continue block31;
                        if (!psXmlNode.isMixedMode() && psXmlNode.getChild() != null) {
                            psXmlNode.setMixedMode(true);
                            psXmlNode.addMixedContent(psXmlNode.getChild());
                        }
                        psXmlNode.appendContent("]");
                        continue block31;
                    }
                    case 47: {
                        if (bl3) {
                            if (streamTokenizer.nextToken() == 62) {
                                bl3 = false;
                                --n3;
                                psXmlNode.setExpanded(false);
                                continue block31;
                            }
                            PsDebug.error("found '/' in attribute mode, error in line=" + streamTokenizer.lineno());
                            return false;
                        }
                        if (!psXmlNode.isMixedMode() && psXmlNode.getChild() != null) {
                            psXmlNode.setMixedMode(true);
                            psXmlNode.addMixedContent(psXmlNode.getChild());
                        }
                        psXmlNode.appendContent("/");
                        bl4 = true;
                        continue block31;
                    }
                    case 91: {
                        if (!bl6) continue block31;
                        if (!psXmlNode.isMixedMode() && psXmlNode.getChild() != null) {
                            psXmlNode.setMixedMode(true);
                            psXmlNode.addMixedContent(psXmlNode.getChild());
                        }
                        psXmlNode.appendContent(" [");
                        continue block31;
                    }
                    case 34: {
                        if (!bl6) continue block31;
                        if (!psXmlNode.isMixedMode() && psXmlNode.getChild() != null) {
                            psXmlNode.setMixedMode(true);
                            psXmlNode.addMixedContent(psXmlNode.getChild());
                        }
                        psXmlNode.appendContent("\"");
                        continue block31;
                    }
                    case 33: {
                        if (!bl6) continue block31;
                        if (!psXmlNode.isMixedMode() && psXmlNode.getChild() != null) {
                            psXmlNode.setMixedMode(true);
                            psXmlNode.addMixedContent(psXmlNode.getChild());
                        }
                        psXmlNode.appendContent("!");
                        continue block31;
                    }
                    case 63: {
                        if (!bl6) continue block31;
                        if (!psXmlNode.isMixedMode() && psXmlNode.getChild() != null) {
                            psXmlNode.setMixedMode(true);
                            psXmlNode.addMixedContent(psXmlNode.getChild());
                        }
                        psXmlNode.appendContent("?");
                        continue block31;
                    }
                    case 61: {
                        if (!bl6) continue block31;
                        if (!psXmlNode.isMixedMode() && psXmlNode.getChild() != null) {
                            psXmlNode.setMixedMode(true);
                            psXmlNode.addMixedContent(psXmlNode.getChild());
                        }
                        psXmlNode.appendContent("=");
                        continue block31;
                    }
                    case -3: {
                        char c;
                        if (bl3) {
                            String string3 = streamTokenizer.sval;
                            streamTokenizer.ordinaryChar(34);
                            if (streamTokenizer.nextToken() == 34) {
                                String string4 = null;
                                streamTokenizer.ordinaryChar(32);
                                streamTokenizer.wordChars(32, 32);
                                streamTokenizer.ordinaryChar(61);
                                streamTokenizer.wordChars(61, 61);
                                c = '\u0001';
                                block41: while (c != '\u0000') {
                                    switch (streamTokenizer.nextToken()) {
                                        case -1: {
                                            PsDebug.warning("premature end of attribute = " + string3 + ", missed '\"' closing");
                                            return false;
                                        }
                                        case 34: {
                                            if (string4 == null) {
                                                string4 = "";
                                            }
                                            psXmlNode.addAttribute(string3, string4);
                                            c = '\u0000';
                                            continue block41;
                                        }
                                        case 10: {
                                            if (string4 == null) {
                                                string4 = "\n";
                                                continue block41;
                                            }
                                            string4 = string4 + "\n";
                                            continue block41;
                                        }
                                        case -3: {
                                            if (string4 == null) {
                                                string4 = streamTokenizer.sval;
                                                continue block41;
                                            }
                                            string4 = string4 + streamTokenizer.sval;
                                            continue block41;
                                        }
                                    }
                                    String string5 = String.valueOf((char)streamTokenizer.ttype);
                                    if (string4 == null) {
                                        string4 = string5;
                                        continue;
                                    }
                                    string4 = string4 + string5;
                                }
                                streamTokenizer.whitespaceChars(32, 32);
                                streamTokenizer.whitespaceChars(61, 61);
                            } else {
                                PsDebug.warning("attribute value not enclosed with quotes \"att-value\".");
                                psXmlNode.addAttribute(string3, streamTokenizer.sval);
                            }
                            streamTokenizer.quoteChar(34);
                            continue block31;
                        }
                        if (!psXmlNode.isExpanded()) {
                            psXmlNode = psXmlNode.getFather();
                        }
                        if (!psXmlNode.isMixedMode() && psXmlNode.getChild() != null) {
                            psXmlNode.setMixedMode(true);
                            psXmlNode.addMixedContent(psXmlNode.getChild());
                        }
                        if (!psXmlNode.hasContent()) {
                            psXmlNode.setContent(streamTokenizer.sval);
                        } else if (psXmlNode.contentEndsWith('\n') || psXmlNode.contentEndsWith('/')) {
                            psXmlNode.appendContent(streamTokenizer.sval);
                        } else {
                            psXmlNode.appendContent(" " + streamTokenizer.sval);
                        }
                        bl4 = true;
                        continue block31;
                    }
                    case -2: 
                }
                if (!psXmlNode.isMixedMode() && psXmlNode.getChild() != null) {
                    psXmlNode.setMixedMode(true);
                }
                if (!psXmlNode.hasContent()) {
                    psXmlNode.setContent(String.valueOf(streamTokenizer.nval));
                } else {
                    psXmlNode.appendContent(" " + String.valueOf(streamTokenizer.nval));
                }
                bl4 = true;
            }
            break;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown in line=" + streamTokenizer.lineno() + ", Exception = " + exception);
            return false;
        }
    }

    public static PdVector[] parseDoubleList(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode, string);
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            return null;
        }
        PdVector[] pdVectorArray = new PdVector[psXmlNodeArray.length];
        for (int i = 0; i < psXmlNodeArray.length; ++i) {
            pdVectorArray[i] = PsXmlLoader.parsePdVector(psXmlNodeArray[i], stringArray);
            if (pdVectorArray[i] != null) continue;
            PsDebug.warning("failed to parse vector at index = " + i);
            return null;
        }
        return pdVectorArray;
    }

    public static PdVector parsePdVector(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, string);
        if (psXmlNode2 == null) {
            return null;
        }
        return PsXmlLoader.parsePdVector(psXmlNode2, stringArray);
    }

    public static PdVector parsePdVector(PsXmlNode psXmlNode, String[] stringArray) {
        if (psXmlNode == null) {
            PsDebug.warning("missing xml node.");
            return null;
        }
        PdVector pdVector = PsXmlLoader.parsePdVector(psXmlNode.getContent());
        if (stringArray != null) {
            PsXmlLoader.parseVectorAttr(pdVector, psXmlNode, stringArray);
        }
        return pdVector;
    }

    public static void parseVectorAttr(P_Vector p_Vector, PsXmlNode psXmlNode, String[] stringArray) {
        if (p_Vector == null || psXmlNode == null || stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = psXmlNode.getAttribute(stringArray[i]);
            if (string == null) continue;
            if (string.equalsIgnoreCase("mark")) {
                p_Vector.setTag(1);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("name")) {
                p_Vector.setName(string);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("detail")) {
                string = PuString.replace(string, "\\n", "\n");
                p_Vector.setDetail(string);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("url")) {
                p_Vector.setURL(string);
                continue;
            }
            PsDebug.warning("unknown attribute = " + stringArray[i]);
            stringArray = null;
            break;
        }
    }

    public static PdVector parsePdVector(String string) {
        if (string == null) {
            return new PdVector();
        }
        String[] stringArray = PuString.splitString(string, ' ');
        if (stringArray == null || stringArray.length == 0) {
            return new PdVector();
        }
        PdVector pdVector = new PdVector(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            pdVector.setEntry(i, PuDouble.parseDouble(stringArray[i]));
        }
        return pdVector;
    }

    public static PdMatrix parsePdMatrix(PsXmlNode psXmlNode, String string) {
        if (psXmlNode == null) {
            PsDebug.warning("missing parent node.");
            return null;
        }
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, string);
        if (psXmlNode2 == null) {
            PsDebug.warning("missing matrix node.");
            return null;
        }
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode2, "row");
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            PsDebug.warning("missing rows in matrix");
            return null;
        }
        String[] stringArray = PuString.splitString(psXmlNodeArray[0].getContent(), ' ');
        if (stringArray == null || stringArray.length == 0) {
            PsDebug.warning("missing entries in row = 0");
            return null;
        }
        int n = psXmlNodeArray.length;
        int n2 = stringArray.length;
        PdMatrix pdMatrix = new PdMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            stringArray = PuString.splitString(psXmlNodeArray[i].getContent(), ' ');
            if (stringArray == null || stringArray.length != n2) {
                PsDebug.warning("invalid number of entries in row = " + i);
                return null;
            }
            for (int j = 0; j < n2; ++j) {
                pdMatrix.setEntry(i, j, PuDouble.parseDouble(stringArray[j]));
            }
        }
        return pdMatrix;
    }

    public static PiVector parsePiVector(String string) {
        if (string == null) {
            return new PiVector();
        }
        String[] stringArray = PuString.splitString(string, ' ');
        if (stringArray == null || stringArray.length == 0) {
            return new PiVector();
        }
        PiVector piVector = new PiVector(stringArray.length);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                piVector.setEntry(i, Integer.parseInt(stringArray[i]));
            }
            return piVector;
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning("wrong format in integer string = " + string);
            return null;
        }
    }

    public static PiVector[] parseIntegerList(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode, string);
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            return null;
        }
        PiVector[] piVectorArray = new PiVector[psXmlNodeArray.length];
        for (int i = 0; i < psXmlNodeArray.length; ++i) {
            piVectorArray[i] = PsXmlLoader.parsePiVector(psXmlNodeArray[i], stringArray);
            if (piVectorArray[i] != null) continue;
            PsDebug.warning("failed to parse vector at index = " + i);
            return null;
        }
        return piVectorArray;
    }

    public static PiVector parsePiVector(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, string);
        if (psXmlNode2 == null) {
            return null;
        }
        return PsXmlLoader.parsePiVector(psXmlNode2, stringArray);
    }

    public static PiVector parsePiVector(PsXmlNode psXmlNode, String[] stringArray) {
        if (psXmlNode == null) {
            PsDebug.warning("missing xml node.");
            return null;
        }
        PiVector piVector = PsXmlLoader.parsePiVector(psXmlNode.getContent());
        if (stringArray != null) {
            PsXmlLoader.parseVectorAttr(piVector, psXmlNode, stringArray);
        }
        return piVector;
    }

    public static Color[] parseColorList(PsXmlNode psXmlNode, String string) {
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode, string);
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            return null;
        }
        Color[] colorArray = new Color[psXmlNodeArray.length];
        for (int i = 0; i < psXmlNodeArray.length; ++i) {
            colorArray[i] = PsXmlLoader.parseColorContent(psXmlNodeArray[i]);
            if (colorArray[i] != null) continue;
            PsDebug.warning("failed to parse color at index = " + i);
            return null;
        }
        return colorArray;
    }

    public static Color parseColorRGB(PsXmlNode psXmlNode, String string) {
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, string);
        if (psXmlNode2 == null) {
            return null;
        }
        return PsXmlLoader.parseColorContent(psXmlNode2);
    }

    public static Color parseColorContent(PsXmlNode psXmlNode) {
        if (psXmlNode == null) {
            return null;
        }
        String string = psXmlNode.getContent();
        return PdColor.parseColor(string);
    }

    public static PsXmlNode addMatrix(PsXmlNode psXmlNode, String string, PdMatrix pdMatrix) {
        if (pdMatrix == null) {
            return null;
        }
        PsXmlNode psXmlNode2 = psXmlNode.addChild(string);
        int n = pdMatrix.getNumRows();
        for (int i = 0; i < n; ++i) {
            psXmlNode2.addChild("row", PuString.toString(pdMatrix.m_data[i], false));
        }
        return psXmlNode2;
    }

    public static void addVectorList(PsXmlNode psXmlNode, String string, PdVector pdVector, int n) {
        if (pdVector == null || pdVector.getSize() < n) {
            return;
        }
        psXmlNode.addAttribute("num", String.valueOf(n));
        for (int i = 0; i < n; ++i) {
            psXmlNode.addChild(string, PuString.toString(pdVector.getEntry(i)));
        }
    }

    public static void addVectorList(PsXmlNode psXmlNode, String string, PdVector[] pdVectorArray, int n) {
        if (pdVectorArray == null || pdVectorArray.length < n) {
            return;
        }
        boolean bl = "p".equals(string);
        psXmlNode.addAttribute("num", String.valueOf(n));
        for (int i = 0; i < n; ++i) {
            PsXmlLoader.addVector(psXmlNode, string, pdVectorArray[i], bl);
        }
    }

    public static void addVectorList(PsXmlNode psXmlNode, String string, PiVector[] piVectorArray, int n) {
        if (piVectorArray == null || piVectorArray.length < n) {
            return;
        }
        boolean bl = "e".equals(string) || "f".equals(string) || "l".equals(string);
        psXmlNode.addAttribute("num", String.valueOf(n));
        for (int i = 0; i < n; ++i) {
            PsXmlLoader.addVector(psXmlNode, string, piVectorArray[i], bl);
        }
    }

    public static PsXmlNode addVector(PsXmlNode psXmlNode, String string, PdVector pdVector, boolean bl) {
        if (pdVector == null) {
            return null;
        }
        PsXmlNode psXmlNode2 = psXmlNode.addChild(string, PuString.toString(pdVector.m_data));
        PsXmlLoader.addVectorAttr(psXmlNode2, pdVector, bl);
        return psXmlNode2;
    }

    public static PsXmlNode addVector(PsXmlNode psXmlNode, String string, PiVector piVector, boolean bl) {
        if (piVector == null) {
            return null;
        }
        PsXmlNode psXmlNode2 = psXmlNode.addChild(string, PuString.toString(piVector.m_data));
        PsXmlLoader.addVectorAttr(psXmlNode2, piVector, bl);
        return psXmlNode2;
    }

    private static PsXmlNode addVectorAttr(PsXmlNode psXmlNode, P_Vector p_Vector, boolean bl) {
        if (bl) {
            String string = p_Vector.getName();
            if (string != null) {
                psXmlNode.addAttribute("name", string);
            }
            if ((string = p_Vector.getURL()) != null) {
                psXmlNode.addAttribute("url", string);
            }
            if ((string = p_Vector.getDetail()) != null) {
                string = PuString.replace(string, "\n", "\\n");
                psXmlNode.addAttribute("detail", string);
            }
        }
        if (p_Vector.hasTag(1)) {
            psXmlNode.addAttribute("tag", "mark");
        }
        return psXmlNode;
    }

    public static void addVectorList(PsXmlNode psXmlNode, String string, PdVector[][] pdVectorArray, int n) {
        int n2;
        if (pdVectorArray == null || pdVectorArray.length < n) {
            return;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (pdVectorArray[n2] != null) continue;
            return;
        }
        n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < pdVectorArray[i].length; ++j) {
                psXmlNode.addChild(string, PuString.toString(pdVectorArray[i][j].m_data));
            }
            n2 += pdVectorArray[i].length;
        }
        psXmlNode.addAttribute("num", String.valueOf(n2));
    }

    public static void addVectorList(PsXmlNode psXmlNode, String string, Color[] colorArray, int n) {
        if (colorArray == null || colorArray.length < n) {
            return;
        }
        psXmlNode.addAttribute("num", String.valueOf(n));
        for (int i = 0; i < n; ++i) {
            String string2 = String.valueOf(colorArray[i].getRed()) + " " + String.valueOf(colorArray[i].getGreen()) + " " + String.valueOf(colorArray[i].getBlue());
            psXmlNode.addChild(string, string2);
        }
    }

    public static PsXmlNode addColor(PsXmlNode psXmlNode, String string, String string2, Color color) {
        if (color == null) {
            return null;
        }
        PsXmlNode psXmlNode2 = psXmlNode.addChild(string);
        if (PsXmlLoader.addColor(psXmlNode2, string2, color) == null) {
            return null;
        }
        return psXmlNode2;
    }

    public static PsXmlNode addColor(PsXmlNode psXmlNode, String string, Color color) {
        if (color == null) {
            return null;
        }
        PsXmlNode psXmlNode2 = psXmlNode.addChild(string);
        psXmlNode2.setContent(String.valueOf(color.getRed()) + " " + String.valueOf(color.getGreen()) + " " + String.valueOf(color.getBlue()));
        psXmlNode2.addAttribute("type", "rgb");
        return psXmlNode2;
    }
}

