/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import jv.geom.PgBndConstraint;
import jv.geom.PgElementSet;
import jv.geom.PgTetraSet;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PgBndElementSet
extends PgElementSet {
    protected PgTetraSet m_geom;
    protected PiVector m_vertexInd = new PiVector();
    protected PiVector m_tetraInd = new PiVector();
    protected PiVector m_neighbourLocInd = new PiVector();
    protected PgBndConstraint m_bndConstraint;
    static /* synthetic */ Class class$jv$geom$PgBndElementSet;

    public PgBndElementSet(int n) {
        super(n);
        if (this.getClass() == (class$jv$geom$PgBndElementSet == null ? (class$jv$geom$PgBndElementSet = PgBndElementSet.class$("jv.geom.PgBndElementSet")) : class$jv$geom$PgBndElementSet)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.clearTag(2);
        this.m_bndConstraint = null;
    }

    public Object clone() {
        PgBndElementSet pgBndElementSet = (PgBndElementSet)super.clone();
        if (pgBndElementSet == null) {
            return null;
        }
        pgBndElementSet.m_geom = null;
        if (this.m_vertexInd != null) {
            pgBndElementSet.m_vertexInd = (PiVector)this.m_vertexInd.clone();
        }
        if (this.m_tetraInd != null) {
            pgBndElementSet.m_tetraInd = (PiVector)this.m_tetraInd.clone();
        }
        if (this.m_neighbourLocInd != null) {
            pgBndElementSet.m_neighbourLocInd = (PiVector)this.m_neighbourLocInd.clone();
        }
        if (this.m_bndConstraint != null) {
            pgBndElementSet.m_bndConstraint = (PgBndConstraint)this.m_bndConstraint.clone();
        }
        return pgBndElementSet;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PgBndElementSet)) {
            return;
        }
        PgBndElementSet pgBndElementSet = (PgBndElementSet)psObject;
        this.m_vertexInd.copy(0, pgBndElementSet.getVertexInd(), 0, this.m_numVertices);
        this.m_tetraInd.copy(0, pgBndElementSet.getTetraInd(), 0, this.m_numElements);
        this.m_tetraInd.copy(0, pgBndElementSet.getTetraInd(), 0, this.m_numElements);
        PgBndConstraint pgBndConstraint = pgBndElementSet.getBndConstraint();
        if (pgBndConstraint != null) {
            if (this.m_bndConstraint == null) {
                this.m_bndConstraint = new PgBndConstraint(pgBndConstraint.getDim());
            }
            this.m_bndConstraint.copy(pgBndConstraint);
        } else {
            this.m_bndConstraint = null;
        }
        this.assignVertices();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgBndElementSet *********\n");
        stringBuffer.append("\t ******* m_vertexInd *******\n");
        if (this.m_vertexInd == null) {
            stringBuffer.append("\t m_vertexInd = null\n");
        } else {
            stringBuffer.append("\t m_vertexInd" + this.m_vertexInd.toShortString());
        }
        stringBuffer.append("\t ******* m_tetraInd *******\n");
        if (this.m_tetraInd == null) {
            stringBuffer.append("\t m_tetraInd = null\n");
        } else {
            stringBuffer.append("\t m_tetraInd = " + this.m_tetraInd.toShortString());
        }
        stringBuffer.append("\t ******* m_neighbourLocInd *******\n");
        if (this.m_neighbourLocInd == null) {
            stringBuffer.append("\t m_neighbourLocInd = null\n");
        } else {
            stringBuffer.append("\t m_neighbourLocInd = " + this.m_neighbourLocInd.toShortString());
        }
        stringBuffer.append("\t ******* m_bndConstraint *******\n");
        if (this.m_bndConstraint == null) {
            stringBuffer.append("\t m_bndConstraint = null\n");
        } else {
            stringBuffer.append("\t " + this.m_bndConstraint.toString());
        }
        return stringBuffer.toString();
    }

    public boolean applyModelingMatrix() {
        if (this.m_bndConstraint == null) {
            return true;
        }
        if (!this.hasModelMatrix()) {
            return false;
        }
        return this.m_bndConstraint.applyModelingMatrix(this.m_modelMatrix);
    }

    public PgTetraSet getTetraSet() {
        return this.m_geom;
    }

    public PiVector getVertexInd() {
        return this.m_vertexInd;
    }

    public void setVertexInd(PiVector piVector) {
        this.m_vertexInd = piVector;
    }

    public PiVector getTetraInd() {
        return this.m_tetraInd;
    }

    public void setTetraInd(PiVector piVector) {
        this.m_tetraInd = piVector;
    }

    public PiVector getNeighbourLocInd() {
        return this.m_neighbourLocInd;
    }

    public void setNeighbourLocInd(PiVector piVector) {
        this.m_neighbourLocInd = piVector;
    }

    public PgBndConstraint getBndConstraint() {
        return this.m_bndConstraint;
    }

    public void setBndConstraint(PgBndConstraint pgBndConstraint) {
        this.m_bndConstraint = pgBndConstraint;
    }

    public void setTetraSet(PgTetraSet pgTetraSet) {
        this.m_geom = pgTetraSet;
    }

    public void setMaxNumVertices(int n) {
        if (this.m_maxNumVertices == n) {
            return;
        }
        super.setMaxNumVertices(n);
        this.m_vertexInd.setSize(n);
    }

    public void setMaxNumElements(int n) {
        if (this.m_maxNumElements == n) {
            return;
        }
        super.setMaxNumElements(n);
        if (n > 0) {
            this.m_tetraInd.setSize(n);
            this.m_neighbourLocInd.setSize(n);
        }
    }

    public boolean assignVertices() {
        if (this.m_geom == null) {
            PsDebug.warning("missing tetra set");
            return false;
        }
        int n = this.m_geom.getNumVertices();
        for (int i = 0; i < this.m_numVertices; ++i) {
            if (this.m_vertexInd.m_data[i] == -1 || this.m_vertexInd.m_data[i] >= n) {
                this.setTag(2);
                return false;
            }
            this.m_vertex[i].copy(this.m_geom.getVertex(this.m_vertexInd.m_data[i]));
        }
        return true;
    }

    public boolean makeTetraInd() {
        PsDebug.message("dev.volume.PgBndElementSet.makeTetraInd() called - method is not yet implemented.");
        return true;
    }

    public boolean merge(PgBndElementSet pgBndElementSet) {
        if (pgBndElementSet == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        if (this.m_geom != pgBndElementSet.m_geom) {
            PsDebug.warning("bnd's associated to different tetraSets", this);
            return false;
        }
        if (this.m_numElements < 1 || pgBndElementSet.m_numElements < 1) {
            PsDebug.warning("bnd has no elements", this);
            return false;
        }
        int n = this.m_numVertices;
        int n2 = this.m_numElements;
        super.merge(pgBndElementSet);
        this.m_vertexInd.copy(n, pgBndElementSet.m_vertexInd, 0, pgBndElementSet.m_numVertices);
        this.m_tetraInd.copy(n2, pgBndElementSet.m_tetraInd, 0, pgBndElementSet.m_numElements);
        this.m_neighbourLocInd.copy(n2, pgBndElementSet.m_neighbourLocInd, 0, pgBndElementSet.m_numElements);
        return true;
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        double d3;
        if (!super.blend(d, pgGeometry, d2, pgGeometry2)) {
            return false;
        }
        if (!(pgGeometry instanceof PgElementSet)) {
            return false;
        }
        PgBndElementSet pgBndElementSet = (PgBndElementSet)pgGeometry;
        PgBndElementSet pgBndElementSet2 = (PgBndElementSet)pgGeometry2;
        double d4 = Math.abs(d);
        PgBndElementSet pgBndElementSet3 = d4 > (d3 = Math.abs(d2)) ? pgBndElementSet : pgBndElementSet2;
        this.m_vertexInd.copy(pgBndElementSet3.m_vertexInd);
        this.m_tetraInd.copy(pgBndElementSet3.m_tetraInd);
        this.m_neighbourLocInd.copy(pgBndElementSet3.m_neighbourLocInd);
        if (pgBndElementSet.m_bndConstraint == null || pgBndElementSet2.m_bndConstraint != null) {
            // empty if block
        }
        return true;
    }

    public boolean constrain() {
        if (this.m_bndConstraint == null) {
            PsDebug.notify("boundary has no constraint");
            return true;
        }
        if (this.m_geom == null) {
            PsDebug.warning("missing tetra set.");
            return true;
        }
        PdVector pdVector = this.m_bndConstraint.m_start;
        PdVector pdVector2 = this.m_bndConstraint.m_dir;
        PdVector pdVector3 = this.m_bndConstraint.m_vec1;
        PdVector pdVector4 = this.m_bndConstraint.m_vec2;
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        if (this.m_bndConstraint.hasShape(4)) {
            for (int i = 0; i < this.m_numVertices; ++i) {
                PuVectorGeom.projectPointToLine(pdVectorArray[this.m_vertexInd.m_data[i]], pdVectorArray[this.m_vertexInd.m_data[i]], pdVector, pdVector2);
            }
        } else if (this.m_bndConstraint.hasShape(5)) {
            for (int i = 0; i < this.m_numVertices; ++i) {
                PuVectorGeom.projectPointToPlane(pdVectorArray[this.m_vertexInd.m_data[i]], pdVectorArray[this.m_vertexInd.m_data[i]], pdVector, pdVector2);
            }
        } else if (this.m_bndConstraint.hasShape(11)) {
            double d = pdVector3.dist(pdVector);
            for (int i = 0; i < this.m_numVertices; ++i) {
                PuVectorGeom.projectPointToCircle(pdVectorArray[this.m_vertexInd.m_data[i]], pdVectorArray[this.m_vertexInd.m_data[i]], pdVector3, pdVector4, d);
            }
        } else {
            PsDebug.warning("not implemented for this shape");
            return false;
        }
        this.assignVertices();
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

