/*
 * Decompiled with CFR 0.152.
 */
package vgp.volume.mc;

import java.util.Enumeration;
import java.util.Vector;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnFunction;

public class PnMarchingCubes {
    protected int m_dimX = 0;
    protected int m_dimY = 0;
    protected int m_dimZ = 0;
    protected PdVector m_origin;
    protected PdVector m_baseX;
    protected PdVector m_baseY;
    protected PdVector m_baseZ;
    protected PdVector m_data = null;
    protected PnFunction m_function;
    protected boolean m_weighted = true;
    protected boolean m_bufferData = false;
    protected boolean m_orientate = true;
    protected Vector m_vertexArray;
    protected Vector m_elementArray;
    protected double[][] m_dataBuffer1 = null;
    protected double[] m_dataBuffer2 = null;
    protected double m_dataBuffer3;
    protected double m_newValue;
    protected int m_dataBufferX;
    protected int m_dataBufferY;
    protected int m_dataBufferZ;
    protected double[] m_value;
    protected PdVector[] m_coords;
    protected PdVector m_tmp;
    protected PdVector m_tmp2;
    protected PdVector m_tmp3;

    public void setVectorGrid(PdVector pdVector, PdVector pdVector2, int n, int n2, int n3) {
        PdVector pdVector3 = new PdVector(3);
        pdVector3.set((pdVector2.m_data[0] - pdVector.m_data[0]) / (double)(n - 1), 0.0, 0.0);
        PdVector pdVector4 = new PdVector(3);
        pdVector4.set(0.0, (pdVector2.m_data[1] - pdVector.m_data[1]) / (double)(n2 - 1), 0.0);
        PdVector pdVector5 = new PdVector(3);
        pdVector5.set(0.0, 0.0, (pdVector2.m_data[2] - pdVector.m_data[2]) / (double)(n3 - 1));
        this.setVectorGrid(n, n2, n3, pdVector, pdVector3, pdVector4, pdVector5);
    }

    public void setVectorGrid(int n, int n2, int n3, PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4) {
        this.m_dimX = n;
        this.m_dimY = n2;
        this.m_dimZ = n3;
        this.m_origin = PdVector.copyNew((PdVector)pdVector);
        this.m_baseX = PdVector.copyNew((PdVector)pdVector2);
        this.m_baseY = PdVector.copyNew((PdVector)pdVector3);
        this.m_baseZ = PdVector.copyNew((PdVector)pdVector4);
        this.m_data = null;
    }

    public void setData(PdVector pdVector) {
        if (pdVector.getSize() != this.m_dimX * this.m_dimY * this.m_dimZ) {
            PsDebug.warning((String)("data vector of length " + this.m_dimX * this.m_dimY * this.m_dimZ + " expected"));
            return;
        }
        this.m_data = pdVector;
        this.m_function = null;
        this.m_bufferData = false;
    }

    public void setFunction(PnFunction pnFunction, boolean bl) {
        this.m_function = pnFunction;
        this.m_data = null;
        this.m_bufferData = bl;
    }

    public void setWeighted(boolean bl) {
        this.m_weighted = bl;
    }

    public boolean getWeighted() {
        return this.m_weighted;
    }

    public void setOrientate(boolean bl) {
        this.m_orientate = bl;
    }

    public boolean getOrientate() {
        return this.m_orientate;
    }

    public PgElementSet startAlgorithm(double d) {
        int n;
        int n2;
        int n3;
        if (this.m_data == null && this.m_function == null) {
            PsDebug.warning((String)"data not set");
            return null;
        }
        if (this.m_origin == null || this.m_baseX == null || this.m_baseY == null || this.m_baseZ == null) {
            PsDebug.warning((String)"vector grid not set");
            return null;
        }
        if (this.m_data != null && this.m_data.getSize() != this.m_dimX * this.m_dimY * this.m_dimZ) {
            PsDebug.warning((String)"wrong dimension of data");
            return null;
        }
        if (this.m_bufferData && this.m_function == null) {
            PsDebug.warning((String)"no function set, data buffering will be disabled");
            this.m_bufferData = false;
        }
        PiVector[] piVectorArray = new PiVector[4];
        for (n3 = 0; n3 < 4; ++n3) {
            piVectorArray[n3] = new PiVector(3);
        }
        this.m_value = new double[4];
        this.m_coords = new PdVector[4];
        for (n3 = 0; n3 < 4; ++n3) {
            this.m_coords[n3] = new PdVector(3);
        }
        this.m_tmp = new PdVector(3);
        this.m_tmp2 = new PdVector(3);
        this.m_tmp3 = new PdVector(3);
        this.m_vertexArray = new Vector();
        this.m_elementArray = new Vector();
        if (this.m_bufferData) {
            this.m_dataBuffer1 = new double[this.m_dimX][this.m_dimY];
            this.m_dataBuffer2 = new double[this.m_dimX];
            for (n3 = 0; n3 < this.m_dimX; ++n3) {
                for (n2 = 0; n2 < this.m_dimY; ++n2) {
                    this.m_dataBuffer1[n3][n2] = this.getValue(n3, n2, 0);
                }
            }
        }
        for (n3 = 0; n3 < this.m_dimZ - 1; ++n3) {
            if (this.m_bufferData) {
                for (n2 = 0; n2 < this.m_dimX; ++n2) {
                    this.m_dataBuffer2[n2] = this.getValue(n2, 0, n3 + 1);
                }
                this.m_dataBufferZ = n3;
            }
            for (n2 = 0; n2 < this.m_dimY - 1; ++n2) {
                if (this.m_bufferData) {
                    this.m_dataBuffer3 = this.getValue(0, n2 + 1, n3 + 1);
                    this.m_dataBufferY = n2;
                }
                for (int i = 0; i < this.m_dimX - 1; ++i) {
                    if (this.m_bufferData) {
                        this.m_newValue = this.getValue(i + 1, n2 + 1, n3 + 1);
                        this.m_dataBufferX = i;
                    }
                    piVectorArray[0].m_data[0] = i + 1;
                    piVectorArray[0].m_data[1] = n2;
                    piVectorArray[0].m_data[2] = n3;
                    piVectorArray[1].m_data[0] = i;
                    piVectorArray[1].m_data[1] = n2 + 1;
                    piVectorArray[1].m_data[2] = n3 + 1;
                    piVectorArray[2].m_data[0] = i;
                    piVectorArray[2].m_data[1] = n2;
                    piVectorArray[2].m_data[2] = n3;
                    piVectorArray[3].m_data[0] = i;
                    piVectorArray[3].m_data[1] = n2 + 1;
                    piVectorArray[3].m_data[2] = n3;
                    this.handleTetra(piVectorArray, d);
                    piVectorArray[0].m_data[0] = i + 1;
                    piVectorArray[0].m_data[1] = n2;
                    piVectorArray[0].m_data[2] = n3;
                    piVectorArray[1].m_data[0] = i;
                    piVectorArray[1].m_data[1] = n2 + 1;
                    piVectorArray[1].m_data[2] = n3 + 1;
                    piVectorArray[2].m_data[0] = i;
                    piVectorArray[2].m_data[1] = n2 + 1;
                    piVectorArray[2].m_data[2] = n3;
                    piVectorArray[3].m_data[0] = i + 1;
                    piVectorArray[3].m_data[1] = n2 + 1;
                    piVectorArray[3].m_data[2] = n3;
                    this.handleTetra(piVectorArray, d);
                    piVectorArray[0].m_data[0] = i + 1;
                    piVectorArray[0].m_data[1] = n2;
                    piVectorArray[0].m_data[2] = n3;
                    piVectorArray[1].m_data[0] = i;
                    piVectorArray[1].m_data[1] = n2 + 1;
                    piVectorArray[1].m_data[2] = n3 + 1;
                    piVectorArray[2].m_data[0] = i + 1;
                    piVectorArray[2].m_data[1] = n2 + 1;
                    piVectorArray[2].m_data[2] = n3;
                    piVectorArray[3].m_data[0] = i + 1;
                    piVectorArray[3].m_data[1] = n2 + 1;
                    piVectorArray[3].m_data[2] = n3 + 1;
                    this.handleTetra(piVectorArray, d);
                    piVectorArray[0].m_data[0] = i + 1;
                    piVectorArray[0].m_data[1] = n2;
                    piVectorArray[0].m_data[2] = n3;
                    piVectorArray[1].m_data[0] = i;
                    piVectorArray[1].m_data[1] = n2 + 1;
                    piVectorArray[1].m_data[2] = n3 + 1;
                    piVectorArray[2].m_data[0] = i + 1;
                    piVectorArray[2].m_data[1] = n2 + 1;
                    piVectorArray[2].m_data[2] = n3 + 1;
                    piVectorArray[3].m_data[0] = i + 1;
                    piVectorArray[3].m_data[1] = n2;
                    piVectorArray[3].m_data[2] = n3 + 1;
                    this.handleTetra(piVectorArray, d);
                    piVectorArray[0].m_data[0] = i + 1;
                    piVectorArray[0].m_data[1] = n2;
                    piVectorArray[0].m_data[2] = n3;
                    piVectorArray[1].m_data[0] = i;
                    piVectorArray[1].m_data[1] = n2 + 1;
                    piVectorArray[1].m_data[2] = n3 + 1;
                    piVectorArray[2].m_data[0] = i + 1;
                    piVectorArray[2].m_data[1] = n2;
                    piVectorArray[2].m_data[2] = n3 + 1;
                    piVectorArray[3].m_data[0] = i;
                    piVectorArray[3].m_data[1] = n2;
                    piVectorArray[3].m_data[2] = n3 + 1;
                    this.handleTetra(piVectorArray, d);
                    piVectorArray[0].m_data[0] = i + 1;
                    piVectorArray[0].m_data[1] = n2;
                    piVectorArray[0].m_data[2] = n3;
                    piVectorArray[1].m_data[0] = i;
                    piVectorArray[1].m_data[1] = n2 + 1;
                    piVectorArray[1].m_data[2] = n3 + 1;
                    piVectorArray[2].m_data[0] = i;
                    piVectorArray[2].m_data[1] = n2;
                    piVectorArray[2].m_data[2] = n3 + 1;
                    piVectorArray[3].m_data[0] = i;
                    piVectorArray[3].m_data[1] = n2;
                    piVectorArray[3].m_data[2] = n3;
                    this.handleTetra(piVectorArray, d);
                    if (!this.m_bufferData) continue;
                    this.m_dataBuffer1[i][n2] = this.m_dataBuffer2[i];
                    this.m_dataBuffer2[i] = this.m_dataBuffer3;
                    this.m_dataBuffer3 = this.m_newValue;
                }
                if (!this.m_bufferData) continue;
                this.m_dataBuffer1[this.m_dimX - 1][n2] = this.m_dataBuffer2[this.m_dimX - 1];
                this.m_dataBuffer2[this.m_dimX - 1] = this.m_newValue;
            }
            if (!this.m_bufferData) continue;
            for (n2 = 0; n2 < this.m_dimX; ++n2) {
                this.m_dataBuffer1[n2][this.m_dimY - 1] = this.m_dataBuffer2[n2];
            }
        }
        this.m_dataBuffer1 = null;
        this.m_dataBuffer2 = null;
        this.m_dataBuffer3 = 0.0;
        piVectorArray = null;
        this.m_value = null;
        this.m_coords = null;
        this.m_tmp = null;
        this.m_tmp2 = null;
        PgElementSet pgElementSet = new PgElementSet(3);
        pgElementSet.setName("Isosurface (level " + d + ")");
        n2 = this.m_vertexArray.size();
        Enumeration enumeration = this.m_vertexArray.elements();
        pgElementSet.setNumVertices(n2);
        for (n = 0; n < n2; ++n) {
            pgElementSet.setVertex(n, (PdVector)enumeration.nextElement());
        }
        n = this.m_elementArray.size();
        enumeration = this.m_elementArray.elements();
        pgElementSet.setNumElements(n);
        for (int i = 0; i < n; ++i) {
            pgElementSet.setElement(i, (PiVector)enumeration.nextElement());
        }
        return pgElementSet;
    }

    protected void handleTetra(PiVector[] piVectorArray, double d) {
        Object object;
        int n;
        this.getCoords(piVectorArray, 0, this.m_coords);
        if (this.m_data != null) {
            for (n = 0; n < 4; ++n) {
                object = piVectorArray[n];
                this.m_value[n] = this.m_data.m_data[object.m_data[2] * this.m_dimX * this.m_dimY + object.m_data[1] * this.m_dimX + object.m_data[0]] - d;
            }
        } else if (this.m_function != null) {
            if (this.m_bufferData) {
                for (n = 0; n < 4; ++n) {
                    object = piVectorArray[n].m_data;
                    this.m_value[n] = object[2] == this.m_dataBufferZ ? this.m_dataBuffer1[object[0]][object[1]] - d : (object[1] == this.m_dataBufferY ? this.m_dataBuffer2[object[0]] - d : (object[0] == this.m_dataBufferX ? this.m_dataBuffer3 - d : this.m_newValue - d));
                }
            } else {
                for (n = 0; n < 4; ++n) {
                    this.m_value[n] = this.m_function.eval(this.m_coords[n]) - d;
                }
            }
        } else {
            PsDebug.warning((String)"No data array or function set.");
            return;
        }
        n = (this.m_value[0] >= 0.0 ? 1 : 0) + (this.m_value[1] >= 0.0 ? 1 : 0) + (this.m_value[2] >= 0.0 ? 1 : 0) + (this.m_value[3] >= 0.0 ? 1 : 0);
        int n2 = 0;
        switch (n) {
            case 0: {
                return;
            }
            case 1: {
                n2 = 0;
                while (!(this.m_value[n2] >= 0.0)) {
                    ++n2;
                }
                this.handleTetra1(this.m_coords, n2);
                break;
            }
            case 2: {
                n2 = 0;
                while (!(this.m_value[n2] >= 0.0)) {
                    ++n2;
                }
                int n3 = n2++;
                while (!(this.m_value[n2] >= 0.0)) {
                    ++n2;
                }
                int n4 = n2;
                this.handleTetra2(this.m_coords, n3, n4);
                break;
            }
            case 3: {
                n2 = 0;
                while (this.m_value[n2] >= 0.0) {
                    ++n2;
                }
                this.handleTetra1(this.m_coords, n2);
                break;
            }
            case 4: {
                return;
            }
            default: {
                PsDebug.error((String)"internal error");
                return;
            }
        }
    }

    protected void handleTetra1(PdVector[] pdVectorArray, int n) {
        int n2;
        for (n2 = 0; n2 == n; ++n2) {
        }
        int n3 = n2++;
        while (n2 == n) {
            ++n2;
        }
        int n4 = n2++;
        while (n2 == n) {
            ++n2;
        }
        int n5 = n2;
        double d = 0.5;
        double d2 = 0.5;
        double d3 = 0.5;
        if (this.m_weighted) {
            d = this.m_value[n3] / (this.m_value[n3] - this.m_value[n]);
            d2 = this.m_value[n4] / (this.m_value[n4] - this.m_value[n]);
            d3 = this.m_value[n5] / (this.m_value[n5] - this.m_value[n]);
        }
        PdVector pdVector = PdVector.blendNew((double)d, (PdVector)pdVectorArray[n], (double)(1.0 - d), (PdVector)pdVectorArray[n3]);
        int n6 = this.m_vertexArray.size();
        this.m_vertexArray.addElement(pdVector);
        pdVector = PdVector.blendNew((double)d2, (PdVector)pdVectorArray[n], (double)(1.0 - d2), (PdVector)pdVectorArray[n4]);
        int n7 = this.m_vertexArray.size();
        this.m_vertexArray.addElement(pdVector);
        pdVector = PdVector.blendNew((double)d3, (PdVector)pdVectorArray[n], (double)(1.0 - d3), (PdVector)pdVectorArray[n5]);
        int n8 = this.m_vertexArray.size();
        this.m_vertexArray.addElement(pdVector);
        boolean bl = false;
        if (this.m_orientate) {
            this.m_tmp.sub(pdVectorArray[n4], pdVectorArray[n3]);
            this.m_tmp2.sub(pdVectorArray[n5], pdVectorArray[n3]);
            this.m_tmp3.cross(this.m_tmp, this.m_tmp2);
            this.m_tmp.sub(pdVectorArray[n], pdVectorArray[n3]);
            boolean bl2 = this.m_tmp.dot(this.m_tmp3) >= 0.0;
            boolean bl3 = bl = bl2 != this.m_value[n] >= 0.0;
        }
        if (!bl) {
            this.m_elementArray.addElement(new PiVector(n6, n7, n8));
        } else {
            this.m_elementArray.addElement(new PiVector(n6, n8, n7));
        }
    }

    protected void handleTetra2(PdVector[] pdVectorArray, int n, int n2) {
        int n3;
        for (n3 = 0; n3 == n || n3 == n2; ++n3) {
        }
        int n4 = n3++;
        while (n3 == n || n3 == n2) {
            ++n3;
        }
        int n5 = n3;
        double d = 0.5;
        double d2 = 0.5;
        double d3 = 0.5;
        double d4 = 0.5;
        if (this.m_weighted) {
            d = this.m_value[n] / (this.m_value[n] - this.m_value[n4]);
            d2 = this.m_value[n2] / (this.m_value[n2] - this.m_value[n4]);
            d3 = this.m_value[n] / (this.m_value[n] - this.m_value[n5]);
            d4 = this.m_value[n2] / (this.m_value[n2] - this.m_value[n5]);
        }
        PdVector pdVector = PdVector.blendNew((double)d, (PdVector)pdVectorArray[n4], (double)(1.0 - d), (PdVector)pdVectorArray[n]);
        int n6 = this.m_vertexArray.size();
        this.m_vertexArray.addElement(pdVector);
        pdVector = PdVector.blendNew((double)d2, (PdVector)pdVectorArray[n4], (double)(1.0 - d2), (PdVector)pdVectorArray[n2]);
        int n7 = this.m_vertexArray.size();
        this.m_vertexArray.addElement(pdVector);
        pdVector = PdVector.blendNew((double)d3, (PdVector)pdVectorArray[n5], (double)(1.0 - d3), (PdVector)pdVectorArray[n]);
        int n8 = this.m_vertexArray.size();
        this.m_vertexArray.addElement(pdVector);
        pdVector = PdVector.blendNew((double)d4, (PdVector)pdVectorArray[n5], (double)(1.0 - d4), (PdVector)pdVectorArray[n2]);
        int n9 = this.m_vertexArray.size();
        this.m_vertexArray.addElement(pdVector);
        boolean bl = false;
        if (this.m_orientate) {
            this.m_tmp.sub(pdVectorArray[n5], pdVectorArray[n4]);
            this.m_tmp2.sub(pdVectorArray[n2], pdVectorArray[n]);
            this.m_tmp3.cross(this.m_tmp, this.m_tmp2);
            this.m_tmp.sub(pdVectorArray[n], pdVectorArray[n4]);
            boolean bl2 = this.m_tmp.dot(this.m_tmp3) >= 0.0;
            boolean bl3 = bl = bl2 != this.m_value[n] >= 0.0;
        }
        if (!bl) {
            this.m_elementArray.addElement(new PiVector(n6, n8, n7));
            this.m_elementArray.addElement(new PiVector(n7, n8, n9));
        } else {
            this.m_elementArray.addElement(new PiVector(n6, n7, n8));
            this.m_elementArray.addElement(new PiVector(n7, n9, n8));
        }
    }

    protected void getCoords(PiVector[] piVectorArray, int n, PdVector[] pdVectorArray) {
        for (int i = 0; i < 4; ++i) {
            pdVectorArray[i].blendBase(this.m_origin, (double)piVectorArray[n + i].m_data[0], this.m_baseX);
            pdVectorArray[i].blendBase(pdVectorArray[i], (double)piVectorArray[n + i].m_data[1], this.m_baseY);
            pdVectorArray[i].blendBase(pdVectorArray[i], (double)piVectorArray[n + i].m_data[2], this.m_baseZ);
        }
    }

    protected double getValue(int n, int n2, int n3) {
        this.m_tmp2.blendBase(this.m_origin, (double)n, this.m_baseX);
        this.m_tmp2.blendBase(this.m_tmp2, (double)n2, this.m_baseY);
        this.m_tmp2.blendBase(this.m_tmp2, (double)n3, this.m_baseZ);
        return this.m_function.eval(this.m_tmp2);
    }
}

