/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.sizeEdge;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.vecmath.PdVector;

public class PjSizeEdge
extends PjProject
implements Runnable {
    public static final int COLOR_SIZE = 0;
    public static final int COLOR_INDEX = 1;
    protected PgElementSet m_geom = new PgElementSet(3);
    protected PdVector m_delSize;
    protected transient Thread m_thread;
    protected PuDouble m_speed;
    protected PuDouble m_size;
    protected boolean m_bShowEdgeColors;
    protected boolean m_bShowEdgeLabels;
    protected boolean m_bShowEdgeSizes;
    protected int m_colorType;
    protected boolean m_bIsUpdateSender = false;
    static /* synthetic */ Class class$vgp$tutor$sizeEdge$PjSizeEdge;

    public PjSizeEdge() {
        super("Size of Element Edges Demo");
        this.m_geom.setParent((PsUpdateIf)this);
        this.m_delSize = new PdVector();
        this.m_size = new PuDouble(PsConfig.getMessage((boolean)true, (int)84000, (String)"Edge Size"), (PsUpdateIf)this);
        this.m_speed = new PuDouble(PsConfig.getMessage((boolean)true, (int)84000, (String)"Speed of Change"), (PsUpdateIf)this);
        if (this.getClass() == (class$vgp$tutor$sizeEdge$PjSizeEdge == null ? (class$vgp$tutor$sizeEdge$PjSizeEdge = PjSizeEdge.class$("vgp.tutor.sizeEdge.PjSizeEdge")) : class$vgp$tutor$sizeEdge$PjSizeEdge)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_colorType = 1;
        this.m_bShowEdgeColors = true;
        this.m_bShowEdgeLabels = false;
        this.m_bShowEdgeSizes = true;
        this.m_geom.computeTorus(10, 10, 2.0, 1.0);
        this.m_geom.setEnabledEdges(true);
        this.m_geom.makeEdgeStars();
        this.m_geom.setGlobalEdgeSize(8.0);
        this.m_geom.showVertices(false);
        this.m_geom.showEdgeColors(this.m_bShowEdgeColors);
        this.m_geom.showEdgeLabels(this.m_bShowEdgeLabels);
        this.m_geom.showEdgeSizes(this.m_bShowEdgeSizes);
        this.m_size.setDefBounds(0.0, 20.0, 1.0, 2.0);
        this.m_size.setDefValue(this.m_geom.getGlobalEdgeSize());
        this.m_size.init();
        this.m_speed.setDefBounds(0.0, 1.5, 0.05, 0.1);
        this.m_speed.setDefValue(1.0);
        this.m_speed.init();
    }

    public void start() {
        this.compute();
        this.m_geom.update((Object)this.m_geom);
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.selectGeometry((PgGeometryIf)this.m_geom);
        super.start();
    }

    public void compute() {
        this.computeEdgeSizes();
        this.computeEdgeColors();
    }

    private void computeEdgeSizes() {
        int n = this.m_geom.getNumEdgeStars();
        this.m_delSize.setSize(n);
        for (int i = 0; i < n; ++i) {
            if (Math.random() > 0.5) {
                this.m_delSize.setEntry(i, 1.0);
                continue;
            }
            this.m_delSize.setEntry(i, -1.0);
        }
        this.m_geom.assureEdgeSizes();
        PdVector pdVector = this.m_geom.getEdgeSizes();
        for (int i = 0; i < n; ++i) {
            pdVector.setEntry(i, Math.random());
        }
    }

    private void computeEdgeColors() {
        this.m_geom.assureEdgeColors();
        Color[] colorArray = this.m_geom.getEdgeColors();
        PdVector pdVector = this.m_geom.getEdgeSizes();
        int n = this.m_geom.getNumEdgeStars();
        for (int i = 0; i < n; ++i) {
            float f = (float)pdVector.getEntry(i);
            if (this.m_colorType == 1) {
                f = (float)i / ((float)n - 1.0f);
            }
            colorArray[i] = new Color(Color.HSBtoRGB(0.83333f * (1.0f - f), 1.0f, 1.0f));
        }
    }

    public void changeEdgeSize(double d) {
        d /= 20.0;
        this.m_geom.assureEdgeSizes();
        PdVector pdVector = this.m_geom.getEdgeSizes();
        int n = this.m_geom.getNumEdgeStars();
        for (int i = 0; i < n; ++i) {
            double d2 = pdVector.getEntry(i);
            double d3 = this.m_delSize.getEntry(i) * d;
            if (d3 > 0.0 && d2 + d3 > 1.0 || d3 < 0.0 && d2 + d3 < 0.0) {
                d3 = -d3;
                this.m_delSize.setEntry(i, -this.m_delSize.getEntry(i));
            }
            pdVector.setEntry(i, d2 + d3);
        }
        this.computeEdgeColors();
    }

    public void showEdgeColors(boolean bl) {
        this.m_bShowEdgeColors = bl;
        this.m_geom.showEdgeColors(bl);
    }

    public void showEdgeSizes(boolean bl) {
        this.m_bShowEdgeSizes = bl;
        this.m_geom.showEdgeSizes(bl);
    }

    public void showEdgeLabels(boolean bl) {
        this.m_bShowEdgeLabels = bl;
        this.m_geom.showEdgeLabels(bl);
    }

    public void setColorType(int n) {
        this.m_colorType = n;
        this.computeEdgeColors();
    }

    public boolean update(Object object) {
        if (this.m_bIsUpdateSender) {
            return true;
        }
        if (object == this) {
            this.m_geom.showEdgeColors(this.m_bShowEdgeColors);
            this.m_geom.showEdgeLabels(this.m_bShowEdgeLabels);
            this.m_geom.showEdgeSizes(this.m_bShowEdgeSizes);
            this.m_bIsUpdateSender = true;
            this.m_geom.update((Object)this.m_geom);
            this.m_bIsUpdateSender = false;
            return true;
        }
        if (object == this.m_geom) {
            return this.update(this);
        }
        if (object == this.m_size) {
            this.m_geom.setGlobalEdgeSize(this.m_size.getValue());
            return this.update(this);
        }
        if (object == this.m_speed) {
            return this.update(this);
        }
        return super.update(object);
    }

    public void startAnim() {
        if (this.m_thread != null) {
            return;
        }
        this.m_thread = new Thread((Runnable)this, PsConfig.getProgram() + ": SizeEdges");
        this.m_thread.setPriority(5);
        this.m_thread.start();
    }

    public void stopAnim() {
        this.m_thread = null;
    }

    public void run() {
        while (this.m_thread != null) {
            this.changeEdgeSize(this.m_speed.getValue());
            this.m_geom.update((Object)this.m_geom);
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

