/*
 * Decompiled with CFR 0.152.
 */
package vgp.surface.kaleidoCycle;

import java.awt.Color;
import jv.anim.PsAnimation;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.geom.PgElementSet;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PjKaleidoCycle
extends PjProject {
    protected PgElementSet m_geom = new PgElementSet(3);
    protected PuInteger m_symmetry;
    protected PuDouble m_scale;
    protected PuDouble m_edgeLength1;
    protected PuDouble m_edgeLength2;
    protected PuDouble m_offset1;
    protected PuDouble m_offset2;
    protected PuDouble m_angle;
    static /* synthetic */ Class class$vgp$surface$kaleidoCycle$PjKaleidoCycle;

    public PjKaleidoCycle() {
        super("KaleidoCycle");
        this.m_geom.setName("KaleidoCycle");
        PsAnimation psAnimation = new PsAnimation();
        psAnimation.setName("KaleidoCycle");
        psAnimation.addTimeListener((PsTimeListenerIf)this);
        this.m_symmetry = new PuInteger("Symmetry", (PsUpdateIf)this);
        this.m_scale = new PuDouble("Scale", (PsUpdateIf)this);
        this.m_edgeLength1 = new PuDouble("Edge Length 1", (PsUpdateIf)this);
        this.m_edgeLength2 = new PuDouble("Edge Length 2", (PsUpdateIf)this);
        this.m_offset1 = new PuDouble("Edge Offset 1", (PsUpdateIf)this);
        this.m_offset2 = new PuDouble("Edge Offset 2", (PsUpdateIf)this);
        this.m_angle = new PuDouble("angle", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$surface$kaleidoCycle$PjKaleidoCycle == null ? (class$vgp$surface$kaleidoCycle$PjKaleidoCycle = PjKaleidoCycle.class$("vgp.surface.kaleidoCycle.PjKaleidoCycle")) : class$vgp$surface$kaleidoCycle$PjKaleidoCycle)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_symmetry.setDefBounds(3, 20, 1, 5);
        this.m_symmetry.setDefValue(3);
        this.m_symmetry.init();
        this.m_scale.setDefBounds(0.1, 10.0, 0.1, 1.0);
        this.m_scale.setDefValue(1.5);
        this.m_scale.init();
        this.m_edgeLength1.setDefBounds(0.1, 1.0, 0.01, 0.1);
        this.m_edgeLength1.setDefValue(0.75);
        this.m_edgeLength1.init();
        this.m_edgeLength2.setDefBounds(0.1, 1.0, 0.01, 0.1);
        this.m_edgeLength2.setDefValue(0.75);
        this.m_edgeLength2.init();
        this.m_offset1.setDefBounds(-1.0, 1.0, 0.01, 0.1);
        this.m_offset1.setDefValue(0.0);
        this.m_offset1.init();
        this.m_offset2.setDefBounds(-1.0, 1.0, 0.01, 0.1);
        this.m_offset2.setDefValue(0.0);
        this.m_offset2.init();
        this.m_angle.setDefBounds(0.0, 360.0, 2.0, 12.0);
        this.m_angle.setDefValue(0.0);
        this.m_angle.init();
        this.m_geom.showElementColors(true);
    }

    public void start() {
        this.computeConnectivity(this.m_symmetry.getValue());
        this.computeAnimation(this.m_angle.getValue());
        this.m_geom.update((Object)this.m_geom);
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.selectGeometry((PgGeometryIf)this.m_geom);
        if (super.hasAnimation()) {
            PsAnimation psAnimation = super.getAnimation();
            psAnimation.setTimeInterval(0.0, 360.0, 2.0, 12.0);
            psAnimation.setRepeat(1);
            psAnimation.start();
        }
        if (this.m_anim != null && this.m_anim.hasAnimationPanel()) {
            this.m_anim.getAnimationPanel().setVisible(false);
        }
        super.start();
    }

    public void reset() {
        this.init();
        this.start();
    }

    public boolean setTime(PsTimeEvent psTimeEvent) {
        double d = psTimeEvent.getTime();
        this.computeAnimation(d);
        this.m_geom.update((Object)this.m_geom);
        return super.update((Object)this);
    }

    public boolean update(Object object) {
        if (object == this.getInfoPanel()) {
            this.m_geom.update((Object)this.m_geom);
            return super.update((Object)this);
        }
        if (object == this.m_symmetry) {
            this.computeConnectivity(this.m_symmetry.getValue());
            this.computeAnimation(this.m_angle.getValue());
            this.m_geom.update((Object)this.m_geom);
            this.fitDisplays();
            return super.update((Object)this);
        }
        if (object == this.m_scale || object == this.m_edgeLength1 || object == this.m_edgeLength2 || object == this.m_offset1 || object == this.m_offset2) {
            this.computeAnimation(this.m_angle.getValue());
            this.m_geom.update((Object)this.m_geom);
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public void computeConnectivity(int n) {
        int n2 = n * 4;
        this.m_geom.setNumVertices(n2);
        this.m_geom.setNumElements(n * 8);
        this.m_geom.assureElementColors();
        for (int i = 0; i < n; ++i) {
            this.m_geom.setElement(8 * i + 0, new PiVector((4 * i + 0) % n2, (4 * i + 2) % n2, (4 * i + 1) % n2));
            this.m_geom.setElement(8 * i + 1, new PiVector((4 * i + 2) % n2, (4 * i + 3) % n2, (4 * i + 1) % n2));
            this.m_geom.setElement(8 * i + 2, new PiVector((4 * i + 1) % n2, (4 * i + 3) % n2, (4 * i + 0) % n2));
            this.m_geom.setElement(8 * i + 3, new PiVector((4 * i + 3) % n2, (4 * i + 2) % n2, (4 * i + 0) % n2));
            this.m_geom.setElement(8 * i + 4, new PiVector((4 * i + 2) % n2, (4 * i + 4) % n2, (4 * i + 3) % n2));
            this.m_geom.setElement(8 * i + 5, new PiVector((4 * i + 4) % n2, (4 * i + 5) % n2, (4 * i + 3) % n2));
            this.m_geom.setElement(8 * i + 6, new PiVector((4 * i + 3) % n2, (4 * i + 5) % n2, (4 * i + 2) % n2));
            this.m_geom.setElement(8 * i + 7, new PiVector((4 * i + 5) % n2, (4 * i + 4) % n2, (4 * i + 2) % n2));
            this.m_geom.setElementColor(8 * i + 0, new Color(255, 127, 0));
            this.m_geom.setElementColor(8 * i + 1, new Color(0, 127, 0));
            this.m_geom.setElementColor(8 * i + 2, new Color(127, 127, 225));
            this.m_geom.setElementColor(8 * i + 3, new Color(255, 0, 63));
            this.m_geom.setElementColor(8 * i + 4, new Color(191, 63, 255));
            this.m_geom.setElementColor(8 * i + 5, new Color(63, 63, 191));
            this.m_geom.setElementColor(8 * i + 6, new Color(127, 255, 159));
            this.m_geom.setElementColor(8 * i + 7, new Color(255, 255, 0));
        }
        this.m_geom.makeNeighbour();
    }

    public void computeAnimation(double d) {
        int n = this.m_symmetry.getValue();
        this.m_angle.setValue(d);
        double d2 = Math.PI * d / 180.0;
        double d3 = this.m_edgeLength1.getValue();
        double d4 = this.m_edgeLength2.getValue();
        double d5 = this.m_offset1.getValue();
        double d6 = this.m_offset2.getValue();
        double d7 = this.m_scale.getValue();
        double d8 = Math.tan(Math.PI / (double)n);
        PdVector pdVector = new PdVector(-d8 * Math.sin(d2) * Math.sin(d2), 1.0, d8 * Math.cos(d2) * Math.sin(d2));
        pdVector.multScalar(1.0 / Math.sqrt(1.0 + d8 * d8 * Math.sin(d2) * Math.sin(d2)));
        PdVector pdVector2 = new PdVector(pdVector.m_data[1] / d8 - pdVector.m_data[0], 0.0, -pdVector.m_data[2] / 2.0);
        pdVector2.multScalar(d7 /= Math.sin(Math.PI * 2 / (double)n));
        PdVector pdVector3 = new PdVector(pdVector.m_data[1] / d8, pdVector.m_data[1], pdVector.m_data[2] / 2.0);
        pdVector3.multScalar(d7);
        PdVector pdVector4 = new PdVector(Math.cos(d2), 0.0, Math.sin(d2));
        PdVector pdVector5 = new PdVector(-Math.sin(d2), -d8 * Math.sin(d2), Math.cos(d2));
        pdVector5.multScalar(1.0 / Math.sqrt(1.0 + d8 * d8 * Math.sin(d2) * Math.sin(d2)));
        this.m_geom.getVertex(0).blendBase(pdVector2, d3 + d5, pdVector4);
        this.m_geom.getVertex(1).blendBase(pdVector2, -d3 + d5, pdVector4);
        this.m_geom.getVertex(2).blendBase(pdVector3, d4 + d6, pdVector5);
        this.m_geom.getVertex(3).blendBase(pdVector3, -d4 + d6, pdVector5);
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j < 4; ++j) {
                PdVector pdVector6 = this.m_geom.getVertex(j);
                double d9 = (double)i * Math.PI * 2.0 / (double)n;
                this.m_geom.getVertex(4 * i + j).set(Math.cos(d9) * pdVector6.m_data[0] - Math.sin(d9) * pdVector6.m_data[1], Math.sin(d9) * pdVector6.m_data[0] + Math.cos(d9) * pdVector6.m_data[1], pdVector6.m_data[2]);
            }
        }
        this.m_geom.makeVertexNormals();
        this.m_geom.makeElementNormals();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

