/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PiVector;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PgWeierstrass_ChenGackstatter
extends PgWeierstrassDescr {
    private final double m_defaultRadius = 8.0;
    private final double m_defaultRadius1 = 1.2;
    protected PuDouble m_dRadius;
    protected PuDouble m_dRadius1;
    private double m_radius = 8.0;
    private double m_radius1 = 1.2;
    private final double m_const = 1.45896;
    static /* synthetic */ Class class$vgp$minimal$weier$PgWeierstrass_ChenGackstatter;

    public PgWeierstrass_ChenGackstatter() {
        super(2, 3);
        this.setName("Cameloid Surface");
        this.m_dRadius = new PuDouble("Radius", (PsUpdateIf)this);
        this.m_dRadius1 = new PuDouble("Radius", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PgWeierstrass_ChenGackstatter == null ? (class$vgp$minimal$weier$PgWeierstrass_ChenGackstatter = PgWeierstrass_ChenGackstatter.class$("vgp.minimal.weier.PgWeierstrass_ChenGackstatter")) : class$vgp$minimal$weier$PgWeierstrass_ChenGackstatter)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_intDiscr.setDefBounds(1, 1000, 10, 100);
        this.m_intDiscr.setDefValue(1000);
        this.m_intDiscr.init();
        this.addParameter((PsObject)this.m_conjugation);
        this.m_numLines[0].setDefBounds(3, 65, 1, 10);
        this.m_numLines[0].setDefValue(9);
        this.m_numLines[0].init();
        this.addParameter((PsObject)this.m_numLines[0]);
        this.m_numLines[1].setDefBounds(3, 65, 1, 10);
        this.m_numLines[1].setDefValue(9);
        this.m_numLines[1].init();
        this.addParameter((PsObject)this.m_numLines[1]);
        this.m_numLines[2].setDefBounds(3, 65, 1, 10);
        this.m_numLines[2].setDefValue(9);
        this.m_numLines[2].init();
        this.addParameter((PsObject)this.m_numLines[2]);
        this.m_dRadius.setDefBounds(0.2, 10.0, 0.1, 1.0);
        this.m_dRadius.setDefValue(8.0);
        this.m_dRadius.init();
        this.addParameter((PsObject)this.m_dRadius);
        this.m_dRadius1.setDefBounds(0.2, 10.0, 0.1, 1.0);
        this.m_dRadius1.setDefValue(1.2);
        this.m_dRadius1.init();
        this.addParameter((PsObject)this.m_dRadius1);
        this.setDomain(0, 0.0, 1.0 - Math.exp(-8.0), 0.0, 1.5707963267948966);
        this.setDomain(1, 0.0, 1.5707963267948966, 0.0, 1.2);
    }

    public boolean update(Object object) {
        if (object == this.m_dRadius) {
            this.m_radius = 1.0 - Math.exp(-this.m_dRadius.getValue());
            this.setUMax(0, this.m_radius);
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_dRadius1) {
            this.m_radius1 = this.m_dRadius1.getValue();
            this.setVMax(1, this.m_radius1);
            return this.m_parent.update((Object)this);
        }
        return super.update(object);
    }

    public int getNumULines(int n) {
        if (n == 0) {
            return this.m_numLines[1].getValue();
        }
        return this.m_numLines[0].getValue();
    }

    public int getNumVLines(int n) {
        if (n == 0) {
            return this.m_numLines[0].getValue();
        }
        return this.m_numLines[2].getValue();
    }

    public PuComplex transform(int n, PuComplex puComplex) {
        PuComplex puComplex2 = n == 0 ? PuComplex.polarToRect((double)(1.0 - puComplex.re), (double)puComplex.im) : PuComplex.polarToRect((double)Math.exp(puComplex.im), (double)puComplex.re);
        return puComplex2;
    }

    public PuComplex f(PuComplex puComplex) {
        if ((puComplex.re == 1.0 || puComplex.re == -1.0) && puComplex.im == 0.0) {
            return PuComplex.ONE;
        }
        PuComplex puComplex2 = PuComplex.mult((PuComplex)puComplex, (double)1.45896);
        puComplex2 = PuComplex.div((PuComplex)puComplex2, (PuComplex)PuComplex.add((PuComplex)PuComplex.mult((PuComplex)PuComplex.sqr((PuComplex)puComplex), (double)-1.0), (double)1.0));
        puComplex2.sqrt();
        return puComplex2;
    }

    public PuComplex g(PuComplex puComplex) {
        if (puComplex.re == 0.0 && puComplex.im == 0.0) {
            return PuComplex.ONE;
        }
        PuComplex puComplex2 = PuComplex.mult((PuComplex)puComplex, (double)1.45896);
        puComplex2 = PuComplex.div((PuComplex)PuComplex.add((PuComplex)PuComplex.mult((PuComplex)PuComplex.sqr((PuComplex)puComplex), (double)-1.0), (double)1.0), (PuComplex)puComplex2);
        puComplex2.mult(PuComplex.NEG_I);
        puComplex2.sqrt();
        puComplex2.mult(PuComplex.sqrt((PuComplex)PuComplex.I));
        return puComplex2;
    }

    public void getConnections(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            this.connectPart(1, 0, 0, 3);
        }
        if (piVector == null) {
            this.connectPart(6, 0, 7, 0);
            this.connectPart(0, 3, 2, 3);
            this.connectPart(1, 3, 3, 3);
            this.connectPart(4, 3, 6, 3);
            this.connectPart(5, 3, 7, 3);
        }
    }

    public int getNumParts(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            return 2;
        }
        return 8;
    }

    public void getReflections(PiVector piVector) {
        if (piVector == null) {
            this.reflectPart(1, 0, 0);
            this.reflectPart(2, 0, 2);
            this.reflectPart(3, 1, 2);
            this.reflectPart(4, 2, 0);
            this.reflectPart(5, 3, 0);
            this.reflectPart(6, 4, 2);
            this.reflectPart(7, 5, 2);
        }
    }

    public void getBndReflectType(PiVector piVector, int n, PiVector piVector2) {
        if (this.equals(piVector, 0)) {
            if (n == 0) {
                piVector2.m_data[0] = 0;
                piVector2.m_data[2] = 1;
            } else if (n == 1) {
                piVector2.m_data[1] = 0;
                piVector2.m_data[3] = 1;
            }
        }
    }

    public boolean connectReflection(PiVector piVector, int n) {
        return true;
    }

    public boolean partIsSubdivided(PiVector piVector, int n) {
        return piVector == null && n == 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

