/*
 * Decompiled with CFR 0.152.
 */
package vgp.iterate.pythagoreanTree;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.number.PdColor;
import jv.number.PuInteger;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;
import jv.vecmath.PuReflect;

public class PjPythagoreanTree
extends PjProject {
    protected PuInteger m_age;
    private boolean m_bRightTriangle;
    private boolean m_bSquareTrunk;
    private PdVector m_diff;
    private PdMatrix m_left;
    private PdMatrix m_right;
    protected PgElementSet m_trunk = new PgElementSet(2);
    protected PgElementSet m_tree;
    protected PdColor m_colTrunk;
    protected PdColor m_colLeaf;
    static /* synthetic */ Class class$vgp$iterate$pythagoreanTree$PjPythagoreanTree;

    public PjPythagoreanTree() {
        super("Pythagorean Tree");
        this.m_trunk.addUpdateListener((PsUpdateIf)this);
        this.m_tree = new PgElementSet(2);
        this.m_diff = new PdVector(2);
        this.m_left = new PdMatrix(3);
        this.m_right = new PdMatrix(3);
        this.m_colTrunk = new PdColor("Color of Trunk", (PsUpdateIf)this);
        this.m_colLeaf = new PdColor("Color of Leafs", (PsUpdateIf)this);
        this.m_age = new PuInteger("Age of Tree", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$iterate$pythagoreanTree$PjPythagoreanTree == null ? (class$vgp$iterate$pythagoreanTree$PjPythagoreanTree = PjPythagoreanTree.class$("vgp.iterate.pythagoreanTree.PjPythagoreanTree")) : class$vgp$iterate$pythagoreanTree$PjPythagoreanTree)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_bRightTriangle = true;
        this.m_bSquareTrunk = true;
        this.m_colTrunk.setColor(new Color(0.62109375f, 0.07421875f, 0.01953125f));
        this.m_colLeaf.setColor(new Color(0.02734375f, 0.57421875f, 0.140625f));
        this.m_trunk.setName("Pythagorean Tree Trunk");
        this.m_trunk.showVertices(true);
        this.m_trunk.setGlobalElementColor(this.m_colTrunk.getColor());
        this.m_trunk.setNumVertices(5);
        this.m_trunk.setNumElements(2);
        this.m_trunk.setVertex(0, 0.0, 0.0);
        this.m_trunk.setVertex(1, 2.57921, 1.93016);
        this.m_trunk.setVertex(2, 4.0, 0.0);
        this.m_trunk.setVertex(3, 0.0, -4.0);
        this.m_trunk.setVertex(4, 4.0, -4.0);
        this.m_trunk.setElement(0, 0, 1, 2);
        this.m_trunk.setElement(1, 0, 2, 4, 3);
        this.m_tree.setName("Pythagorean Tree");
        this.m_tree.showElementColors(true);
        this.m_age.setDefBounds(1, 15, 1, 2);
        this.m_age.setDefValue(3);
        this.m_age.init();
        this.setAge(this.m_age.getDefValue());
    }

    public void start() {
        this.getDisplay().selectCamera(1);
        this.getDisplay().setMajorMode(5);
        this.m_trunk.update((Object)this.m_trunk);
        this.addGeometry((PgGeometryIf)this.m_tree);
        this.addGeometry((PgGeometryIf)this.m_trunk);
        this.selectGeometry((PgGeometryIf)this.m_trunk);
        super.start();
    }

    public void reset() {
        this.init();
        this.m_trunk.update((Object)this.m_trunk);
    }

    public boolean update(Object object) {
        if (object == this) {
            return super.update((Object)this);
        }
        if (object == this.m_trunk) {
            this.computeMatrices();
            this.computeTreeVertices(this.m_age.getValue());
            this.m_tree.update((Object)this.m_tree);
            return this.update((Object)this);
        }
        if (object == this.m_age) {
            this.setAge(this.m_age.getValue());
            this.m_tree.update((Object)this.m_tree);
            return this.update((Object)this);
        }
        if (object == this.m_colTrunk) {
            this.computeTreeConnectivity(this.m_age.getValue());
            this.m_trunk.setGlobalElementColor(this.m_colTrunk.getColor());
            this.m_trunk.update((Object)this.m_trunk);
            return true;
        }
        if (object == this.m_colLeaf) {
            this.computeTreeConnectivity(this.m_age.getValue());
            this.m_tree.update((Object)this.m_tree);
            return true;
        }
        return super.update(object);
    }

    private void computeMatrices() {
        PdVector[] pdVectorArray = this.m_trunk.getVertices();
        double d = pdVectorArray[4].dist(pdVectorArray[3]);
        double d2 = pdVectorArray[1].dist(pdVectorArray[2]);
        double d3 = pdVectorArray[1].dist(pdVectorArray[0]);
        double d4 = PdVector.angle((PdVector)pdVectorArray[2], (PdVector)pdVectorArray[0], (PdVector)pdVectorArray[1]) / 180.0 * Math.PI;
        if (pdVectorArray[1].m_data[1] > pdVectorArray[0].m_data[1]) {
            d4 *= -1.0;
        }
        this.computeMatrix(this.m_right, pdVectorArray[4], d2 / d, d4, pdVectorArray[2]);
        double d5 = PdVector.angle((PdVector)pdVectorArray[0], (PdVector)pdVectorArray[1], (PdVector)pdVectorArray[2]) / 180.0 * Math.PI;
        if (pdVectorArray[1].m_data[1] < pdVectorArray[0].m_data[1]) {
            d5 *= -1.0;
        }
        this.computeMatrix(this.m_left, pdVectorArray[3], d3 / d, d5, pdVectorArray[0]);
    }

    private void computeMatrix(PdMatrix pdMatrix, PdVector pdVector, double d, double d2, PdVector pdVector2) {
        PdVector pdVector3 = PdVector.copyNew((PdVector)pdVector);
        pdVector3.multScalar(-1.0);
        pdMatrix.copy(PuReflect.translate((PdVector)pdVector3));
        pdMatrix.leftMult(PuReflect.scale((double)d, (int)2));
        pdMatrix.leftMult(PuReflect.rotateXY((double)d2, (int)2));
        pdMatrix.leftMult(PuReflect.translate((PdVector)pdVector2));
    }

    private void computeTreeVertices(int n) {
        int n2;
        this.m_tree.setNumVertices(3 * ((1 << n) - 1));
        PdVector[] pdVectorArray = this.m_tree.getVertices();
        for (n2 = 0; n2 < 3; ++n2) {
            pdVectorArray[n2].copy(this.m_trunk.getVertex(n2));
        }
        for (n2 = 1; n2 < n; ++n2) {
            int n3 = 1 << n2 - 1;
            int n4 = n3 - 1;
            int n5 = 3 * n4;
            int n6 = n5 + (n3 *= 3);
            int n7 = n6 + n3;
            int n8 = 0;
            while (n8 < n3) {
                pdVectorArray[n6].leftMultAffin(this.m_left, pdVectorArray[n5], true);
                pdVectorArray[n7].leftMultAffin(this.m_right, pdVectorArray[n5], true);
                ++n8;
                ++n6;
                ++n7;
                ++n5;
            }
        }
    }

    private void computeTreeConnectivity(int n) {
        int n2 = (1 << n) - 1;
        this.m_tree.setNumElements(2 * n2 - 2);
        for (int i = 1; i < n; ++i) {
            int n3 = 1 << i - 1;
            int n4 = n3 - 1;
            int n5 = 2 * n3 - 1;
            int n6 = 2 * n5 - 2;
            int n7 = 3 * n5;
            Color color = this.m_colTrunk.getColor();
            Color color2 = this.m_colLeaf.getColor();
            float f = (float)i / ((float)n - 1.0f);
            Color color3 = PdColor.blend((double)(1.0f - f), (Color)color, (double)f, (Color)color2);
            f = ((float)i - 0.5f) / ((float)n - 1.0f);
            Color color4 = PdColor.blend((double)(1.0f - f), (Color)color, (double)f, (Color)color2);
            for (int j = 0; j < n3; ++j) {
                int n8 = 3 * n4;
                this.m_tree.setElementColor(n6, color3);
                this.m_tree.setElement(n6++, n7, n7 + 1, n7 + 2);
                this.m_tree.setElementColor(n6, color4);
                this.m_tree.setElement(n6++, n7, n7 + 2, n8 + 1, n8);
                ++n8;
                this.m_tree.setElementColor(n6, color3);
                this.m_tree.setElement(n6++, n7 += 3, n7 + 1, n7 + 2);
                this.m_tree.setElementColor(n6, color4);
                this.m_tree.setElement(n6++, n7, n7 + 2, n8 + 1, n8);
                n7 += 3;
                ++n4;
            }
        }
    }

    public void pickVertex(PgGeometryIf pgGeometryIf, int n, PdVector pdVector) {
        if (pgGeometryIf != this.m_trunk) {
            return;
        }
        if (n != 1) {
            int[] nArray = new int[]{3, 1, 4, 0, 2};
            int[] nArray2 = new int[]{2, 1, 0, 4, 3};
            int[] nArray3 = new int[]{4, 1, 3, 2, 0};
            PdVector[] pdVectorArray = this.m_trunk.getVertices();
            if (this.m_bSquareTrunk) {
                PdVector pdVector2 = PdVector.subNew((PdVector)pdVectorArray[nArray3[n]], (PdVector)pdVectorArray[n]);
                double d = Math.abs(pdVector2.m_data[0]) - Math.abs(pdVector2.m_data[1]);
                pdVector2.m_data[0] = pdVector2.m_data[0] - (double)PuMath.sign((double)pdVector2.m_data[0]) * d / 2.0;
                pdVector2.m_data[1] = pdVector2.m_data[1] + (double)PuMath.sign((double)pdVector2.m_data[1]) * d / 2.0;
                pdVectorArray[n].sub(pdVectorArray[nArray3[n]], pdVector2);
            }
            pdVectorArray[nArray[n]].m_data[0] = pdVectorArray[n].m_data[0];
            pdVectorArray[nArray2[n]].m_data[1] = pdVectorArray[n].m_data[1];
            pdVectorArray[1].blend(0.5, pdVectorArray[0], 0.5, pdVectorArray[2], 1.0, this.m_diff);
        }
        this.assureRightTriangle();
    }

    public int getAge() {
        return this.m_age.getValue();
    }

    public void setAge(int n) {
        if (n < 1) {
            return;
        }
        this.m_age.setValue(n);
        this.computeTreeConnectivity(n);
        this.computeTreeVertices(n);
    }

    private void assureRightTriangle() {
        PdVector[] pdVectorArray = this.m_trunk.getVertices();
        double d = pdVectorArray[0].dist(pdVectorArray[2]) / 2.0;
        PdVector pdVector = PdVector.addNew((PdVector)pdVectorArray[0], (PdVector)pdVectorArray[2]);
        pdVector.multScalar(0.5);
        this.m_diff.sub(pdVectorArray[1], pdVector);
        if (this.m_bRightTriangle) {
            this.m_diff.setLength(d);
            pdVectorArray[1].add(pdVector, this.m_diff);
        }
    }

    public boolean isEnabledRightTriangle() {
        return this.m_bRightTriangle;
    }

    public void setEnabledRightTriangle(boolean bl) {
        this.m_bRightTriangle = bl;
        if (bl) {
            this.assureRightTriangle();
        }
    }

    public boolean isEnabledSquareTrunk() {
        return this.m_bSquareTrunk;
    }

    public void setEnabledSquareTrunk(boolean bl) {
        this.m_bSquareTrunk = bl;
        if (bl) {
            this.pickVertex((PgGeometryIf)this.m_trunk, 0, null);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

