/*
 * Decompiled with CFR 0.152.
 */
package vgp.curve.subdivision;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.geom.PgElementSet;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject_IP;
import vgp.curve.subdivision.PjSubdivisionCurve;

public class PjSubdivisionCurve_IP
extends PjProject_IP
implements ActionListener,
ItemListener {
    protected PjSubdivisionCurve m_pjSubdivCurve;
    protected PsPanel m_pSlider;
    protected PsPanel m_pButtons;
    protected Checkbox m_cReuseTriangleRuns;
    protected Checkbox m_cShowControl;
    protected Checkbox m_cShowSubdivCurve;
    protected Checkbox m_cShowSurface;
    protected Button m_bNewCurve;
    protected Button m_bChangeBaseSurface;
    protected Button m_bPointSetFromDisplay;
    protected Button m_bReset;
    static /* synthetic */ Class class$vgp$curve$subdivision$PjSubdivisionCurve_IP;

    public PjSubdivisionCurve_IP() {
        if (this.getClass() == (class$vgp$curve$subdivision$PjSubdivisionCurve_IP == null ? (class$vgp$curve$subdivision$PjSubdivisionCurve_IP = PjSubdivisionCurve_IP.class$("vgp.curve.subdivision.PjSubdivisionCurve_IP")) : class$vgp$curve$subdivision$PjSubdivisionCurve_IP)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addTitle("");
        this.addNotice(this.getNotice());
        this.m_pSlider = new PsPanel();
        ((Container)((Object)this)).add((Component)this.m_pSlider);
        this.m_pButtons = new PsPanel((LayoutManager)new GridLayout(2, 2));
        this.m_bNewCurve = new Button("New Random Curve");
        this.m_bNewCurve.addActionListener(this);
        this.m_pButtons.add(this.m_bNewCurve);
        this.m_bPointSetFromDisplay = new Button("Points from Display");
        this.m_bPointSetFromDisplay.addActionListener(this);
        this.m_pButtons.add(this.m_bPointSetFromDisplay);
        this.m_cReuseTriangleRuns = new Checkbox("Reuse Triangles");
        this.m_cReuseTriangleRuns.addItemListener(this);
        this.m_pButtons.add(this.m_cReuseTriangleRuns);
        this.m_bChangeBaseSurface = new Button("Surface from Display");
        this.m_bChangeBaseSurface.addActionListener(this);
        this.m_pButtons.add(this.m_bChangeBaseSurface);
        ((Container)((Object)this)).add((Component)this.m_pButtons);
        this.addLine(1);
        this.addSubTitle("Show");
        PsPanel psPanel = new PsPanel((LayoutManager)new GridLayout(1, 3));
        psPanel.setInsetSize(3);
        ((Container)((Object)this)).add((Component)psPanel);
        this.m_cShowControl = new Checkbox("Polygon");
        this.m_cShowControl.addItemListener(this);
        psPanel.add(this.m_cShowControl);
        this.m_cShowSubdivCurve = new Checkbox("Subdivision");
        this.m_cShowSubdivCurve.addItemListener(this);
        psPanel.add(this.m_cShowSubdivCurve);
        this.m_cShowSurface = new Checkbox("Surface");
        this.m_cShowSurface.addItemListener(this);
        psPanel.add(this.m_cShowSurface);
        Panel panel = new Panel(new FlowLayout(1));
        this.m_bReset = new Button("Reset");
        this.m_bReset.addActionListener(this);
        panel.add(this.m_bReset);
        ((Container)((Object)this)).add(panel);
    }

    public String getNotice() {
        String string = "Subdivision curves on surfaces are determined by a piecewise geodesic control polygon. Then refinement follows similar rules like in the planar case. Pick and drag control points to change the shape of the control polygon and thus of the subdivision curve. While pressing 'p' pick and drag control points, if control points are selected.";
        return string;
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.setTitle(psUpdateIf.getName());
        this.m_pjSubdivCurve = (PjSubdivisionCurve)psUpdateIf;
        this.m_pSlider.removeAll();
        this.m_pSlider.add((Component)this.m_pjSubdivCurve.m_depth.assureInspector("Info", "_IP"));
        this.m_pSlider.add((Component)this.m_pjSubdivCurve.m_numPoints.assureInspector("Info", "_IP"));
    }

    public boolean update(Object object) {
        if (this.m_pjSubdivCurve == object) {
            PsPanel.setState((Checkbox)this.m_cReuseTriangleRuns, (boolean)this.m_pjSubdivCurve.getReuseTriangleRunsWhileIterating());
            PsPanel.setState((Checkbox)this.m_cShowControl, (boolean)this.m_pjSubdivCurve.m_controlPolygon.isVisible());
            PsPanel.setState((Checkbox)this.m_cShowSubdivCurve, (boolean)this.m_pjSubdivCurve.m_subdivCurve.isVisible());
            PsPanel.setState((Checkbox)this.m_cShowSurface, (boolean)this.m_pjSubdivCurve.m_baseGeom.isVisible());
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_pjSubdivCurve == null) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.m_bNewCurve) {
            this.m_pjSubdivCurve.m_depth.init();
            this.m_pjSubdivCurve.m_depth.update((Object)this.m_pjSubdivCurve.m_depth);
            this.m_pjSubdivCurve.makeDefaultRefPoints();
            this.m_pjSubdivCurve.update((Object)this.m_pjSubdivCurve);
        } else if (object == this.m_bPointSetFromDisplay) {
            this.m_pjSubdivCurve.useGivenReferencePoints();
        } else if (object == this.m_bChangeBaseSurface) {
            PgGeometryIf pgGeometryIf = this.m_pjSubdivCurve.getDisplay().getSelectedGeometry();
            if (pgGeometryIf != null && pgGeometryIf instanceof PgElementSet) {
                this.m_pjSubdivCurve.setGeometry(pgGeometryIf);
            }
        } else if (object == this.m_bReset) {
            this.m_pjSubdivCurve.init();
            this.m_pjSubdivCurve.start();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_pjSubdivCurve == null) {
            return;
        }
        Object object = itemEvent.getSource();
        if (object == this.m_cReuseTriangleRuns) {
            this.m_pjSubdivCurve.setReuseTriangleRunsWhileIterating(this.m_cReuseTriangleRuns.getState());
            this.m_pjSubdivCurve.update((Object)this.m_pjSubdivCurve);
        } else if (object == this.m_cShowControl) {
            this.m_pjSubdivCurve.m_controlPolygon.setVisible(this.m_cShowControl.getState());
            this.m_pjSubdivCurve.m_controlPolygon.update(null);
        } else if (object == this.m_cShowSubdivCurve) {
            this.m_pjSubdivCurve.m_subdivCurve.setVisible(this.m_cShowSubdivCurve.getState());
            this.m_pjSubdivCurve.m_subdivCurve.update(null);
        } else if (object == this.m_cShowSurface) {
            this.m_pjSubdivCurve.m_baseGeom.setVisible(this.m_cShowSurface.getState());
            this.m_pjSubdivCurve.m_baseGeom.update(null);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

