/*
 * Decompiled with CFR 0.152.
 */
package vgp.volume.mc;

import jv.function.PuFunction;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PuCleanMesh;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import vgp.volume.mc.PnMarchingCubes;
import vgp.volume.mc.PnPassedFunction;

public class PjMarchingCubes
extends PjProject {
    protected static final int DEFAULT_DIMENSION = 9;
    protected static final String DEFAULT_FUNCTION = "u*v+v*w-2*u*w";
    protected static final double DEFAULT_THRESHOLD = 0.0;
    protected static final boolean DEFAULT_WEIGHTING = true;
    protected static final boolean DEFAULT_ORIENTATE = true;
    protected static final boolean DEFAULT_AUTO_UPDATE = true;
    protected static final int[] DEFAULT_FROM = new int[]{-1, -1, -1};
    protected static final int[] DEFAULT_TO = new int[]{1, 1, 1};
    protected PgElementSet m_geom;
    protected PuDouble m_level;
    protected PgElementSet m_domainBounds;
    protected PuFunction m_function = new PuFunction(3, 1);
    protected PuInteger m_dimX;
    protected PuInteger m_dimY;
    protected PuInteger m_dimZ;
    protected PuDouble m_xFrom;
    protected PuDouble m_xTo;
    protected PuDouble m_yFrom;
    protected PuDouble m_yTo;
    protected PuDouble m_zFrom;
    protected PuDouble m_zTo;
    protected boolean m_bWeighting;
    protected boolean m_bOrientate;
    protected boolean m_bAutoUpdate;
    static /* synthetic */ Class class$vgp$volume$mc$PjMarchingCubes;

    public PjMarchingCubes() {
        super("Marching Cubes Demo");
        this.m_function.setParent((PsUpdateIf)this);
        this.m_function.setName("Function (u, v, w)");
        this.m_function.setExpressionName(0, "F");
        this.m_level = new PuDouble("Level", (PsUpdateIf)this);
        this.m_dimX = new PuInteger("Sample rate u", (PsUpdateIf)this);
        this.m_dimY = new PuInteger("Sample rate v", (PsUpdateIf)this);
        this.m_dimZ = new PuInteger("Sample rate w", (PsUpdateIf)this);
        this.m_xFrom = new PuDouble("uMin", (PsUpdateIf)this);
        this.m_xTo = new PuDouble("uMax", (PsUpdateIf)this);
        this.m_yFrom = new PuDouble("vMin", (PsUpdateIf)this);
        this.m_yTo = new PuDouble("vMax", (PsUpdateIf)this);
        this.m_zFrom = new PuDouble("wMin", (PsUpdateIf)this);
        this.m_zTo = new PuDouble("wMax", (PsUpdateIf)this);
        this.m_geom = new PgElementSet(3);
        this.m_geom.setName("Isosurface");
        this.m_domainBounds = new PgElementSet(3);
        this.m_domainBounds.setName("Domain Bounds");
        if (((Object)((Object)this)).getClass() == (class$vgp$volume$mc$PjMarchingCubes == null ? (class$vgp$volume$mc$PjMarchingCubes = PjMarchingCubes.class$("vgp.volume.mc.PjMarchingCubes")) : class$vgp$volume$mc$PjMarchingCubes)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_function.setExpression(DEFAULT_FUNCTION);
        this.m_geom.showVertices(false);
        this.m_geom.showEdges(false);
        this.m_geom.showElements(true);
        this.m_geom.showElementBackColor(true);
        this.m_bWeighting = true;
        this.m_bOrientate = true;
        this.m_bAutoUpdate = true;
        this.m_domainBounds.showElements(false);
        this.m_domainBounds.showVertices(false);
        this.m_domainBounds.showEdges(true);
        this.m_domainBounds.setNumVertices(8);
        this.m_domainBounds.setNumElements(6);
        this.m_domainBounds.setElement(0, new PiVector(0, 1, 3, 2));
        this.m_domainBounds.setElement(1, new PiVector(4, 5, 7, 6));
        this.m_domainBounds.setElement(2, new PiVector(0, 4, 5, 1));
        this.m_domainBounds.setElement(3, new PiVector(1, 5, 7, 3));
        this.m_domainBounds.setElement(4, new PiVector(7, 3, 2, 6));
        this.m_domainBounds.setElement(5, new PiVector(2, 6, 4, 0));
        this.m_level.setDefBounds(-5.0, 5.0, 0.01, 0.1);
        this.m_level.setDefValue(0.0);
        this.m_level.init();
        this.m_dimX.setDefBounds(3, 32, 1, 3);
        this.m_dimX.setDefValue(9);
        this.m_dimX.init();
        this.m_dimY.setDefBounds(3, 32, 1, 3);
        this.m_dimY.setDefValue(9);
        this.m_dimY.init();
        this.m_dimZ.setDefBounds(3, 32, 1, 3);
        this.m_dimZ.setDefValue(9);
        this.m_dimZ.init();
        this.m_xFrom.setDefBounds(-10.0, 0.0, 0.1, 1.0);
        this.m_xFrom.setDefValue((double)DEFAULT_FROM[0]);
        this.m_xFrom.init();
        this.m_xTo.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_xTo.setDefValue((double)DEFAULT_TO[0]);
        this.m_xTo.init();
        this.m_yFrom.setDefBounds(-10.0, 0.0, 0.1, 1.0);
        this.m_yFrom.setDefValue((double)DEFAULT_FROM[1]);
        this.m_yFrom.init();
        this.m_yTo.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_yTo.setDefValue((double)DEFAULT_TO[1]);
        this.m_yTo.init();
        this.m_zFrom.setDefBounds(-10.0, 0.0, 0.1, 1.0);
        this.m_zFrom.setDefValue((double)DEFAULT_FROM[2]);
        this.m_zFrom.init();
        this.m_zTo.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_zTo.setDefValue((double)DEFAULT_TO[2]);
        this.m_zTo.init();
    }

    public void start() {
        this.computeGeometry();
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.addGeometry((PgGeometryIf)this.m_domainBounds);
        this.selectGeometry((PgGeometryIf)this.m_geom);
        super.start();
    }

    public void reset() {
        this.init();
        this.start();
        this.fitDisplays();
    }

    public void computeGeometry() {
        this.m_domainBounds.setVertex(0, this.m_xFrom.getValue(), this.m_yFrom.getValue(), this.m_zFrom.getValue());
        this.m_domainBounds.setVertex(1, this.m_xTo.getValue(), this.m_yFrom.getValue(), this.m_zFrom.getValue());
        this.m_domainBounds.setVertex(2, this.m_xFrom.getValue(), this.m_yTo.getValue(), this.m_zFrom.getValue());
        this.m_domainBounds.setVertex(3, this.m_xTo.getValue(), this.m_yTo.getValue(), this.m_zFrom.getValue());
        this.m_domainBounds.setVertex(4, this.m_xFrom.getValue(), this.m_yFrom.getValue(), this.m_zTo.getValue());
        this.m_domainBounds.setVertex(5, this.m_xTo.getValue(), this.m_yFrom.getValue(), this.m_zTo.getValue());
        this.m_domainBounds.setVertex(6, this.m_xFrom.getValue(), this.m_yTo.getValue(), this.m_zTo.getValue());
        this.m_domainBounds.setVertex(7, this.m_xTo.getValue(), this.m_yTo.getValue(), this.m_zTo.getValue());
        PnMarchingCubes pnMarchingCubes = new PnMarchingCubes();
        PdVector pdVector = new PdVector(this.m_xFrom.getValue(), this.m_yFrom.getValue(), this.m_zFrom.getValue());
        PdVector pdVector2 = new PdVector(this.m_xTo.getValue(), this.m_yTo.getValue(), this.m_zTo.getValue());
        pnMarchingCubes.setVectorGrid(pdVector, pdVector2, this.m_dimX.getValue(), this.m_dimY.getValue(), this.m_dimZ.getValue());
        pnMarchingCubes.setFunction(new PnPassedFunction(this.m_function), true);
        pnMarchingCubes.setWeighted(this.m_bWeighting);
        pnMarchingCubes.setOrientate(this.m_bOrientate);
        PgElementSet pgElementSet = pnMarchingCubes.startAlgorithm(this.m_level.getValue());
        PuCleanMesh.identifyVertices((PgPointSet)pgElementSet, (double)1.0E-10);
        this.m_geom.setNumVertices(pgElementSet.getNumVertices());
        this.m_geom.setVertices(pgElementSet.getVertices());
        this.m_geom.setNumElements(pgElementSet.getNumElements());
        this.m_geom.setElements(pgElementSet.getElements());
        this.m_geom.makeNeighbour();
        this.m_geom.makeElementNormals();
    }

    public boolean update(Object object) {
        if (this.isUpdateSender()) {
            return true;
        }
        if (!this.m_bAutoUpdate) {
            return true;
        }
        if (object == this) {
            this.computeGeometry();
            this.m_domainBounds.update((Object)this.m_domainBounds);
            this.setUpdateSender(true);
            this.m_geom.update((Object)this.m_geom);
            this.setUpdateSender(false);
            return super.update((Object)this);
        }
        if (object == this.m_level) {
            return this.update((Object)this);
        }
        if (object == this.m_dimX || object == this.m_dimY || object == this.m_dimZ) {
            return this.update((Object)this);
        }
        if (object == this.m_xFrom || object == this.m_xTo || object == this.m_yFrom || object == this.m_yTo || object == this.m_zFrom || object == this.m_zTo) {
            return this.update((Object)this);
        }
        if (object == this.m_function) {
            return this.update((Object)this);
        }
        return super.update(object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

