/*
 * Decompiled with CFR 0.152.
 */
package vgp.surface.common;

import jv.number.PuDouble;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import vgp.surface.common.PgSurfaceDescr;

public class PgSurface_KleinBottle
extends PgSurfaceDescr {
    private int m_uDiscr = 21;
    private int m_vDiscr = 45;
    private final double m_defHandleWidth = 2.0;
    private final double m_defBodyWidth = 4.0;
    private final double m_defHandleRadius = 1.0;
    private final double m_defShift = 10.0;
    protected PuDouble m_moebius;
    protected PuDouble m_howToBuild;
    protected PuDouble m_handleWidth;
    protected PuDouble m_bodyWidth;
    protected PuDouble m_handleRadius;
    protected PuDouble m_shift;
    private double unfold = 0.0;
    static /* synthetic */ Class class$vgp$surface$common$PgSurface_KleinBottle;

    public PgSurface_KleinBottle() {
        this.setName("KleinBottle");
        this.m_handleWidth = new PuDouble("Handle Width", (PsUpdateIf)this);
        this.m_handleRadius = new PuDouble("Handle Radius", (PsUpdateIf)this);
        this.m_bodyWidth = new PuDouble("Body Width", (PsUpdateIf)this);
        this.m_shift = new PuDouble("Shift", (PsUpdateIf)this);
        this.m_moebius = new PuDouble("Moebius Strip", (PsUpdateIf)this);
        this.m_howToBuild = new PuDouble("How to build", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$surface$common$PgSurface_KleinBottle == null ? (class$vgp$surface$common$PgSurface_KleinBottle = PgSurface_KleinBottle.class$("vgp.surface.common.PgSurface_KleinBottle")) : class$vgp$surface$common$PgSurface_KleinBottle)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setSize(-1.5707963267948966, 0.0, 4.71238898038469, Math.PI * 4);
        this.setDiscrBounds(2, 2, 5 * this.m_uDiscr, 5 * this.m_vDiscr);
        this.setDiscr(this.m_uDiscr, this.m_vDiscr);
        this.m_handleWidth.setDefBounds(0.0, 8.0, 0.01, 0.1);
        this.m_handleWidth.setDefValue(2.0);
        this.m_handleWidth.init();
        this.m_bodyWidth.setDefBounds(0.0, 16.0, 0.01, 0.1);
        this.m_bodyWidth.setDefValue(4.0);
        this.m_bodyWidth.init();
        this.m_handleRadius.setDefBounds(0.0, 4.0, 0.01, 0.1);
        this.m_handleRadius.setDefValue(1.0);
        this.m_handleRadius.init();
        this.m_shift.setDefBounds(0.0, 50.26548245743669, 0.1, 1.0);
        this.m_shift.setDefValue(10.0);
        this.m_shift.init();
        this.m_moebius.setDefBounds(-1.0, 1.0, 0.02, 0.1);
        this.m_moebius.setDefValue(0.0);
        this.m_moebius.init();
        this.m_howToBuild.setDefBounds(0.0, 1.0, 0.01, 0.05);
        this.m_howToBuild.setDefValue(1.0);
        this.m_howToBuild.init();
        this.addParameter((PsObject)this.m_bodyWidth);
        this.addParameter((PsObject)this.m_handleWidth);
        this.addParameter((PsObject)this.m_handleRadius);
        this.addParameter((PsObject)this.m_shift);
        this.addParameter((PsObject)this.m_moebius);
        this.addParameter((PsObject)this.m_howToBuild);
        this.useFunctionExpression(false);
    }

    public boolean update(Object object) {
        if (object == this.m_handleWidth || object == this.m_bodyWidth || object == this.m_handleRadius || object == this.m_shift) {
            return super.update(null);
        }
        if (object == this.m_moebius) {
            double d = this.m_moebius.getValue();
            if (d > 0.0) {
                this.setUMin(-1.5707963267948966 + d * Math.PI);
                this.setUMax(4.71238898038469 - d * Math.PI);
            }
            if (d <= 0.0) {
                this.setUMin(-4.71238898038469 - d * Math.PI);
                this.setUMax(1.5707963267948966 + d * Math.PI);
            }
            return super.update(null);
        }
        if (object == this.m_howToBuild) {
            double d = this.m_howToBuild.getValue();
            if (d > 0.4) {
                this.m_shift.setValue((d - 0.4) / 0.6 * 10.0 + (1.0 - d) / 0.6 * 12.5);
                this.setVMin(0.0);
                this.setVMax((5.0 * d - 1.0) * Math.PI);
                this.m_handleWidth.setValue(2.0);
            }
            if (d <= 0.4 && d > 0.2) {
                this.m_shift.setValue(12.5);
                this.setVMin(0.1 - (d - 0.2) / 0.2 * 0.1);
                this.setVMax(Math.PI);
                this.m_handleWidth.setValue(2.0 * (5.0 * d - 1.0));
            }
            if (d <= 0.2) {
                this.m_shift.setValue(12.5);
                this.setVMin(0.1);
                this.setVMax(Math.PI);
                this.m_handleWidth.setValue(0.0);
                this.unfold = 1.0 - 5.0 * d;
            }
            return super.update(null);
        }
        return super.update(object);
    }

    public boolean isUPeriodic() {
        return this.getUMax() - this.getUMin() >= Math.PI * 2;
    }

    public boolean isVPeriodic() {
        return this.getVMax() - this.getVMin() >= Math.PI * 4;
    }

    private void top(PdVector pdVector, double d, double d2) {
        double d3 = this.m_handleRadius.getValue();
        double d4 = this.m_handleWidth.getValue();
        pdVector.setEntry(0, -d3 * Math.cos(d) * Math.cos(d2) - d4 * (Math.cos(d2) + 1.0));
        pdVector.setEntry(1, d3 * Math.sin(d));
        pdVector.setEntry(2, -(d3 * Math.cos(d) + d4) * Math.sin(d2) - Math.PI * 3);
    }

    private void han(PdVector pdVector, double d, double d2, boolean bl) {
        double d3 = this.m_handleRadius.getValue();
        double d4 = this.m_handleWidth.getValue();
        double d5 = this.m_handleWidth.getValue() * Math.sin(d2);
        double d6 = 3.0 / Math.sqrt(d5 * d5 + 9.0);
        double d7 = Math.sqrt(1.0 - d6 * d6);
        if (this.m_handleWidth.getValue() != 0.0) {
            pdVector.setEntry(0, -d3 * Math.cos(d) * d6 + d4 * (Math.cos(d2) - 1.0));
            pdVector.setEntry(1, d3 * Math.sin(d));
            pdVector.setEntry(2, d3 * Math.cos(d) * d7 - 3.0 * d2);
        } else {
            double d8 = 1.0 - this.unfold;
            double d9 = this.m_uMin.getValue();
            double d10 = this.m_uMax.getValue();
            if (bl) {
                d9 = Math.PI - this.m_uMax.getValue();
                d10 = Math.PI - this.m_uMin.getValue();
            }
            double d11 = d10 - d9;
            double d12 = (d10 + d9) / 2.0;
            double d13 = (d - d9) / d11;
            double d14 = d12 + d8 * (d13 - 0.5) * d11;
            if (d8 != 0.0) {
                pdVector.setEntry(0, d3 * (-1.0 / d8 * Math.cos(d14) + (1.0 / d8 - 1.0) * Math.cos(d12)));
                pdVector.setEntry(1, d3 * (1.0 / d8 * Math.sin(d14) - (1.0 / d8 - 1.0) * Math.sin(d12)));
            } else {
                pdVector.setEntry(0, d3 * ((d - d12) * Math.sin(d12) - Math.cos(d12)));
                pdVector.setEntry(1, d3 * ((d - d12) * Math.cos(d12) + Math.sin(d12)));
            }
            pdVector.setEntry(2, -3.0 * d2);
        }
    }

    private void bod(PdVector pdVector, double d, double d2) {
        double d3 = this.m_handleRadius.getValue();
        double d4 = this.m_bodyWidth.getValue();
        double d5 = (d4 + d3 - (d4 - d3) * Math.cos(d2)) / 2.0;
        pdVector.setEntry(0, d5 * Math.cos(d));
        pdVector.setEntry(1, d5 * Math.sin(d));
        pdVector.setEntry(2, -3.0 * (Math.PI - d2));
    }

    private void bot(PdVector pdVector, double d, double d2) {
        double d3 = this.m_handleRadius.getValue();
        double d4 = this.m_bodyWidth.getValue();
        double d5 = (d4 + d3) / 2.0;
        double d6 = (d4 + d3 + (d4 - d3) * Math.cos(d2)) / 2.0;
        pdVector.setEntry(0, d6 * Math.cos(d));
        pdVector.setEntry(1, d6 * Math.sin(d));
        pdVector.setEntry(2, d5 * Math.sin(d2));
    }

    public boolean calc_f(PdVector pdVector, double d, double d2) {
        boolean bl = false;
        double d3 = d2 + this.m_shift.getValue();
        if (d3 > Math.PI * 8 || d3 < 0.0) {
            d3 -= Math.PI * 8 * Math.floor(d3 / (Math.PI * 8));
        }
        if (d3 >= Math.PI * 4) {
            bl = true;
            d = Math.PI - d;
            d3 -= Math.PI * 4;
        }
        if (d3 <= Math.PI) {
            this.han(pdVector, d, d3, bl);
        } else if (d3 < Math.PI * 2) {
            this.top(pdVector, d, d3 - Math.PI);
        } else if (d3 < Math.PI * 3) {
            this.bod(pdVector, d, d3 - Math.PI * 2);
        } else {
            this.bot(pdVector, d, d3 - Math.PI * 3);
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

