/*
 * Decompiled with CFR 0.152.
 */
package vgp.surface.common;

import jv.function.PuFunction;
import jv.number.PuDouble;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import vgp.surface.common.PgSurfaceDescr;

public class PgSurface_Cone
extends PgSurfaceDescr {
    private double m_defAngle = 25.0;
    protected PuDouble m_angle;
    private double m_defRadius = 1.0;
    protected PuDouble m_radius;
    static /* synthetic */ Class class$vgp$surface$common$PgSurface_Cone;

    public PgSurface_Cone() {
        this.setName("Cone");
        this.m_function = new PuFunction(2, 3);
        this.m_function.setName("Coordinate Functions");
        this.m_angle = new PuDouble("Opening Angle", (PsUpdateIf)this);
        this.m_radius = new PuDouble("Scaling Factor", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$surface$common$PgSurface_Cone == null ? (class$vgp$surface$common$PgSurface_Cone = PgSurface_Cone.class$("vgp.surface.common.PgSurface_Cone")) : class$vgp$surface$common$PgSurface_Cone)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setSize(0.0, 0.0, Math.PI * 2, 1.0);
        this.setDiscr(17, 12);
        this.m_angle.setDefBounds(0.0, 90.0, 0.1, 1.0);
        this.m_angle.setDefValue(this.m_defAngle);
        this.m_angle.init();
        this.addParameter((PsObject)this.m_angle);
        this.m_radius.setDefBounds(0.0, 50.0, 0.01, 1.0);
        this.m_radius.setDefValue(this.m_defRadius);
        this.m_radius.init();
        this.addParameter((PsObject)this.m_radius);
        this.m_function.setExpression(0, "r*v*cos(u)*tan(a)");
        this.m_function.setExpression(1, "r*v*sin(u)*tan(a)");
        this.m_function.setExpression(2, "r*v");
        this.m_function.addParameter("a", this.getAngle());
        this.m_function.addParameter("r", this.m_radius.getValue());
        this.setFunction(this.m_function);
        this.useFunctionExpression(true);
    }

    private double getAngle() {
        return this.m_angle.getValue() * Math.PI / 180.0;
    }

    public boolean update(Object object) {
        if (object == this.m_angle) {
            this.m_function.setParameter("a", this.getAngle());
            return super.update(null);
        }
        if (object == this.m_radius) {
            this.m_function.setParameter("r", this.m_radius.getValue());
            return super.update(null);
        }
        return super.update(object);
    }

    public boolean isUPeriodic() {
        return this.getUMax() - this.getUMin() >= Math.PI * 2;
    }

    public boolean calc_f(PdVector pdVector, double d, double d2) {
        double d3 = this.m_radius.getValue();
        pdVector.set(d3 * d2 * Math.cos(d) * Math.tan(this.getAngle()), d3 * d2 * Math.sin(d) * Math.tan(this.getAngle()), d3 * d2);
        return true;
    }

    protected PdVector calc_df_dU(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        double d3 = this.m_radius.getValue();
        pdVector.set(-d3 * d2 * Math.sin(d) * Math.tan(this.getAngle()), d3 * d2 * Math.cos(d) * Math.tan(this.getAngle()), 0.0);
        return pdVector;
    }

    protected PdVector calc_df_dV(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        double d3 = this.m_radius.getValue();
        pdVector.set(d3 * Math.cos(d) * Math.tan(this.getAngle()), d3 * Math.sin(d) * Math.tan(this.getAngle()), d3);
        return pdVector;
    }

    protected PdVector calc_ddf_dUdU(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        double d3 = this.m_radius.getValue();
        pdVector.set(-d3 * d2 * Math.cos(d) * Math.tan(this.getAngle()), -d3 * d2 * Math.sin(d) * Math.tan(this.getAngle()), 0.0);
        return pdVector;
    }

    protected PdVector calc_ddf_dVdV(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        pdVector.set(0.0, 0.0, 0.0);
        return pdVector;
    }

    protected PdVector calc_ddf_dUdV(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        double d3 = this.m_radius.getValue();
        pdVector.set(-d3 * Math.sin(d) * Math.tan(this.getAngle()), d3 * Math.cos(d) * Math.tan(this.getAngle()), 0.0);
        return pdVector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

