/*
 * Decompiled with CFR 0.152.
 */
package vgp.imageSource;

import java.awt.Color;
import java.awt.Image;
import jv.function.PuComplexFunction;
import jv.geom.PgElementSet;
import jv.geom.PgTexture;
import jv.number.PuComplex;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.objectGui.PsImage;
import jv.project.PgGeometryIf;
import jv.project.PvViewerIf;
import jv.thirdParty.ruler.PgAxes;
import jv.vecmath.PdVector;
import jv.viewer.PvDisplay;
import jvx.surface.PgDomain;
import jvx.surface.PgDomainDescr;
import vgp.imageSource.PiDomainDroste;
import vgp.imageSource.PjImageSource;

public class PjDomainDroste
extends PjImageSource {
    protected PgDomain m_domain;
    protected PgElementSet m_surface;
    protected PuComplexFunction m_function;
    protected static String m_defExpression = "z*z";
    protected PsImage m_image;
    protected String m_defaultImageFile;
    protected String m_imageFile;
    static /* synthetic */ Class class$vgp$imageSource$PjDomainDroste;

    public PjDomainDroste() {
        this.m_imageFile = this.m_defaultImageFile = "images/snapshot.jpg";
        this.setName("Droste Demo");
        this.setImageSource(new PiDomainDroste());
        this.m_domain = new PgDomain(2);
        this.m_domain.setVisible(true);
        this.m_domain.setName("Complex Domain");
        this.m_domain.setDimOfElements(4);
        this.m_domain.addUpdateListener((PsUpdateIf)this);
        this.m_surface = new PgElementSet(2);
        this.m_surface.setName("Complex Map");
        this.m_function = new PuComplexFunction(1, 1);
        this.m_function.setName("Complex Function");
        this.m_function.setParent((PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$imageSource$PjDomainDroste == null ? (class$vgp$imageSource$PjDomainDroste = PjDomainDroste.class$("vgp.imageSource.PjDomainDroste")) : class$vgp$imageSource$PjDomainDroste)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        PgDomainDescr pgDomainDescr = this.m_domain.getDescr();
        pgDomainDescr.setMaxSize(-10.0, -10.0, 10.0, 10.0);
        pgDomainDescr.setSize(-2.0, -2.0, 2.0, 2.0);
        pgDomainDescr.setDiscrBounds(2, 2, 50, 50);
        pgDomainDescr.setDiscr(20, 20);
        this.m_domain.init();
        this.m_domain.showElements(true);
        this.m_domain.makeVertexColorsFromXYZ();
        this.m_domain.showEdgeColorFromVertices(true);
        this.m_domain.showEdgeColors(true);
        this.m_domain.setGlobalEdgeColor(new Color(161, 161, 161));
        this.m_domain.setGlobalElementColor(Color.white);
        this.m_surface.copy((PsObject)this.m_domain);
        this.m_surface.setGlobalEdgeColor(Color.blue);
        this.m_function.setExpression(m_defExpression);
    }

    public void start() {
        PgTexture pgTexture;
        Object object;
        PvViewerIf pvViewerIf = this.getViewer();
        if (pvViewerIf != null && (object = pvViewerIf.getParameter("vgp.imageSource.PjDomainDroste#expression")) != null) {
            m_defExpression = object;
            this.m_function.setExpression(m_defExpression);
        }
        if (this.m_imageDisplay != null) {
            this.m_imageDisplay.setDistance(7.0);
        }
        if (pvViewerIf != null && (object = pvViewerIf.getParameter("vgp.imageSource.PjDomainDroste#image")) != null) {
            this.m_imageFile = object;
        }
        this.m_domain.setDimOfTextures(2);
        this.m_domain.assureVertexTextures();
        this.m_domain.showVertexTexture(true);
        object = PsImage.getImageResource((String)this.m_imageFile);
        if (object != null) {
            pgTexture = new PgTexture();
            pgTexture.setImage((Image)object);
            pgTexture.setImageName(this.m_imageFile);
            this.m_domain.setTexture(pgTexture);
            this.m_domain.update((Object)this.m_domain);
        }
        this.compute();
        this.addGeometry((PgGeometryIf)this.m_domain);
        this.addGeometry((PgGeometryIf)this.m_surface);
        this.selectGeometry((PgGeometryIf)this.m_domain);
        pgTexture = this.getDisplay();
        if (pgTexture != null) {
            pgTexture.showAxes(true);
            PgAxes pgAxes = ((PvDisplay)pgTexture).getAxes();
            pgAxes.setMode(3);
            pgTexture.selectCamera(1);
        }
        super.start();
    }

    public boolean update(Object object) {
        if (this.isUpdateSender()) {
            return true;
        }
        if (object == this) {
            this.compute();
            this.setUpdateSender(true);
            this.m_domain.update((Object)this.m_domain);
            this.m_function.update((Object)this.m_function);
            this.m_surface.update((Object)this.m_surface);
            this.setUpdateSender(false);
            return super.update((Object)this);
        }
        if (object == this.m_function) {
            this.compute();
            this.m_surface.update((Object)this.m_surface);
            return super.update((Object)this);
        }
        if (object == this.m_domain) {
            this.m_domain.makeVertexColorsFromXYZ();
            this.m_surface.copy((PsObject)this.m_domain);
            this.m_surface.setGlobalEdgeColor(Color.blue);
            this.compute();
            this.m_surface.update((Object)this.m_surface);
            return super.update((Object)this);
        }
        return false;
    }

    public void compute() {
        int n = this.m_domain.getNumVertices();
        PdVector[] pdVectorArray = this.m_domain.getVertices();
        PuComplex puComplex = new PuComplex();
        PuComplex puComplex2 = new PuComplex();
        for (int i = 0; i < n; ++i) {
            puComplex.set(pdVectorArray[i].m_data[0], pdVectorArray[i].m_data[1]);
            puComplex2.copy(this.m_function.eval(puComplex));
            this.m_surface.setVertex(i, puComplex2.re, puComplex2.im);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

