/*
 * Decompiled with CFR 0.152.
 */
package vgp.discrete.ellipse;

import java.awt.Color;
import jv.function.PuFunction;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.vecmath.PdVector;
import jvx.numeric.PnRootFinder;

public class PjEllipse
extends PjProject {
    protected PgPolygon m_poly = new PgPolygon(2);
    protected PgPolygon m_ellipse = new PgPolygon(2);
    protected PgPolygon m_rolled = new PgPolygon(2);
    protected PgPolygon m_unrolled;
    protected PgPointSet m_focus = new PgPointSet(2);
    protected PgElementSet m_rotated;
    protected PuInteger m_steps;
    protected PuInteger m_rotdiscr;
    protected PdVector m_start;
    protected PuInteger m_firstDir;
    protected PuDouble m_a;
    protected PuDouble m_b;
    protected boolean m_autofit = true;
    static /* synthetic */ Class class$vgp$discrete$ellipse$PjEllipse;

    public PjEllipse() {
        super("Elliptic Billard");
        this.m_unrolled = new PgPolygon(2);
        this.m_rotated = new PgElementSet(3);
        this.m_firstDir = new PuInteger("Initial Direction", (PsUpdateIf)this);
        this.m_steps = new PuInteger("Length", (PsUpdateIf)this);
        this.m_rotdiscr = new PuInteger("Rotation Discr.", (PsUpdateIf)this);
        this.m_a = new PuDouble("Ellipse Width", (PsUpdateIf)this);
        this.m_b = new PuDouble("Ellipse Height", (PsUpdateIf)this);
        this.m_start = new PdVector(2);
        if (((Object)((Object)this)).getClass() == (class$vgp$discrete$ellipse$PjEllipse == null ? (class$vgp$discrete$ellipse$PjEllipse = PjEllipse.class$("vgp.discrete.ellipse.PjEllipse")) : class$vgp$discrete$ellipse$PjEllipse)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_firstDir.setDefBounds(0, 360, 1, 5);
        this.m_firstDir.setDefValue(0);
        this.m_firstDir.init();
        this.m_steps.setDefBounds(2, 50, 1, 5);
        this.m_steps.setDefValue(10);
        this.m_steps.init();
        this.m_rotdiscr.setDefBounds(0, 30, 1, 5);
        this.m_rotdiscr.setDefValue(10);
        this.m_rotdiscr.init();
        this.m_a.setDefBounds(0.5, 10.0, 0.1, 0.5);
        this.m_a.setDefValue(2.0);
        this.m_a.init();
        this.m_b.setDefBounds(0.5, 10.0, 0.1, 0.5);
        this.m_b.setDefValue(1.0);
        this.m_b.init();
        this.m_start.set(0.5, 0.9);
    }

    public void start() {
        PsDebug.notify((String)"PjEllipse.start: ");
        this.m_poly.setName("Curve");
        this.m_poly.setGlobalVertexColor(Color.blue);
        this.m_poly.setGlobalEdgeColor(Color.blue);
        this.m_ellipse.setName("Ellipse");
        this.m_ellipse.showVertices(false);
        this.m_rolled.setName("Unrolled Focus");
        this.m_rolled.setGlobalEdgeColor(Color.red);
        this.m_focus.setName("Focus");
        this.m_unrolled.setName("Unrolled Polygon");
        this.m_unrolled.setGlobalVertexColor(Color.blue);
        this.m_unrolled.setGlobalEdgeColor(Color.blue);
        this.m_rotated.setName("Surface");
        this.compute();
        this.selectGeometry((PgGeometryIf)this.m_poly);
        this.showBillard();
        this.addGeometry((PgGeometryIf)this.m_poly);
        this.addGeometry((PgGeometryIf)this.m_ellipse);
        this.addGeometry((PgGeometryIf)this.m_rolled);
        this.addGeometry((PgGeometryIf)this.m_unrolled);
        this.addGeometry((PgGeometryIf)this.m_focus);
        this.addGeometry((PgGeometryIf)this.m_rotated);
        super.start();
    }

    public void compute() {
        double d = this.m_a.getValue();
        double d2 = this.m_b.getValue();
        PjEllipse.computeEllipse(d, d2, 50, this.m_ellipse);
        double d3 = this.m_firstDir.getValue();
        PdVector pdVector = new PdVector(Math.cos(Math.PI / 180 * d3), Math.sin(Math.PI / 180 * d3));
        PjEllipse.computeBillard(d, d2, this.m_start, pdVector, this.m_steps.getValue(), this.m_poly);
        PdVector pdVector2 = new PdVector(2);
        if (d >= d2) {
            pdVector2.set(Math.sqrt(d * d - d2 * d2), 0.0);
        } else {
            pdVector2.set(0.0, Math.sqrt(d2 * d2 - d * d));
        }
        PjEllipse.unroll(this.m_poly, pdVector2, this.m_rolled, this.m_unrolled);
        this.m_focus.setNumVertices(1);
        this.m_focus.setVertex(0, pdVector2);
        this.computeXRotation(this.m_rolled, this.m_rotdiscr.getValue(), this.m_rotated);
    }

    public static void computeEllipse(double d, double d2, int n, PgPolygon pgPolygon) {
        pgPolygon.setNumVertices(n + 1);
        double d3 = Math.PI * 2 / (double)n;
        for (int i = 0; i < n + 1; ++i) {
            pgPolygon.setVertex(i, d * Math.cos((double)i * d3), d2 * Math.sin((double)i * d3));
        }
    }

    public static void computeBillard(double d, double d2, PdVector pdVector, PdVector pdVector2, int n, PgPolygon pgPolygon) {
        PuFunction puFunction = new PuFunction(1, 1);
        puFunction.setExpression("(a*cos(u)-c)*e-(b*sin(u)-d)*f");
        double d3 = pdVector.getEntry(0);
        double d4 = pdVector.getEntry(1);
        double d5 = pdVector2.getEntry(0);
        double d6 = pdVector2.getEntry(1);
        puFunction.addParameter("a", d);
        puFunction.addParameter("b", d2);
        puFunction.addParameter("c", d3);
        puFunction.addParameter("d", d4);
        puFunction.addParameter("e", d6);
        puFunction.addParameter("f", d5);
        pgPolygon.setNumVertices(n + 1);
        pgPolygon.setVertex(0, d3, d4);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ++n2;
            puFunction.setParameter("c", d3);
            puFunction.setParameter("d", d4);
            puFunction.setParameter("e", d6);
            puFunction.setParameter("f", d5);
            PdVector pdVector3 = PnRootFinder.findRoots((PuFunction)puFunction, (double)-0.7853981633974483, (double)(Math.PI * 2), (int)200);
            if (pdVector3.getSize() == 0) {
                return;
            }
            double d7 = -1.0;
            double d8 = -1.0;
            for (int j = 0; j < pdVector3.getSize(); ++j) {
                double d9 = Math.abs(d5) > 1.0E-10 ? (d * Math.cos(pdVector3.getEntry(j)) - d3) / d5 : (d2 * Math.sin(pdVector3.getEntry(j)) - d4) / d6;
                if (j != 0 && !(d9 > d7)) continue;
                d7 = d9;
                d8 = pdVector3.getEntry(j);
            }
            if (Math.abs(d7) < 0.01) {
                d7 = 0.0;
            }
            if (d7 < 0.0) {
                return;
            }
            pgPolygon.setVertex(n2, d3 += d5 * d7, d4 += d6 * d7);
            double d10 = Math.sqrt(d * d * Math.sin(d8) * Math.sin(d8) + d2 * d2 * Math.cos(d8) * Math.cos(d8));
            double d11 = -d * Math.sin(d8) / d10;
            if (d11 < -1.0) {
                d11 = -1.0;
            }
            if (d11 > 1.0) {
                d11 = 1.0;
            }
            double d12 = Math.acos(-d * Math.sin(d8) / d10);
            if (d2 * Math.cos(d8) < 0.0) {
                d12 = Math.PI * 2 - d12;
            }
            double d13 = Math.acos(d5);
            if (d6 < 0.0) {
                d13 = Math.PI * 2 - d13;
            }
            double d14 = d12 + (d12 - d13);
            d5 = Math.cos(d14);
            d6 = Math.sin(d14);
        }
    }

    public static void unroll(PgPolygon pgPolygon, PdVector pdVector, PgPolygon pgPolygon2, PgPolygon pgPolygon3) {
        int n = pgPolygon.getNumVertices() - 1;
        pgPolygon3.setNumVertices(n + 1);
        pgPolygon2.setNumVertices(n);
        PdVector pdVector2 = new PdVector(n);
        PdVector pdVector3 = new PdVector(n);
        PdVector pdVector4 = new PdVector(n);
        PdVector pdVector5 = new PdVector(2);
        PdVector pdVector6 = new PdVector(2);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            pgPolygon3.setVertex(i, d, 0.0);
            pdVector2.setEntry(i, d);
            pdVector5.copy(pgPolygon.getVertex(i + 1));
            pdVector5.sub(pgPolygon.getVertex(i));
            double d2 = pdVector5.length();
            d += d2;
            pdVector6.copy(pdVector);
            pdVector6.sub(pgPolygon.getVertex(i));
            double d3 = pdVector6.length();
            pdVector4.setEntry(i, d3);
            double d4 = PdVector.dot((PdVector)pdVector5, (PdVector)pdVector6) / d2 / d3;
            if (d4 < -1.0) {
                d4 = -1.0;
            } else if (d4 > 1.0) {
                d4 = 1.0;
            }
            double d5 = Math.acos(d4);
            pdVector3.setEntry(i, d5);
            pgPolygon2.setVertex(i, pdVector2.getEntry(i) + pdVector4.getEntry(i) * d4, pdVector4.getEntry(i) * Math.sin(d5));
        }
        pgPolygon3.setVertex(n, d, 0.0);
    }

    public void computeXRotation(PgPolygon pgPolygon, int n, PgElementSet pgElementSet) {
        int n2 = pgPolygon.getNumVertices();
        PdVector[] pdVectorArray = pgPolygon.getVertices();
        pgElementSet.setNumVertices(n2 * (n + 1));
        pgElementSet.setDimOfElements(4);
        pgElementSet.makeQuadrConn(n + 1, n2);
        int n3 = 0;
        double d = 0.0;
        double d2 = Math.PI * 2 / (double)n;
        for (int i = 0; i < n + 1; ++i) {
            double d3 = Math.cos(d);
            double d4 = Math.sin(d);
            for (int j = 0; j < n2; ++j) {
                pgElementSet.setVertex(n3, pdVectorArray[j].getEntry(0), d3 * pdVectorArray[j].getEntry(1), d4 * pdVectorArray[j].getEntry(1));
                ++n3;
            }
            d += d2;
        }
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        double d;
        PdVector pdVector = pvPickEvent.getViewBase();
        double d2 = pdVector.getEntry(0);
        double d3 = pdVector.getEntry(1);
        double d4 = this.m_a.getValue();
        if (d2 * d2 / d4 / d4 + d3 * d3 / (d = this.m_b.getValue()) / d <= 1.0) {
            this.m_start.set(d2, d3);
            this.compute();
            this.m_poly.update(null);
            this.m_ellipse.update(null);
            this.m_rolled.update(null);
            this.m_unrolled.update(null);
            this.m_focus.update(null);
        }
    }

    public void dragInitial(PvPickEvent pvPickEvent) {
        this.pickInitial(pvPickEvent);
    }

    public boolean update(Object object) {
        PsDebug.notify((String)"PjEllipse.update() called");
        if (object == this.m_firstDir) {
            this.compute();
            this.m_poly.update(null);
            this.m_ellipse.update(null);
            this.m_rolled.update(null);
            this.m_focus.update(null);
            this.m_unrolled.update(null);
            this.m_rotated.update(null);
            if (this.getDisplay() != null && this.m_autofit) {
                this.getDisplay().fit();
            }
            return true;
        }
        if (object == this.m_rotdiscr) {
            this.compute();
            this.m_poly.update(null);
            this.m_ellipse.update(null);
            this.m_rolled.update(null);
            this.m_focus.update(null);
            this.m_unrolled.update(null);
            this.m_rotated.update(null);
            return true;
        }
        if (object == this.m_steps) {
            this.compute();
            this.m_poly.update(null);
            this.m_ellipse.update(null);
            this.m_rolled.update(null);
            this.m_focus.update(null);
            this.m_unrolled.update(null);
            this.m_rotated.update(null);
            if (this.getDisplay() != null && this.m_autofit) {
                this.getDisplay().fit();
            }
            return true;
        }
        if (object == this.m_a) {
            this.fixInitialPointWithA();
            this.compute();
            this.m_poly.update(null);
            this.m_ellipse.update(null);
            this.m_rolled.update(null);
            this.m_focus.update(null);
            this.m_rotated.update(null);
            this.m_unrolled.update(null);
            if (this.getDisplay() != null && this.m_autofit) {
                this.getDisplay().fit();
            }
            return true;
        }
        if (object == this.m_b) {
            this.fixInitialPointWithB();
            this.compute();
            this.m_poly.update(null);
            this.m_ellipse.update(null);
            this.m_rolled.update(null);
            this.m_focus.update(null);
            this.m_unrolled.update(null);
            this.m_rotated.update(null);
            if (this.getDisplay() != null && this.m_autofit) {
                this.getDisplay().fit();
            }
            return true;
        }
        return false;
    }

    public void fixInitialPointWithB() {
        double d;
        double d2 = this.m_a.getValue();
        double d3 = this.m_b.getValue();
        double d4 = this.m_start.getEntry(0);
        if (d4 * d4 / d2 / d2 + (d = this.m_start.getEntry(1)) * d / d3 / d3 >= 1.0 && d4 * d4 / d2 / d2 <= 1.0) {
            this.m_start.set(d4, d3 * Math.sqrt(1.0 - d4 * d4 / d2 / d2));
        } else if (d4 * d4 / d2 / d2 + d * d / d3 / d3 >= 1.0) {
            this.m_start.set(d2 * Math.sqrt(1.0 - d * d / d3 / d3), d);
        }
    }

    public void fixInitialPointWithA() {
        double d;
        double d2 = this.m_a.getValue();
        double d3 = this.m_b.getValue();
        double d4 = this.m_start.getEntry(0);
        if (d4 * d4 / d2 / d2 + (d = this.m_start.getEntry(1)) * d / d3 / d3 >= 1.0 && d * d / d3 / d3 <= 1.0) {
            this.m_start.set(d2 * Math.sqrt(1.0 - d * d / d3 / d3), d);
        } else if (d4 * d4 / d2 / d2 + d * d / d3 / d3 >= 1.0) {
            this.m_start.set(d4, d3 * Math.sqrt(1.0 - d4 * d4 / d2 / d2));
        }
    }

    public void showBillard() {
        this.m_poly.setVisible(true);
        this.m_ellipse.setVisible(true);
        this.m_focus.setVisible(true);
        this.m_rolled.setVisible(false);
        this.m_unrolled.setVisible(false);
        this.m_rotated.setVisible(false);
        this.m_poly.update(null);
        this.m_ellipse.update(null);
        this.m_rolled.update(null);
        this.m_unrolled.update(null);
        this.m_rotated.update(null);
        this.m_focus.update(null);
        PvDisplayIf pvDisplayIf = this.getDisplay();
        if (pvDisplayIf != null) {
            pvDisplayIf.selectCamera(1);
            pvDisplayIf.setMajorMode(6);
            if (this.m_autofit) {
                pvDisplayIf.fit();
            }
        }
    }

    public void showUnrolled() {
        this.m_poly.setVisible(false);
        this.m_ellipse.setVisible(false);
        this.m_focus.setVisible(false);
        this.m_rolled.setVisible(true);
        this.m_unrolled.setVisible(true);
        this.m_rotated.setVisible(false);
        this.m_poly.update(null);
        this.m_ellipse.update(null);
        this.m_rolled.update(null);
        this.m_unrolled.update(null);
        this.m_rotated.update(null);
        this.m_focus.update(null);
        PvDisplayIf pvDisplayIf = this.getDisplay();
        if (pvDisplayIf != null) {
            pvDisplayIf.selectCamera(1);
            pvDisplayIf.setMajorMode(3);
            if (this.m_autofit) {
                pvDisplayIf.fit();
            }
        }
    }

    public void showSurface() {
        this.m_poly.setVisible(false);
        this.m_ellipse.setVisible(false);
        this.m_focus.setVisible(false);
        this.m_rolled.setVisible(false);
        this.m_unrolled.setVisible(false);
        this.m_rotated.setVisible(true);
        this.m_poly.update(null);
        this.m_ellipse.update(null);
        this.m_rolled.update(null);
        this.m_unrolled.update(null);
        this.m_rotated.update(null);
        this.m_focus.update(null);
        PvDisplayIf pvDisplayIf = this.getDisplay();
        if (pvDisplayIf != null) {
            pvDisplayIf.selectCamera(0);
            pvDisplayIf.setMajorMode(0);
            if (this.m_autofit) {
                pvDisplayIf.fit();
            }
        }
    }

    public void setAutoFit(boolean bl) {
        this.m_autofit = bl;
        if (this.getDisplay() != null && this.m_autofit) {
            this.getDisplay().fit();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

