/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.Color;
import jv.object.PsDebug;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;

final class PvGrid
extends PgJvxSrc {
    protected int m_gridOrient;
    protected PdVector m_increments;
    protected double m_uMin = -20.0;
    protected double m_vMin = -20.0;
    protected double m_wMin = -20.0;
    protected double m_uMax = 20.0;
    protected double m_vMax = 20.0;
    protected double m_wMax = 20.0;
    private PdVector m_uDir;
    private PdVector m_vDir;
    private PdVector m_normal;

    public PvGrid(int n) {
        super(n);
        this.setType(33);
        this.setState(151, true);
        this.m_uDir = new PdVector(3);
        this.m_vDir = new PdVector(3);
        this.m_normal = new PdVector(3);
        this.m_increments = new PdVector(2.0, 2.0);
        this.init();
    }

    public void init() {
        super.init();
        this.setGridOrientation(0);
        this.setGlobalVertexColor(Color.blue);
        this.setGlobalEdgeColor(new Color(161, 161, 161));
        this.setGlobalElementColor(Color.white);
        this.showElements(false);
    }

    public PdVector getGridIncrements() {
        return this.m_increments;
    }

    public void setGridIncrements(PdVector pdVector) {
        this.m_increments.copy(pdVector);
    }

    public int getGridOrientation() {
        return this.m_gridOrient;
    }

    public void setGridOrientation(int n) {
        switch (n) {
            case 0: {
                this.m_uDir.set(1.0, 0.0, 0.0);
                this.m_vDir.set(0.0, 1.0, 0.0);
                this.m_normal.set(0.0, 0.0, 1.0);
                break;
            }
            case 1: {
                this.m_uDir.set(0.0, 1.0, 0.0);
                this.m_vDir.set(0.0, 0.0, 1.0);
                this.m_normal.set(1.0, 0.0, 0.0);
                break;
            }
            case 2: {
                this.m_uDir.set(1.0, 0.0, 0.0);
                this.m_vDir.set(0.0, 0.0, 1.0);
                this.m_normal.set(0.0, -1.0, 0.0);
                break;
            }
            default: {
                PsDebug.warning("grid orientation out of bounds, orient = " + n);
                return;
            }
        }
        this.m_gridOrient = n;
    }

    public void compute() {
        double d = this.m_increments.getEntry(0);
        double d2 = this.m_increments.getEntry(1);
        double d3 = this.m_uMin;
        double d4 = this.m_vMin;
        double d5 = this.m_uMax;
        double d6 = this.m_vMax;
        int n = 1 + (int)Math.ceil((d5 - d3) / d);
        int n2 = 1 + (int)Math.ceil((d6 - d4) / d2);
        this.setNumVertices(n * n2);
        int n3 = 0;
        double d7 = d3;
        for (int i = 0; i < n; ++i) {
            double d8 = d4;
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < this.m_dim; ++k) {
                    this.m_vertex[n3].m_data[k] = d7 * this.m_uDir.m_data[k] + d8 * this.m_vDir.m_data[k];
                }
                ++n3;
                d8 += d2;
                if (j != n2 - 1) continue;
                d8 = Math.min(d8, d6);
            }
            d7 += d;
            if (i != n - 1) continue;
            d7 = Math.min(d7, d5);
        }
        this.makeQuadrConn(n, n2, false, false);
        this.assureVertexNormals();
        PdVector.setConstant(this.m_vertexNormal, this.m_normal);
    }
}

