/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.io.Serializable;
import jv.object.PsDebug;
import jv.vecmath.PdVector;

public class PuComplex
implements Cloneable,
Serializable {
    public static final PuComplex ZERO = new PuComplex(0.0, 0.0);
    public static final PuComplex ONE = new PuComplex(1.0, 0.0);
    public static final PuComplex I = new PuComplex(0.0, 1.0);
    public static final PuComplex NEG_ONE = new PuComplex(-1.0, 0.0);
    public static final PuComplex NEG_I = new PuComplex(0.0, -1.0);
    public static final PuComplex PI_OVER_4 = new PuComplex(0.7071067811865476, 0.7071067811865476);
    public static final PuComplex PI3_OVER_4 = new PuComplex(-0.7071067811865476, 0.7071067811865476);
    public static final PuComplex PI5_OVER_4 = new PuComplex(-0.7071067811865476, -0.7071067811865476);
    public static final PuComplex PI7_OVER_4 = new PuComplex(0.7071067811865476, -0.7071067811865476);
    public double re = 0.0;
    public double im = 0.0;

    public PuComplex() {
    }

    public PuComplex(double d) {
        this.re = d;
        this.im = 0.0;
    }

    public PuComplex(PuComplex puComplex) {
        this.re = puComplex.re;
        this.im = puComplex.im;
    }

    public PuComplex(double d, double d2) {
        this.re = d;
        this.im = d2;
    }

    public PuComplex set(double d, double d2) {
        this.re = d;
        this.im = d2;
        return this;
    }

    public PuComplex set(PdVector pdVector) {
        if (pdVector == null || pdVector.getSize() < 2) {
            PsDebug.warning("missing or wrong length of argument vector");
            return this;
        }
        this.re = pdVector.getEntry(0);
        this.im = pdVector.getEntry(1);
        return this;
    }

    public PuComplex copy(PuComplex puComplex) {
        this.re = puComplex.re;
        this.im = puComplex.im;
        return this;
    }

    public String toString() {
        String string = this.im + "*i";
        if (this.im == 1.0) {
            string = "i";
        } else if (this.im == -1.0) {
            string = "-i";
        } else if (this.im == 0.0) {
            return "" + this.re;
        }
        if (this.re == 0.0) {
            return string;
        }
        if (string.charAt(0) == '-') {
            return this.re + string;
        }
        return this.re + "+" + string;
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.re) || Double.isInfinite(this.im);
    }

    public boolean isNaN() {
        return Double.isNaN(this.re) || Double.isNaN(this.im);
    }

    public static boolean equals(PuComplex puComplex, PuComplex puComplex2, double d) {
        return Math.abs(puComplex.re - puComplex2.re) < d && Math.abs(puComplex.im - puComplex2.im) < d;
    }

    public boolean equals(PuComplex puComplex, double d) {
        return PuComplex.equals(this, puComplex, d);
    }

    public static PuComplex add(PuComplex puComplex, PuComplex puComplex2) {
        PuComplex puComplex3 = new PuComplex();
        puComplex3.re = puComplex.re + puComplex2.re;
        puComplex3.im = puComplex.im + puComplex2.im;
        return puComplex3;
    }

    public PuComplex add(PuComplex puComplex) {
        this.re += puComplex.re;
        this.im += puComplex.im;
        return this;
    }

    public static PuComplex add(PuComplex puComplex, double d) {
        PuComplex puComplex2 = new PuComplex();
        puComplex2.re = puComplex.re + d;
        puComplex2.im = puComplex.im;
        return puComplex2;
    }

    public PuComplex add(double d) {
        this.re += d;
        return this;
    }

    public static PuComplex sub(PuComplex puComplex, PuComplex puComplex2) {
        PuComplex puComplex3 = new PuComplex();
        puComplex3.re = puComplex.re - puComplex2.re;
        puComplex3.im = puComplex.im - puComplex2.im;
        return puComplex3;
    }

    public PuComplex sub(PuComplex puComplex) {
        this.re -= puComplex.re;
        this.im -= puComplex.im;
        return this;
    }

    public static PuComplex sub(PuComplex puComplex, double d) {
        PuComplex puComplex2 = new PuComplex();
        puComplex2.re = puComplex.re - d;
        puComplex2.im = puComplex.im;
        return puComplex2;
    }

    public PuComplex sub(double d) {
        this.re -= d;
        return this;
    }

    public static PuComplex mult(PuComplex puComplex, PuComplex puComplex2) {
        PuComplex puComplex3 = new PuComplex();
        puComplex3.re = puComplex.re * puComplex2.re - puComplex.im * puComplex2.im;
        puComplex3.im = puComplex.re * puComplex2.im + puComplex.im * puComplex2.re;
        return puComplex3;
    }

    public PuComplex mult(PuComplex puComplex) {
        double d = this.re;
        double d2 = this.im;
        this.re = d * puComplex.re - d2 * puComplex.im;
        this.im = d * puComplex.im + d2 * puComplex.re;
        return this;
    }

    public static PuComplex mult(PuComplex puComplex, double d) {
        PuComplex puComplex2 = new PuComplex();
        puComplex2.re = puComplex.re * d;
        puComplex2.im = puComplex.im * d;
        return puComplex2;
    }

    public PuComplex mult(double d) {
        this.re *= d;
        this.im *= d;
        return this;
    }

    public static PuComplex div(PuComplex puComplex, PuComplex puComplex2) {
        PuComplex puComplex3 = new PuComplex();
        double d = puComplex2.re * puComplex2.re + puComplex2.im * puComplex2.im;
        if (d == 0.0) {
            PsDebug.warning("divide by zero");
            puComplex3.re = puComplex.re > 0.0 ? Double.POSITIVE_INFINITY : (puComplex.re < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            puComplex3.im = puComplex.im > 0.0 ? Double.POSITIVE_INFINITY : (puComplex.im < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            return puComplex3;
        }
        puComplex3.re = (puComplex.re * puComplex2.re + puComplex.im * puComplex2.im) / d;
        puComplex3.im = (puComplex.im * puComplex2.re - puComplex.re * puComplex2.im) / d;
        return puComplex3;
    }

    public static PuComplex div(double d, PuComplex puComplex) {
        PuComplex puComplex2 = new PuComplex();
        double d2 = puComplex.re * puComplex.re + puComplex.im * puComplex.im;
        if (d2 == 0.0) {
            PsDebug.warning("divide by zero");
            puComplex2.re = d > 0.0 ? Double.POSITIVE_INFINITY : (d < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            puComplex2.im = Double.NaN;
            return puComplex2;
        }
        puComplex2.re = d * puComplex.re / d2;
        puComplex2.im = -d * puComplex.im / d2;
        return puComplex2;
    }

    public PuComplex div(PuComplex puComplex) {
        double d = this.re;
        double d2 = this.im;
        double d3 = puComplex.re * puComplex.re + puComplex.im * puComplex.im;
        if (d3 == 0.0) {
            PsDebug.warning("divide by zero");
            this.re = this.re > 0.0 ? Double.POSITIVE_INFINITY : (this.re < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            this.im = this.im > 0.0 ? Double.POSITIVE_INFINITY : (this.im < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            return this;
        }
        this.re = (d * puComplex.re + d2 * puComplex.im) / d3;
        this.im = (d2 * puComplex.re - d * puComplex.im) / d3;
        return this;
    }

    public static PuComplex div(PuComplex puComplex, double d) {
        PuComplex puComplex2 = new PuComplex();
        if (d == 0.0) {
            PsDebug.warning("divide by zero");
            puComplex2.re = puComplex.re > 0.0 ? Double.POSITIVE_INFINITY : (puComplex.re < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            puComplex2.im = puComplex.im > 0.0 ? Double.POSITIVE_INFINITY : (puComplex.im < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            return puComplex2;
        }
        puComplex2.re = puComplex.re / d;
        puComplex2.im = puComplex.im / d;
        return puComplex2;
    }

    public PuComplex div(double d) {
        if (d == 0.0) {
            PsDebug.warning("divide by zero");
            this.re = this.re > 0.0 ? Double.POSITIVE_INFINITY : (this.re < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            this.im = this.im > 0.0 ? Double.POSITIVE_INFINITY : (this.im < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            return this;
        }
        this.re /= d;
        this.im /= d;
        return this;
    }

    public static PuComplex sqr(PuComplex puComplex) {
        PuComplex puComplex2 = new PuComplex();
        puComplex2.re = puComplex.re * puComplex.re - puComplex.im * puComplex.im;
        puComplex2.im = 2.0 * puComplex.re * puComplex.im;
        return puComplex2;
    }

    public PuComplex sqr() {
        double d = this.re;
        double d2 = this.im;
        this.re = d * d - d2 * d2;
        this.im = 2.0 * d * d2;
        return this;
    }

    public static PuComplex cube(PuComplex puComplex) {
        PuComplex puComplex2 = new PuComplex();
        puComplex2.re = puComplex.re * (puComplex.re * puComplex.re - 3.0 * puComplex.im * puComplex.im);
        puComplex2.im = puComplex.im * (3.0 * puComplex.re * puComplex.re - puComplex.im * puComplex.im);
        return puComplex2;
    }

    public PuComplex cube() {
        double d = this.re;
        double d2 = this.im;
        this.re = d * (d * d - 3.0 * d2 * d2);
        this.im = d2 * (3.0 * d * d - d2 * d2);
        return this;
    }

    public static double abs(PuComplex puComplex) {
        return puComplex.abs();
    }

    public double abs() {
        return Math.sqrt(this.re * this.re + this.im * this.im);
    }

    public double sqrAbs() {
        return this.re * this.re + this.im * this.im;
    }

    public static PuComplex inv(PuComplex puComplex) {
        double d = puComplex.re * puComplex.re + puComplex.im * puComplex.im;
        if (d == 0.0) {
            PsDebug.warning("divide by zero");
            return new PuComplex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        PuComplex puComplex2 = new PuComplex();
        puComplex2.re = puComplex.re / d;
        puComplex2.im = -puComplex.im / d;
        return puComplex2;
    }

    public PuComplex inv() {
        double d = this.re * this.re + this.im * this.im;
        if (d == 0.0) {
            PsDebug.warning("divide by zero");
            this.re = Double.POSITIVE_INFINITY;
            this.im = Double.POSITIVE_INFINITY;
            return this;
        }
        this.re /= d;
        this.im /= -d;
        return this;
    }

    public static double re(PuComplex puComplex) {
        return puComplex.re;
    }

    public double re() {
        return this.re;
    }

    public static double im(PuComplex puComplex) {
        return puComplex.im;
    }

    public double im() {
        return this.im;
    }

    public static PuComplex conj(PuComplex puComplex) {
        return new PuComplex(puComplex.re, -puComplex.im);
    }

    public PuComplex conj() {
        this.im = -this.im;
        return this;
    }

    public static PuComplex neg(PuComplex puComplex) {
        return new PuComplex(-puComplex.re, -puComplex.im);
    }

    public PuComplex neg() {
        this.re = -this.re;
        this.im = -this.im;
        return this;
    }

    public static PuComplex rotJ(PuComplex puComplex) {
        return new PuComplex(-puComplex.im, puComplex.re);
    }

    public PuComplex rotJ() {
        double d = this.re;
        this.re = -this.im;
        this.im = d;
        return this;
    }

    public static PuComplex rot(PuComplex puComplex, double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = puComplex.re * d2 - puComplex.im * d3;
        double d5 = puComplex.re * d3 + puComplex.im * d2;
        return new PuComplex(d4, d5);
    }

    public PuComplex rot(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = this.re;
        this.re = this.re * d2 - this.im * d3;
        this.im = d4 * d3 + this.im * d2;
        return this;
    }

    public static double arg(PuComplex puComplex) {
        if (Math.abs(puComplex.re) > Math.abs(puComplex.im)) {
            double d = Math.atan(puComplex.im / puComplex.re);
            if (puComplex.re > 0.0) {
                return puComplex.im >= 0.0 ? d : d + Math.PI * 2;
            }
            return d + Math.PI;
        }
        if (puComplex.im == 0.0) {
            return 0.0;
        }
        double d = Math.atan(puComplex.re / puComplex.im);
        if (puComplex.im > 0.0) {
            return 1.5707963267948966 - d;
        }
        return 4.71238898038469 - d;
    }

    public double arg() {
        return PuComplex.arg(this);
    }

    public static double argPB(PuComplex puComplex) {
        double d = PuComplex.arg(puComplex);
        if (d > Math.PI) {
            d -= Math.PI * 2;
        }
        return d;
    }

    public double argPB() {
        return PuComplex.argPB(this);
    }

    public static PuComplex polarToRect(double d, double d2) {
        PuComplex puComplex = new PuComplex();
        puComplex.re = d * Math.cos(d2);
        puComplex.im = d * Math.sin(d2);
        return puComplex;
    }

    public static PuComplex exp(PuComplex puComplex) {
        PuComplex puComplex2 = new PuComplex();
        double d = Math.exp(puComplex.re);
        puComplex2.re = d * Math.cos(puComplex.im);
        puComplex2.im = d * Math.sin(puComplex.im);
        return puComplex2;
    }

    public static PuComplex exp_self(PuComplex puComplex) {
        return puComplex.exp();
    }

    public PuComplex exp() {
        double d = Math.exp(this.re);
        this.re = d * Math.cos(this.im);
        this.im = d * Math.sin(this.im);
        return this;
    }

    public static PuComplex log(PuComplex puComplex) {
        PuComplex puComplex2 = new PuComplex(puComplex);
        return puComplex2.log();
    }

    public PuComplex log() {
        if (this.abs() == 0.0) {
            PsDebug.warning("log(0) error");
            this.re = Double.NEGATIVE_INFINITY;
            this.im = 0.0;
            return this;
        }
        double d = Math.log(this.abs());
        double d2 = this.arg();
        this.re = d;
        this.im = d2;
        return this;
    }

    public static PuComplex logPB(PuComplex puComplex) {
        PuComplex puComplex2 = new PuComplex(puComplex);
        return puComplex2.logPB();
    }

    public PuComplex logPB() {
        if (this.abs() == 0.0) {
            PsDebug.warning("log(0) error");
            this.re = Double.NEGATIVE_INFINITY;
            this.im = 0.0;
            return this;
        }
        double d = Math.log(this.abs());
        double d2 = this.argPB();
        this.re = d;
        this.im = d2;
        return this;
    }

    public static PuComplex sqrt(PuComplex puComplex) {
        return PuComplex.polarToRect(Math.sqrt(puComplex.abs()), puComplex.arg() / 2.0);
    }

    public PuComplex sqrt() {
        double d = Math.sqrt(this.abs());
        double d2 = this.arg() / 2.0;
        this.re = d * Math.cos(d2);
        this.im = d * Math.sin(d2);
        return this;
    }

    public static PuComplex pow(PuComplex puComplex, PuComplex puComplex2) {
        if (puComplex.abs() == 0.0) {
            PsDebug.warning("PuComplex.pow(0,*) called.");
            return ZERO;
        }
        return PuComplex.exp(PuComplex.mult(puComplex2, PuComplex.log(puComplex)));
    }

    public static PuComplex pow(PuComplex puComplex, double d) {
        if (puComplex.abs() == 0.0) {
            PsDebug.warning("PuComplex.pow(0,*) called.");
            return ZERO;
        }
        double d2 = d * Math.log(puComplex.abs());
        double d3 = d * puComplex.arg();
        double d4 = Math.exp(d2);
        PuComplex puComplex2 = new PuComplex(d4 * Math.cos(d3), d4 * Math.sin(d3));
        return puComplex2;
    }

    public PuComplex pow(double d) {
        if (this.abs() == 0.0) {
            PsDebug.warning("PuComplex.pow(0,*) called.");
            return ZERO;
        }
        double d2 = d * Math.log(this.abs());
        double d3 = d * this.arg();
        double d4 = Math.exp(d2);
        this.re = d4 * Math.cos(d3);
        this.im = d4 * Math.sin(d3);
        return this;
    }

    public static PuComplex pow(PuComplex puComplex, int n) {
        boolean bl;
        if (puComplex.abs() == 0.0) {
            PsDebug.warning("PuComplex.pow(0,*) called.");
            return ZERO;
        }
        if (n == 0) {
            return ONE;
        }
        boolean bl2 = bl = n < 0;
        if (bl) {
            n = -n;
        }
        PuComplex puComplex2 = new PuComplex(puComplex);
        for (int i = 1; i < n; ++i) {
            double d = puComplex2.re * puComplex.re - puComplex2.im * puComplex.im;
            puComplex2.im = puComplex2.im * puComplex.re + puComplex2.re * puComplex.im;
            puComplex2.re = d;
        }
        if (bl) {
            double d = puComplex2.re * puComplex2.re + puComplex2.im * puComplex2.im;
            puComplex2.re /= d;
            puComplex2.im /= -d;
        }
        return puComplex2;
    }

    public static PuComplex sin(PuComplex puComplex) {
        PuComplex puComplex2 = new PuComplex(puComplex);
        puComplex2.sin();
        return puComplex2;
    }

    public PuComplex sin() {
        double d = Math.sin(this.re) * (Math.exp(this.im) + Math.exp(-this.im)) / 2.0;
        double d2 = Math.cos(this.re) * (Math.exp(this.im) - Math.exp(-this.im)) / 2.0;
        this.re = d;
        this.im = d2;
        return this;
    }

    public static PuComplex cos(PuComplex puComplex) {
        PuComplex puComplex2 = new PuComplex(puComplex);
        puComplex2.cos();
        return puComplex2;
    }

    public PuComplex cos() {
        double d = Math.cos(this.re) * (Math.exp(this.im) + Math.exp(-this.im)) / 2.0;
        double d2 = Math.sin(this.re) * (-Math.exp(this.im) + Math.exp(-this.im)) / 2.0;
        this.re = d;
        this.im = d2;
        return this;
    }

    public static PuComplex tan(PuComplex puComplex) {
        PuComplex puComplex2 = PuComplex.sin(puComplex);
        PuComplex puComplex3 = PuComplex.cos(puComplex);
        return puComplex2.div(puComplex3);
    }

    public PuComplex tan() {
        PuComplex puComplex = PuComplex.cos(this);
        this.sin();
        this.div(puComplex);
        return this;
    }

    public static PuComplex cot(PuComplex puComplex) {
        PuComplex puComplex2 = PuComplex.sin(puComplex);
        PuComplex puComplex3 = PuComplex.cos(puComplex);
        return puComplex3.div(puComplex2);
    }

    public PuComplex cot() {
        PuComplex puComplex = PuComplex.sin(this);
        this.cos();
        this.div(puComplex);
        return this;
    }

    public static PuComplex sinh(PuComplex puComplex) {
        PuComplex puComplex2 = new PuComplex(puComplex);
        puComplex2.sinh();
        return puComplex2;
    }

    public PuComplex sinh() {
        double d = Math.cos(this.im) * (Math.exp(this.re) - Math.exp(-this.re)) / 2.0;
        double d2 = Math.sin(this.im) * (Math.exp(this.re) + Math.exp(-this.re)) / 2.0;
        this.re = d;
        this.im = d2;
        return this;
    }

    public static PuComplex cosh(PuComplex puComplex) {
        PuComplex puComplex2 = new PuComplex(puComplex);
        puComplex2.cosh();
        return puComplex2;
    }

    public PuComplex cosh() {
        double d = Math.cos(this.im) * (Math.exp(this.re) + Math.exp(-this.re)) / 2.0;
        double d2 = Math.sin(this.im) * (Math.exp(this.re) - Math.exp(-this.re)) / 2.0;
        this.re = d;
        this.im = d2;
        return this;
    }

    public static PuComplex tanh(PuComplex puComplex) {
        PuComplex puComplex2 = PuComplex.sinh(puComplex);
        PuComplex puComplex3 = PuComplex.cosh(puComplex);
        return puComplex2.div(puComplex3);
    }

    public PuComplex tanh() {
        PuComplex puComplex = PuComplex.cosh(this);
        this.sinh();
        this.div(puComplex);
        return this;
    }

    public static PuComplex coth(PuComplex puComplex) {
        PuComplex puComplex2 = PuComplex.sinh(puComplex);
        PuComplex puComplex3 = PuComplex.cosh(puComplex);
        return puComplex3.div(puComplex2);
    }

    public PuComplex coth() {
        PuComplex puComplex = PuComplex.sinh(this);
        this.cosh();
        this.div(puComplex);
        return this;
    }

    public static PuComplex blend(double d, PuComplex puComplex, double d2, PuComplex puComplex2) {
        if (puComplex == null || puComplex2 == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PuComplex puComplex3 = new PuComplex();
        puComplex3.re = d * puComplex.re + d2 * puComplex2.re;
        puComplex3.im = d * puComplex.im + d2 * puComplex2.im;
        return puComplex3;
    }

    public static PuComplex moebius(PuComplex puComplex, PuComplex puComplex2, PuComplex puComplex3, PuComplex puComplex4, PuComplex puComplex5) {
        double d = puComplex.re * puComplex5.re - puComplex.im * puComplex5.im + puComplex2.re;
        double d2 = puComplex.im * puComplex5.re + puComplex.re * puComplex5.im + puComplex2.im;
        double d3 = puComplex3.re * puComplex5.re - puComplex3.im * puComplex5.im + puComplex4.re;
        double d4 = puComplex3.im * puComplex5.re + puComplex3.re * puComplex5.im + puComplex4.im;
        double d5 = d3 * d3 + d4 * d4;
        if (d5 == 0.0) {
            PsDebug.warning("division by zero.");
            return ZERO;
        }
        PuComplex puComplex6 = new PuComplex((d * d3 + d2 * d4) / d5, (d2 * d3 - d * d4) / d5);
        return puComplex6;
    }

    public static PuComplex moebius(double d, double d2, double d3, double d4, PuComplex puComplex) {
        double d5 = d * puComplex.re + d2;
        double d6 = d * puComplex.im;
        double d7 = d3 * puComplex.re + d4;
        double d8 = d3 * puComplex.im;
        double d9 = d7 * d7 + d8 * d8;
        if (d9 == 0.0) {
            PsDebug.warning("division by zero.");
            return ZERO;
        }
        PuComplex puComplex2 = new PuComplex((d5 * d7 + d6 * d8) / d9, (d6 * d7 - d5 * d8) / d9);
        return puComplex2;
    }
}

