/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import jv.object.PsConfig;
import jv.object.PsDebug;

public class PgFileDialog
extends FileDialog {
    protected String m_ext = null;

    public PgFileDialog(Frame frame, String string, int n) {
        super(frame, string, n);
        this.setDirectory(PsConfig.getCodeBase());
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            ((Component)this).hide();
        } else {
            this.show();
        }
    }

    public void show() {
        if (this.getFile() == null) {
            if (this.m_ext != null) {
                super.setFile("*." + this.m_ext);
            } else {
                super.setFile("*.*");
            }
        }
        super.show();
    }

    public boolean isFileSelected() {
        return this.getDirectory() != null && this.getFile() != null;
    }

    public String getFullFileName() {
        String string = this.getFile();
        if (string == null) {
            return null;
        }
        String string2 = this.getDirectory();
        if (string2 == null) {
            return null;
        }
        String string3 = string2 + string;
        return string3.trim();
    }

    public void setExtension(String string) {
        this.m_ext = string;
    }

    public File openFile() {
        if (this.getDirectory() == null || this.getFile() == null) {
            PsDebug.warning("missing dir or file name");
            return null;
        }
        try {
            File file = PsConfig.isApplication() ? new File(this.getDirectory() + this.getFile()) : new File(this.getFile());
            return file;
        }
        catch (Exception exception) {
            PsDebug.warning("could not open file = " + this.getFile() + " in directory = " + this.getDirectory());
            return null;
        }
    }
}

