/*
 * Decompiled with CFR 0.152.
 */
package jvx.surface;

import jv.function.PuFunction;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jvx.surface.PgDomainDescr;

public class PgParmSurface
extends PgElementSet {
    protected PgDomainDescr m_domainDescr;
    protected PuFunction m_function;
    protected PgElementSet m_surface;
    protected boolean m_bIsUpdateSender = false;
    static /* synthetic */ Class class$jvx$surface$PgParmSurface;

    public PgParmSurface() {
        this(3);
    }

    public PgParmSurface(int n) {
        super(n);
        this.setTag(10);
        int n2 = 2;
        this.m_domainDescr = new PgDomainDescr(n2);
        this.m_domainDescr.setParent((PsUpdateIf)this);
        this.m_domainDescr.setName(PsConfig.getMessage((int)15030));
        this.m_domainDescr.setMaxSize(-10.0, -10.0, 10.0, 10.0);
        this.m_domainDescr.setSize(-5.0, -5.0, 5.0, 5.0);
        this.m_domainDescr.setDiscr(20, 20);
        this.m_function = new PuFunction(n2, n);
        this.m_function.setParent((PsUpdateIf)this);
        this.m_function.setName(PsConfig.getMessage((int)15044));
        this.m_function.setExpression(0, "u");
        this.m_function.setExpression(1, "v");
        this.m_function.setExpression(2, "sin(u)*cos(v)");
        if (((Object)((Object)this)).getClass() == (class$jvx$surface$PgParmSurface == null ? (class$jvx$surface$PgParmSurface = PgParmSurface.class$("jvx.surface.PgParmSurface")) : class$jvx$surface$PgParmSurface)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_domainDescr.init();
        this.m_function.init();
    }

    public Object clone() {
        PgParmSurface pgParmSurface = (PgParmSurface)((Object)super.clone());
        if (pgParmSurface == null) {
            return null;
        }
        pgParmSurface.m_domainDescr = (PgDomainDescr)((Object)this.m_domainDescr.clone());
        pgParmSurface.m_domainDescr.addUpdateListener((PsUpdateIf)pgParmSurface);
        pgParmSurface.m_function = (PuFunction)this.m_function.clone();
        pgParmSurface.m_function.setParent((PsUpdateIf)pgParmSurface);
        return pgParmSurface;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (!(psObject instanceof PgParmSurface)) {
            return;
        }
        PgParmSurface pgParmSurface = (PgParmSurface)psObject;
        this.m_domainDescr.copy(pgParmSurface.m_domainDescr);
        this.m_function.copy((PsObject)pgParmSurface.m_function);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgParmSurface *********\n");
        stringBuffer.append(this.m_domainDescr.toString());
        stringBuffer.append(this.m_function.toString());
        return stringBuffer.toString();
    }

    public boolean update(Object object) {
        PsDebug.notify((String)"called");
        if (this.m_bIsUpdateSender) {
            return true;
        }
        if (object == null) {
            return super.update(null);
        }
        if (object == this || object == this.getInfoPanel()) {
            this.compute();
            this.m_bIsUpdateSender = true;
            this.m_domainDescr.updatePanels((Object)this.m_domainDescr);
            this.m_function.updatePanels((Object)this.m_function);
            this.m_bIsUpdateSender = false;
            return super.update(object);
        }
        if (object == this.m_domainDescr) {
            return this.update((Object)this);
        }
        if (object == this.m_function) {
            return this.update((Object)this);
        }
        return super.update(object);
    }

    public PgDomainDescr getDomainDescr() {
        return this.m_domainDescr;
    }

    public boolean setDomainDescr(PgDomainDescr pgDomainDescr) {
        if (pgDomainDescr == null) {
            PsDebug.warning((String)"missing domainDescr.");
            return false;
        }
        this.m_domainDescr.copy(pgDomainDescr);
        return true;
    }

    public PuFunction getFunctionExpr() {
        return this.m_function;
    }

    public boolean setFunctionExpr(PuFunction puFunction) {
        if (puFunction == null) {
            PsDebug.warning((String)"missing function.");
            return false;
        }
        if (puFunction.getNumFunctions() != this.getDimOfVertices()) {
            PsDebug.warning((String)"number of functions differs from dimension of vertices.");
            return false;
        }
        this.m_function.copy((PsObject)puFunction);
        return true;
    }

    public PgDomainDescr getDomain() {
        return this.m_domainDescr;
    }

    public boolean setDomain(PgDomainDescr pgDomainDescr) {
        if (pgDomainDescr == null) {
            if (this.m_domainDescr != null) {
                this.m_domainDescr.removeUpdateListener((PsUpdateIf)this);
                this.m_domainDescr = null;
            }
            return false;
        }
        this.m_domainDescr = pgDomainDescr;
        this.m_domainDescr.addUpdateListener((PsUpdateIf)this);
        return true;
    }

    public PuFunction getFunction() {
        return this.m_function;
    }

    public boolean setFunction(PuFunction puFunction) {
        if (puFunction == null) {
            if (this.m_function != null) {
                this.m_function.removeUpdateListener((PsUpdateIf)this);
                this.m_function = null;
            }
            return false;
        }
        if (puFunction.getNumFunctions() != this.getDimOfVertices()) {
            PsDebug.warning((String)"number of functions different than dimension of vertices.");
            return false;
        }
        this.m_function = puFunction;
        this.m_function.addUpdateListener((PsUpdateIf)this);
        return true;
    }

    public boolean setSurface(PgElementSet pgElementSet) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing surface");
            return false;
        }
        this.m_surface = pgElementSet;
        return true;
    }

    public void compute() {
        int n = this.m_domainDescr.getNumULines();
        int n2 = this.m_domainDescr.getNumVLines();
        this.setNumVertices(n * n2);
        double[] dArray = new double[2];
        PdVector pdVector = new PdVector(((PgGeometry)this).m_dim);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.m_domainDescr.eval(dArray, i, j);
                this.m_function.eval(pdVector.m_data, dArray);
                this.setVertex(n3, pdVector);
                ++n3;
            }
        }
        this.setDimOfElements(4);
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
        this.makeElementNormals();
        this.makeVertexNormals();
        if (this.hasVertexTextures()) {
            this.makeVertexTextureFromUV();
        }
        if (this.m_surface != null) {
            this.m_surface.copy((PsObject)this);
        }
    }

    public boolean computeSurface() {
        this.compute();
        return true;
    }

    public boolean makeVertexTextureFromUV() {
        if (((PgPointSet)this).m_numVertices == 0) {
            return true;
        }
        if (this.m_domainDescr == null) {
            return true;
        }
        int n = this.m_domainDescr.getNumULines();
        int n2 = this.m_domainDescr.getNumVLines();
        return this.makeVertexTextureFromUV(n, n2, 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

