/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jvx.numeric.PnPreconditioner;
import jvx.numeric.PnSparseMatrix;

public class PnPreconditionerJacobi
extends PnPreconditioner {
    private PdVector m_invdiag;

    public PnPreconditionerJacobi(PnSparseMatrix pnSparseMatrix) {
        this.setSparseMatrix(pnSparseMatrix);
    }

    public void setSparseMatrix(PnSparseMatrix pnSparseMatrix) {
        if (!pnSparseMatrix.isSquare()) {
            PsDebug.warning((String)"Matrix is not square.");
            return;
        }
        this.m_smat = pnSparseMatrix;
        this.m_invdiag = new PdVector(pnSparseMatrix.m_iSize);
        for (int i = 0; i < this.m_invdiag.getSize(); ++i) {
            int n = pnSparseMatrix.getIndex(i, i);
            this.m_invdiag.m_data[i] = pnSparseMatrix.m_stiff[i].m_data[n];
            this.m_invdiag.m_data[i] = this.m_invdiag.m_data[i] == 0.0 ? 1.0 : 1.0 / this.m_invdiag.m_data[i];
        }
    }

    public PdVector apply(PdVector pdVector, PdVector pdVector2, int n) {
        int n2 = this.m_invdiag.getSize();
        if (n == 1) {
            for (int i = 0; i < n2; ++i) {
                pdVector2.m_data[i] = pdVector.m_data[i] * this.m_invdiag.m_data[i];
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    pdVector2.m_data[n * i + j] = pdVector.m_data[n * i + j] * this.m_invdiag.m_data[i];
                }
            }
        }
        return pdVector2;
    }

    public PdVector applyTransposed(PdVector pdVector, PdVector pdVector2, int n) {
        return this.apply(pdVector, pdVector2, n);
    }
}

