/*
 * Decompiled with CFR 0.152.
 */
package jvx.material;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.geom.PgTetraSet;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jvx.project.PjWorkshop;
import jvx.volume.PgCubeSet;

public class PwMaterial
extends PjWorkshop {
    protected PuDouble m_gVertexSize = new PuDouble("Vertex Size", (PsUpdateIf)this);
    protected PuDouble m_gPolygonSize = new PuDouble("Polygon Size", (PsUpdateIf)this);
    protected PdColor m_gVertexColor = new PdColor("Vertex", (PsUpdateIf)this);
    protected PdColor m_gElementColor = new PdColor("Face", (PsUpdateIf)this);
    protected PdColor m_gElementBackColor = new PdColor("Backface", (PsUpdateIf)this);
    protected PdColor m_gPolygonColor = new PdColor("Polygon", (PsUpdateIf)this);
    protected PdColor m_gTetrahedronColor = new PdColor("Tetrahedron", (PsUpdateIf)this);
    protected PdColor m_gCubeColor = new PdColor("Cube", (PsUpdateIf)this);
    protected PgPointSet m_pointSet;
    protected PgElementSet m_elementSet;
    protected PgPolygon m_polygon;
    protected PgPolygonSet m_polygonSet;
    protected PgTetraSet m_tetraSet;
    protected PgCubeSet m_cubeSet;
    protected boolean m_bSaveShowTaggedElements;
    protected boolean m_bSaveShowTaggedVertices;
    protected boolean m_bSaveShowTaggedEdges;
    protected boolean m_bSaveShowTaggedPolygons;
    protected boolean m_bSaveShowTaggedTetrahedra;
    protected boolean m_bSaveShowTaggedCubes;
    static /* synthetic */ Class class$jvx$material$PwMaterial;
    static /* synthetic */ Class class$jvx$volume$PgCubeSet;

    public PwMaterial() {
        super("Individual Material");
        if (((Object)((Object)this)).getClass() == (class$jvx$material$PwMaterial == null ? (class$jvx$material$PwMaterial = PwMaterial.class$("jvx.material.PwMaterial")) : class$jvx$material$PwMaterial)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_gVertexSize.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_gVertexSize.setDefValue(1.0);
        this.m_gVertexSize.init();
        this.m_gPolygonSize.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_gPolygonSize.setDefValue(1.0);
        this.m_gPolygonSize.init();
        this.m_gVertexColor.setColor(Color.red);
        this.m_gVertexColor.init();
        this.m_gElementColor.setColor(Color.blue);
        this.m_gElementColor.init();
        this.m_gElementBackColor.setColor(Color.orange);
        this.m_gElementBackColor.init();
        this.m_gPolygonColor.setColor(Color.black);
        this.m_gPolygonColor.init();
        this.m_gTetrahedronColor.setColor(Color.blue);
        this.m_gTetrahedronColor.init();
        this.m_gCubeColor.setColor(Color.blue);
        this.m_gCubeColor.init();
    }

    public void setGeometry(PgGeometry pgGeometry) {
        super.setGeometry(pgGeometry);
        this.m_pointSet = (PgPointSet)pgGeometry;
        this.m_bSaveShowTaggedVertices = this.m_pointSet.isShowingTaggedVertices();
        this.m_gVertexColor.setColor(this.m_pointSet.getGlobalVertexColor());
        this.m_bSaveShowTaggedElements = true;
        this.m_bSaveShowTaggedEdges = true;
        this.m_bSaveShowTaggedPolygons = true;
        if (pgGeometry.getType() == 33) {
            this.m_elementSet = (PgElementSet)pgGeometry;
            this.m_bSaveShowTaggedElements = this.m_elementSet.isShowingTaggedElements();
            this.m_gElementColor.setColor(this.m_elementSet.getGlobalElementColor());
            this.m_gElementBackColor.setColor(this.m_elementSet.getGlobalElementBackColor());
        } else if (pgGeometry.getType() == 31) {
            this.m_polygon = (PgPolygon)pgGeometry;
        } else if (pgGeometry.getType() == 32) {
            this.m_polygonSet = (PgPolygonSet)pgGeometry;
            this.m_bSaveShowTaggedPolygons = this.m_polygonSet.isShowingTaggedPolygons();
            this.m_gPolygonColor.setColor(this.m_polygonSet.getGlobalPolygonColor());
        } else if (pgGeometry.getType() == 34) {
            if (pgGeometry.getClass() == (class$jvx$volume$PgCubeSet == null ? (class$jvx$volume$PgCubeSet = PwMaterial.class$("jvx.volume.PgCubeSet")) : class$jvx$volume$PgCubeSet)) {
                this.m_cubeSet = (PgCubeSet)pgGeometry;
                this.m_bSaveShowTaggedCubes = this.m_cubeSet.isShowingTaggedCubes();
                this.m_gCubeColor.setColor(this.m_cubeSet.getGlobalCubeColor());
            } else {
                this.m_tetraSet = (PgTetraSet)pgGeometry;
                this.m_bSaveShowTaggedTetrahedra = this.m_tetraSet.isShowingTaggedTetras();
                this.m_gTetrahedronColor.setColor(this.m_tetraSet.getGlobalTetraColor());
            }
        }
    }

    public boolean update(Object object) {
        if (object == this.m_gVertexColor) {
            Color color = this.m_gVertexColor.getColor();
            int n = this.m_pointSet.getNumVertices();
            if (!this.m_pointSet.hasVertexColors()) {
                this.m_pointSet.assureVertexColors();
                Color color2 = this.m_pointSet.getGlobalVertexColor();
                for (int i = 0; i < n; ++i) {
                    this.m_pointSet.setVertexColor(i, color2);
                }
            }
            for (int i = 0; i < n; ++i) {
                if (!this.m_pointSet.hasTagVertex(i, 1)) continue;
                this.m_pointSet.setVertexColor(i, color);
            }
            this.m_pointSet.showVertices(true);
            this.m_pointSet.showVertexColors(true);
            return this.m_geom.update((Object)this.m_geom);
        }
        if (object == this.m_gElementColor) {
            Color color = this.m_gElementColor.getColor();
            int n = this.m_elementSet.getNumElements();
            if (!this.m_elementSet.hasElementColors()) {
                this.m_elementSet.assureElementColors();
                Color color3 = this.m_elementSet.getGlobalElementColor();
                for (int i = 0; i < n; ++i) {
                    this.m_elementSet.setElementColor(i, color3);
                }
            }
            for (int i = 0; i < n; ++i) {
                if (!this.m_elementSet.hasTagElement(i, 1)) continue;
                this.m_elementSet.setElementColor(i, color);
            }
            this.m_elementSet.showElements(true);
            this.m_elementSet.showElementColors(true);
            return this.m_geom.update((Object)this.m_geom);
        }
        if (object == this.m_gElementBackColor) {
            Color color = this.m_gElementBackColor.getColor();
            int n = this.m_elementSet.getNumElements();
            if (!this.m_elementSet.hasElementBackColors()) {
                this.m_elementSet.assureElementBackColors();
                Color color4 = this.m_elementSet.getGlobalElementBackColor();
                for (int i = 0; i < n; ++i) {
                    this.m_elementSet.setElementBackColor(i, color4);
                }
            }
            for (int i = 0; i < n; ++i) {
                if (!this.m_elementSet.hasTagElement(i, 1)) continue;
                this.m_elementSet.setElementBackColor(i, color);
            }
            this.m_elementSet.showElements(true);
            this.m_elementSet.showElementBackColors(true);
            return this.m_geom.update((Object)this.m_geom);
        }
        if (object == this.m_gPolygonColor) {
            Color color = this.m_gPolygonColor.getColor();
            int n = this.m_polygonSet.getNumPolygons();
            if (!this.m_polygonSet.hasPolygonColors()) {
                this.m_polygonSet.assurePolygonColors();
                Color color5 = this.m_polygonSet.getGlobalPolygonColor();
                for (int i = 0; i < n; ++i) {
                    this.m_polygonSet.setPolygonColor(i, color5);
                }
            }
            for (int i = 0; i < n; ++i) {
                if (!this.m_polygonSet.hasTagPolygon(i, 1)) continue;
                this.m_polygonSet.setPolygonColor(i, color);
            }
            this.m_polygonSet.showPolygons(true);
            this.m_polygonSet.showPolygonColors(true);
            return this.m_geom.update((Object)this.m_geom);
        }
        if (object == this.m_gTetrahedronColor) {
            Color color = this.m_gTetrahedronColor.getColor();
            int n = this.m_tetraSet.getNumTetras();
            if (!this.m_tetraSet.hasTetraColors()) {
                this.m_tetraSet.assureTetraColors();
                Color color6 = this.m_tetraSet.getGlobalTetraColor();
                for (int i = 0; i < n; ++i) {
                    this.m_tetraSet.setTetraColor(i, color6);
                }
            }
            for (int i = 0; i < n; ++i) {
                if (!this.m_tetraSet.hasTagTetra(i, 1)) continue;
                this.m_tetraSet.setTetraColor(i, color);
            }
            this.m_tetraSet.showTetras(true);
            this.m_tetraSet.showTetraColors(true);
            return this.m_geom.update((Object)this.m_geom);
        }
        if (object == this.m_gCubeColor) {
            Color color = this.m_gCubeColor.getColor();
            int n = this.m_cubeSet.getNumCubes();
            if (!this.m_cubeSet.hasCubeColors()) {
                this.m_cubeSet.assureCubeColors();
                Color color7 = this.m_cubeSet.getGlobalCubeColor();
                for (int i = 0; i < n; ++i) {
                    this.m_cubeSet.setCubeColor(i, color7);
                }
            }
            for (int i = 0; i < n; ++i) {
                if (!this.m_cubeSet.hasTagCube(i, 1)) continue;
                this.m_cubeSet.setCubeColor(i, color);
            }
            this.m_cubeSet.showCubes(true);
            this.m_cubeSet.showCubeColors(true);
            return this.m_geom.update((Object)this.m_geom);
        }
        if (object == this.m_gVertexSize) {
            int n;
            double d;
            this.m_pointSet.showVertices(true);
            int n2 = this.m_pointSet.getNumVertices();
            if (!this.m_pointSet.hasVertexSizes()) {
                this.m_pointSet.assureVertexSizes();
                d = 1.0;
                for (n = 0; n < n2; ++n) {
                    this.m_pointSet.setVertexSize(n, d);
                }
            }
            d = this.m_gVertexSize.getValue();
            for (n = 0; n < n2; ++n) {
                if (!this.m_pointSet.hasTagVertex(n, 1)) continue;
                this.m_pointSet.setVertexSize(n, d);
            }
            this.m_pointSet.showVertexSizes(true);
            return this.m_geom.update((Object)this.m_geom);
        }
        if (object == this.m_gPolygonSize) {
            int n;
            double d;
            this.m_polygonSet.showPolygons(true);
            int n3 = this.m_polygonSet.getNumPolygons();
            if (!this.m_polygonSet.hasPolygonSizes()) {
                this.m_polygonSet.assurePolygonSizes();
                d = 1.0;
                for (n = 0; n < n3; ++n) {
                    this.m_polygonSet.setPolygonSize(n, d);
                }
            }
            d = this.m_gPolygonSize.getValue();
            for (n = 0; n < n3; ++n) {
                if (!this.m_polygonSet.hasTagPolygon(n, 1)) continue;
                this.m_polygonSet.setPolygonSize(n, d);
            }
            this.m_polygonSet.showPolygonSizes(true);
            return this.m_geom.update((Object)this.m_geom);
        }
        return super.update(object);
    }

    protected void resetVisibility() {
        this.m_pointSet.showTaggedVertices(this.m_bSaveShowTaggedVertices);
        if (this.m_elementSet != null) {
            this.m_elementSet.showTaggedElements(this.m_bSaveShowTaggedElements);
            this.m_elementSet.showTaggedEdges(this.m_bSaveShowTaggedEdges);
        }
        if (this.m_polygonSet != null) {
            this.m_polygonSet.showTaggedPolygons(this.m_bSaveShowTaggedPolygons);
        }
    }

    protected void removeAllSelections() {
        int n;
        int n2;
        int n3 = this.m_pointSet.getNumVertices();
        for (n2 = 0; n2 < n3; ++n2) {
            this.m_pointSet.clearTagVertex(n2, 1);
        }
        if (this.m_elementSet != null) {
            n2 = this.m_elementSet.getNumElements();
            for (n = 0; n < n2; ++n) {
                this.m_elementSet.clearTagElement(n, 1);
            }
        }
        if (this.m_polygonSet != null) {
            n2 = this.m_polygonSet.getNumPolygons();
            for (n = 0; n < n2; ++n) {
                this.m_polygonSet.clearTagPolygon(n, 1);
            }
        }
        if (this.m_tetraSet != null) {
            n2 = this.m_tetraSet.getNumTetras();
            for (n = 0; n < n2; ++n) {
                this.m_tetraSet.clearTagTetra(n, 1);
            }
        }
        if (this.m_cubeSet != null) {
            n2 = this.m_cubeSet.getNumCubes();
            for (n = 0; n < n2; ++n) {
                this.m_cubeSet.clearTagCube(n, 1);
            }
        }
    }

    public void close() {
        this.resetVisibility();
        this.m_geom.update((Object)this.m_geom);
        super.close();
    }

    public void ok() {
        this.resetVisibility();
        this.m_geom.update((Object)this.m_geom);
        super.ok();
    }

    public void cancel() {
        this.resetVisibility();
        this.m_geom.update((Object)this.m_geom);
        super.cancel();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

