/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import jv.geom.PgBndPolygon;
import jv.geom.PgEdgeStar;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.geom.PgVectorField;
import jv.loader.PgAbstractLoader;
import jv.loader.PvDisplayOption;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwBoundary;

public class PgPovLoader
extends PgAbstractLoader {
    private static final double ASSUMED_GAMMA = 2.2;
    private static final double LIGHT_AMPLIFICATION = 1.65;
    private static final double DEFAULT_AMBIENT = 0.0;
    private static final String TAB_SPACE = "   ";
    private static final String AMBIENT_FINISH = "finish {\n   ambient AMBIENT\n}";
    private int m_curcam;
    static final String MACRO_ARROW = "#macro arrow(base_x, base_y, base_z, dir_x, dir_y, dir_z, wid)\nunion {\n   cylinder {\n      <base_x, base_y, base_z>, <base_x, base_y, base_z> + <dir_x, dir_y, dir_z> * 0.7, wid\n   }\n   cone {\n      <base_x, base_y, base_z> + <dir_x, dir_y, dir_z> * 0.7, wid*2.5, <base_x, base_y, base_z> + <dir_x, dir_y, dir_z>, 0\n   }\n}\n#end\n";

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        writer.write("// Produced with JavaView v." + PsConfig.getVersion() + "\n");
        writer.write("// JavaView is " + PsConfig.getCopyright() + ", " + PsConfig.getHomepage() + "\n");
        writer.write("// by " + PsConfig.getAuthors() + "\n");
        writer.write("//     File Format = POV-Ray POV\n");
        writer.write("//     Geometry    = " + pgJvxSrc.getName() + "\n");
        writer.write("//     Date        = " + new Date().toString() + "\n");
        writer.write("//\n");
        writer.write("// End of Header\n\n");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n#declare SCALE_VERTEX= 1;");
        stringBuffer.append("\n#declare SCALE_VERTEX_MARK= 1;");
        stringBuffer.append("\n#declare SCALE_EDGE= 0.5;");
        stringBuffer.append("\n#declare SCALE_BOUNDARY= 1;");
        stringBuffer.append("\n#declare SCALE_BOUNDING_BOX= 0.5;");
        stringBuffer.append("\n#declare WIDTH_VECTOR= 1;\n");
        stringBuffer.append("\n#declare AREA_LIGHTS = 0;");
        stringBuffer.append("\n#declare RADIOSITY = 0;\n");
        stringBuffer.append("\n#declare SHADOW_VECTOR= 1;");
        stringBuffer.append("\n#declare SHADOW_EDGES= 1;");
        stringBuffer.append("\n#declare SHADOW_VERTICES= 1;");
        stringBuffer.append("\n#declare SHADOW_OBJECT= 1;");
        stringBuffer.append("\n#declare SHADOW_MARKED_VERTICES= 1;");
        stringBuffer.append("\n#declare SHADOW_VERTEX_NORMALS= 1;");
        stringBuffer.append("\n#declare SHADOW_ELEMENT_NORMALS= 1;");
        stringBuffer.append("\n#declare SHADOW_BOUNDING_BOX= 0;");
        stringBuffer.append("\n#declare SHADOW_BOUNDARY= 1;");
        stringBuffer.append("\n#declare SHADOW_POLYGON_VERTICES= 1;");
        stringBuffer.append("\n#declare SHADOW_POLYGON_EDGES= 1;");
        stringBuffer.append("\n#declare SHADOW_POLYGON_VERTEX_NORMALS= 1;");
        stringBuffer.append("\n#declare AMBIENT=0.0;\n");
        stringBuffer.append(new PovObject("global_settings", "max_trace_level 15", "assumed_gamma 2.2", "#if (RADIOSITY) \n #include \"rad_def.inc\" \n radiosity { Rad_Settings(Radiosity_Final,off,off) } \n #end").toString().trim());
        boolean bl = false;
        for (int i = 0; i < pgJvxSrcArray.length; ++i) {
            bl |= pgJvxSrcArray[i].isShowingVertexNormals();
            bl |= pgJvxSrcArray[i].isShowingVectorFields();
            bl |= pgJvxSrcArray[i].isShowingElementNormals();
            bl |= pgJvxSrcArray[i].isShowingPolygonNormals();
        }
        if (bl) {
            stringBuffer.append("\n#macro arrow(base_x, base_y, base_z, dir_x, dir_y, dir_z, wid)\nunion {\n   cylinder {\n      <base_x, base_y, base_z>, <base_x, base_y, base_z> + <dir_x, dir_y, dir_z> * 0.7, wid\n   }\n   cone {\n      <base_x, base_y, base_z> + <dir_x, dir_y, dir_z> * 0.7, wid*2.5, <base_x, base_y, base_z> + <dir_x, dir_y, dir_z>, 0\n   }\n}\n#end\n\n");
        }
        this.appendObj(stringBuffer, new PovObject("background", PgPovLoader.toPovString(this.getDisplayOption().getBackgroundColor())));
        this.appendCamera(stringBuffer);
        double d = this.appendLights(stringBuffer, pgJvxSrcArray);
        if (this.getDisplayOption().getOption(27)) {
            this.appendObj(stringBuffer, new PovObject("plane", "<0,0,1>, 0", this.newPigment(new Color(0.3f, 0.3f, 0.3f)).toString()));
        }
        for (int i = 0; i < pgJvxSrcArray.length; ++i) {
            boolean bl2;
            if (!pgJvxSrcArray[i].isVisible()) continue;
            PgPointSet pgPointSet = null;
            if (pgJvxSrcArray[i].getType() == 30) {
                pgPointSet = new PgPointSet(3);
            } else if (pgJvxSrcArray[i].getType() == 33) {
                pgPointSet = new PgElementSet(3);
            } else if (pgJvxSrcArray[i].getType() == 31) {
                pgPointSet = new PgPolygon(3);
            } else {
                if (pgJvxSrcArray[i].getType() != 32) continue;
                pgPointSet = new PgPolygonSet(3);
            }
            pgPointSet.setJvx(pgJvxSrcArray[i]);
            String string = PgPovLoader.cleanName(pgPointSet.getName());
            int n = pgPointSet.getNumVertices();
            boolean bl3 = bl2 = pgJvxSrcArray[i].getVertexNormals() != null && pgJvxSrcArray[i].getVertexNormals().length == n;
            if (pgPointSet.isShowingBndBox() || this.getDisplayOption().getOption(12)) {
                this.appendObj(stringBuffer, this.makeBoundingBox(pgPointSet));
            }
            this.appendObj(stringBuffer, this.declareArray("vertices_" + string, pgPointSet.getVertices()));
            if (bl2) {
                this.appendObj(stringBuffer, this.declareArray("vertex_normals_" + string, pgPointSet.getVertexNormals()));
            }
            if (pgPointSet.isShowingVertices()) {
                this.appendObj(stringBuffer, this.makePointSet(pgPointSet));
            }
            if (pgPointSet.isShowingVertexNormals()) {
                this.appendObj(stringBuffer, this.makeVertexNormals(pgPointSet));
            }
            if (pgPointSet.isShowingVectorFields()) {
                for (int j = 0; j < pgPointSet.getNumVectorFields(); ++j) {
                    if (pgPointSet.getVectorField(j).getBasedOn() != 0) continue;
                    this.appendObj(stringBuffer, this.makeVertexVectorField(pgPointSet, pgPointSet.getVectorField(j)));
                }
            }
            if (pgPointSet instanceof PgElementSet) {
                PgElementSet pgElementSet = (PgElementSet)pgPointSet;
                pgElementSet.makeNeighbour();
                if (pgElementSet.isShowingEdges()) {
                    this.appendObj(stringBuffer, this.makeEdges(pgElementSet));
                }
                if (pgElementSet.isShowingElementNormals()) {
                    this.appendObj(stringBuffer, this.makeElementNormals(pgElementSet));
                }
                if (pgElementSet.isShowingVectorFields()) {
                    for (int j = 0; j < pgElementSet.getNumVectorFields(); ++j) {
                        PgVectorField pgVectorField = pgElementSet.getVectorField(j);
                        if (pgVectorField.getBasedOn() != 1) continue;
                        this.appendObj(stringBuffer, this.makeElementVectorField(pgVectorField));
                    }
                }
                if (pgElementSet.isShowingBoundaries()) {
                    this.appendObj(stringBuffer, this.makeBoundary(pgElementSet));
                }
                if (pgElementSet.isShowingElements()) {
                    double d2;
                    PgElementSet.triangulate((PgElementSet)pgElementSet);
                    double d3 = d2 = pgElementSet.isShowingTransparency() ? pgElementSet.getTransparency() : 0.0;
                    if (pgElementSet.isShowingElementColors()) {
                        if (pgElementSet.isShowingElementColorFromVertices()) {
                            this.appendObj(stringBuffer, this.declareArray("color_textures_" + string, pgElementSet.getVertexColors(), d2));
                        } else {
                            this.appendObj(stringBuffer, this.declareArray("color_textures_" + string, pgElementSet.getElementColors(), d2));
                        }
                    }
                    this.appendObj(stringBuffer, this.makeElements(pgElementSet, d, bl2, d2));
                }
            }
            if (pgPointSet instanceof PgPolygon && ((PgPolygonSet)pgPointSet).isShowingPolygons()) {
                this.appendObj(stringBuffer, this.makePolygonEdges((PgPolygon)pgPointSet));
            }
            if (!(pgPointSet instanceof PgPolygonSet) || !((PgPolygonSet)pgPointSet).isShowingPolygons()) continue;
            this.appendObj(stringBuffer, this.makePolygonSetEdges((PgPolygonSet)pgPointSet));
        }
        writer.write(stringBuffer.toString());
        writer.flush();
        writer.close();
        return true;
    }

    private PovObject makePointSet(PgPointSet pgPointSet) {
        String string = PgPovLoader.cleanName(pgPointSet.getName());
        PovObject povObject = new PovObject("union", "// vertices of " + string);
        povObject.addChild("#local rad =" + this.getRadius(pgPointSet.getGlobalVertexSize()) + " * SCALE_VERTEX;");
        povObject.addChild("#local rad_mark = 2 * SCALE_VERTEX;");
        povObject.addChild("#local mark_color = " + PgPovLoader.toPovString(Color.magenta) + ";");
        for (int i = 0; i < pgPointSet.getNumVertices(); ++i) {
            PovObject povObject2 = new PovObject("sphere");
            if (pgPointSet.hasTagVertex(i, 1)) {
                povObject2.addChild("vertices_" + string + "[" + i + "], rad_mark");
                povObject2.addChild(new PovObject("pigment", "mark_color"));
            } else {
                povObject2.addChild("vertices_" + string + "[" + i + "], rad");
                if (pgPointSet.isShowingVertexColors()) {
                    povObject2.addChild(this.newPigment(pgPointSet.getVertexColor(i)));
                }
            }
            povObject.addChild(povObject2);
        }
        if (!pgPointSet.isShowingVertexColors()) {
            povObject.addChild(this.newPigment(pgPointSet.getGlobalVertexColor()));
        }
        povObject.addChild(AMBIENT_FINISH);
        povObject.addChild("#if(SHADOW_POLYGON_VERTICES=0) no_shadow #end");
        return povObject;
    }

    private PovObject makeElements(PgElementSet pgElementSet, double d, boolean bl, double d2) {
        Object object;
        int n;
        PovObject povObject;
        int n2;
        int n3;
        String string = PgPovLoader.cleanName(pgElementSet.getName());
        int n4 = pgElementSet.getNumElements();
        int n5 = pgElementSet.getNumVertices();
        PovObject povObject2 = new PovObject("mesh2", "// elements of " + string);
        PovObject povObject3 = new PovObject("vertex_vectors");
        povObject3.addChild(n5 + ",");
        for (n3 = 0; n3 < n5 - 1; ++n3) {
            povObject3.addChild("vertices_" + string + "[" + n3 + "],");
        }
        povObject3.addChild("vertices_" + string + "[" + (n5 - 1) + "]");
        povObject2.addChild(povObject3);
        if (bl) {
            PovObject povObject4 = new PovObject("normal_vectors");
            povObject4.addChild(n5 + ",");
            for (n2 = 0; n2 < n5 - 1; ++n2) {
                povObject4.addChild("vertex_normals_" + string + "[" + n2 + "],");
            }
            povObject4.addChild("vertex_normals_" + string + "[" + (n5 - 1) + "]");
            povObject2.addChild(povObject4);
        }
        n3 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            n3 |= pgElementSet.hasTagElement(n2, 1);
        }
        PovObject povObject5 = new PovObject("texture", this.newPigment(Color.magenta).toString());
        if (pgElementSet.hasVertexTextures() && pgElementSet.isShowingVertexTexture()) {
            povObject = new PovObject("uv_vectors");
            povObject.addChild("" + n5);
            for (n = 0; n < n5; ++n) {
                povObject.addChild(PgPovLoader.toPovString(pgElementSet.getVertexTexture(n)));
            }
            povObject2.addChild(povObject);
        }
        if (!(!pgElementSet.isShowingElementColors() || pgElementSet.hasVertexTextures() && pgElementSet.isShowingVertexTexture())) {
            povObject = new PovObject("texture_list");
            n = pgElementSet.isShowingElementColorFromVertices() ? n5 : n4;
            povObject.addChild("" + n);
            if (n3 != 0) {
                povObject.addChild(povObject5);
            }
            for (int i = 0; i < n; ++i) {
                object = new PovObject("texture");
                ((PovObject)object).addChild("pigment { color_textures_" + string + "[" + i + "] }");
                povObject.addChild((PovObject)object);
            }
            povObject2.addChild(povObject);
        } else if (n3 != 0) {
            povObject = new PovObject("texture_list", "1", povObject5.toString());
            povObject2.addChild(povObject);
        }
        povObject = new PovObject("face_indices", "// faces of " + string);
        povObject.addChild("" + n4 + ",");
        for (n = 0; n < n4; ++n) {
            PiVector piVector = pgElementSet.getElement(n);
            povObject.addChild("<" + piVector.getEntry(0) + "," + piVector.getEntry(1) + "," + piVector.getEntry(2) + ">");
            if (!(pgElementSet.hasVertexTextures() && pgElementSet.isShowingVertexTexture() || !pgElementSet.isShowingElementColors() || pgElementSet.hasTagElement(n, 1))) {
                if (pgElementSet.isShowingElementColorFromVertices()) {
                    povObject.append(", " + (piVector.getEntry(0) + 1) + ", " + (piVector.getEntry(1) + 1) + ", " + (piVector.getEntry(2) + 1));
                } else {
                    povObject.append(", " + n);
                }
            }
            if (!pgElementSet.hasTagElement(n, 1) || !pgElementSet.isShowingElementColors()) continue;
            povObject.append(", 0");
        }
        povObject2.addChild(povObject);
        PovObject povObject6 = this.newPigment(pgElementSet.getGlobalElementColor());
        if (pgElementSet.isShowingTransparency()) {
            povObject6.addChild("filter " + d2);
        }
        PovObject povObject7 = new PovObject("finish", "ambient AMBIENT");
        if (Math.abs(1.65 * d) > 1.0E-10) {
            povObject7.addChild("specular " + 1.65 * d);
        }
        if ((object = pgElementSet.getTextureImageName()) != null) {
            PovObject povObject8 = new PovObject("texture");
            String string2 = ((String)object).substring(((String)object).lastIndexOf(".") + 1, ((String)object).length());
            PovObject povObject9 = new PovObject("uv_mapping pigment", "image_map { " + string2 + " \"" + (String)object + "\" }");
            povObject8.addChild(povObject9);
            povObject2.addChild(povObject8);
        }
        povObject2.addChild(povObject6);
        povObject2.addChild(povObject7);
        povObject2.addChild("#if(SHADOW_OBJECT=0) no_shadow #end");
        return povObject2;
    }

    private PovObject makeEdges(PgElementSet pgElementSet) {
        String string = PgPovLoader.cleanName(pgElementSet.getName());
        double d = pgElementSet.getGlobalEdgeSize();
        double d2 = this.getRadius(d);
        PgEdgeStar[] pgEdgeStarArray = pgElementSet.makeEdgeStars();
        PovObject povObject = new PovObject("union", "// edges of " + string);
        povObject.addChild("#local rad =" + d2 + "*SCALE_EDGE;");
        povObject.addChild("#local p = vertices_" + string + ";");
        for (int i = 0; i < pgEdgeStarArray.length; ++i) {
            int n = pgEdgeStarArray[i].getVertexInd(1);
            int n2 = pgEdgeStarArray[i].getVertexInd(0);
            if (!(pgElementSet.getVertex(n).dist(pgElementSet.getVertex(n2)) > 1.0E-10)) continue;
            PovObject povObject2 = new PovObject("cylinder");
            povObject2.addChild("p[" + n2 + "] p[" + n + "] rad");
            if (pgElementSet.hasEdgeColors()) {
                povObject2.addChild(this.newPigment(pgElementSet.getEdgeColors()[i]));
            }
            povObject.addChild(povObject2);
        }
        if (!pgElementSet.hasEdgeColors()) {
            povObject.addChild(this.newPigment(pgElementSet.getGlobalEdgeColor()));
        }
        povObject.addChild(AMBIENT_FINISH);
        povObject.addChild("#if(SHADOW_EDGES=0) no_shadow #end");
        return povObject;
    }

    private PovObject makePolygonEdges(PgPolygon pgPolygon) {
        String string = PgPovLoader.cleanName(pgPolygon.getName());
        PovObject povObject = new PovObject("union", "// polygons of " + string);
        povObject.addChild("#local rad =" + this.getRadius(pgPolygon.getGlobalEdgeSize()) + " * SCALE_EDGE;");
        PovObject povObject2 = new PovObject("union", "// polygon " + string);
        int n = pgPolygon.getNumEdges();
        for (int i = 0; i < n; ++i) {
            if (!(pgPolygon.getVertex(i).dist(pgPolygon.getVertex((i + 1) % n)) > 1.0E-10)) continue;
            PovObject povObject3 = new PovObject("cylinder");
            povObject3.addChild("vertices_" + string + "[" + i + "]");
            povObject3.addChild("vertices_" + string + "[" + (i + 1) % n + "]");
            povObject3.addChild("rad");
            if (pgPolygon.hasTag(1)) {
                povObject3.addChild(this.newPigment(Color.magenta));
                povObject3.addChild(AMBIENT_FINISH);
                continue;
            }
            if (!pgPolygon.hasEdgeColors() || !pgPolygon.isShowingEdgeColors()) continue;
            povObject3.addChild(this.newPigment(pgPolygon.getEdgeColors()[i]));
            povObject3.addChild(AMBIENT_FINISH);
        }
        povObject2.addChild(this.newPigment(pgPolygon.getGlobalEdgeColor()));
        povObject2.addChild(AMBIENT_FINISH);
        povObject2.addChild("#if(SHADOW_POLYGON_EDGES=0) no_shadow #end");
        return povObject2;
    }

    private PovObject makePolygonSetEdges(PgPolygonSet pgPolygonSet) {
        String string = PgPovLoader.cleanName(pgPolygonSet.getName());
        PovObject povObject = new PovObject("union", "// polygons of " + string);
        povObject.addChild("#local rad =" + this.getRadius(pgPolygonSet.getGlobalPolygonSize()) + "*SCALE_EDGE;");
        for (int i = 0; i < pgPolygonSet.getNumPolygons(); ++i) {
            PovObject povObject2 = new PovObject("union");
            PiVector piVector = pgPolygonSet.getPolygon(i);
            int n = piVector.getSize();
            int n2 = pgPolygonSet.isClosed(i) ? piVector.getSize() : piVector.getSize() - 1;
            for (int j = 0; j < n2; ++j) {
                boolean bl = pgPolygonSet.hasTagPolygon(i, 1);
                int n3 = piVector.getEntry(j);
                int n4 = piVector.getEntry((j + 1) % n);
                if (!(pgPolygonSet.getVertex(n4).dist(pgPolygonSet.getVertex(n3)) > 1.0E-10)) continue;
                PovObject povObject3 = new PovObject("cylinder");
                povObject3.addChild("vertices_" + string + "[" + n3 + "]");
                povObject3.addChild("vertices_" + string + "[" + n4 + "]");
                povObject3.addChild("rad");
                if (!bl) {
                    if (pgPolygonSet.hasPolygonColors() && pgPolygonSet.isShowingPolygonColors()) {
                        povObject3.addChild(this.newPigment(pgPolygonSet.getPolygonColor(i)));
                        povObject3.addChild(AMBIENT_FINISH);
                    }
                } else {
                    povObject3.addChild(this.newPigment(Color.magenta));
                    povObject3.addChild(AMBIENT_FINISH);
                }
                povObject2.addChild(povObject3);
            }
            povObject2.addChild(this.newPigment(pgPolygonSet.getGlobalPolygonColor()));
            povObject.addChild(povObject2);
        }
        povObject.addChild(AMBIENT_FINISH);
        povObject.addChild("#if(SHADOW_POLYGON_EDGES=0) no_shadow #end");
        return povObject;
    }

    private PovObject makeBoundary(PgElementSet pgElementSet) {
        String string = PgPovLoader.cleanName(pgElementSet.getName());
        PwBoundary.makeBoundary(pgElementSet);
        PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
        double d = this.getRadius(pgElementSet.getGlobalBndSize());
        PovObject povObject = new PovObject("object", "// boundary of " + string);
        povObject.addChild("#local rad = " + d + " * SCALE_BOUNDARY;");
        PovObject povObject2 = new PovObject("union");
        for (int i = 0; i < pgBndPolygonArray.length; ++i) {
            PgBndPolygon pgBndPolygon = pgBndPolygonArray[i];
            int n = pgBndPolygon.getNumVertices();
            for (int j = 0; j < n; ++j) {
                int n2 = pgBndPolygon.getVertexInd().getEntry(j);
                int n3 = pgBndPolygon.getVertexInd().getEntry((j + 1) % n);
                if (!(pgElementSet.getVertex(n2).dist(pgElementSet.getVertex(n3)) > 1.0E-10)) continue;
                PovObject povObject3 = new PovObject("cylinder");
                povObject3.addChild("vertices_" + string + "[" + n2 + "], vertices_" + string + "[" + n3 + "], rad");
                povObject2.addChild(povObject3);
            }
        }
        povObject2.addChild(this.newPigment(pgElementSet.getGlobalBndColor()));
        povObject2.addChild(AMBIENT_FINISH);
        povObject.addChild(povObject2);
        povObject.addChild("#if(SHADOW_BOUNDARY=0) no_shadow #end");
        return povObject;
    }

    private PovObject makeBoundingBox(PgPointSet pgPointSet) {
        PovObject povObject = new PovObject("union", "// bounding box of " + PgPovLoader.cleanName(pgPointSet.getName()));
        povObject.addChild("#local rad = " + this.getRadius(1.0) + " * SCALE_BOUNDING_BOX;\n");
        double[] dArray = PdVector.blendNew((double)1.0, (PdVector)pgPointSet.getBounds()[0], (double)0.0, (PdVector)pgPointSet.getBounds()[1]).m_data;
        double[] dArray2 = PdVector.blendNew((double)0.0, (PdVector)pgPointSet.getBounds()[0], (double)1.0, (PdVector)pgPointSet.getBounds()[1]).m_data;
        PdVector[] pdVectorArray = new PdVector[]{new PdVector(dArray[0], dArray[1], dArray[2]), new PdVector(dArray[0], dArray[1], dArray2[2]), new PdVector(dArray[0], dArray2[1], dArray[2]), new PdVector(dArray[0], dArray2[1], dArray2[2]), new PdVector(dArray2[0], dArray[1], dArray[2]), new PdVector(dArray2[0], dArray[1], dArray2[2]), new PdVector(dArray2[0], dArray2[1], dArray[2]), new PdVector(dArray2[0], dArray2[1], dArray2[2])};
        povObject.addChild(this.newCylinder(pdVectorArray[0], pdVectorArray[1]));
        povObject.addChild(this.newCylinder(pdVectorArray[0], pdVectorArray[2]));
        povObject.addChild(this.newCylinder(pdVectorArray[0], pdVectorArray[4]));
        povObject.addChild(this.newCylinder(pdVectorArray[1], pdVectorArray[3]));
        povObject.addChild(this.newCylinder(pdVectorArray[1], pdVectorArray[5]));
        povObject.addChild(this.newCylinder(pdVectorArray[2], pdVectorArray[3]));
        povObject.addChild(this.newCylinder(pdVectorArray[2], pdVectorArray[6]));
        povObject.addChild(this.newCylinder(pdVectorArray[3], pdVectorArray[7]));
        povObject.addChild(this.newCylinder(pdVectorArray[4], pdVectorArray[5]));
        povObject.addChild(this.newCylinder(pdVectorArray[4], pdVectorArray[6]));
        povObject.addChild(this.newCylinder(pdVectorArray[5], pdVectorArray[7]));
        povObject.addChild(this.newCylinder(pdVectorArray[6], pdVectorArray[7]));
        povObject.addChild(this.newPigment(Color.blue));
        povObject.addChild(AMBIENT_FINISH);
        povObject.addChild("#if(SHADOW_BOUNDING_BOX=0) no_shadow #end");
        return povObject;
    }

    private PovObject makeVertexNormals(PgPointSet pgPointSet) {
        String string = PgPovLoader.cleanName(pgPointSet.getName());
        double d = this.getRadius(pgPointSet.getGlobalVertexNormalSize());
        PovObject povObject = new PovObject("union");
        povObject.addChild("// vertex normals of " + string);
        for (int i = 0; i < pgPointSet.getNumVertices(); ++i) {
            PdVector pdVector = PdVector.copyNew((PdVector)pgPointSet.getVertexNormal(i));
            pdVector.setLength(pgPointSet.getGlobalVertexNormalLength());
            povObject.addChild(PgPovLoader.toPovArrow(pgPointSet.getVertex(i), pdVector, d, "WIDTH_VECTOR"));
        }
        povObject.addChild(this.newPigment(pgPointSet.getGlobalVertexNormalColor()));
        povObject.addChild("#if(SHADOW_VERTEX_NORMALS=0) no_shadow #end");
        return povObject;
    }

    private PovObject makeElementNormals(PgElementSet pgElementSet) {
        double d = this.getRadius(pgElementSet.getGlobalElementNormalSize());
        PovObject povObject = this.newPigment(pgElementSet.getGlobalElementNormalColor());
        PovObject povObject2 = new PovObject("union", "// element normals of " + PgPovLoader.cleanName(pgElementSet.getName()));
        for (int i = 0; i < pgElementSet.getNumElements(); ++i) {
            PdVector pdVector = pgElementSet.getCenterOfElement(null, i);
            PdVector pdVector2 = PdVector.copyNew((PdVector)pgElementSet.getElementNormal(i));
            pdVector2.setLength(pgElementSet.getGlobalElementNormalLength());
            String string = PgPovLoader.toPovArrow(pdVector, pdVector2, d, "WIDTH_VECTOR");
            povObject2.addChild(string);
        }
        povObject2.addChild(povObject);
        povObject2.addChild("#if(SHADOW_ELEMENT_NORMALS=0) no_shadow #end");
        return povObject2;
    }

    private PovObject makeVertexVectorField(PgPointSet pgPointSet, PgVectorField pgVectorField) {
        Color color = pgPointSet.getGlobalVectorColor();
        if (pgVectorField.isShowingIndividualMaterial()) {
            color = pgVectorField.getGlobalVectorColor();
        }
        PovObject povObject = new PovObject("union");
        povObject.addChild("// vector field " + PgPovLoader.cleanName(pgVectorField.getName()) + " of " + PgPovLoader.cleanName(pgPointSet.getName()));
        for (int i = 0; i < pgPointSet.getNumVertices(); ++i) {
            if (!(pgVectorField.getVector(i).sqrLength() > 1.0E-10)) continue;
            PdVector pdVector = PdVector.copyNew((PdVector)pgVectorField.getVector(i));
            pdVector.setLength(pgVectorField.getGlobalVectorLength());
            String string = PgPovLoader.toPovArrow(pgPointSet.getVertex(i), pdVector, pgPointSet.getGlobalVectorSize(), "WIDTH_VECTOR");
            povObject.addChild(string);
        }
        povObject.addChild(this.newPigment(color));
        povObject.addChild("#if(SHADOW_VECTOR=0) no_shadow #end");
        return povObject;
    }

    private PovObject makeElementVectorField(PgVectorField pgVectorField) {
        PgElementSet pgElementSet = (PgElementSet)pgVectorField.getGeometry();
        Color color = pgElementSet.getGlobalVectorColor();
        if (pgVectorField.isShowingIndividualMaterial()) {
            color = pgVectorField.getGlobalVectorColor();
        }
        PovObject povObject = new PovObject("object");
        povObject.addChild("// vector field " + PgPovLoader.cleanName(pgVectorField.getName()) + " of " + PgPovLoader.cleanName(pgElementSet.getName()));
        for (int i = 0; i < pgElementSet.getNumVertices(); ++i) {
            if (!(pgVectorField.getVector(i).sqrLength() > 1.0E-10)) continue;
            PdVector pdVector = pgElementSet.getCenterOfElement(null, i);
            PdVector pdVector2 = PdVector.copyNew((PdVector)pgElementSet.getElementNormal(i));
            pdVector2.setLength(pgElementSet.getGlobalElementNormalLength());
            String string = PgPovLoader.toPovArrow(pdVector, pdVector2, pgElementSet.getGlobalElementNormalSize(), "WIDTH_VECTOR");
            povObject.addChild(string);
        }
        povObject.addChild(this.newPigment(color));
        povObject.addChild("#if(SHADOW_VECTOR=0) no_shadow #end");
        return povObject;
    }

    private double appendLights(StringBuffer stringBuffer, PgJvxSrc[] pgJvxSrcArray) {
        PvDisplayOption pvDisplayOption = this.getDisplayOption();
        double d = 0.0;
        for (int i = 0; i < pvDisplayOption.getNumLights(); ++i) {
            PdVector pdVector = pvDisplayOption.getLightPosition(i);
            PdVector pdVector2 = pvDisplayOption.getLightInterest(i);
            if (pvDisplayOption.getLightReference(i) == 1) {
                pdVector = pvDisplayOption.getCameraPosition(this.m_curcam);
                pdVector2 = pvDisplayOption.getCameraInterest(this.m_curcam);
            }
            double d2 = pvDisplayOption.getLightIntensity(i);
            if (pvDisplayOption.isLightHighlight(i)) {
                d += d2 / (double)pvDisplayOption.getNumLights();
            }
            int n = pvDisplayOption.getLightType(i);
            Color color = pvDisplayOption.getLightColor(i);
            PovObject povObject = new PovObject("light_source", "// " + pvDisplayOption.getLightName(i));
            povObject.addChild(PgPovLoader.toPovString(pdVector));
            povObject.append("color rgb <" + (double)color.getRed() * d2 / 255.0 + "," + (double)color.getGreen() * d2 / 255.0 + "," + (double)color.getBlue() * d2 / 255.0 + ">*" + 1.65);
            switch (n) {
                case 0: {
                    povObject.addChild("parallel");
                    break;
                }
                case 1: {
                    povObject.addChild("parallel");
                    break;
                }
                case 2: {
                    povObject.addChild("parallel");
                    break;
                }
                case 3: {
                    povObject.addChild("spotlight \n");
                    povObject.addChild("falloff " + pvDisplayOption.getLightFalloff(i));
                    povObject.addChild("radius " + pvDisplayOption.getLightAngle(i));
                    povObject.addChild("tightness " + pvDisplayOption.getLightCorona(i));
                    break;
                }
                case 4: {
                    povObject.addChild("parallel");
                    break;
                }
                case 5: {
                    povObject.addChild("parallel");
                    break;
                }
                case 6: {
                    povObject.addChild("parallel");
                    break;
                }
                default: {
                    povObject.addChild("parallel");
                }
            }
            povObject.addChild("point_at" + PgPovLoader.toPovString(pdVector2));
            PdVector[] pdVectorArray = new PdVector[]{new PdVector(3), new PdVector(3)};
            for (int j = 0; j < pgJvxSrcArray.length; ++j) {
                PdVector[] pdVectorArray2 = pgJvxSrcArray[j].getBounds();
                pdVectorArray[0].min(pdVectorArray2[0]);
                pdVectorArray[1].max(pdVectorArray2[1]);
            }
            double d3 = 0.5 * PdVector.dist((PdVector)pdVectorArray[0], (PdVector)pdVectorArray[1]);
            PdVector pdVector3 = new PdVector(Math.PI, Math.E, 1.0);
            PdVector pdVector4 = PdVector.subNew((PdVector)pdVector2, (PdVector)pdVector);
            pdVector3.orthogonalize(pdVector4);
            pdVector3.setLength(d3);
            PdVector pdVector5 = PdVector.crossNew((PdVector)pdVector4, (PdVector)pdVector3);
            pdVector5.setLength(d3);
            povObject.addChild("#if (AREA_LIGHTS=1) area_light " + PgPovLoader.toPovString(pdVector3) + ", " + PgPovLoader.toPovString(pdVector5) + ", " + 4 + ", " + 4 + " adaptive 1 jitter #end");
            this.appendObj(stringBuffer, povObject);
        }
        return d;
    }

    private int appendCamera(StringBuffer stringBuffer) {
        PvDisplayOption pvDisplayOption = this.getDisplayOption();
        int n = pvDisplayOption.getCurrentCamera();
        this.m_curcam = 0;
        while (this.m_curcam < pvDisplayOption.getNumCameras() && n != pvDisplayOption.getCameraProjection(this.m_curcam)) {
            ++this.m_curcam;
        }
        double d = pvDisplayOption.getCameraFieldOfView(this.m_curcam);
        PdVector pdVector = pvDisplayOption.getCameraInterest(this.m_curcam);
        PdVector pdVector2 = new PdVector(3);
        pdVector2 = d == 0.0 ? pvDisplayOption.getCameraPosition(this.m_curcam) : PdVector.blendNew((double)1.0, (PdVector)pdVector, (double)(-1.0 / d), (PdVector)pdVector, (double)(1.0 / d), (PdVector)pvDisplayOption.getCameraPosition(this.m_curcam));
        pdVector2.blend(0.7, pdVector2, 0.3, pdVector);
        pvDisplayOption.setCameraRoll(0, -pvDisplayOption.getCameraRoll(this.m_curcam));
        PovObject povObject = new PovObject("camera");
        if (d == 0.0) {
            povObject.addChild("orthographic angle 0");
        } else {
            povObject.addChild("angle 360/pi*atan(" + 0.9 * d + ")");
        }
        povObject.addChild("right " + pvDisplayOption.getWindowSize().width + "/" + pvDisplayOption.getWindowSize().height + "*x");
        povObject.addChild("up y");
        PdVector pdVector3 = pvDisplayOption.getCameraMatrix(this.m_curcam).getRow(1);
        pdVector3.setSize(3);
        povObject.addChild("sky" + PgPovLoader.toPovString(pdVector3));
        povObject.addChild("location" + PgPovLoader.toPovString(pdVector2));
        povObject.addChild("look_at" + PgPovLoader.toPovString(pdVector));
        this.appendObj(stringBuffer, povObject);
        return this.m_curcam;
    }

    private PovObject declareArray(String string, Color[] colorArray, double d) {
        PovObject povObject = new PovObject("#declare " + string + "=array[" + colorArray.length + "]");
        for (int i = 0; i < colorArray.length; ++i) {
            if (i != 0) {
                povObject.append(", ");
            }
            povObject.append("\n");
            povObject.append(TAB_SPACE);
            if (d > 0.0) {
                povObject.append(PgPovLoader.toPovString(colorArray[i], d));
                continue;
            }
            povObject.append(PgPovLoader.toPovString(colorArray[i]));
        }
        return povObject;
    }

    private PovObject declareArray(String string, PdVector[] pdVectorArray) {
        PovObject povObject = new PovObject("#declare " + string + "=array[" + pdVectorArray.length + "]");
        for (int i = 0; i < pdVectorArray.length; ++i) {
            if (i != 0) {
                povObject.append(", ");
            }
            povObject.append("\n");
            povObject.append(TAB_SPACE);
            povObject.append(PgPovLoader.toPovString(pdVectorArray[i]));
        }
        return povObject;
    }

    private void appendObj(StringBuffer stringBuffer, PovObject povObject) {
        stringBuffer.append("\n");
        stringBuffer.append(povObject.toString());
    }

    private double getRadius(double d) {
        PvDisplayOption pvDisplayOption = this.getDisplayOption();
        PdVector pdVector = pvDisplayOption.getCameraMatrix(this.m_curcam).getRow(2);
        pdVector.setSize(3);
        pdVector.normalize();
        double d2 = PdVector.dotDir((PdVector)pdVector, (PdVector)pvDisplayOption.getCameraInterest(this.m_curcam), (PdVector)pvDisplayOption.getCameraPosition(this.m_curcam));
        double d3 = pvDisplayOption.getCameraFieldOfView(this.m_curcam);
        if (d3 < 1.0E-10) {
            d3 = 90.0;
        }
        return Math.abs(d2 *= Math.atan(d3 * Math.PI) * d / (double)pvDisplayOption.getWindowSize().width);
    }

    private static String cleanName(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (!(c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a') && c <= 'z') continue;
            cArray[i] = 95;
        }
        return new String(cArray);
    }

    private static String toPovArrow(PdVector pdVector, PdVector pdVector2, double d, String string) {
        String string2 = "arrow(" + pdVector.m_data[0] + ", " + -pdVector.m_data[1] + ", " + pdVector.m_data[2] + ", " + pdVector2.m_data[0] + ", " + -pdVector2.m_data[1] + ", " + pdVector2.m_data[2] + ", " + d;
        if (string != null) {
            string2 = string2 + " * " + string;
        }
        return string2 + ")";
    }

    private static String toPovString(Color color, double d) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("color rgbt <");
        stringBuffer.append((double)color.getRed() / 255.0 + ",");
        stringBuffer.append((double)color.getGreen() / 255.0 + ",");
        stringBuffer.append((double)color.getBlue() / 255.0 + ",");
        stringBuffer.append(d + ">");
        return stringBuffer.toString();
    }

    private static String toPovString(PdVector pdVector) {
        if (pdVector.getSize() < 1) {
            return "";
        }
        if (pdVector.getSize() == 1) {
            return "<" + pdVector.getEntry(0) + ">";
        }
        if (pdVector.getSize() == 2) {
            return "<" + pdVector.getEntry(0) + "," + -pdVector.getEntry(1) + ">";
        }
        return "<" + pdVector.getEntry(0) + "," + -pdVector.getEntry(1) + "," + pdVector.getEntry(2) + ">";
    }

    private static String toPovString(Color color) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("color rgb <");
        stringBuffer.append((float)color.getRed() / 255.0f);
        stringBuffer.append(",");
        stringBuffer.append((float)color.getGreen() / 255.0f);
        stringBuffer.append(",");
        stringBuffer.append((float)color.getBlue() / 255.0f);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    private PovObject newCylinder(PdVector pdVector, PdVector pdVector2) {
        PovObject povObject = new PovObject("cylinder", PgPovLoader.toPovString(pdVector) + ", " + PgPovLoader.toPovString(pdVector2) + ", rad\n");
        return povObject;
    }

    private PovObject newPigment(Color color) {
        if (color == null) {
            return null;
        }
        return new PovObject("pigment", PgPovLoader.toPovString(color));
    }

    private final class PovObject {
        private StringBuffer m_buf = new StringBuffer();

        PovObject(String string) {
            this.m_buf.append(string);
            this.m_buf.append(" {");
        }

        public PovObject(String string, String string2) {
            this(string, new String[]{string2});
        }

        public PovObject(String string, String string2, String string3) {
            this(string, new String[]{string2, string3});
        }

        public PovObject(String string, String string2, String string3, String string4) {
            this(string, new String[]{string2, string3, string4});
        }

        public PovObject(String string, String[] stringArray) {
            this(string);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.addChild(stringArray[i]);
                }
            }
        }

        public void addChild(PovObject povObject) {
            this.addChild(povObject.toString());
        }

        public void addChild(String string) {
            string = "\n" + string;
            string = PuString.replace((String)string, (String)"\n", (String)"\n   ");
            this.m_buf.append(string);
        }

        public void append(String string) {
            this.m_buf.append(string);
        }

        public String toString() {
            return this.m_buf.toString() + "\n}";
        }
    }
}

