/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Date;
import jv.loader.PgAbstractLoader;
import jv.loader.PvDisplayOption;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PgOffLoader
extends PgAbstractLoader {
    private static final String StrNL = "\n";

    public static PgJvxSrc[] read(String string) {
        BufferedReader bufferedReader = PsUtil.open((String)string);
        if (bufferedReader == null) {
            PsDebug.warning((String)("could not open = " + string));
            return null;
        }
        PgOffLoader pgOffLoader = new PgOffLoader();
        PgJvxSrc[] pgJvxSrcArray = pgOffLoader.read(bufferedReader);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (pgJvxSrcArray != null && pgJvxSrcArray.length > 0 && pgJvxSrcArray[0] != null) {
            if (pgJvxSrcArray.length == 1) {
                pgJvxSrcArray[0].setName(PsUtil.getFileBaseName((String)string));
            } else {
                for (int i = 0; i < pgJvxSrcArray.length; ++i) {
                    pgJvxSrcArray[i].setName(PsUtil.getFileBaseName((String)string) + "[" + i + "]");
                }
            }
        }
        return pgJvxSrcArray;
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing reader");
            return null;
        }
        PgJvxSrc pgJvxSrc = this.parse(bufferedReader);
        if (pgJvxSrc == null) {
            PsDebug.warning((String)"error during parsing of reader");
            return null;
        }
        this.geomInitType(pgJvxSrc);
        return new PgJvxSrc[]{pgJvxSrc};
    }

    private void geomInitType(PgJvxSrc pgJvxSrc) {
        switch (pgJvxSrc.getType()) {
            case 30: {
                pgJvxSrc.showVertices(true);
                break;
            }
            case 33: {
                pgJvxSrc.showEdges(true);
                pgJvxSrc.showElements(true);
                break;
            }
            case 32: {
                pgJvxSrc.showVertices(true);
                pgJvxSrc.showPolygons(true);
                pgJvxSrc.showEdges(true);
            }
        }
    }

    protected PgJvxSrc parse(BufferedReader bufferedReader) {
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.ordinaryChars(47, 47);
        streamTokenizer.whitespaceChars(59, 59);
        streamTokenizer.commentChar(35);
        PgJvxSrc pgJvxSrc = this.parseGeom(streamTokenizer);
        return pgJvxSrc;
    }

    private PgJvxSrc parseGeom(StreamTokenizer streamTokenizer) {
        try {
            block6: while (true) {
                switch (streamTokenizer.nextToken()) {
                    default: {
                        continue block6;
                    }
                    case -1: {
                        PsDebug.warning((String)"could not find magic keyword OFF");
                        return null;
                    }
                    case -3: 
                }
                if (streamTokenizer.sval.endsWith("OFF")) {
                    PgJvxSrc pgJvxSrc = this.parseOff(streamTokenizer);
                    return pgJvxSrc;
                }
                if (streamTokenizer.sval.endsWith("VECT")) {
                    PgJvxSrc pgJvxSrc = this.parseVect(streamTokenizer);
                    return pgJvxSrc;
                }
                if (streamTokenizer.sval.endsWith("LIST")) {
                    PgJvxSrc pgJvxSrc = this.parseList(streamTokenizer);
                    return pgJvxSrc;
                }
                if (streamTokenizer.sval.endsWith("INST")) break;
            }
            PgJvxSrc pgJvxSrc = this.parseInst(streamTokenizer);
            return pgJvxSrc;
        }
        catch (IOException iOException) {
            PsDebug.warning((String)("Exception thrown in line=" + streamTokenizer.lineno() + ", Exception = " + iOException));
            return null;
        }
    }

    private PgJvxSrc parseList(StreamTokenizer streamTokenizer) {
        PsDebug.warning((String)"method parseList not implemented yet, send your geometry to JavaView authors.");
        return null;
    }

    private PgJvxSrc parseVect(StreamTokenizer streamTokenizer) {
        PsDebug.warning((String)"method parseVect not implemented yet, send your geometry to JavaView authors.");
        return null;
    }

    private PgJvxSrc parseInst(StreamTokenizer streamTokenizer) {
        PgJvxSrc pgJvxSrc = null;
        PdMatrix pdMatrix = null;
        try {
            do {
                switch (streamTokenizer.nextToken()) {
                    default: {
                        PsDebug.warning((String)"identifier \"geom\" or \"transform\" expected in Inst");
                        return null;
                    }
                    case -3: 
                }
                if (streamTokenizer.sval.equals("geom")) {
                    pgJvxSrc = this.parseGeom(streamTokenizer);
                    continue;
                }
                if (streamTokenizer.sval.equals("transform")) {
                    pdMatrix = new PdMatrix(4);
                    for (int i = 0; i < 4; ++i) {
                        for (int j = 0; j < 4; ++j) {
                            pdMatrix.m_data[j][i] = PuDouble.parseDouble((StreamTokenizer)streamTokenizer);
                        }
                    }
                    this.m_displayOption = new PvDisplayOption();
                    this.m_displayOption.setCameraMatrix(0, pdMatrix);
                    continue;
                }
                PsDebug.warning((String)"identifier \"geom\" or \"transform\" expected in Inst");
                return null;
            } while (pgJvxSrc == null || pdMatrix == null);
        }
        catch (IOException iOException) {
            PsDebug.warning((String)("Exception thrown in line=" + streamTokenizer.lineno() + ", Exception = " + iOException));
            return null;
        }
        return pgJvxSrc;
    }

    private PgJvxSrc parseOff(StreamTokenizer streamTokenizer) {
        int n = 4;
        int n2 = 200;
        double[] dArray = new double[n];
        int[] nArray = new int[n2];
        try {
            int n3;
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            int n4 = 3;
            PgJvxSrc pgJvxSrc = new PgJvxSrc();
            pgJvxSrc.setType(33);
            String string = streamTokenizer.sval;
            boolean bl5 = string.startsWith("ST");
            if (bl5) {
                string = string.substring(2);
            }
            if (bl4 = string.startsWith("C")) {
                string = string.substring(1);
            }
            if (bl3 = string.startsWith("N")) {
                string = string.substring(1);
            }
            if (bl2 = string.startsWith("4")) {
                string = string.substring(1);
            }
            if (bl = string.startsWith("n")) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != -2) {
                    PsDebug.warning((String)("missing dim of vertices=" + streamTokenizer.lineno()));
                    return null;
                }
                n4 = (int)streamTokenizer.nval;
            }
            if (bl2) {
                ++n4;
            }
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != -2) {
                PsDebug.warning((String)("missing number of vertices=" + streamTokenizer.lineno()));
                return null;
            }
            pgJvxSrc.setDimOfVertices(n4);
            pgJvxSrc.setNumVertices((int)streamTokenizer.nval);
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != -2) {
                PsDebug.warning((String)("missing number of elements=" + streamTokenizer.lineno()));
                return null;
            }
            pgJvxSrc.setDimOfElements(-1);
            pgJvxSrc.setNumElements((int)streamTokenizer.nval);
            double d = -1.0;
            int n5 = 3;
            int n6 = 2;
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != -2) {
                PsDebug.warning((String)("missing number of edges=" + streamTokenizer.lineno()));
                return null;
            }
            int n7 = pgJvxSrc.getNumVertices();
            PdVector[] pdVectorArray = pgJvxSrc.getVertices();
            Color[] colorArray = null;
            PdVector[] pdVectorArray2 = null;
            PdVector[] pdVectorArray3 = null;
            if (bl4) {
                pgJvxSrc.assureVertexColors();
                colorArray = new Color[n7];
            }
            if (bl3) {
                pgJvxSrc.assureVertexNormals();
                pdVectorArray2 = pgJvxSrc.getVertexNormals();
            }
            if (bl5) {
                pgJvxSrc.assureVertexTextures();
                pdVectorArray3 = pgJvxSrc.getVertexTextures();
            }
            streamTokenizer.eolIsSignificant(true);
            int n8 = 0;
            for (n8 = 0; n8 < n7; ++n8) {
                for (n3 = 0; n3 < n4; ++n3) {
                    dArray[n3] = PuDouble.parseDouble((StreamTokenizer)streamTokenizer);
                }
                if (bl2) {
                    n3 = 0;
                    while (n3 < n4 - 1) {
                        int n9 = n3++;
                        dArray[n9] = dArray[n9] / dArray[n4 - 1];
                    }
                    pdVectorArray[n8].set(dArray, n4 - 1);
                } else {
                    pdVectorArray[n8].set(dArray, n4);
                }
                if (bl3) {
                    for (n3 = 0; n3 < n5; ++n3) {
                        dArray[n3] = PuDouble.parseDouble((StreamTokenizer)streamTokenizer);
                    }
                    pdVectorArray2[n8].set(dArray, n5);
                }
                if (bl4) {
                    for (n3 = 0; n3 < 3; ++n3) {
                        dArray[n3] = PuDouble.parseDouble((StreamTokenizer)streamTokenizer);
                        if (!(dArray[n3] > 1.0)) continue;
                        int n10 = n3;
                        dArray[n10] = dArray[n10] / 255.0;
                    }
                    colorArray[n8] = new Color((float)dArray[0], (float)dArray[1], (float)dArray[2]);
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -2) {
                        streamTokenizer.pushBack();
                        d = PuDouble.parseDouble((StreamTokenizer)streamTokenizer);
                    }
                }
                if (!bl5) continue;
                for (n3 = 0; n3 < n6; ++n3) {
                    dArray[n3] = PuDouble.parseDouble((StreamTokenizer)streamTokenizer);
                }
                pdVectorArray3[n8].set(dArray, n6);
            }
            streamTokenizer.eolIsSignificant(false);
            if (colorArray != null) {
                pgJvxSrc.setVertexColors(colorArray);
                pgJvxSrc.showVertexColors(true);
            }
            if (pdVectorArray2 != null) {
                pgJvxSrc.setVertexNormals(pdVectorArray2);
            }
            if (pdVectorArray3 != null) {
                pgJvxSrc.setVertexTextures(pdVectorArray3);
                pgJvxSrc.showVertexTexture(true);
            }
            int n11 = pgJvxSrc.getNumElements();
            PiVector[] piVectorArray = pgJvxSrc.getElements();
            Color[] colorArray2 = null;
            streamTokenizer.eolIsSignificant(true);
            int n12 = 0;
            while (n12 < n11) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -1) {
                    PsDebug.warning((String)"premature end of file");
                    return null;
                }
                if (streamTokenizer.ttype == 10) continue;
                if (streamTokenizer.ttype != -2) {
                    PsDebug.warning((String)("missing size of face[" + n12 + "] at line=" + streamTokenizer.lineno()));
                    return null;
                }
                int n13 = (int)streamTokenizer.nval;
                for (n3 = 0; n3 < n13; ++n3) {
                    streamTokenizer.nextToken();
                    nArray[n3] = (int)streamTokenizer.nval;
                }
                piVectorArray[n12].setSize(n13);
                piVectorArray[n12].set(nArray, n13);
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != 10) {
                    streamTokenizer.pushBack();
                    dArray[0] = PuDouble.parseDouble((StreamTokenizer)streamTokenizer);
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != 10) {
                        if (colorArray2 == null) {
                            colorArray2 = new Color[n11];
                            for (int i = 0; i < n12; ++i) {
                                colorArray2[i] = Color.white;
                            }
                        }
                        streamTokenizer.pushBack();
                        for (n3 = 1; n3 < 3; ++n3) {
                            dArray[n3] = PuDouble.parseDouble((StreamTokenizer)streamTokenizer);
                        }
                        for (n3 = 0; n3 < 3; ++n3) {
                            if (!(dArray[n3] > 1.0)) continue;
                            int n14 = n3;
                            dArray[n14] = dArray[n14] / 255.0;
                        }
                        colorArray2[n12] = new Color((float)dArray[0], (float)dArray[1], (float)dArray[2]);
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype != 10) {
                            streamTokenizer.pushBack();
                            d = PuDouble.parseDouble((StreamTokenizer)streamTokenizer);
                        }
                    }
                } else if (colorArray2 != null) {
                    colorArray2[n12] = Color.white;
                }
                ++n12;
            }
            streamTokenizer.eolIsSignificant(false);
            if (colorArray2 != null) {
                pgJvxSrc.setElementColors(colorArray2);
                pgJvxSrc.showElementColors(true);
            } else if (colorArray != null) {
                pgJvxSrc.showElementColors(true);
                pgJvxSrc.showElementColorFromVertices(true);
                pgJvxSrc.showSmoothElementColors(true);
            }
            if (d != -1.0) {
                if (d > 1.0) {
                    d /= 255.0;
                }
                pgJvxSrc.setTransparency(1.0 - d);
                pgJvxSrc.showTransparency(true);
            }
            return pgJvxSrc;
        }
        catch (IOException iOException) {
            PsDebug.warning((String)("Exception thrown in line=" + streamTokenizer.lineno() + ", Exception = " + iOException));
            return null;
        }
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        PdVector[] pdVectorArray;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        if (pgJvxSrc.getType() != 33) {
            PsDebug.warning((String)"geometry is not an element set");
            return false;
        }
        String string = "";
        Color[] colorArray = pgJvxSrc.getVertexColors();
        if (colorArray != null) {
            string = string + "C";
        }
        if ((pdVectorArray = pgJvxSrc.getVertexNormals()) != null) {
            string = string + "N";
        }
        Color[] colorArray2 = pgJvxSrc.getElementColors();
        int n = pgJvxSrc.getNumVertices();
        int n2 = pgJvxSrc.getNumElements();
        writer.write("# Produced with JavaView v." + PsConfig.getVersion() + StrNL);
        writer.write("# JavaView is " + PsConfig.getCopyright() + ", " + PsConfig.getHomepage() + StrNL);
        writer.write("# by " + PsConfig.getAuthors() + StrNL);
        writer.write("#     File Format = GeomView OFF\n");
        writer.write("#     Date        = " + new Date().toString() + StrNL);
        writer.write("#     Scene Title = " + pgJvxSrc.getTitle() + StrNL);
        writer.write("#\n");
        writer.write("#     Geometry    = " + pgJvxSrc.getName() + StrNL);
        writer.write("#     Number of Vertices = " + n + StrNL);
        writer.write("#     Number of Elements = " + n2 + StrNL);
        if (colorArray != null) {
            writer.write("#     Additional: Vertex Colors\n");
        }
        if (pdVectorArray != null) {
            writer.write("#     Additional: Vertex Normals\n");
        }
        if (colorArray2 != null) {
            writer.write("#     Additional: Element Colors\n");
        }
        writer.write("#\n# End of Header\n");
        writer.write(string + "OFF\n");
        writer.write(String.valueOf(pgJvxSrc.getNumVertices()) + " " + String.valueOf(pgJvxSrc.getNumElements()) + " 0\n");
        boolean bl = pgJvxSrc.isShowingTransparency();
        double d = pgJvxSrc.getTransparency();
        if (n > 0) {
            writer.write(PgOffLoader.writeVertices(n, pgJvxSrc.getVertices(), colorArray, pdVectorArray, bl, d));
        }
        if (n2 > 0) {
            writer.write(PgOffLoader.writeElements(n2, pgJvxSrc.getElements(), colorArray2, bl, d));
        }
        return true;
    }

    protected static String writeVertices(int n, PdVector[] pdVectorArray, Color[] colorArray, PdVector[] pdVectorArray2, boolean bl, double d) {
        if (n <= 0 || pdVectorArray == null || n > pdVectorArray.length) {
            return null;
        }
        float f = 1.0f - (float)d;
        String string = " " + String.valueOf(f);
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < n; ++i) {
            int n2;
            if (pdVectorArray[i] == null || pdVectorArray[i].getSize() == 0) {
                PsDebug.warning((String)("missing vertex, ind = " + i));
                return null;
            }
            int n3 = Math.min(3, pdVectorArray[i].getSize());
            for (n2 = 0; n2 < n3; ++n2) {
                if (Math.abs(pdVectorArray[i].m_data[n2]) > 1.0E-10) {
                    stringBuffer.append(" " + PuString.toString((float)((float)pdVectorArray[i].m_data[n2])));
                    continue;
                }
                stringBuffer.append(" 0.");
            }
            for (n2 = n3; n2 < 3; ++n2) {
                stringBuffer.append(" 0.");
            }
            if (pdVectorArray2 != null) {
                n3 = Math.min(3, pdVectorArray2[i].getSize());
                for (n2 = 0; n2 < n3; ++n2) {
                    if (Math.abs(pdVectorArray2[i].m_data[n2]) > 1.0E-10) {
                        stringBuffer.append(" " + PuString.toString((float)((float)pdVectorArray2[i].m_data[n2])));
                        continue;
                    }
                    stringBuffer.append(" 0.");
                }
                for (n2 = n3; n2 < 3; ++n2) {
                    stringBuffer.append(" 0.");
                }
            }
            if (colorArray != null) {
                stringBuffer.append(" " + PdColor.toStringAsFloat((Color)colorArray[i], (String)" "));
                if (bl) {
                    stringBuffer.append(string);
                }
            }
            stringBuffer.append(StrNL);
        }
        return stringBuffer.toString();
    }

    protected static String writeElements(int n, PiVector[] piVectorArray, Color[] colorArray, boolean bl, double d) {
        if (n <= 0 || piVectorArray == null || n > piVectorArray.length) {
            return null;
        }
        float f = 1.0f - (float)d;
        String string = " " + String.valueOf(f);
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < n; ++i) {
            if (piVectorArray[i] == null) {
                PsDebug.warning((String)("missing element, ind = " + i));
                return null;
            }
            stringBuffer.append(String.valueOf(piVectorArray[i].getSize()));
            for (int j = 0; j < piVectorArray[i].m_data.length; ++j) {
                stringBuffer.append(" " + String.valueOf(piVectorArray[i].m_data[j]));
            }
            if (colorArray != null) {
                stringBuffer.append(" " + PdColor.toStringAsFloat((Color)colorArray[i], (String)" "));
                if (bl) {
                    stringBuffer.append(string);
                }
            }
            stringBuffer.append(StrNL);
        }
        return stringBuffer.toString();
    }
}

