/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.util.BitSet;
import jv.geom.PgBndConstraint;
import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PgMacroPatch
extends PsObject {
    protected PiVector[] m_vertexType;
    protected PdVector[] m_vertex;
    protected PiVector m_element;
    protected BitSet[] m_bndShapeBits;
    protected PiVector[] m_bndShape;
    protected int m_dim;
    protected int m_bndType;
    protected int m_orientation;
    protected int m_numULines;
    protected int m_numVLines;
    protected int m_numUSubs;
    protected int m_numVSubs;
    static /* synthetic */ Class class$jvx$loader$PgMacroPatch;

    public PgMacroPatch(int n) {
        this.m_dim = n;
        if (((Object)((Object)this)).getClass() == (class$jvx$loader$PgMacroPatch == null ? (class$jvx$loader$PgMacroPatch = PgMacroPatch.class$("jvx.loader.PgMacroPatch")) : class$jvx$loader$PgMacroPatch)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_orientation = 0;
        this.m_vertexType = null;
        this.m_vertex = null;
        this.m_element = new PiVector();
        this.m_bndShapeBits = null;
        this.m_bndShape = null;
    }

    public int getDimVertices() {
        return this.m_dim;
    }

    public int getNumVertices() {
        return this.m_element.getSize();
    }

    public void setNumVertices(int n) {
        this.m_element.setSize(n);
        this.m_bndShapeBits = new BitSet[n];
        for (int i = 0; i < n; ++i) {
            this.m_bndShapeBits[i] = new BitSet(32);
        }
        this.m_bndShape = PiVector.realloc((PiVector[])this.m_bndShape, (int)n, (int)3);
    }

    public int getBndType() {
        return this.m_bndType;
    }

    public void setBndType(int n) {
        this.m_bndType = n;
    }

    public int getOrientation() {
        return this.m_orientation;
    }

    public void setOrientation(int n) {
        this.m_orientation = n;
    }

    public void setVertexType(PiVector[] piVectorArray) {
        this.m_vertexType = piVectorArray;
    }

    public void setVertex(PdVector[] pdVectorArray) {
        this.m_vertex = pdVectorArray;
    }

    public PgPolygon makePolygon(PgPolygon pgPolygon, int n) {
        if (n < 0 || this.getNumVertices() <= n) {
            PsDebug.warning((String)("polygon index=" + n + " out of range"));
            return pgPolygon;
        }
        int n2 = this.m_element.getSize();
        int n3 = n2 == 4 && n % 2 == 1 ? this.m_numVLines : this.m_numULines;
        if (pgPolygon == null) {
            pgPolygon = new PgPolygon(this.m_dim);
        }
        pgPolygon.setNumVertices(n3);
        PdVector pdVector = this.m_vertex[this.m_element.m_data[n]];
        PdVector pdVector2 = this.m_vertex[this.m_element.m_data[(n + 1) % n2]];
        PiVector piVector = this.m_bndShape[n];
        PdVector[] pdVectorArray = pgPolygon.getVertices();
        if (this.m_bndShapeBits[n].get(7)) {
            for (int i = 0; i < n3; ++i) {
                double d = (double)i / ((double)n3 - 1.0);
                pdVectorArray[i].blend(1.0 - d, pdVector, d, pdVector2);
            }
        } else if (this.m_bndShapeBits[n].get(8)) {
            PdVector pdVector3 = this.m_vertex[piVector.m_data[1]];
            PdVector pdVector4 = this.m_vertex[piVector.m_data[2]];
            for (int i = 0; i < n3; ++i) {
                double d = (double)i / ((double)n3 - 1.0);
                PuVectorGeom.evalCircle((PdVector)pdVectorArray[i], (PdVector)pdVector3, (PdVector)pdVector4, (PdVector)pdVector, (PdVector)pdVector2, (double)d);
            }
        } else if (this.m_bndShapeBits[n].get(9)) {
            PdVector pdVector5 = this.m_vertex[piVector.m_data[1]];
            PdVector pdVector6 = this.m_vertex[piVector.m_data[2]];
            for (int i = 0; i < n3; ++i) {
                double d = (double)i / ((double)n3 - 1.0);
                PuVectorGeom.evalHelix((PdVector)pdVectorArray[i], (PdVector)pdVector5, (PdVector)pdVector6, (PdVector)pdVector, (PdVector)pdVector2, (double)d);
            }
        } else if (this.m_bndShapeBits[n].get(10)) {
            PsDebug.warning((String)"evalSpline not yet written, use line instead");
        } else {
            PsDebug.warning((String)"unrecognized edge type");
        }
        return pgPolygon;
    }

    public PgBndConstraint makeBndConstraint(PgBndConstraint pgBndConstraint, int n) {
        if (n < 0 || this.getNumVertices() <= n) {
            PsDebug.warning((String)("BndConstraint index=" + n + " out of range"));
            return pgBndConstraint;
        }
        int n2 = this.m_element.getSize();
        if (pgBndConstraint == null) {
            pgBndConstraint = new PgBndConstraint(this.m_dim);
        }
        pgBndConstraint.m_start = this.m_vertex[this.m_element.m_data[n]];
        pgBndConstraint.m_end = this.m_vertex[this.m_element.m_data[(n + 1) % n2]];
        pgBndConstraint.setShape(this.m_bndShapeBits[n]);
        pgBndConstraint.m_vec1 = this.m_vertex[this.m_bndShape[n].m_data[1]];
        pgBndConstraint.m_vec2 = this.m_vertex[this.m_bndShape[n].m_data[2]];
        if (pgBndConstraint.m_startDir == null) {
            pgBndConstraint.m_startDir = new PdVector(this.m_dim);
        }
        pgBndConstraint.m_startDir.setConstant(0.0);
        if (pgBndConstraint.m_endDir == null) {
            pgBndConstraint.m_endDir = new PdVector(this.m_dim);
        }
        pgBndConstraint.m_endDir.setConstant(0.0);
        if (this.m_bndShapeBits[n].get(4)) {
            pgBndConstraint.m_dir = PdVector.subNew((PdVector)pgBndConstraint.m_end, (PdVector)pgBndConstraint.m_start);
            pgBndConstraint.m_dir.normalize();
        } else if (this.m_bndShapeBits[n].get(5)) {
            PdVector pdVector;
            pgBndConstraint.m_dir = this.m_vertex[this.m_bndShape[n].m_data[2]];
            pgBndConstraint.m_dir.normalize();
            if (this.m_bndShapeBits[(n - 1 + n2) % n2].get(5)) {
                pdVector = this.m_vertex[this.m_bndShape[(n - 1 + n2) % n2].m_data[2]];
                pgBndConstraint.m_startDir = PdVector.crossNew((PdVector)pgBndConstraint.m_dir, (PdVector)pdVector);
                pgBndConstraint.m_startDir.normalize();
            }
            if (this.m_bndShapeBits[(n + 1) % n2].get(5)) {
                pdVector = this.m_vertex[this.m_bndShape[(n + 1) % n2].m_data[2]];
                pgBndConstraint.m_endDir = PdVector.crossNew((PdVector)pgBndConstraint.m_dir, (PdVector)pdVector);
                pgBndConstraint.m_endDir.normalize();
            }
        } else if (!this.m_bndShapeBits[n].get(11) && !this.m_bndShapeBits[n].get(12)) {
            if (this.m_bndShapeBits[n].get(3)) {
                pgBndConstraint.m_dir = new PdVector(this.m_dim);
                pgBndConstraint.m_dir.setConstant(0.0);
            } else {
                PsDebug.warning((String)"unrecognized edge type");
                pgBndConstraint.m_dir.setConstant(0.0);
            }
        }
        return pgBndConstraint;
    }

    public PgElementSet buildElementSet(PgElementSet pgElementSet) {
        if (pgElementSet == null) {
            pgElementSet = new PgElementSet(this.m_dim);
        }
        int n = this.getNumVertices();
        PgPolygon[] pgPolygonArray = new PgPolygon[n];
        for (int i = 0; i < n; ++i) {
            pgPolygonArray[i] = new PgPolygon(this.m_dim);
            pgPolygonArray[i] = this.makePolygon(pgPolygonArray[i], i);
        }
        PgBndConstraint[] pgBndConstraintArray = new PgBndConstraint[n];
        for (int i = 0; i < n; ++i) {
            pgBndConstraintArray[i] = new PgBndConstraint(this.m_dim);
            pgBndConstraintArray[i] = this.makeBndConstraint(pgBndConstraintArray[i], i);
        }
        switch (n) {
            case 3: {
                pgElementSet.buildTriangleFromCurve(pgPolygonArray, pgBndConstraintArray);
                break;
            }
            case 4: {
                pgElementSet.buildQuadrFromCurve(pgPolygonArray, pgBndConstraintArray);
                break;
            }
            default: {
                PsDebug.warning((String)("not supported, number of vertices = " + String.valueOf(n)));
            }
        }
        return pgElementSet;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

