/*
 * Decompiled with CFR 0.152.
 */
package jvx.gui;

import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.StringTokenizer;

public class PsToolTip
extends Canvas
implements MouseListener,
MouseMotionListener {
    private static final int MAX_LINE_LENGTH = 100;
    private static final int DELAY = 800;
    private static final int VERTICAL_OFFSET = 25;
    private static final int HORIZONTAL_ENLARGE = 5;
    protected Component m_owner;
    private Container m_mainContainer;
    private LayoutManager m_mainLayout;
    private boolean m_shown;
    private String[] m_textLines;
    private int m_maxWidth;
    private int m_numLines;
    private int m_lineHeight;
    private int m_lineAscent;
    private static volatile ToolTipTimer m_timer = new ToolTipTimer();

    public PsToolTip(Component component, String string) {
        this(component, true, string);
    }

    public PsToolTip(Component component, boolean bl, String string) {
        if (component == null) {
            return;
        }
        if (string == null) {
            string = "";
        }
        this.setTipText(string);
        this.m_owner = component;
        this.setBackground(new Color(255, 255, 220));
        this.removeMouseListeners(this.m_owner, true);
        this.addMouseListeners(this.m_owner, bl);
    }

    public void setTipText(String string) {
        string = PsToolTip.formatLines(string, 100);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        this.m_numLines = stringTokenizer.countTokens();
        this.m_textLines = new String[this.m_numLines];
        for (int i = 0; i < this.m_numLines; ++i) {
            this.m_textLines[i] = stringTokenizer.nextToken();
        }
    }

    private static String formatLines(String string, int n) {
        BreakIterator breakIterator = BreakIterator.getLineInstance(Locale.getDefault());
        breakIterator.setText(string);
        int n2 = breakIterator.first();
        int n3 = breakIterator.next();
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n3 != -1) {
            String string2 = string.substring(n2, n3);
            int n5 = string2.indexOf("\n");
            n4 = n5 >= 0 ? string2.length() - n5 - 1 : (n4 += string2.length());
            if (n4 >= n) {
                stringBuffer.append("\n");
                n4 = string2.length();
            }
            stringBuffer.append(string2);
            n2 = n3;
            n3 = breakIterator.next();
        }
        return stringBuffer.toString();
    }

    private void addMouseListeners(Component component, boolean bl) {
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        if (bl && component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                this.addMouseListeners(componentArray[i], true);
            }
        }
    }

    private void removeMouseListeners(Component component) {
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
    }

    public void remove() {
        this.removeMouseListeners(this.m_owner, true);
    }

    private void removeMouseListeners(Component component, boolean bl) {
        this.removeMouseListeners(component);
        if (bl && component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                this.removeMouseListeners(componentArray[i], true);
            }
        }
    }

    public void paint(Graphics graphics) {
        graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        int n = this.m_lineAscent;
        for (int i = 0; i < this.m_numLines; ++i) {
            graphics.drawString(this.m_textLines[i], 5, n);
            n += this.m_lineHeight;
        }
    }

    private void findMainContainer() {
        Container container = this.m_owner.getParent();
        while (true) {
            if (container instanceof Applet || container instanceof Frame) break;
            container = container.getParent();
        }
        this.m_mainContainer = container;
        this.m_mainLayout = this.m_mainContainer.getLayout();
    }

    protected void showTooltip(Point point) {
        this.findMainContainer();
        FontMetrics fontMetrics = this.getFontMetrics(this.m_owner.getFont());
        if (fontMetrics == null) {
            return;
        }
        this.m_lineHeight = fontMetrics.getHeight();
        this.m_lineAscent = fontMetrics.getAscent();
        this.m_maxWidth = 0;
        for (int i = 0; i < this.m_numLines; ++i) {
            this.m_maxWidth = Math.max(fontMetrics.stringWidth(this.m_textLines[i]), this.m_maxWidth);
        }
        this.m_mainContainer.setLayout(null);
        this.setSize(this.m_maxWidth + 10, this.m_numLines * this.m_lineHeight + 1);
        Point point2 = this.m_mainContainer.getLocationOnScreen();
        this.setLocation(point.x - point2.x, point.y - point2.y + 25);
        if (this.m_mainContainer.getSize().width < this.getLocation().x + this.getSize().width) {
            this.setLocation(this.m_mainContainer.getSize().width - this.getSize().width, this.getLocation().y);
        }
        this.m_mainContainer.add((Component)this, 0);
        this.m_mainContainer.validate();
        this.repaint();
        this.m_shown = true;
    }

    private void hideTooltip() {
        if (this.m_shown) {
            this.m_mainContainer.remove(0);
            this.m_mainContainer.setLayout(this.m_mainLayout);
            this.m_mainContainer.validate();
        }
        this.m_shown = false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        long l = System.currentTimeMillis() + 800L;
        Component component = mouseEvent.getComponent();
        Point point = component.getLocationOnScreen();
        point.setLocation(point.x + mouseEvent.getX(), point.y + mouseEvent.getY());
        m_timer.setTooltip(this, l, point);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        Point point = component.getLocationOnScreen();
        point.setLocation(point.x + mouseEvent.getX(), point.y + mouseEvent.getY());
        m_timer.setPosition(this, point);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        m_timer.clearTooltip(this);
        this.hideTooltip();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        m_timer.clearTooltip(this);
        this.hideTooltip();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        m_timer.clearTooltip(this);
        this.hideTooltip();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    protected static class ToolTipTimer
    implements Runnable {
        private static volatile long m_popUpTime = 0L;
        private static volatile Point m_pos;
        private static volatile Thread m_thread;
        private static volatile PsToolTip m_lastCaller;

        protected ToolTipTimer() {
        }

        public void run() {
            while (m_popUpTime > System.currentTimeMillis()) {
                try {
                    long l = m_popUpTime - System.currentTimeMillis();
                    if (l <= 0L) continue;
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (m_lastCaller != null) {
                m_lastCaller.showTooltip(m_pos);
                m_lastCaller = null;
            }
        }

        protected void setTooltip(PsToolTip psToolTip, long l, Point point) {
            if (l < m_popUpTime) {
                return;
            }
            m_lastCaller = psToolTip;
            m_popUpTime = l;
            m_pos = point;
            if (m_thread == null || !m_thread.isAlive()) {
                m_thread = new Thread((Runnable)this, "Tooltip timer thread");
                m_thread.start();
            }
        }

        protected void setPosition(PsToolTip psToolTip, Point point) {
            if (m_lastCaller == psToolTip) {
                m_pos = point;
            }
        }

        protected void clearTooltip(PsToolTip psToolTip) {
            if (m_lastCaller == psToolTip) {
                m_lastCaller = null;
                m_popUpTime = 0L;
            }
        }

        static {
            m_lastCaller = null;
        }
    }
}

