/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.geom.PgEdgeStar;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jvx.geom.PwCurvature;
import jvx.geom.PwShapeOperator;
import jvx.project.PjWorkshop_IP;

public class PwShapeOperator_IP
extends PjWorkshop_IP
implements ItemListener {
    private static final long serialVersionUID = -8731738301460055172L;
    Checkbox m_cStarMethod;
    Checkbox m_cEpsBallMethod;
    CheckboxGroup m_cAlgo;
    Label m_lMinEdgeLength;
    Label m_lBoundingBoxDiag;
    PuDouble m_dRadius;
    Checkbox m_cVertexBased;
    Checkbox m_cElementBased;
    CheckboxGroup m_cBasis;
    Button m_bShape;
    Button m_bPrintShape;
    Button m_bPrincCurv;
    Button m_bPrintCurv;
    boolean m_vertexBased;
    PdMatrix[] m_shape;
    PdVector[] m_pcValues;
    PdVector[][] m_pcDirections;
    PwShapeOperator m_workshop;
    static /* synthetic */ Class class$jvx$geom$PwShapeOperator_IP;

    public PwShapeOperator_IP() {
        if (this.getClass() == (class$jvx$geom$PwShapeOperator_IP == null ? (class$jvx$geom$PwShapeOperator_IP = PwShapeOperator_IP.class$("jvx.geom.PwShapeOperator_IP")) : class$jvx$geom$PwShapeOperator_IP)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_cAlgo = new CheckboxGroup();
        this.m_cStarMethod = new Checkbox("Vertex-Star");
        this.m_cStarMethod.setCheckboxGroup(this.m_cAlgo);
        this.m_cStarMethod.addItemListener(this);
        this.m_cEpsBallMethod = new Checkbox("Eps-Ball");
        this.m_cEpsBallMethod.setCheckboxGroup(this.m_cAlgo);
        this.m_cEpsBallMethod.addItemListener(this);
        this.m_cAlgo.setSelectedCheckbox(this.m_cEpsBallMethod);
        this.m_lMinEdgeLength = new Label("0");
        this.m_lBoundingBoxDiag = new Label("0");
        this.m_dRadius = new PuDouble("Radius");
        this.m_cBasis = new CheckboxGroup();
        this.m_cVertexBased = new Checkbox("Vertices");
        this.m_cVertexBased.setCheckboxGroup(this.m_cBasis);
        this.m_cElementBased = new Checkbox("Elements");
        this.m_cElementBased.setCheckboxGroup(this.m_cBasis);
        this.m_cBasis.setSelectedCheckbox(this.m_cVertexBased);
        this.m_vertexBased = true;
        this.m_bShape = new Button("Get Shape Operator");
        this.m_bShape.setActionCommand("shape");
        this.m_bShape.addActionListener(this);
        this.m_bPrintShape = new Button("Print Shape Operator");
        this.m_bPrintShape.setActionCommand("printShape");
        this.m_bPrintShape.addActionListener(this);
        this.m_bPrintShape.setEnabled(false);
        this.m_bPrincCurv = new Button("Get Principal Curvatures");
        this.m_bPrincCurv.setActionCommand("princCurv");
        this.m_bPrincCurv.addActionListener(this);
        this.m_bPrincCurv.setEnabled(false);
        this.m_bPrintCurv = new Button("Print Principle Curvature");
        this.m_bPrintCurv.setActionCommand("printCurv");
        this.m_bPrintCurv.addActionListener(this);
        this.m_bPrintCurv.setEnabled(false);
        this.addSubTitle("Shape Operator");
        ((Container)((Object)this)).add(this.m_cStarMethod);
        ((Container)((Object)this)).add(this.m_cEpsBallMethod);
        this.addLabelComponent("Minimum Edge Length: ", this.m_lMinEdgeLength);
        this.addLabelComponent("Bounding Box Diagonal", this.m_lBoundingBoxDiag);
        ((Container)((Object)this)).add((Component)this.m_dRadius.getInfoPanel());
        ((Container)((Object)this)).add(this.m_cVertexBased);
        ((Container)((Object)this)).add(this.m_cElementBased);
        Panel panel = new Panel(new FlowLayout());
        panel.add(this.m_bShape);
        panel.add(this.m_bPrintShape);
        ((Container)((Object)this)).add(panel);
        this.addSubTitle("Principle Curvature Directions");
        ((Container)((Object)this)).add(this.m_bPrincCurv);
        ((Container)((Object)this)).add(this.m_bPrintCurv);
    }

    public String getNotice() {
        return "Calculate shape operator for vertices or elements and get principle curvature directions.";
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_workshop = (PwShapeOperator)psUpdateIf;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block14: {
            block16: {
                block15: {
                    PgElementSet pgElementSet;
                    int n;
                    int n2;
                    block13: {
                        n2 = ((PgElementSet)this.m_workshop.getGeometry()).getNumVertices();
                        n = ((PgElementSet)this.m_workshop.getGeometry()).getNumElements();
                        pgElementSet = (PgElementSet)this.m_workshop.getGeometry();
                        if (actionEvent.getSource() != this.m_bShape) break block13;
                        PdMatrix[] pdMatrixArray = null;
                        if (this.m_cAlgo.getSelectedCheckbox() == this.m_cStarMethod) {
                            pdMatrixArray = PdMatrix.realloc(null, (int)n2, (int)3, (int)3);
                            PwCurvature.getShapeOperator(pgElementSet, pdMatrixArray);
                            this.m_vertexBased = true;
                        } else if (this.m_cAlgo.getSelectedCheckbox() == this.m_cEpsBallMethod) {
                            if (this.m_cBasis.getSelectedCheckbox() == this.m_cVertexBased) {
                                pdMatrixArray = PdMatrix.realloc(null, (int)n2, (int)3, (int)3);
                                PwShapeOperator.getShapeOperator(pgElementSet, this.m_dRadius.getValue(), true, pdMatrixArray);
                                this.m_vertexBased = true;
                            } else if (this.m_cBasis.getSelectedCheckbox() == this.m_cElementBased) {
                                pdMatrixArray = PdMatrix.realloc(null, (int)n, (int)3, (int)3);
                                PwShapeOperator.getShapeOperator(pgElementSet, this.m_dRadius.getValue(), false, pdMatrixArray);
                                this.m_vertexBased = false;
                            }
                        }
                        this.m_shape = pdMatrixArray;
                        this.m_bPrincCurv.setEnabled(true);
                        this.m_bPrintShape.setEnabled(true);
                        break block14;
                    }
                    if (actionEvent.getSource() != this.m_bPrincCurv) break block15;
                    this.m_pcValues = new PdVector[2];
                    int n3 = this.m_vertexBased ? n2 : n;
                    this.m_pcValues[0] = new PdVector(n3);
                    this.m_pcValues[1] = new PdVector(n3);
                    this.m_pcDirections = new PdVector[2][n3];
                    this.m_pcDirections[0] = PdVector.realloc(null, (int)n3, (int)3);
                    this.m_pcDirections[1] = PdVector.realloc(null, (int)n3, (int)3);
                    PwShapeOperator.getPrincipalCurvatures(pgElementSet, this.m_shape, this.m_pcValues, this.m_pcDirections, true, this.m_vertexBased);
                    for (int i = 0; i < n3; ++i) {
                        this.m_pcDirections[0][i].multScalar(Math.abs(this.m_pcValues[1].getEntry(i)));
                        this.m_pcDirections[1][i].multScalar(Math.abs(this.m_pcValues[0].getEntry(i)));
                    }
                    PgVectorField pgVectorField = new PgVectorField(3);
                    pgVectorField.setBasedOn(this.m_vertexBased ? 0 : 1);
                    pgVectorField.setGeometry((PgPointSet)pgElementSet);
                    for (int i = 0; i < pgVectorField.getNumVectors(); ++i) {
                        pgVectorField.setVector(i, this.m_pcDirections[0][i]);
                    }
                    pgVectorField.setGlobalVectorColor(new Color(255, 0, 0));
                    pgVectorField.update((Object)pgVectorField);
                    PgVectorField pgVectorField2 = new PgVectorField(3);
                    pgVectorField2.setBasedOn(this.m_vertexBased ? 0 : 1);
                    pgVectorField2.setGeometry((PgPointSet)pgElementSet);
                    for (int i = 0; i < pgVectorField2.getNumVectors(); ++i) {
                        pgVectorField2.setVector(i, this.m_pcDirections[1][i]);
                    }
                    pgVectorField2.setGlobalVectorColor(new Color(255, 0, 0));
                    pgVectorField2.update((Object)pgVectorField2);
                    PgVectorField pgVectorField3 = new PgVectorField(3);
                    pgVectorField3.setBasedOn(this.m_vertexBased ? 0 : 1);
                    pgVectorField3.setGeometry((PgPointSet)pgElementSet);
                    for (int i = 0; i < pgVectorField3.getNumVectors(); ++i) {
                        pgVectorField3.setVector(i, this.m_pcDirections[0][i]);
                        pgVectorField3.getVector(i).multScalar(-1.0);
                    }
                    pgVectorField3.setGlobalVectorColor(new Color(255, 0, 0));
                    pgVectorField3.update((Object)pgVectorField3);
                    PgVectorField pgVectorField4 = new PgVectorField(3);
                    pgVectorField4.setBasedOn(this.m_vertexBased ? 0 : 1);
                    pgVectorField4.setGeometry((PgPointSet)pgElementSet);
                    for (int i = 0; i < pgVectorField4.getNumVectors(); ++i) {
                        pgVectorField4.setVector(i, this.m_pcDirections[1][i]);
                        pgVectorField4.getVector(i).multScalar(-1.0);
                    }
                    pgVectorField4.setGlobalVectorColor(new Color(255, 0, 0));
                    pgVectorField4.update((Object)pgVectorField4);
                    pgElementSet.addVectorField(pgVectorField);
                    pgElementSet.addVectorField(pgVectorField2);
                    pgElementSet.addVectorField(pgVectorField3);
                    pgElementSet.addVectorField(pgVectorField4);
                    pgElementSet.update(null);
                    this.m_bPrintCurv.setEnabled(true);
                    break block14;
                }
                if (actionEvent.getSource() != this.m_bPrintShape) break block16;
                for (int i = 0; i < this.m_shape.length; ++i) {
                    PsDebug.message((String)(i + ": " + this.m_shape[i].toShortString()));
                }
                break block14;
            }
            if (actionEvent.getSource() != this.m_bPrintCurv) break block14;
            for (int i = 0; i < this.m_shape.length; ++i) {
                PsDebug.message((String)(i + ": " + this.m_pcDirections[0][i].toShortString() + " = " + this.m_pcValues[0].m_data[i] + "\n" + this.m_pcDirections[1][i].toShortString() + " = " + this.m_pcValues[1].m_data[i]));
            }
        }
    }

    public boolean update(Object object) {
        boolean bl = super.update(object);
        if (object == this.getFather() && this.m_workshop != null && this.m_workshop.getGeometry() != null) {
            PgEdgeStar[] pgEdgeStarArray = ((PgElementSet)this.m_workshop.getGeometry()).makeEdgeStars();
            double d = PdVector.dist((PdVector)this.m_workshop.getGeometry().getVertex(pgEdgeStarArray[0].getVertexInd(0)), (PdVector)this.m_workshop.getGeometry().getVertex(pgEdgeStarArray[0].getVertexInd(1)));
            double d2 = 0.0;
            for (int i = 1; i < pgEdgeStarArray.length; ++i) {
                double d3 = PdVector.dist((PdVector)this.m_workshop.getGeometry().getVertex(pgEdgeStarArray[i].getVertexInd(0)), (PdVector)this.m_workshop.getGeometry().getVertex(pgEdgeStarArray[i].getVertexInd(1)));
                if (d3 < d) {
                    d = d3;
                }
                d2 += d3;
            }
            this.m_lMinEdgeLength.setText("" + d);
            this.m_dRadius.setValue(d2 / (double)pgEdgeStarArray.length * 3.0);
            this.m_lBoundingBoxDiag.setText("" + (this.m_workshop.getGeometry().getBounds()[0].length() + this.m_workshop.getGeometry().getBounds()[1].length()) / 100.0);
        }
        return bl;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.m_cStarMethod) {
            if (this.m_cStarMethod.getState()) {
                this.m_cElementBased.setState(false);
                this.m_cElementBased.setEnabled(false);
                this.m_cVertexBased.setState(true);
            } else {
                this.m_cElementBased.setEnabled(true);
            }
        } else if (itemEvent.getSource() == this.m_cEpsBallMethod) {
            if (this.m_cStarMethod.getState()) {
                this.m_cElementBased.setState(false);
                this.m_cElementBased.setEnabled(false);
                this.m_cVertexBased.setState(true);
            } else {
                this.m_cElementBased.setEnabled(true);
            }
        }
    }

    public Dimension getDialogSize() {
        return new Dimension(350, 500);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

