/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.util.BitSet;
import java.util.Vector;
import jv.geom.PgPointSet;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PnTree {
    protected PgPointSet[] m_pointSet;
    protected Vector[] m_position;
    protected PdVector m_bndBoxMin;
    protected PdVector m_bndBoxMax;
    protected int m_dim;
    protected boolean[] m_bUseVector;
    protected Vector[] m_vertex;

    public PnTree(PgPointSet pgPointSet) {
        this(new PgPointSet[]{pgPointSet});
    }

    public PnTree(PgPointSet pgPointSet, PgPointSet pgPointSet2) {
        this(new PgPointSet[]{pgPointSet, pgPointSet2});
    }

    public PnTree(PgPointSet[] pgPointSetArray) {
        this.m_pointSet = pgPointSetArray;
        this.computeBndBox();
        int n = pgPointSetArray.length;
        this.m_position = new Vector[n];
        this.m_bUseVector = new boolean[n];
        this.m_vertex = new Vector[n];
        for (int i = 0; i < n; ++i) {
            this.m_position[i] = new Vector();
            this.m_bUseVector[i] = false;
        }
    }

    private void computeBndBox() {
        int n;
        int n2 = this.m_pointSet.length;
        PdVector[] pdVectorArray = new PdVector[n2];
        PdVector[] pdVectorArray2 = new PdVector[n2];
        this.m_dim = 0;
        for (n = 0; n < n2; ++n) {
            if (this.m_pointSet[n].getDimOfVertices() <= this.m_dim) continue;
            this.m_dim = this.m_pointSet[n].getDimOfVertices();
        }
        for (n = 0; n < n2; ++n) {
            PdVector[] pdVectorArray3 = this.m_pointSet[n].getAmbientBounds();
            if (pdVectorArray3 == null) continue;
            pdVectorArray3[0].setSize(this.m_dim);
            pdVectorArray3[1].setSize(this.m_dim);
            pdVectorArray[n] = pdVectorArray3[0];
            pdVectorArray2[n] = pdVectorArray3[1];
        }
        this.m_bndBoxMin = new PdVector(this.m_dim);
        this.m_bndBoxMax = new PdVector(this.m_dim);
        PdVector.min((PdVector)this.m_bndBoxMin, (PdVector[])pdVectorArray, (int)n2);
        PdVector.max((PdVector)this.m_bndBoxMax, (PdVector[])pdVectorArray2, (int)n2);
    }

    public void setVertices(int n, Vector vector) {
        if (vector != null) {
            this.m_vertex[n] = vector;
            this.m_bUseVector[n] = true;
        } else {
            this.m_bUseVector[n] = false;
        }
    }

    public void setElements(PiVector[] piVectorArray, int n) {
        this.m_position[0].removeAllElements();
        for (int i = 0; i < n; ++i) {
            this.m_position[0].addElement(this.computePosition(0, piVectorArray[i]));
        }
    }

    public void setElements(int n, PiVector[] piVectorArray, int n2) {
        this.m_position[n].removeAllElements();
        for (int i = 0; i < n2; ++i) {
            this.m_position[n].addElement(this.computePosition(n, piVectorArray[i]));
        }
    }

    public void setElement(int n, PiVector piVector) {
        if (this.m_position[0].size() > n) {
            this.m_position[0].setElementAt(this.computePosition(0, piVector), n);
        } else {
            this.m_position[0].addElement(this.computePosition(0, piVector));
        }
    }

    public void setElement(int n, int n2, PiVector piVector) {
        if (this.m_position[n].size() > n2) {
            this.m_position[n].setElementAt(this.computePosition(n, piVector), n2);
        } else {
            this.m_position[n].addElement(this.computePosition(n, piVector));
        }
    }

    public void addElement(PiVector piVector) {
        this.m_position[0].addElement(this.computePosition(0, piVector));
    }

    public void addElement(int n, PiVector piVector) {
        this.m_position[n].addElement(this.computePosition(n, piVector));
    }

    public void removeElement(int n) {
        this.m_position[0].removeElementAt(n);
    }

    public void removeElement(int n, int n2) {
        this.m_position[n].removeElementAt(n2);
    }

    private boolean[][] computePosition(int n, PiVector piVector) {
        int n2;
        int n3;
        Object object;
        int n4;
        PgPointSet pgPointSet = this.m_pointSet[n];
        int n5 = piVector.getSize();
        PdVector[] pdVectorArray = new PdVector[n5];
        if (this.m_bUseVector[n]) {
            for (n4 = 0; n4 < n5; ++n4) {
                pdVectorArray[n4] = (PdVector)this.m_vertex[n].elementAt(piVector.m_data[n4]);
            }
        } else {
            for (n4 = 0; n4 < n5; ++n4) {
                pdVectorArray[n4] = pgPointSet.getVertex(piVector.m_data[n4]);
            }
        }
        BitSet[] bitSetArray = new BitSet[this.m_dim];
        for (int i = 0; i < this.m_dim; ++i) {
            bitSetArray[i] = new BitSet();
        }
        if (n5 == 1) {
            boolean[][] blArray = new boolean[this.m_dim][1];
            for (int i = 0; i < this.m_dim; ++i) {
                blArray[i][0] = true;
            }
            return blArray;
        }
        double d = 0.0;
        for (int i = 1; i < n5; ++i) {
            double d2 = PdVector.sqrDist((PdVector)pdVectorArray[0], (PdVector)pdVectorArray[i]);
            if (!(d2 > d)) continue;
            d = d2;
        }
        if (d == 0.0) {
            boolean[][] blArray = new boolean[this.m_dim][1];
            for (int i = 0; i < this.m_dim; ++i) {
                blArray[i][0] = true;
            }
            return blArray;
        }
        PdVector pdVector = PdVector.copyNew((PdVector)this.m_bndBoxMin);
        PdVector pdVector2 = PdVector.copyNew((PdVector)this.m_bndBoxMax);
        boolean bl = true;
        boolean[] blArray = new boolean[this.m_dim];
        int n6 = 0;
        while (bl) {
            object = PdVector.blendNew((double)0.5, (PdVector)pdVector, (double)0.5, (PdVector)pdVector2);
            for (n3 = 0; n3 < this.m_dim; ++n3) {
                if (pdVectorArray[0].m_data[n3] > object.m_data[n3]) {
                    blArray[n3] = true;
                    pdVector.m_data[n3] = object.m_data[n3];
                    continue;
                }
                blArray[n3] = false;
                pdVector2.m_data[n3] = object.m_data[n3];
            }
            for (n3 = 1; n3 < n5; ++n3) {
                for (n2 = 0; n2 < this.m_dim; ++n2) {
                    if (!(pdVectorArray[n3].m_data[n2] > pdVector2.m_data[n2]) && !(pdVectorArray[n3].m_data[n2] < pdVector.m_data[n2])) continue;
                    bl = false;
                }
            }
            if (!bl) continue;
            for (n3 = 0; n3 < this.m_dim; ++n3) {
                if (blArray[n3]) {
                    bitSetArray[n3].set(n6);
                    continue;
                }
                bitSetArray[n3].clear(n6);
            }
            ++n6;
        }
        object = new boolean[this.m_dim][n6 + 1];
        for (n3 = 0; n3 < this.m_dim; ++n3) {
            object[n3][0] = (PdVector)true;
        }
        for (n3 = 0; n3 < n6; ++n3) {
            for (n2 = 0; n2 < this.m_dim; ++n2) {
                object[n2][n3 + 1] = (PdVector)bitSetArray[n2].get(n3);
            }
        }
        return object;
    }

    public boolean compare(int n, int n2) {
        int n3;
        int n4;
        boolean[][] blArray = (boolean[][])this.m_position[0].elementAt(n);
        boolean[][] blArray2 = (boolean[][])this.m_position[0].elementAt(n2);
        int n5 = blArray2[0].length;
        if (n5 < (n4 = (n3 = blArray[0].length))) {
            n4 = n5;
        }
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < this.m_dim; ++j) {
                if (blArray[j][i] == blArray2[j][i]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean compare(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        boolean[][] blArray = (boolean[][])this.m_position[n].elementAt(n2);
        boolean[][] blArray2 = (boolean[][])this.m_position[n3].elementAt(n4);
        int n7 = blArray2[0].length;
        if (n7 < (n6 = (n5 = blArray[0].length))) {
            n6 = n7;
        }
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < this.m_dim; ++j) {
                if (blArray[j][i] == blArray2[j][i]) continue;
                return false;
            }
        }
        return true;
    }
}

